/*
 * Decompiled with CFR 0.152.
 */
package com.keysight.database.rest;

import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.keysight.database.helpers.ConnectionProfile;
import com.keysight.database.helpers.DatabaseQueryHelper;
import com.keysight.database.helpers.PluginConfigContainer;
import com.keysight.database.helpers.PluginConfigManager;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/admin-config/")
public class RestAdminConfigService {
    private static final Logger log = LoggerFactory.getLogger(RestAdminConfigService.class);
    private final UserManager userManager;
    private final UserAccessor userAccessor;
    private final PluginConfigManager pluginConfigManager;
    private final PluginSettingsFactory pluginSettingsFactory;
    private final TransactionTemplate transactionTemplate;

    public RestAdminConfigService(UserManager userManager, UserAccessor userAccessor, PluginConfigManager pluginConfigManager, PluginSettingsFactory pluginSettingsFactory, TransactionTemplate transactionTemplate) {
        this.userManager = userManager;
        this.userAccessor = userAccessor;
        this.pluginConfigManager = pluginConfigManager;
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.transactionTemplate = transactionTemplate;
    }

    @GET
    @Path(value="configuration")
    @Produces(value={"application/json"})
    public Response getConfiguration(@Context HttpServletRequest request) {
        this.pluginConfigManager.loadFromStorage();
        if (!this.isAuthorized(request)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        PluginConfigContainer pluginConfigContainer = new PluginConfigContainer();
        pluginConfigContainer.urlEncodeAndSetXml(this.pluginConfigManager.getGeneralConfigXml());
        return Response.ok((Object)pluginConfigContainer).build();
    }

    @PUT
    @Path(value="configuration")
    @Consumes(value={"application/json"})
    public Response putConfiguration(PluginConfigContainer pluginConfigContainer, @Context HttpServletRequest request) {
        this.pluginConfigManager.loadFromStorage();
        if (!this.isAuthorized(request)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        this.pluginConfigManager.setGeneralConfigXml(pluginConfigContainer.getUrlDecodedXml());
        return Response.noContent().build();
    }

    @GET
    @Path(value="profiles")
    @Produces(value={"application/json"})
    public Response getProfiles(@Context HttpServletRequest request) {
        this.pluginConfigManager.loadFromStorage();
        if (!this.isAuthorized(request)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        PluginConfigContainer pluginConfigContainer = new PluginConfigContainer();
        pluginConfigContainer.urlEncodeAndSetXml(this.pluginConfigManager.getProfileConfigXml());
        return Response.ok((Object)pluginConfigContainer).build();
    }

    @PUT
    @Path(value="profiles")
    @Consumes(value={"application/json"})
    public Response putProfiles(PluginConfigContainer pluginConfigContainer, @Context HttpServletRequest request) {
        this.pluginConfigManager.loadFromStorage();
        if (!this.isAuthorized(request)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        this.pluginConfigManager.setProfileConfigXml(pluginConfigContainer.getUrlDecodedXml(), pluginConfigContainer.getPasswordMap());
        return Response.noContent().build();
    }

    @POST
    @Path(value="profiles/test/")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response testProfile(ConnectionProfile profile, @Context HttpServletRequest request) {
        Connection testConnect;
        this.pluginConfigManager.loadFromStorage();
        try {
            testConnect = DatabaseQueryHelper.createConnection(profile, this.pluginConfigManager);
        }
        catch (MacroExecutionException e) {
            return Response.serverError().entity((Object)("Error creating connection: " + e.getMessage())).build();
        }
        return Response.ok((Object)this.transactionTemplate.execute(() -> testConnect != null)).build();
    }

    @GET
    @Path(value="get-installed-drivers")
    @Produces(value={"application/json"})
    public Response getInstalledDrivers(@Context HttpServletRequest request) {
        this.pluginConfigManager.loadFromStorage();
        if (!this.isAuthorized(request)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        PluginConfigContainer pluginConfigContainer = new PluginConfigContainer();
        pluginConfigContainer.urlEncodeAndSetXml(this.pluginConfigManager.getGeneralConfigXml());
        return Response.ok((Object)pluginConfigContainer).build();
    }

    private boolean isAuthorized(HttpServletRequest request) {
        UserKey userKey = this.userManager.getRemoteUserKey(request);
        if (userKey == null) {
            return false;
        }
        if (this.userManager.isSystemAdmin(userKey)) {
            return true;
        }
        UserProfile currentProfile = this.userManager.getUserProfile(userKey);
        assert (currentProfile != null);
        String currentUsername = currentProfile.getUsername();
        List currentGroups = this.userAccessor.getGroupNamesForUserName(currentUsername);
        if (this.pluginConfigManager.getAuthorizedUsers().contains(currentUsername)) {
            return true;
        }
        ArrayList<String> tempList = new ArrayList<String>(this.pluginConfigManager.getAuthorizedGroups());
        tempList.retainAll(currentGroups);
        return !tempList.isEmpty();
    }
}

