/*
 * Decompiled with CFR 0.152.
 */
package com.keysight.database.macros;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.storage.macro.MacroId;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.fugue.Option;
import com.atlassian.renderer.v2.RenderUtils;
import com.keysight.database.helpers.PluginConfigManager;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacroResultsCache
implements Macro {
    private static final Logger log = LoggerFactory.getLogger(MacroResultsCache.class);
    private static final String CACHE_EXPIRATION = "cache-expiration";
    private static final String BOUNDING_BOX = "bounding-box";
    private static final String REFRESH_BUTTON = "refresh-button";
    protected final CacheManager cacheManager;
    protected final ClusterManager clusterManager;
    protected final PluginConfigManager pluginConfigManager;
    protected final VelocityHelperService velocityHelperService;
    protected Map<String, String> parameters = null;
    protected String body = null;
    protected ConversionContext context = null;
    protected Cache<String, String> dataCache = null;
    protected Cache<String, String> creationTimeCache = null;

    public MacroResultsCache(CacheManager cacheManager, ClusterManager clusterManager, PluginConfigManager pluginConfigManager, VelocityHelperService velocityHelperService) {
        this.cacheManager = cacheManager;
        this.clusterManager = clusterManager;
        this.pluginConfigManager = pluginConfigManager;
        this.velocityHelperService = velocityHelperService;
        pluginConfigManager.loadFromStorage();
        this.dataCache = cacheManager.getCache(MacroResultsCache.class.getName() + "data.cache", (CacheLoader)new MacroResultsCacheDataCacheLoader(), new CacheSettingsBuilder().expireAfterWrite(pluginConfigManager.getMaxCacheLifeTimeInDaysAsLong(), TimeUnit.DAYS).build());
        this.creationTimeCache = cacheManager.getCache(MacroResultsCache.class.getName() + ".create-time.cache", (CacheLoader)new MacroResultsCacheCreateTimeCacheLoader(), new CacheSettingsBuilder().expireAfterWrite(pluginConfigManager.getMaxCacheLifeTimeInDaysAsLong(), TimeUnit.DAYS).build());
    }

    public String execute(Map<String, String> parameters, String body, ConversionContext context) throws MacroExecutionException {
        this.parameters = parameters;
        this.body = body;
        this.context = context;
        String macroId = null;
        int expiration = 0;
        String clusterNodeId = null;
        try {
            if (parameters.containsKey(CACHE_EXPIRATION)) {
                expiration = Integer.parseInt(parameters.get(CACHE_EXPIRATION));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (expiration > 0) {
            try {
                clusterNodeId = this.clusterManager.isClustered() ? this.clusterManager.getThisNodeInformation().getAnonymizedNodeIdentifier() + ":" : "";
                MacroDefinition macroDefinition = (MacroDefinition)context.getProperty("macroDefinition");
                Option option = macroDefinition.getMacroId();
                macroId = clusterNodeId + ((MacroId)option.get()).getId();
                long creationTime = Long.parseLong((String)this.creationTimeCache.get((Object)macroId));
                if (creationTime + (long)expiration * 60L * 1000L < System.currentTimeMillis()) {
                    this.creationTimeCache.remove((Object)macroId);
                    this.dataCache.remove((Object)macroId);
                }
                return (String)this.dataCache.get((Object)macroId);
            }
            catch (NoSuchElementException exception) {
                return this.tryRenderMacro(null);
            }
        }
        return this.tryRenderMacro(null);
    }

    public String tryRenderMacro(String macroId) {
        try {
            return this.renderMacro(macroId);
        }
        catch (Exception exception) {
            return RenderUtils.blockError((String)"Macro Execution Error:", (String)exception.getMessage());
        }
    }

    public String renderMacro(String macroId) throws MacroExecutionException {
        if (macroId != null) {
            try {
                this.creationTimeCache.remove((Object)macroId);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.creationTimeCache.get((Object)macroId);
        }
        String boxCssClass = "";
        String panelCssClass = "";
        String refreshButton = "";
        String macroIdWithoutClusterNodeId = macroId;
        log.debug("Macro ID Without Cluster Node Id: " + macroIdWithoutClusterNodeId);
        String[] parts = macroId.split(":");
        if (parts.length > 1) {
            macroIdWithoutClusterNodeId = parts[1];
            log.debug("Macro ID Without Cluster Node Id: " + macroIdWithoutClusterNodeId);
        }
        log.debug("Macro ID Without Cluster Node Id: " + macroIdWithoutClusterNodeId);
        if (this.parameters.containsKey(BOUNDING_BOX)) {
            panelCssClass = " panel";
            boxCssClass = "class=\"macro-results-cache-box macro-results-cache-top macro-results-cache-body-container macro-results-cache-bottom\"";
        }
        refreshButton = this.parameters.containsKey(REFRESH_BUTTON) && macroIdWithoutClusterNodeId != null ? "      <div class=\"macro-results-cache-refresh-button\">\n         <span class=\"refresh-button\">\n            <a class=\"icon icon-refresh\" rel=\"nofollow\" onclick=\"forceMacroResultsCacheCacheRefresh('" + macroIdWithoutClusterNodeId + "');\"/>&nbsp;            <a onclick=\"forceMacroResultsCacheCacheRefresh('" + macroIdWithoutClusterNodeId + "');\">Refresh</a>         </span>\n      </div>\n" : "";
        return "<div class=\"macro-results-cache-container" + panelCssClass + "\">\n   <div " + boxCssClass + ">      <div class=\"macro-result-cache-body\">" + this.body + "\n      </div>\n" + refreshButton + "   </div>\n</div>\n";
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.RICH_TEXT;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    private class MacroResultsCacheDataCacheLoader
    implements CacheLoader<String, String> {
        private MacroResultsCacheDataCacheLoader() {
        }

        public String load(String macroId) {
            return MacroResultsCache.this.tryRenderMacro(macroId);
        }
    }

    private class MacroResultsCacheCreateTimeCacheLoader
    implements CacheLoader<String, String> {
        private MacroResultsCacheCreateTimeCacheLoader() {
        }

        public String load(String creationTimeInMillisFromLong) {
            return Long.toString(System.currentTimeMillis());
        }
    }
}

