/*
 * Decompiled with CFR 0.152.
 */
package com.keysight.database.macros;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.content.render.xhtml.storage.macro.MacroId;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.mail.template.ConfluenceMailQueueItem;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.confluence.xhtml.api.MacroDefinitionHandler;
import com.atlassian.confluence.xhtml.api.MacroDefinitionMarshallingStrategy;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.core.task.MultiQueueTaskManager;
import com.atlassian.mail.queue.MailQueueItem;
import com.atlassian.renderer.v2.RenderUtils;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.keysight.database.helpers.ConnectionProfile;
import com.keysight.database.helpers.DatabaseQueryHelper;
import com.keysight.database.helpers.InsertLogEntryIntoAuditDatabase;
import com.keysight.database.helpers.PluginConfigManager;
import com.keysight.database.helpers.mail.MailService;
import com.keysight.database.helpers.mail.MailServiceImpl;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseQuery
implements Macro {
    private static final Logger log = LoggerFactory.getLogger(DatabaseQuery.class);
    private static final String PROFILE = "profile";
    private static final String QUERY_ISVISIBLE = "show-query";
    private static final String COLLAPSE_QUERY = "collapse-query";
    private static final String SQL = "sql";
    private static final String CACHE_EXPIRATION = "cache-expiration";
    private static final String BOUNDING_BOX = "bounding-box";
    private static final String REFRESH_BUTTON = "refresh-button";
    private static final String HIDE_HEADER = "hide-header";
    private static final String HTML_IS_OK = "html-is-ok";
    protected final CacheManager cacheManager;
    protected final PageManager pageManager;
    protected final PermissionManager permissionManager;
    protected final PluginConfigManager pluginConfigManager;
    protected final PluginSettingsFactory pluginSettingsFactory;
    protected final SettingsManager settingsManager;
    protected final SpaceManager spaceManager;
    protected final MultiQueueTaskManager taskManager;
    protected final TransactionTemplate transactionTemplate;
    protected final UserAccessor userAccessor;
    protected final UserManager userManager;
    protected final VelocityHelperService velocityHelperService;
    protected final XhtmlContent xhtmlUtils;
    protected final MailService mailService;
    private Connection connect = null;
    private Statement statement = null;
    private ResultSet resultSet = null;
    protected Map<String, String> parameters = null;
    protected String body = null;
    protected ConversionContext context = null;
    protected Cache<String, String> dataCache = null;
    protected Cache<String, String> creationTimeCache = null;
    private String macroId = null;
    private String profileId = null;
    private String sql = null;
    private Map<String, MacroDefinition> macroDefinitionsFromSavedContent = null;

    public DatabaseQuery(CacheManager cacheManager, PageManager pageManager, PermissionManager permissionManager, PluginConfigManager pluginConfigManager, PluginSettingsFactory pluginSettingsFactory, SettingsManager settingsManager, SpaceManager spaceManager, MultiQueueTaskManager taskManager, TransactionTemplate transactionTemplate, UserAccessor userAccessor, UserManager userManager, VelocityHelperService velocityHelperService, XhtmlContent xhtmlUtils) {
        this.cacheManager = cacheManager;
        this.pageManager = pageManager;
        this.permissionManager = permissionManager;
        this.pluginConfigManager = pluginConfigManager;
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.settingsManager = settingsManager;
        this.spaceManager = spaceManager;
        this.taskManager = taskManager;
        this.transactionTemplate = transactionTemplate;
        this.userAccessor = userAccessor;
        this.userManager = userManager;
        this.velocityHelperService = velocityHelperService;
        this.xhtmlUtils = xhtmlUtils;
        this.mailService = new MailServiceImpl(taskManager);
        this.dataCache = cacheManager.getCache(DatabaseQuery.class.getName() + "data.cache", (CacheLoader)new DatabaseQueryDataCacheLoader(), new CacheSettingsBuilder().expireAfterWrite(pluginConfigManager.getMaxCacheLifeTimeInDaysAsLong(), TimeUnit.DAYS).build());
        this.creationTimeCache = cacheManager.getCache(DatabaseQuery.class.getName() + ".create-time.cache", (CacheLoader)new DatabaseQueryCreateTimeCacheLoader(), new CacheSettingsBuilder().expireAfterWrite(pluginConfigManager.getMaxCacheLifeTimeInDaysAsLong(), TimeUnit.DAYS).build());
    }

    private Map<String, MacroDefinition> getMacrosInContent(String bodyAsString) throws MacroExecutionException {
        final HashMap<String, MacroDefinition> macroDefinitions = new HashMap<String, MacroDefinition>();
        try {
            this.xhtmlUtils.handleMacroDefinitions(bodyAsString, this.context, new MacroDefinitionHandler(){

                public void handle(MacroDefinition macroDefinition) {
                    macroDefinitions.put(((MacroId)macroDefinition.getMacroIdentifier().get()).getId(), macroDefinition);
                    try {
                        Map sub_macros = DatabaseQuery.this.getMacrosInContent(macroDefinition.getBodyText());
                        macroDefinitions.putAll(sub_macros);
                    }
                    catch (MacroExecutionException macroExecutionException) {
                        // empty catch block
                    }
                }
            }, MacroDefinitionMarshallingStrategy.MARSHALL_MACRO);
        }
        catch (XhtmlException e) {
            throw new MacroExecutionException((Throwable)e);
        }
        for (Map.Entry macro : macroDefinitions.entrySet()) {
            log.debug("Macro Identifier: " + (String)macro.getKey());
        }
        return macroDefinitions;
    }

    private MacroDefinition getSavedMacroById(String macroId, Map<String, MacroDefinition> savedMacros) throws MacroExecutionException {
        MacroDefinition savedMacroDefinition = null;
        if (savedMacros.containsKey(macroId)) {
            savedMacroDefinition = savedMacros.get(macroId);
        }
        if (savedMacroDefinition == null) {
            log.debug("Could not locate a macroId from a saved macro.");
        }
        return savedMacroDefinition;
    }

    private String getMacroId() {
        String macroId = null;
        if (this.context.hasProperty("macroDefinition")) {
            MacroDefinition macroDefinition = (MacroDefinition)this.context.getProperty("macroDefinition");
            macroId = macroDefinition.getMacroIdentifier().map(MacroId::getId).orElse(null);
            log.debug("The conversion context macroDefinition id is " + macroId);
            if (!this.macroDefinitionsFromSavedContent.containsKey(macroId)) {
                log.debug("The macro id was not found");
                MacroDefinition macroDefinitionByParameterMatch = this.GetMacroDefinitionByParameterMatch();
                macroId = macroDefinitionByParameterMatch != null ? ((MacroId)macroDefinitionByParameterMatch.getMacroIdentifier().get()).getId() : null;
            }
        }
        return macroId;
    }

    private MacroDefinition GetMacroDefinitionByParameterMatch() {
        log.debug("Get macro by parameter match");
        MacroDefinition matchedMacroDefinition = null;
        for (Map.Entry<String, MacroDefinition> entry : this.macroDefinitionsFromSavedContent.entrySet()) {
            MacroDefinition macroDefinition = entry.getValue();
            boolean matchedByParameter = true;
            log.debug("Check macro id " + ((MacroId)macroDefinition.getMacroIdentifier().get()).getId());
            if (this.getProfileId(entry.getValue()) == null) {
                log.debug("This is not a database query macro");
                continue;
            }
            log.debug("Saved Macro Profile: \"" + this.getProfileId(macroDefinition) + "\"");
            log.debug("Active Macro Profile: \"" + this.parameters.get(PROFILE) + "\"");
            log.debug("Saved Macro Body: \"" + macroDefinition.getBodyText() + "\"");
            log.debug("Active Macro Body: \"" + this.body + "\"");
            if (!this.parameters.get(PROFILE).equals(this.getProfileId(macroDefinition))) {
                matchedByParameter = false;
            }
            if (this.parameters.containsKey(SQL)) {
                if (!this.parameters.get(SQL).equals(macroDefinition.getParameters().get(SQL))) {
                    matchedByParameter = false;
                }
            } else if (!macroDefinition.getBodyText().equals(this.body)) {
                matchedByParameter = false;
            }
            if (!matchedByParameter) continue;
            matchedMacroDefinition = macroDefinition;
            String macroId = ((MacroId)macroDefinition.getMacroIdentifier().get()).getId();
            log.debug("Matched to macro id: " + macroId);
            break;
        }
        return matchedMacroDefinition;
    }

    private List<String> GetSavedMacroDefinitionIds(Map<String, MacroDefinition> macroDefinitions) {
        ArrayList<String> savedMacroDefinitionIds = new ArrayList<String>(macroDefinitions.keySet());
        return savedMacroDefinitionIds;
    }

    private int getCacheExpiration(Map<String, String> parameters) {
        int cacheExpiration = 0;
        try {
            if (parameters.containsKey(CACHE_EXPIRATION)) {
                cacheExpiration = Integer.parseInt(parameters.get(CACHE_EXPIRATION));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cacheExpiration;
    }

    private boolean currentUserHasPermissionsForProfile(ConnectionProfile profile) {
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        boolean userHasPermissions = false;
        log.debug("Check if " + currentUser.getName() + " has access to the profile.");
        if (profile.universalAccessAllowed()) {
            log.debug("The profile allows universal access.");
            userHasPermissions = true;
        } else {
            UserProfile currentProfile = this.userManager.getUserProfile(currentUser.getKey());
            String currentUsername = currentProfile.getUsername();
            ArrayList<String> authorizedUsers = profile.getAuthorizedUsers();
            log.debug("Test if " + currentUsername + " is an authorized user for the profile");
            if (profile.getAuthorizedUsers().contains(currentUsername)) {
                log.debug("The user, \"" + currentUsername + "\", has named access to the profile");
                userHasPermissions = true;
            } else {
                List currentGroups = this.userAccessor.getGroupNamesForUserName(currentUsername);
                ArrayList<String> authorizedGroups = profile.getAuthorizedGroups();
                authorizedGroups.retainAll(currentGroups);
                if (!authorizedGroups.isEmpty()) {
                    log.debug("The user, \"" + currentUsername + "\", has group access to the profile");
                    userHasPermissions = true;
                }
            }
        }
        return userHasPermissions;
    }

    public boolean allowedContentType(ConversionContext context) {
        ContentEntityObject contentEntityObject = context.getEntity();
        ContentTypeEnum contentEntityObjectType = contentEntityObject.getTypeEnum();
        ArrayList<ContentTypeEnum> allowedContentTypes = new ArrayList<ContentTypeEnum>();
        allowedContentTypes.add(ContentTypeEnum.BLOG);
        allowedContentTypes.add(ContentTypeEnum.DRAFT);
        allowedContentTypes.add(ContentTypeEnum.PAGE);
        return allowedContentTypes.contains(contentEntityObjectType);
    }

    public String execute(Map<String, String> parameters, String body, ConversionContext context) throws MacroExecutionException {
        ArrayList macrosInSavedPageContent = new ArrayList();
        this.parameters = parameters;
        this.body = body;
        this.context = context;
        this.macroDefinitionsFromSavedContent = new HashMap<String, MacroDefinition>();
        if (!this.allowedContentType(context)) {
            throw new MacroExecutionException("This macro may only be used on pages and blog posts.\n");
        }
        try {
            this.macroDefinitionsFromSavedContent = this.getMacrosInContent(this.context.getEntity().getBodyContent().getBody());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.macroId = this.getMacroId();
        int cacheExpiration = this.getCacheExpiration(parameters);
        log.debug("\n\n\nCACHE Expiration: " + cacheExpiration + ")\n\n\n");
        if (this.macroId == null) {
            return this.tryRenderDatabaseQuery(this.macroId);
        }
        if (cacheExpiration > 0) {
            try {
                long creationTime = Long.parseLong((String)this.creationTimeCache.get((Object)this.macroId));
                if (creationTime + (long)cacheExpiration * 60L * 1000L < System.currentTimeMillis()) {
                    log.debug("Clear " + this.macroId + " From the cache\n");
                    this.creationTimeCache.remove((Object)this.macroId);
                    this.dataCache.remove((Object)this.macroId);
                }
                log.debug("Try to get Data from CACHE (MacroID: " + this.macroId + ")\n");
                return (String)this.dataCache.get((Object)this.macroId);
            }
            catch (NoSuchElementException exception) {
                log.debug("Cache Retrieval aborted: " + exception.getMessage() + "\n");
                return this.tryRenderDatabaseQuery(this.macroId);
            }
        }
        log.debug("Render the sql with macroId: " + this.macroId);
        return this.tryRenderDatabaseQuery(this.macroId);
    }

    private String tryRenderDatabaseQuery(String macroId) {
        try {
            return this.renderDatabaseQuery(macroId);
        }
        catch (Exception exception) {
            return RenderUtils.blockError((String)"Macro Execution Error:", (String)exception.getMessage());
        }
    }

    private String getSql(MacroDefinition macroDefinition) {
        String sql = null;
        log.debug(macroDefinition.toString());
        Map macroParameters = macroDefinition.getParameters();
        if (macroParameters.containsKey(SQL)) {
            log.debug("Getting SQL from macro parameters");
            sql = (String)macroParameters.get(SQL);
        } else {
            log.debug("Getting SQL from body");
            sql = macroDefinition.getBodyText();
        }
        log.debug("Got SQL: " + sql);
        return sql;
    }

    private String getProfileId(MacroDefinition macroDefinition) {
        String activeProfileId = null;
        Map macroParameters = macroDefinition.getParameters();
        if (macroParameters.containsKey(PROFILE)) {
            activeProfileId = (String)macroParameters.get(PROFILE);
        }
        return activeProfileId;
    }

    public String renderDatabaseQuery(String macroId) throws MacroExecutionException {
        String baseUrl = this.settingsManager.getGlobalSettings().getBaseUrl();
        String template = "/com/keysight/database/templates/database-query.vm";
        Map velocityContext = this.velocityHelperService.createDefaultVelocityContext();
        ConnectionProfile profile = null;
        MacroDefinition macroDefinition = null;
        String spaceKey = this.context.getSpaceKey();
        String spaceName = this.spaceManager.getSpace(spaceKey).getName();
        String pageName = this.context.getEntity().getTitle();
        String pageUrl = baseUrl + this.context.getEntity().getUrlPath();
        ArrayList<String> columnNames = new ArrayList<String>();
        ArrayList dataRows = new ArrayList();
        String fullName = null;
        String userName = null;
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        if (currentUser != null) {
            fullName = currentUser.getFullName();
            userName = currentUser.getName();
        } else {
            fullName = "Anonymous";
            userName = "anonymous";
        }
        log.debug("Full Name: " + fullName);
        log.debug("User Name: " + userName);
        if (macroId != null) {
            if (this.macroDefinitionsFromSavedContent.containsKey(macroId)) {
                macroDefinition = this.macroDefinitionsFromSavedContent.get(macroId);
                this.creationTimeCache.remove((Object)macroId);
            }
            this.creationTimeCache.get((Object)macroId);
        } else {
            macroDefinition = (MacroDefinition)this.context.getProperty("macroDefinition");
        }
        log.debug("macro definition found for macro " + macroId);
        String sql = "";
        try {
            sql = this.getSql(macroDefinition);
        }
        catch (Exception e) {
            log.debug("unable to get sql");
            sql = "SELECT * from data";
        }
        String activeProfileId = this.getProfileId(macroDefinition);
        log.debug("sql: " + sql);
        String rawSql = sql;
        sql = sql.replaceAll("\\s+", " ");
        log.debug("This is the SQL I want to use: " + sql);
        log.debug("This is the profile id want to use: " + activeProfileId);
        this.pluginConfigManager.loadFromStorage();
        if (activeProfileId != null) {
            profile = this.pluginConfigManager.getConnectionProfileFromId(activeProfileId);
            if (profile == null) {
                String escapedActiveProfileId = activeProfileId.replace(">", "&gt;").replace("<", "&lt;");
                throw new MacroExecutionException("No profile found with that ID for which you are authorized: " + escapedActiveProfileId);
            }
        } else {
            throw new MacroExecutionException("No profile selected");
        }
        if (!profile.spaceIsAuthorizedToUseProfile(this.context.getSpaceKey())) {
            throw new MacroExecutionException("The selected database profile may not be used from this space.");
        }
        if (macroId == null && !this.currentUserHasPermissionsForProfile(profile)) {
            throw new MacroExecutionException("The current user does not have permissions to use this profile.");
        }
        this.connect = DatabaseQueryHelper.createConnection(profile, this.pluginConfigManager);
        if (this.connect != null) {
            try {
                this.statement = this.connect.createStatement();
                int softTimer = Integer.MAX_VALUE;
                int startQuery = (int)(new Date().getTime() / 1000L);
                if (!Objects.equals(this.pluginConfigManager.getTimeoutLimitValue(), "")) {
                    int timeVal;
                    try {
                        timeVal = Integer.parseInt(this.pluginConfigManager.getTimeoutLimitValue());
                    }
                    catch (NumberFormatException e) {
                        throw new MacroExecutionException("Failed to parse query timeout: " + this.pluginConfigManager.getTimeoutLimitValue());
                    }
                    if (Objects.equals(StringUtils.lowerCase((String)this.pluginConfigManager.getTimeoutLimitType()), "soft")) {
                        softTimer = timeVal;
                    } else {
                        this.statement.setQueryTimeout(timeVal);
                    }
                }
                int softRowLimit = Integer.MAX_VALUE;
                if (!Objects.equals(this.pluginConfigManager.getRowLimitValue(), "")) {
                    int rowLimit;
                    try {
                        rowLimit = Integer.parseInt(this.pluginConfigManager.getRowLimitValue());
                    }
                    catch (NumberFormatException e) {
                        throw new MacroExecutionException("Failed to parse query row limit: " + this.pluginConfigManager.getTimeoutLimitValue());
                    }
                    if (Objects.equals(StringUtils.lowerCase((String)this.pluginConfigManager.getRowLimitType()), "soft")) {
                        softRowLimit = rowLimit;
                    } else {
                        this.statement.setMaxRows(rowLimit);
                    }
                }
                this.resultSet = this.statement.executeQuery(sql);
                int endQuery = (int)(new Date().getTime() / 1000L);
                if (endQuery - startQuery > softTimer) {
                    String message = "<p>The user <b>" + fullName + " ( " + userName + " )</b> executed an sql query\n using the Database Connection Macro on the page <a href=\"" + pageUrl + "\">" + pageName + "</a>\n in the space <b>" + spaceName + "</b>. It took " + (endQuery - startQuery) + " seconds\nexceeding the soft time limit of " + softTimer + ".</p>\n";
                    this.sendEmail(this.pluginConfigManager, "Confluence DB Connection Soft Timeout Limit Warning", message, null);
                }
                for (int i = 1; i <= this.resultSet.getMetaData().getColumnCount(); ++i) {
                    columnNames.add(this.resultSet.getMetaData().getColumnLabel(i));
                }
                velocityContext.put("columnNames", columnNames);
                int rowCount = 0;
                while (this.resultSet.next()) {
                    ++rowCount;
                    ArrayList<String> row = new ArrayList<String>();
                    for (int i = 1; i <= this.resultSet.getMetaData().getColumnCount(); ++i) {
                        row.add(this.resultSet.getString(i));
                    }
                    dataRows.add(row);
                }
                Date entryDate = new Date(System.currentTimeMillis());
                if (rowCount > softRowLimit) {
                    String message = "<p>The user <b>" + fullName + " ( " + userName + " )</b> executed an sql query\n using the Database Connection Macro on the page <a href=\"" + pageUrl + "\">" + pageName + "</a>\n in the space <b>" + spaceName + "</b>. It returned " + rowCount + " rows\n exceeding the soft row limit of " + softRowLimit + ".</p>\n";
                    this.sendEmail(this.pluginConfigManager, "Confluence DB Connector Soft Row Limit Warning", message, null);
                }
                String logMessage = "DB Query( fullName=" + fullName + ", userName=" + userName + ", pageName=" + pageName + ", spaceName=" + spaceName + ", databaseProfile=" + profile.getName() + ", rowCount=" + rowCount + ", queryDuration=" + (endQuery - startQuery) + ")\n";
                if (this.pluginConfigManager.getAtlassianLogLevel().equals("Warn")) {
                    log.warn(logMessage);
                } else {
                    log.info(logMessage);
                }
                ConnectionProfile auditLogProfile = this.pluginConfigManager.getConnectionProfileFromId(this.pluginConfigManager.getAuditLogDbProfile());
                if (auditLogProfile != null) {
                    InsertLogEntryIntoAuditDatabase runnable = new InsertLogEntryIntoAuditDatabase(auditLogProfile, this.pluginConfigManager, profile, fullName, userName, pageUrl, pageName, spaceName, rowCount, endQuery - startQuery, rawSql);
                    new Thread(runnable).start();
                }
                if (this.pluginConfigManager.getLogEmail() != null && !Objects.equals(this.pluginConfigManager.getLogEmail(), "")) {
                    String delimiter = "-----field-delimiter\n";
                    String keyValueSplitter = "-----key-value-splitter\n";
                    String message = null;
                    message = this.pluginConfigManager.getEmailContentFormat().equals("XML") ? "<database-connector-log-entry>\n   <fullName><![CDATA[" + fullName + "]]></fullName>\n   <userName><![CDATA[" + userName + "]]></userName>\n   <pageName><![CDATA[" + pageName + "]]></pageName>\n   <pageUrl><![CDATA[" + pageUrl + "]]></pageUrl>\n   <spaceName><![CDATA[" + spaceName + "]]></spaceName>\n   <databaseProfile><![CDATA[" + profile.getName() + "]]></databaseProfile>\n   <rowCount><![CDATA[" + rowCount + "]]></rowCount>\n   <queryDuration><![CDATA[" + (endQuery - startQuery) + "]]></queryDuration>\n   <sqlQuery><![CDATA[" + rawSql + "]]></sqlQuery>\n   <timestamp><![CDATA[" + LocalDateTime.now() + "]]></timestamp>\n</database-connector-log-entry>\n" : (this.pluginConfigManager.getEmailContentFormat().equals("JSON") ? "{\"fullName\":\"" + StringEscapeUtils.escapeJson((String)fullName) + "\",\"userName\":\"" + StringEscapeUtils.escapeJson((String)userName) + "\",\"pageName\":\"" + StringEscapeUtils.escapeJson((String)pageName) + "\",\"pageUrl\":\"" + StringEscapeUtils.escapeJson((String)pageUrl) + "\",\"databaseProfile\":\"" + StringEscapeUtils.escapeJson((String)profile.getName()) + "\",\"spaceName\":\"" + StringEscapeUtils.escapeJson((String)spaceName) + "\",\"rowCount\":\"" + rowCount + "\",\"queryDuration\":\"" + (endQuery - startQuery) + "\",\"sqlQuery\":\"" + StringEscapeUtils.escapeJson((String)StringEscapeUtils.escapeJson((String)rawSql)) + "\",\"timestamp\":\"" + LocalDateTime.now() + "\"}" : (this.pluginConfigManager.getEmailContentFormat().equals("Parsable Text") ? delimiter + "fullName\n" + keyValueSplitter + fullName + "\n" + delimiter + "userName\n" + keyValueSplitter + userName + "\n" + delimiter + "pageName\n" + keyValueSplitter + pageName + "\n" + delimiter + "pageUrl\n" + keyValueSplitter + pageUrl + "\n" + delimiter + "databaseProfile\n" + keyValueSplitter + profile.getName() + "\n" + delimiter + "spaceName\n" + keyValueSplitter + spaceName + "\n" + delimiter + "rowCount\n" + keyValueSplitter + rowCount + "\n" + delimiter + "queryDuration\n" + keyValueSplitter + (endQuery - startQuery) + "\n" + delimiter + "sqlQuery\n" + keyValueSplitter + rawSql + "\n" + delimiter + "timestamp\n" + keyValueSplitter + LocalDateTime.now() + "\n" : "fullName = " + fullName + "\nuserName = " + userName + "\npageUrl = " + pageUrl + "\npageName = " + pageName + "\nspaceName = " + spaceName + "\ndatabaseProfile = " + profile.getName() + "\nrowCount = " + rowCount + "\nqueryDuration = " + (endQuery - startQuery) + "\ntimestamp = " + LocalDateTime.now() + "\nsqlQuery\n--------\n" + rawSql + "\n"));
                    this.sendPlainTextEmail(this.pluginConfigManager, "DB Connector Log Entry: Returned " + rowCount + " rows in " + (endQuery - startQuery) + " seconds at " + LocalDateTime.now(), message, this.pluginConfigManager.getLogEmail());
                }
                velocityContext.put("dataRows", dataRows);
            }
            catch (Exception e) {
                throw new MacroExecutionException((Throwable)e);
            }
            finally {
                this.close();
            }
        }
        StringBuilder codeViewOfBody = new StringBuilder();
        codeViewOfBody.append("<ac:structured-macro ac:name=\"code\" ac:schema-version=\"1\">");
        codeViewOfBody.append("<ac:parameter ac:name=\"language\">sql</ac:parameter>");
        codeViewOfBody.append("<ac:parameter ac:name=\"title\">SQL Query</ac:parameter>");
        if (this.parameters.containsKey(COLLAPSE_QUERY)) {
            codeViewOfBody.append("<ac:parameter ac:name=\"collapse\">true</ac:parameter>");
        }
        codeViewOfBody.append("   <ac:plain-text-body><![CDATA[");
        codeViewOfBody.append(rawSql);
        codeViewOfBody.append("]]></ac:plain-text-body>");
        codeViewOfBody.append("</ac:structured-macro>");
        String databaseQueryContainerCssClass = "";
        String boxCssClass = "";
        if (this.parameters.containsKey(BOUNDING_BOX)) {
            databaseQueryContainerCssClass = "panel database-query-container";
            boxCssClass = "database-query-box database-query-top database-query-body-container database-query-bottom";
            velocityContext.put("boxCssClass", boxCssClass);
        } else {
            databaseQueryContainerCssClass = "database-query-container";
        }
        velocityContext.put("databaseQueryContainerCssClass", databaseQueryContainerCssClass);
        if (this.parameters.containsKey(REFRESH_BUTTON) && macroId != null) {
            velocityContext.put("showRefreshMacroId", "true");
            velocityContext.put("refreshMacroId", macroId);
        }
        if (!this.parameters.containsKey(HIDE_HEADER)) {
            velocityContext.put("showHeader", "true");
        }
        velocityContext.put("showQuery", this.parameters.get(QUERY_ISVISIBLE));
        velocityContext.put("htmlIsOk", this.parameters.get(HTML_IS_OK));
        velocityContext.put("code", codeViewOfBody.toString());
        return this.velocityHelperService.getRenderedTemplate(template, velocityContext);
    }

    private void sendEmail(PluginConfigManager pluginConfigManager, String subject, String body, String customEmail) {
        this.sendEmailLowLevel(pluginConfigManager, subject, body, customEmail, "text/html");
    }

    private void sendPlainTextEmail(PluginConfigManager pluginConfigManager, String subject, String body, String customEmail) {
        this.sendEmailLowLevel(pluginConfigManager, subject, body, customEmail, "text/plain");
    }

    private void sendEmailLowLevel(PluginConfigManager pluginConfigManager, String subject, String body, String customEmail, String mimeType) {
        pluginConfigManager.loadFromStorage();
        if (customEmail == null || Objects.equals(customEmail, "")) {
            customEmail = pluginConfigManager.getNotificationEmail();
        }
        try {
            ConfluenceMailQueueItem mailQueueItem = new ConfluenceMailQueueItem(customEmail, subject, body, mimeType);
            this.mailService.sendEmail((MailQueueItem)mailQueueItem);
        }
        catch (Exception e) {
            log.error("Failed to send email.");
            log.error(e.getMessage());
        }
    }

    private void close() {
        try {
            if (this.resultSet != null) {
                this.resultSet.close();
            }
            if (this.statement != null) {
                this.statement.close();
            }
            if (this.connect != null) {
                this.connect.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.PLAIN_TEXT;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    private class DatabaseQueryDataCacheLoader
    implements CacheLoader<String, String> {
        private DatabaseQueryDataCacheLoader() {
        }

        public String load(String macroId) {
            return DatabaseQuery.this.tryRenderDatabaseQuery(macroId);
        }
    }

    private class DatabaseQueryCreateTimeCacheLoader
    implements CacheLoader<String, String> {
        private DatabaseQueryCreateTimeCacheLoader() {
        }

        public String load(String creationTimeInMillisFromLong) {
            return Long.toString(System.currentTimeMillis());
        }
    }
}

