/*
 * Decompiled with CFR 0.152.
 */
package com.keysight.database.helpers;

import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.keysight.database.helpers.DriverDetails;
import com.keysight.database.helpers.PluginConfigManager;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileConfigUI
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(ProfileConfigUI.class);
    private final UserManager userManager;
    private final LoginUriProvider loginUriProvider;
    private final TemplateRenderer templateRenderer;
    private final UserAccessor userAccessor;
    private final PluginConfigManager pluginConfigManager;
    private final PluginSettingsFactory pluginSettingsFactory;
    private final TransactionTemplate transactionTemplate;

    public ProfileConfigUI(LoginUriProvider loginUriProvider, PluginConfigManager pluginConfigManager, PluginSettingsFactory pluginSettingsFactory, TemplateRenderer templateRenderer, TransactionTemplate transactionTemplate, UserAccessor userAccessor, UserManager userManager) {
        this.loginUriProvider = loginUriProvider;
        this.pluginConfigManager = pluginConfigManager;
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.templateRenderer = templateRenderer;
        this.transactionTemplate = transactionTemplate;
        this.userAccessor = userAccessor;
        this.userManager = userManager;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (!this.isAuthorized(request)) {
            this.redirectToLogin(request, response);
            return;
        }
        this.pluginConfigManager.loadFromStorage();
        HashMap<String, String> velocityContext = new HashMap<String, String>();
        velocityContext.put("relativeHome", new File(".").getCanonicalPath());
        velocityContext.put("javaVersion", System.getProperty("java.version"));
        velocityContext.put("jvmBits", System.getProperty("sun.arch.data.model"));
        HashMap<String, String> driverKeyMap = new HashMap<String, String>();
        driverKeyMap.put("DB2", "db2");
        driverKeyMap.put("Derby", "derby");
        driverKeyMap.put("jTDS SQL Server", "jTdsSqlServer");
        driverKeyMap.put("Microsoft SQL Server", "microsoftSqlServer");
        driverKeyMap.put("MongoDB", "mongoDb");
        driverKeyMap.put("MySQL", "mySql");
        driverKeyMap.put("Oracle", "oracle");
        driverKeyMap.put("PostgreSQL", "postgreSql");
        driverKeyMap.put("Sybase", "sybase");
        for (String key : driverKeyMap.keySet()) {
            DriverDetails driverDetails = this.pluginConfigManager.getDriverDetails(key);
            if (!driverDetails.isOk) {
                velocityContext.put((String)driverKeyMap.get(key), "error");
                log.debug(driverDetails.className.toString());
                log.debug(driverDetails.url.toString());
                continue;
            }
            if (!driverDetails.isLocal) {
                velocityContext.put((String)driverKeyMap.get(key), "warning");
                continue;
            }
            velocityContext.put((String)driverKeyMap.get(key), "ok");
        }
        response.setContentType("text/html;charset=utf-8");
        this.templateRenderer.render("/com/keysight/database/templates/profile-config-ui.vm", velocityContext, (Writer)response.getWriter());
    }

    private void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    private boolean isAuthorized(HttpServletRequest request) {
        UserKey userKey = this.userManager.getRemoteUserKey(request);
        if (userKey == null) {
            return false;
        }
        if (this.userManager.isSystemAdmin(userKey)) {
            return true;
        }
        UserProfile currentProfile = this.userManager.getUserProfile(userKey);
        assert (currentProfile != null);
        String currentUsername = currentProfile.getUsername();
        List currentGroups = this.userAccessor.getGroupNamesForUserName(currentUsername);
        this.pluginConfigManager.loadFromStorage();
        if (this.pluginConfigManager.getAuthorizedUsers().contains(currentUsername)) {
            return true;
        }
        ArrayList<String> tempList = new ArrayList<String>(this.pluginConfigManager.getAuthorizedGroups());
        tempList.retainAll(currentGroups);
        return !tempList.isEmpty();
    }
}

