/*
 * Decompiled with CFR 0.152.
 */
package com.keysight.database.helpers;

import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.keysight.database.helpers.ConnectionProfile;
import com.keysight.database.helpers.DatabaseDriverDelegate;
import com.keysight.database.helpers.DriverDetails;
import com.keysight.database.helpers.PluginConfigContainer;
import java.io.StringReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@Component
public class PluginConfigManager {
    private final String DB2_DOWNLOAD;
    private final String DB2_DRIVER_KEY = "DB2";
    private final String DB2_REGEX = ".*db2jcc.*";
    private final String DB2_CLASS_NAME = "com.ibm.db2.jcc.DB2Driver";
    private String DERBY_DOWNLOAD = "https://repo1.maven.org/maven2/org/apache/derby/derbyclient/10.17.1.0/derbyclient-10.17.1.0.jar";
    private final String DERBY_DRIVER_KEY = "Derby";
    private final String DERBY_REGEX = ".*derby.*";
    private final String DERBY_CLASS_NAME = "org.apache.derby.jdbc.EmbeddedDriver";
    private String JTDS_SQL_SERVER_DOWNLOAD = "https://repo1.maven.org/maven2/com/microsoft/sqlserver/mssql-jdbc/12.6.0.jre11/mssql-jdbc-12.6.0.jre11.jar";
    private final String JTDS_SQL_SERVER_DRIVER_KEY = "jTDS SQL Server";
    private final String JTDS_SQL_SERVER_REGEX = ".*jtds.*";
    private final String JTDS_SQL_SERVER_CLASS_NAME = "net.sourceforge.jtds.jdbc.Driver";
    private String SQL_SERVER_DOWNLOAD = "https://github.com/microsoft/mssql-jdbc/releases/download/v12.6.0/mssql-jdbc-12.6.0.jre11.jar";
    private final String SQL_SERVER_DRIVER_KEY = "Microsoft SQL Server";
    private final String SQL_SERVER_REGEX = ".*sqljdbc.*";
    private final String SQL_SERVER_CLASS_NAME = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    private String MONGODB_DOWNLOAD = "https://repo1.maven.org/maven2/org/mongodb/mongodb-driver-sync/4.11.1/mongodb-driver-sync-4.11.1.jar";
    private final String MONGODB_DRIVER_KEY = "MongoDB";
    private final String MONGODB_REGEX = ".*mongodb.*";
    private final String MONGODB_CLASS_NAME = "mongodb.jdbc.MongoDriver";
    private String MYSQL_DOWNLOAD = "https://repo1.maven.org/maven2/com/mysql/mysql-connector-j/8.3.0/mysql-connector-j-8.3.0.jar";
    private final String MYSQL_DRIVER_KEY = "MySQL";
    private final String MYSQL_REGEX = ".*mysql.*";
    private final String MYSQL_CLASS_NAME = "com.mysql.jdbc.Driver";
    private final String ORACLE_DOWNLOAD;
    private final String ORACLE_DRIVER_KEY = "Oracle";
    private final String ORACLE_REGEX = ".*ojdbc.*";
    private final String ORACLE_CLASS_NAME = "oracle.jdbc.driver.OracleDriver";
    private String POSTGRESQL_DOWNLOAD = "https://repo1.maven.org/maven2/org/postgresql/postgresql/42.7.1/postgresql-42.7.1.jar";
    private final String POSTGRESQL_DRIVER_KEY = "PostgreSQL";
    private final String POSTGRESQL_REGEX = ".*postgre.*";
    private final String POSTGRESQL_CLASS_NAME = "org.postgresql.Driver";
    private final String SYBASE_DOWNLOAD;
    private final String SYBASE_DRIVER_KEY = "Sybase";
    private final String SYBASE_REGEX = ".*jconn.*";
    private final String SYBASE_CLASS_NAME = "sybase.jdbc.sqlanywhere.IDriver";
    private String jdbcDriverDirectory;
    private String configAuthorizedUsers;
    private String configAuthorizedGroups;
    private String configAuthorizedSpaces;
    private String rowLimitType;
    private String rowLimitValue;
    private String timeoutLimitType;
    private String timeoutLimitValue;
    private String notificationEmail;
    private String atlassianLogLevel;
    private String logEmail;
    private String emailContentFormat = "";
    private String auditLogDbProfile = "";
    private String logEntryTableName = "";
    private String logEntryLifeTime = "";
    private String maxCacheLifeTimeInDays = "7";
    private Element generalConfigRoot;
    private Element profileConfigRoot;
    private String profileConfigXml;
    private String generalConfigXml;
    private Map<String, String> passwordMap;
    private static final Logger log = LoggerFactory.getLogger(PluginConfigManager.class);
    private final PluginSettingsFactory pluginSettingsFactory;
    private final TransactionTemplate transactionTemplate;
    private static final String INFO = "Info";
    private static final String SOFT = "Soft";
    private static final String PLAIN_TEXT = "Plain Text";
    private static final String NEW_LOG_ENTRY = "newLogEntry";

    @Autowired
    public PluginConfigManager(PluginSettingsFactory pluginSettingsFactory, TransactionTemplate transactionTemplate) {
        this.DB2_DOWNLOAD = null;
        this.ORACLE_DOWNLOAD = null;
        this.SYBASE_DOWNLOAD = null;
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.transactionTemplate = transactionTemplate;
        this.loadFromStorage();
    }

    public void loadFromStorage() {
        try {
            this.loadGeneralConfigXmlFromStorage();
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = builder.parse(new InputSource(new StringReader(this.generalConfigXml)));
            this.generalConfigRoot = document.getDocumentElement();
            this.loadProfileConfigXmlFromStorage();
            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            document = builder.parse(new InputSource(new StringReader(this.profileConfigXml)));
            this.profileConfigRoot = document.getDocumentElement();
            this.loadPasswordMapFromStorage();
            this.jdbcDriverDirectory = new String(Base64.decodeBase64((String)this.getValueOfElement("jdbc-driver-directory")), "UTF-8");
            String jTdsDriverUrl = new String(Base64.decodeBase64((String)this.getValueOfElement("jtds-driver-url")), "UTF-8");
            String microsoftDriverUrl = new String(Base64.decodeBase64((String)this.getValueOfElement("microsoft-driver-url")), "UTF-8");
            String derbyDriverUrl = new String(Base64.decodeBase64((String)this.getValueOfElement("derby-driver-url")), "UTF-8");
            String mongoDriverUrl = new String(Base64.decodeBase64((String)this.getValueOfElement("mongo-driver-url")), "UTF-8");
            String mysqlDriverUrl = new String(Base64.decodeBase64((String)this.getValueOfElement("mysql-driver-url")), "UTF-8");
            String pgsqlDriverUrl = new String(Base64.decodeBase64((String)this.getValueOfElement("pgsql-driver-url")), "UTF-8");
            if (!StringUtils.isEmpty((CharSequence)jTdsDriverUrl)) {
                this.JTDS_SQL_SERVER_DOWNLOAD = jTdsDriverUrl;
            }
            if (!StringUtils.isEmpty((CharSequence)microsoftDriverUrl)) {
                this.SQL_SERVER_DOWNLOAD = microsoftDriverUrl;
            }
            if (!StringUtils.isEmpty((CharSequence)derbyDriverUrl)) {
                this.DERBY_DOWNLOAD = derbyDriverUrl;
            }
            if (!StringUtils.isEmpty((CharSequence)mongoDriverUrl)) {
                this.MONGODB_DOWNLOAD = mongoDriverUrl;
            }
            if (!StringUtils.isEmpty((CharSequence)mysqlDriverUrl)) {
                this.MYSQL_DOWNLOAD = mysqlDriverUrl;
            }
            if (!StringUtils.isEmpty((CharSequence)pgsqlDriverUrl)) {
                this.POSTGRESQL_DOWNLOAD = pgsqlDriverUrl;
            }
            this.configAuthorizedUsers = new String(Base64.decodeBase64((String)this.getValueOfElement("config-authorized-users")), "UTF-8");
            this.configAuthorizedGroups = new String(Base64.decodeBase64((String)this.getValueOfElement("config-authorized-groups")), "UTF-8");
            this.configAuthorizedSpaces = new String(Base64.decodeBase64((String)this.getValueOfElement("config-authorized-spaces")), "UTF-8");
            this.rowLimitType = new String(Base64.decodeBase64((String)this.getValueOfElement("row-limit-type")), "UTF-8");
            this.rowLimitValue = new String(Base64.decodeBase64((String)this.getValueOfElement("row-limit-value")), "UTF-8");
            this.timeoutLimitType = new String(Base64.decodeBase64((String)this.getValueOfElement("timeout-limit-type")), "UTF-8");
            this.timeoutLimitValue = new String(Base64.decodeBase64((String)this.getValueOfElement("timeout-limit-value")), "UTF-8");
            this.notificationEmail = new String(Base64.decodeBase64((String)this.getValueOfElement("notification-email")), "UTF-8");
            this.atlassianLogLevel = new String(Base64.decodeBase64((String)this.getValueOfElement("atlassian-log-level")), "UTF-8");
            this.logEmail = new String(Base64.decodeBase64((String)this.getValueOfElement("log-email")), "UTF-8");
            this.emailContentFormat = new String(Base64.decodeBase64((String)this.getValueOfElement("email-content-format")), "UTF-8");
            this.auditLogDbProfile = new String(Base64.decodeBase64((String)this.getValueOfElement("audit-log-db-profile")), "UTF-8");
            this.logEntryTableName = new String(Base64.decodeBase64((String)this.getValueOfElement("log-entry-table-name")), "UTF-8");
            this.logEntryLifeTime = new String(Base64.decodeBase64((String)this.getValueOfElement("log-entry-life-time")), "UTF-8");
            this.maxCacheLifeTimeInDays = new String(Base64.decodeBase64((String)this.getValueOfElement("max-cache-lifetime-in-days")), "UTF-8");
            if (StringUtils.isEmpty((CharSequence)this.emailContentFormat)) {
                this.emailContentFormat = PLAIN_TEXT;
            }
            if (StringUtils.isEmpty((CharSequence)this.logEntryTableName)) {
                this.logEntryTableName = NEW_LOG_ENTRY;
            }
            if (StringUtils.isEmpty((CharSequence)this.atlassianLogLevel)) {
                this.logEntryTableName = INFO;
            }
            if (StringUtils.isEmpty((CharSequence)this.timeoutLimitType)) {
                this.timeoutLimitType = SOFT;
            }
            if (StringUtils.isEmpty((CharSequence)this.rowLimitType)) {
                this.rowLimitType = SOFT;
            }
            if (StringUtils.isEmpty((CharSequence)this.maxCacheLifeTimeInDays)) {
                this.maxCacheLifeTimeInDays = "7";
            }
        }
        catch (Exception exception) {
            log.warn("Unable to load the DB Connector plugin configuration:" + exception);
        }
    }

    private void loadGeneralConfigXmlFromStorage() {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<plugin-configuration>\n    <jtds-driver-url></jtds-driver-url>\n    <microsoft-driver-url></microsoft-driver-url>\n    <derby-driver-url></derby-driver-url>\n    <mongo-driver-url></mongo-driver-url>\n    <mysql-driver-url></mysql-driver-url>\n    <pgsql-driver-url></pgsql-driver-url>\n    <jdbc-driver-directory></jdbc-driver-directory>\n    <config-authorized-users></config-authorized-users>\n    <config-authorized-groups></config-authorized-groups>\n    <config-authorized-spaces></config-authorized-spaces>\n    <row-limit-type></row-limit-type>\n    <row-limit-value></row-limit-value>\n    <timeout-limit-type></timeout-limit-type>\n    <timeout-limit-value></timeout-limit-value>\n    <notification-email></notification-email>\n    <atlassian-log-level></atlassian-log-level>\n    <log-email></log-email>\n    <email-content-format></email-content-format>\n    <audit-log-db-profile></audit-log-db-profile>\n    <log-entry-table-name></log-entry-table-name>\n    <log-entry-life-time></log-entry-life-time>\n</plugin-configuration>\n";
        try {
            PluginConfigContainer pluginConfigContainer = (PluginConfigContainer)this.transactionTemplate.execute(() -> {
                PluginSettings settings = this.pluginSettingsFactory.createGlobalSettings();
                PluginConfigContainer innerPluginConfigContainer = new PluginConfigContainer();
                innerPluginConfigContainer.setXml((String)settings.get(PluginConfigManager.class.getName() + ".xml"));
                return innerPluginConfigContainer;
            });
            if (pluginConfigContainer.getXml() != null && !StringUtils.isEmpty((CharSequence)pluginConfigContainer.getXml())) {
                xml = pluginConfigContainer.getXml();
            }
        }
        catch (Exception exception) {
            log.warn("Failed to retrieve or parse the profile xml config: " + exception.getMessage());
        }
        this.generalConfigXml = xml;
    }

    public boolean setGeneralConfigXml(String xml) {
        boolean updated = false;
        if (this.generalConfigXmlIsValid(xml)) {
            updated = true;
            this.transactionTemplate.execute(() -> {
                PluginSettings pluginSettings = this.pluginSettingsFactory.createGlobalSettings();
                pluginSettings.put(PluginConfigManager.class.getName() + ".xml", (Object)xml);
                return null;
            });
            this.loadFromStorage();
        }
        return updated;
    }

    public String getGeneralConfigXml() {
        return this.generalConfigXml;
    }

    private boolean generalConfigXmlIsValid(String xml) {
        boolean flag = true;
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = builder.parse(new InputSource(new StringReader(xml)));
            Element element = document.getDocumentElement();
        }
        catch (Exception exception) {
            flag = false;
        }
        return flag;
    }

    private void loadProfileConfigXmlFromStorage() {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><saved-profiles></saved-profiles>\n";
        try {
            PluginConfigContainer pluginConfigContainer = (PluginConfigContainer)this.transactionTemplate.execute(() -> {
                PluginSettings settings = this.pluginSettingsFactory.createGlobalSettings();
                PluginConfigContainer innerPluginConfigContainer = new PluginConfigContainer();
                innerPluginConfigContainer.setXml((String)settings.get(PluginConfigManager.class.getName() + "_profiles.xml"));
                return innerPluginConfigContainer;
            });
            if (pluginConfigContainer.getXml() != null && !StringUtils.isEmpty((CharSequence)pluginConfigContainer.getXml())) {
                xml = pluginConfigContainer.getXml();
            }
        }
        catch (Exception exception) {
            log.warn("Failed to retrieve or parse the profile xml config: " + exception.getMessage());
        }
        this.profileConfigXml = xml;
    }

    public boolean setProfileConfigXml(String xml) {
        return this.setProfileConfigXml(xml, new HashMap<String, String>());
    }

    public boolean setProfileConfigXml(String xml, Map<String, String> passwordMap) {
        boolean updated = false;
        if (this.profileXmlIsValid(xml)) {
            this.profileConfigXml = xml;
            updated = true;
            this.transactionTemplate.execute(() -> {
                if (passwordMap != null) {
                    this.storePassword(passwordMap);
                }
                PluginSettings pluginSettings = this.pluginSettingsFactory.createGlobalSettings();
                pluginSettings.put(PluginConfigManager.class.getName() + "_profiles.xml", (Object)xml);
                return null;
            });
            this.loadFromStorage();
        }
        return updated;
    }

    public String getProfileConfigXml() {
        return this.profileConfigXml;
    }

    private boolean profileXmlIsValid(String xml) {
        boolean flag = true;
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = builder.parse(new InputSource(new StringReader(xml)));
            Element element = document.getDocumentElement();
        }
        catch (Exception exception) {
            flag = false;
        }
        return flag;
    }

    private void loadPasswordMapFromStorage() {
        Map passwordMap = new HashMap();
        try {
            passwordMap = (Map)this.transactionTemplate.execute(() -> {
                PluginSettings settings = this.pluginSettingsFactory.createGlobalSettings();
                HashMap innerPasswordMap = (HashMap)settings.get(PluginConfigManager.class.getName() + "_passwordMap");
                if (innerPasswordMap == null) {
                    innerPasswordMap = new HashMap();
                }
                return innerPasswordMap;
            });
        }
        catch (Exception exception) {
            log.warn("Failed to retrieve or parse the profile xml config: " + exception.getMessage());
        }
        this.passwordMap = passwordMap;
    }

    private void storePassword(Map<String, String> passwords) {
        this.transactionTemplate.execute(() -> {
            PluginSettings settings = this.pluginSettingsFactory.createGlobalSettings();
            HashMap tempPasswordMap = (HashMap)settings.get(PluginConfigManager.class.getName() + "_passwordMap");
            if (tempPasswordMap == null) {
                tempPasswordMap = new HashMap();
            }
            HashMap innerPasswordMap = tempPasswordMap;
            passwords.forEach((profileId, password) -> {
                if (innerPasswordMap.containsKey(profileId)) {
                    innerPasswordMap.remove(profileId);
                }
                innerPasswordMap.put(profileId, password);
            });
            settings.put(PluginConfigManager.class.getName() + "_passwordMap", innerPasswordMap);
            return innerPasswordMap;
        });
        this.loadPasswordMapFromStorage();
    }

    private void purgePassword(Map<String, String> passwords) {
        this.transactionTemplate.execute(() -> {
            PluginSettings settings = this.pluginSettingsFactory.createGlobalSettings();
            HashMap tempPasswordMap = (HashMap)settings.get(PluginConfigManager.class.getName() + "_passwordMap");
            if (tempPasswordMap == null) {
                tempPasswordMap = new HashMap();
            }
            HashMap innerPasswordMap = tempPasswordMap;
            passwords.forEach((profileId, password) -> {
                if (innerPasswordMap.containsKey(profileId)) {
                    innerPasswordMap.remove(profileId);
                }
            });
            settings.put(PluginConfigManager.class.getName() + "_passwordMap", innerPasswordMap);
            return innerPasswordMap;
        });
        this.loadPasswordMapFromStorage();
    }

    public List<ConnectionProfile> getConnectionProfiles() {
        NodeList profileNodes = this.getProfiles();
        ArrayList<ConnectionProfile> profiles = new ArrayList<ConnectionProfile>();
        if (profileNodes != null) {
            for (int i = 0; i < profileNodes.getLength(); ++i) {
                Element profileNode = (Element)profileNodes.item(i);
                profiles.add(new ConnectionProfile(profileNode));
            }
        }
        return profiles;
    }

    public ConnectionProfile getConnectionProfileFromId(String profileId) {
        NodeList profileNodes = this.getProfiles();
        ConnectionProfile theSelectedProfile = null;
        for (int i = 0; i < profileNodes.getLength(); ++i) {
            Element profileNode = (Element)profileNodes.item(i);
            ConnectionProfile profile = new ConnectionProfile(profileNode);
            if (profile.getId() == null || !profile.getId().equals(profileId)) continue;
            theSelectedProfile = profile;
            break;
        }
        return theSelectedProfile;
    }

    private String getValueOfElement(String tagName) {
        NodeList allNodes = this.generalConfigRoot.getElementsByTagName(tagName);
        String text = "";
        for (int i = 0; i < allNodes.getLength(); ++i) {
            if (allNodes.item(i).getNodeType() != 1) continue;
            text = allNodes.item(i).getTextContent();
            break;
        }
        return text;
    }

    private void printLoadedDrivers() {
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            Driver jdbcDriver = drivers.nextElement();
            if (jdbcDriver.getClass() == DatabaseDriverDelegate.class) {
                DatabaseDriverDelegate delegateDriver = (DatabaseDriverDelegate)drivers.nextElement();
                jdbcDriver = delegateDriver.getRealDriver();
            }
            log.warn("Loaded JDBC Driver: " + jdbcDriver.getClass().getName());
        }
    }

    DriverDetails getDriverDetails(String driverKey) {
        DriverDetails driverDetails = null;
        if (driverKey.equals("MySQL")) {
            driverDetails = this.getJdbcDriver(this.MYSQL_DOWNLOAD, "MySQL", ".*mysql.*");
            driverDetails.className = "com.mysql.jdbc.Driver";
        } else if (driverKey.equals("jTDS SQL Server")) {
            driverDetails = this.getJdbcDriver(this.JTDS_SQL_SERVER_DOWNLOAD, "jTDS SQL Server", ".*jtds.*");
            driverDetails.className = "net.sourceforge.jtds.jdbc.Driver";
        } else if (driverKey.equals("Microsoft SQL Server")) {
            driverDetails = this.getJdbcDriver(this.SQL_SERVER_DOWNLOAD, "Microsoft SQL Server", ".*sqljdbc.*");
            driverDetails.className = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
        } else if (driverKey.equals("Oracle")) {
            driverDetails = this.getJdbcDriver(this.ORACLE_DOWNLOAD, "Oracle", ".*ojdbc.*");
            driverDetails.className = "oracle.jdbc.driver.OracleDriver";
        } else if (driverKey.equals("PostgreSQL")) {
            driverDetails = this.getJdbcDriver(this.POSTGRESQL_DOWNLOAD, "PostgreSQL", ".*postgre.*");
            driverDetails.className = "org.postgresql.Driver";
        } else if (driverKey.equals("DB2")) {
            driverDetails = this.getJdbcDriver(this.DB2_DOWNLOAD, "DB2", ".*db2jcc.*");
            driverDetails.className = "com.ibm.db2.jcc.DB2Driver";
        } else if (driverKey.equals("Derby")) {
            driverDetails = this.getJdbcDriver(this.DERBY_DOWNLOAD, "Derby", ".*derby.*");
            driverDetails.className = "org.apache.derby.jdbc.EmbeddedDriver";
        } else if (driverKey.equals("MongoDB")) {
            driverDetails = this.getJdbcDriver(this.MONGODB_DOWNLOAD, "MongoDB", ".*mongodb.*");
            driverDetails.className = "mongodb.jdbc.MongoDriver";
        } else if (driverKey.equals("Sybase")) {
            driverDetails = this.getJdbcDriver(this.SYBASE_DOWNLOAD, "Sybase", ".*jconn.*");
            driverDetails.className = "sybase.jdbc.sqlanywhere.IDriver";
        }
        return driverDetails;
    }

    public void loadJdbcDriver(String driverKey) {
        DriverDetails driverDetails = this.getDriverDetails(driverKey);
        try {
            if (!StringUtils.isEmpty((CharSequence)driverDetails.className)) {
                URLClassLoader urlClassLoader = new URLClassLoader(new URL[]{driverDetails.url});
                Driver driver = (Driver)Class.forName(driverDetails.className, true, urlClassLoader).newInstance();
                DriverManager.registerDriver(new DatabaseDriverDelegate(driver));
            }
        }
        catch (Exception exception) {
            log.warn("Error getting jdbc driver for " + driverKey + ": " + exception.getMessage());
        }
    }

    private DriverDetails getJdbcDriver(String url, String driverKey, String regex) {
        DriverDetails driverDetails;
        block13: {
            driverDetails = new DriverDetails();
            driverDetails.isLocal = false;
            if (!StringUtils.isEmpty((CharSequence)url)) {
                try {
                    driverDetails.url = new URL(url);
                    driverDetails.isOk = true;
                    log.debug("url did parse: " + url);
                }
                catch (Exception exception) {
                    driverDetails.url = null;
                    driverDetails.isOk = false;
                    log.debug("url did not parse: " + url + " " + exception);
                }
            } else {
                driverDetails.url = null;
                driverDetails.isOk = false;
                log.debug("no url");
            }
            if (!StringUtils.isEmpty((CharSequence)this.getJdbcDriverDirectory())) {
                try {
                    DirectoryStream<Path> directoryStream3;
                    Path jdbcDriverDirectoryPath;
                    block14: {
                        jdbcDriverDirectoryPath = Paths.get(this.getJdbcDriverDirectory(), new String[0]);
                        log.debug("Driver Directory: " + this.getJdbcDriverDirectory());
                        if (!Files.isDirectory(jdbcDriverDirectoryPath, new LinkOption[0])) break block13;
                        try {
                            jdbcDriverDirectoryPath = Paths.get(this.getJdbcDriverDirectory(), driverKey);
                            if (!Files.isDirectory(jdbcDriverDirectoryPath, new LinkOption[0])) break block14;
                            directoryStream3 = Files.newDirectoryStream(jdbcDriverDirectoryPath);
                            for (Path path : directoryStream3) {
                                if (!path.toString().matches(".*\\.jar")) continue;
                                driverDetails.isLocal = true;
                                driverDetails.url = path.toUri().toURL();
                                driverDetails.isOk = true;
                                break;
                            }
                        }
                        catch (Exception directoryStream2) {
                            // empty catch block
                        }
                    }
                    if (driverDetails.isLocal) break block13;
                    jdbcDriverDirectoryPath = Paths.get(this.getJdbcDriverDirectory(), new String[0]);
                    try {
                        directoryStream3 = Files.newDirectoryStream(jdbcDriverDirectoryPath);
                        for (Path path : directoryStream3) {
                            if (!path.toString().matches(regex)) continue;
                            driverDetails.isLocal = true;
                            driverDetails.url = path.toUri().toURL();
                            driverDetails.isOk = true;
                        }
                    }
                    catch (Exception directoryStream3) {}
                }
                catch (Exception e) {
                    log.warn("The jdbcDriverDirectoryPath \"" + this.getJdbcDriverDirectory() + "\" is invalid. Error Message: " + e.getMessage());
                }
            }
        }
        return driverDetails;
    }

    public NodeList getProfiles() {
        if (this.profileConfigRoot != null) {
            return this.profileConfigRoot.getElementsByTagName("saved-profile");
        }
        log.warn("No profileConfigRoot: The DB Connector failed to parse the profiles xml config file.");
        return null;
    }

    private String getJdbcDriverDirectory() {
        return this.jdbcDriverDirectory;
    }

    private void setJdbcDriverDirectory(String jdbcDriverDirectory) {
        this.jdbcDriverDirectory = jdbcDriverDirectory;
    }

    public String getRowLimitType() {
        return this.rowLimitType;
    }

    public String getRowLimitValue() {
        return this.rowLimitValue;
    }

    public String getTimeoutLimitType() {
        return this.timeoutLimitType;
    }

    public String getTimeoutLimitValue() {
        return this.timeoutLimitValue;
    }

    public String getNotificationEmail() {
        return this.notificationEmail;
    }

    public String getLogEmail() {
        return this.logEmail;
    }

    public String getEmailContentFormat() {
        return this.emailContentFormat;
    }

    public String getAuditLogDbProfile() {
        return this.auditLogDbProfile;
    }

    public String getLogEntryTableName() {
        return this.logEntryTableName;
    }

    public String getLogEntryLifeTime() {
        return this.logEntryLifeTime;
    }

    public String getMaxCacheLifeTimeInDays() {
        return this.maxCacheLifeTimeInDays;
    }

    public String getAtlassianLogLevel() {
        return this.atlassianLogLevel;
    }

    public long getMaxCacheLifeTimeInDaysAsLong() {
        long lifeTime = 7L;
        try {
            lifeTime = Long.parseLong(this.maxCacheLifeTimeInDays);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return lifeTime;
    }

    public ArrayList<String> getAuthorizedUsers() {
        return new ArrayList<String>(Arrays.asList(StringUtils.split((String)this.configAuthorizedUsers, (String)",")));
    }

    public ArrayList<String> getAuthorizedGroups() {
        return new ArrayList<String>(Arrays.asList(StringUtils.split((String)this.configAuthorizedGroups, (String)",")));
    }

    public ArrayList<String> getAuthorizedSpaces() {
        return new ArrayList<String>(Arrays.asList(StringUtils.split((String)this.configAuthorizedSpaces, (String)",")));
    }

    public Map<String, String> getAuthMap() {
        return this.passwordMap;
    }
}

