/*
 * Decompiled with CFR 0.152.
 */
package com.keysight.database.helpers;

import com.keysight.database.helpers.ConnectionProfile;
import com.keysight.database.helpers.DatabaseQueryHelper;
import com.keysight.database.helpers.PluginConfigManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.time.LocalDateTime;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsertLogEntryIntoAuditDatabase
implements Runnable {
    ConnectionProfile auditLogProfile;
    PluginConfigManager pluginConfigManager;
    ConnectionProfile profile;
    String fullName;
    String userName;
    String pageUrl;
    String pageName;
    String spaceName;
    int rowCount;
    int queryDuration;
    String sql;
    Connection connect;
    PreparedStatement preparedStatement;
    PreparedStatement trimPreparedStatement;
    private static final Logger log = LoggerFactory.getLogger(InsertLogEntryIntoAuditDatabase.class);

    public InsertLogEntryIntoAuditDatabase(ConnectionProfile auditLogProfile, PluginConfigManager pluginConfigManager, ConnectionProfile profile, String fullName, String userName, String pageUrl, String pageName, String spaceName, int rowCount, int queryDuration, String sql) {
        this.auditLogProfile = auditLogProfile;
        this.pluginConfigManager = pluginConfigManager;
        this.profile = profile;
        this.auditLogProfile = auditLogProfile;
        this.fullName = fullName;
        this.userName = userName;
        this.pageUrl = pageUrl;
        this.pageName = pageName;
        this.spaceName = spaceName;
        this.rowCount = rowCount;
        this.queryDuration = queryDuration;
        this.sql = sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block10: {
            String logEntryTableName = this.pluginConfigManager.getLogEntryTableName();
            String logEntryLifeTime = this.pluginConfigManager.getLogEntryLifeTime();
            double daysBack = -1.0;
            String logSql = "INSERT INTO " + logEntryTableName + "(fullName, userName,pageUrl, pageName, spaceName,databaseProfile, rowCount, queryDuration, sqlQuery, timestamp) VALUES (?,?,?,?,?,?,?,?,?,?)";
            String trimSql = "DELETE FROM " + logEntryTableName + " WHERE timestamp <= ?";
            try {
                this.connect = DatabaseQueryHelper.createConnection(this.auditLogProfile, this.pluginConfigManager);
                this.preparedStatement = this.connect.prepareStatement(logSql);
                this.preparedStatement.setString(1, this.fullName);
                this.preparedStatement.setString(2, this.userName);
                this.preparedStatement.setString(3, this.pageUrl);
                this.preparedStatement.setString(4, this.pageName);
                this.preparedStatement.setString(5, this.spaceName);
                this.preparedStatement.setString(6, this.profile.getName());
                this.preparedStatement.setInt(7, this.rowCount);
                this.preparedStatement.setInt(8, this.queryDuration);
                this.preparedStatement.setString(9, this.sql);
                this.preparedStatement.setObject(10, LocalDateTime.now());
                this.preparedStatement.executeUpdate();
                this.preparedStatement.close();
                if (StringUtils.isEmpty((CharSequence)logEntryLifeTime)) break block10;
                try {
                    daysBack = Float.parseFloat(logEntryLifeTime);
                }
                catch (Exception floatConversionException) {
                    log.error("DB Connection error trying to convert the Log Entry Life Time number " + logEntryLifeTime + " to a float.\n");
                }
                if (daysBack > 0.0) {
                    LocalDateTime dateThreshold = LocalDateTime.now();
                    try {
                        this.trimPreparedStatement = this.connect.prepareStatement(trimSql);
                        this.trimPreparedStatement.setObject(1, dateThreshold.minusMinutes((long)(daysBack * 24.0 * 60.0)));
                        this.trimPreparedStatement.executeUpdate();
                    }
                    catch (Exception trimException) {
                        log.error("DB Connection error trying to trim the Log Entry table: " + trimException.getMessage() + "\n");
                    }
                }
            }
            catch (Exception e) {
                log.error("DB Connection error trying to update the audit log: " + e.getMessage() + "\n");
            }
            finally {
                this.close();
            }
        }
    }

    private void close() {
        try {
            if (this.preparedStatement != null) {
                this.preparedStatement.close();
            }
            if (this.trimPreparedStatement != null) {
                this.trimPreparedStatement.close();
            }
            if (this.connect != null) {
                this.connect.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

