/*
 * Decompiled with CFR 0.152.
 */
package com.keysight.database.helpers;

import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.keysight.database.helpers.DriverDetails;
import com.keysight.database.helpers.PluginConfigManager;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneralAdminConfigUI
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(GeneralAdminConfigUI.class);
    private final UserManager userManager;
    private final LoginUriProvider loginUriProvider;
    private final TemplateRenderer templateRenderer;
    private final PluginConfigManager pluginConfigManager;
    private final PluginSettingsFactory pluginSettingsFactory;
    private final TransactionTemplate transactionTemplate;
    private final SettingsManager settingsManager;
    private boolean tryToSaveProfileConfigXml;
    private boolean tryToSaveGeneralConfigXml;
    private boolean savedProfileConfigXml;
    private boolean savedGeneralConfigXml;

    public GeneralAdminConfigUI(LoginUriProvider loginUriProvider, PluginConfigManager pluginConfigManager, PluginSettingsFactory pluginSettingsFactory, SettingsManager settingsManager, TemplateRenderer templateRenderer, TransactionTemplate transactionTemplate, UserManager userManager) {
        this.loginUriProvider = loginUriProvider;
        this.pluginConfigManager = pluginConfigManager;
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.settingsManager = settingsManager;
        this.templateRenderer = templateRenderer;
        this.transactionTemplate = transactionTemplate;
        this.userManager = userManager;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.tryToSaveGeneralConfigXml = false;
        this.tryToSaveProfileConfigXml = false;
        this.renderIt(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
        if (isMultipart) {
            DiskFileItemFactory factory = new DiskFileItemFactory();
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
            try {
                List fileItems = upload.parseRequest(request);
                Iterator fileIterator = fileItems.iterator();
                this.tryToSaveGeneralConfigXml = false;
                this.tryToSaveProfileConfigXml = false;
                while (fileIterator.hasNext()) {
                    FileItem fileItem = (FileItem)fileIterator.next();
                    if (fileItem.isFormField()) continue;
                    String fieldName = fileItem.getFieldName();
                    String fileContents = fileItem.getString();
                    if (fieldName.equals("upload-general-config") && !StringUtils.isEmpty((CharSequence)fileContents)) {
                        this.savedGeneralConfigXml = this.pluginConfigManager.setGeneralConfigXml(fileContents);
                        this.tryToSaveGeneralConfigXml = true;
                        continue;
                    }
                    if (!fieldName.equals("upload-profile-config") || StringUtils.isEmpty((CharSequence)fileContents)) continue;
                    this.savedProfileConfigXml = this.pluginConfigManager.setProfileConfigXml(fileContents);
                    this.tryToSaveProfileConfigXml = true;
                }
            }
            catch (Exception exception) {
                log.warn("Failed to upload configuration file: " + exception.getMessage());
            }
        }
        this.renderIt(request, response);
    }

    public void renderIt(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (!this.isAuthorized(request)) {
            this.redirectToLogin(request, response);
            return;
        }
        HashMap<String, Object> velocityContext = new HashMap<String, Object>();
        velocityContext.put("relativeHome", new File(".").getCanonicalPath());
        velocityContext.put("javaVersion", System.getProperty("java.version"));
        velocityContext.put("jvmBits", System.getProperty("sun.arch.data.model"));
        HashMap<String, String> driverKeyMap = new HashMap<String, String>();
        driverKeyMap.put("DB2", "db2");
        driverKeyMap.put("Derby", "derby");
        driverKeyMap.put("jTDS SQL Server", "jTdsSqlServer");
        driverKeyMap.put("Microsoft SQL Server", "microsoftSqlServer");
        driverKeyMap.put("MongoDB", "mongoDb");
        driverKeyMap.put("MySQL", "mySql");
        driverKeyMap.put("Oracle", "oracle");
        driverKeyMap.put("PostgreSQL", "postgreSql");
        driverKeyMap.put("Sybase", "sybase");
        if (this.tryToSaveProfileConfigXml) {
            velocityContext.put("tryToSaveProfileConfigXml", "true");
            if (this.savedProfileConfigXml) {
                velocityContext.put("savedProfileConfigXml", "true");
            }
        }
        if (this.tryToSaveGeneralConfigXml) {
            velocityContext.put("tryToSaveGeneralConfigXml", "true");
            if (this.savedGeneralConfigXml) {
                velocityContext.put("savedGeneralConfigXml", "true");
            }
        }
        for (String key : driverKeyMap.keySet()) {
            DriverDetails driverDetails = this.pluginConfigManager.getDriverDetails(key);
            if (!driverDetails.isOk) {
                velocityContext.put((String)driverKeyMap.get(key), "error");
                log.debug(driverDetails.className.toString());
                log.debug(driverDetails.url.toString());
                continue;
            }
            if (!driverDetails.isLocal) {
                velocityContext.put((String)driverKeyMap.get(key), "warning");
                continue;
            }
            velocityContext.put((String)driverKeyMap.get(key), "ok");
        }
        velocityContext.put("baseUrl", this.settingsManager.getGlobalSettings().getBaseUrl());
        velocityContext.put("profiles", this.pluginConfigManager.getConnectionProfiles());
        response.setContentType("text/html;charset=utf-8");
        this.templateRenderer.render("/com/keysight/database/templates/general-admin-ui.vm", velocityContext, (Writer)response.getWriter());
    }

    private void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    private boolean isAuthorized(HttpServletRequest request) {
        UserKey userKey = this.userManager.getRemoteUserKey(request);
        if (userKey == null) {
            return false;
        }
        return this.userManager.isSystemAdmin(userKey);
    }
}

