/*
 * Decompiled with CFR 0.152.
 */
package com.keysight.database.helpers;

import com.atlassian.confluence.macro.MacroExecutionException;
import com.keysight.database.helpers.ConnectionProfile;
import com.keysight.database.helpers.PluginConfigManager;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseQueryHelper {
    private static final Logger log = LoggerFactory.getLogger(DatabaseQueryHelper.class);

    public static Connection createConnection(String profileId, PluginConfigManager pluginConfigManager) throws MacroExecutionException {
        pluginConfigManager.loadFromStorage();
        ConnectionProfile profile = pluginConfigManager.getConnectionProfileFromId(profileId);
        if (profile == null) {
            String profileIdEscaped = profileId.replace(">", "&gt;").replace("<", "&lt;");
            throw new MacroExecutionException("No profile found with that ID for which you are authorized: " + profileIdEscaped);
        }
        return DatabaseQueryHelper.createConnection(profile, pluginConfigManager);
    }

    public static Connection createConnection(ConnectionProfile profile, PluginConfigManager pluginConfigManager) throws MacroExecutionException {
        Connection connect;
        String username = profile.getDatabaseUsername();
        String password = profile.getDatabasePassword();
        if (StringUtils.isEmpty((CharSequence)password) || Objects.equals(password, "*****")) {
            password = pluginConfigManager.getAuthMap().get(profile.getProfileId());
        }
        String subProtocol = StringUtils.lowerCase((String)profile.getDatabaseType());
        String connectionString = null;
        if (subProtocol.equals("microsoft sql server")) {
            subProtocol = "sqlserver";
        } else if (subProtocol.equals("jtds sql server")) {
            subProtocol = "jtds:sqlserver";
        } else if (subProtocol.equals("mongodb")) {
            subProtocol = "mongo";
        }
        if (subProtocol.equals("oracle")) {
            String oraclePort = "1521";
            if (!StringUtils.isEmpty((CharSequence)profile.getDatabasePort())) {
                oraclePort = profile.getDatabasePort();
            }
            connectionString = "jdbc:" + subProtocol + ":thin:@" + profile.getDatabaseServer() + ":" + oraclePort + "/" + profile.getDatabaseName();
        } else {
            connectionString = "jdbc:" + subProtocol + "://" + profile.getDatabaseServer();
            if (!StringUtils.isEmpty((CharSequence)profile.getDatabasePort())) {
                connectionString = connectionString + ":" + profile.getDatabasePort();
            }
            connectionString = profile.getDatabaseType().matches("Microsoft SQL Server") ? connectionString + ";databaseName=" + profile.getDatabaseName() : (profile.getDatabaseType().matches("jTDS SQL Server") ? connectionString + ";databaseName=" + profile.getDatabaseName() : connectionString + "/" + profile.getDatabaseName());
        }
        if (!StringUtils.isEmpty((CharSequence)profile.getConnectionStringSuffix())) {
            connectionString = profile.getDatabaseType().matches("Microsoft SQL Server") ? connectionString + ";" + profile.getConnectionStringSuffix() : (profile.getDatabaseType().matches("jTDS SQL Server") ? connectionString + ";" + profile.getConnectionStringSuffix() : connectionString + "?" + profile.getConnectionStringSuffix());
        }
        log.debug("Connection String: " + connectionString);
        try {
            connect = DriverManager.getConnection(connectionString, username, password);
        }
        catch (SQLException exception) {
            if (exception.getMessage().matches(".*No suitable driver found.*")) {
                pluginConfigManager.loadJdbcDriver(profile.getDatabaseType());
                try {
                    connect = DriverManager.getConnection(connectionString, username, password);
                }
                catch (Exception exception2) {
                    throw new MacroExecutionException((Throwable)exception2);
                }
            }
            throw new MacroExecutionException((Throwable)exception);
        }
        catch (Exception exception) {
            throw new MacroExecutionException((Throwable)exception);
        }
        return connect;
    }
}

