/*
 * Decompiled with CFR 0.152.
 */
package com.keysight.database.helpers;

import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ConnectionProfile {
    private static final Logger log = LoggerFactory.getLogger(ConnectionProfile.class);
    @XmlElement
    public String authorizedUsers;
    @XmlElement
    public String authorizedGroups;
    @XmlElement
    public String authorizedSpaces;
    @XmlElement
    private String connectionStringSuffix;
    @XmlElement
    private String databaseName;
    @XmlElement
    private String databasePassword;
    @XmlElement
    private String databasePort;
    @XmlElement
    private String databaseServer;
    @XmlElement
    private String databaseType;
    @XmlElement
    private String databaseUsername;
    @XmlElement
    private String profileDescription;
    @XmlElement
    private String profileId;
    @XmlElement
    private String profileName;

    public ConnectionProfile() {
    }

    public ConnectionProfile(Element profile) {
        try {
            this.profileName = this.GetValueOfElementWithName(profile, "profile-name");
            this.profileId = this.GetValueOfElementWithName(profile, "profile-id");
            this.profileDescription = this.GetValueOfElementWithName(profile, "profile-description");
            this.authorizedUsers = this.GetValueOfElementWithName(profile, "authorized-users");
            this.authorizedGroups = this.GetValueOfElementWithName(profile, "authorized-groups");
            this.authorizedSpaces = this.GetValueOfElementWithName(profile, "authorized-spaces");
            this.databaseType = this.GetValueOfElementWithName(profile, "database-type");
            this.databaseName = this.GetValueOfElementWithName(profile, "database-name");
            this.databaseServer = this.GetValueOfElementWithName(profile, "database-server");
            this.databasePort = this.GetValueOfElementWithName(profile, "database-port");
            this.databaseUsername = this.GetValueOfElementWithName(profile, "database-username");
            this.databasePassword = this.GetValueOfElementWithName(profile, "database-password");
            this.connectionStringSuffix = this.GetValueOfElementWithName(profile, "connection-string-suffix");
        }
        catch (Exception e) {
            log.error("Failed to get XML details");
        }
    }

    private ArrayList<String> trimList(ArrayList<String> untrimmedList) {
        ArrayList<String> trimmedList = new ArrayList<String>();
        for (String item : untrimmedList) {
            trimmedList.add(item.trim());
        }
        return trimmedList;
    }

    public ArrayList<String> getAuthorizedUsers() {
        if (StringUtils.isEmpty((CharSequence)this.authorizedUsers)) {
            return new ArrayList<String>();
        }
        return this.trimList(new ArrayList<String>(Arrays.asList(StringUtils.split((String)this.authorizedUsers, (String)","))));
    }

    public ArrayList<String> getAuthorizedGroups() {
        if (StringUtils.isEmpty((CharSequence)this.authorizedGroups)) {
            return new ArrayList<String>();
        }
        return this.trimList(new ArrayList<String>(Arrays.asList(StringUtils.split((String)this.authorizedGroups, (String)","))));
    }

    public ArrayList<String> getAuthorizedSpaces() {
        if (StringUtils.isEmpty((CharSequence)this.authorizedSpaces)) {
            return new ArrayList<String>();
        }
        return this.trimList(new ArrayList<String>(Arrays.asList(StringUtils.split((String)this.authorizedSpaces, (String)","))));
    }

    public boolean spaceIsAuthorizedToUseProfile(String spaceKey) {
        boolean spaceHasPermissionsToUseProfile = false;
        ArrayList<String> authorizedSpaces = this.getAuthorizedSpaces();
        if (authorizedSpaces.size() == 0) {
            spaceHasPermissionsToUseProfile = true;
        } else if (authorizedSpaces.contains(spaceKey)) {
            spaceHasPermissionsToUseProfile = true;
        }
        return spaceHasPermissionsToUseProfile;
    }

    public boolean universalAccessAllowed() {
        boolean flag = false;
        if (StringUtils.isEmpty((CharSequence)this.authorizedUsers) && StringUtils.isEmpty((CharSequence)this.authorizedGroups) && StringUtils.isEmpty((CharSequence)this.authorizedSpaces)) {
            flag = true;
        }
        return flag;
    }

    public String getConnectionStringSuffix() {
        return this.connectionStringSuffix;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getDatabasePassword() {
        return this.databasePassword;
    }

    public String getDatabasePort() {
        return this.databasePort;
    }

    public String getDatabaseServer() {
        return this.databaseServer;
    }

    public String getDatabaseType() {
        return this.databaseType;
    }

    public String getDatabaseUsername() {
        return this.databaseUsername;
    }

    public String getProfileDescription() {
        return this.profileDescription;
    }

    public String getProfileId() {
        return this.profileId;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public String getId() {
        return this.getProfileId();
    }

    public String getName() {
        return this.getProfileName();
    }

    private String GetValueOfElementWithName(Element profile, String elementName) {
        String profileName = new String("");
        try {
            NodeList nodeList = profile.getElementsByTagName(elementName);
            if (nodeList.getLength() > 0) {
                profileName = new String(Base64.decodeBase64((String)nodeList.item(0).getTextContent()), "UTF-8");
            }
        }
        catch (Exception e) {
            log.error("Failed to get the value of xml element with name " + elementName + " from the connection profile.");
        }
        return profileName;
    }
}

