/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender.user;

import com.atlassian.confluence.core.DateFormatter;
import com.atlassian.confluence.license.exception.LicenseUserLimitExceededException;
import com.atlassian.confluence.mail.ConfluenceMailServerManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.login.LoginInfo;
import com.atlassian.confluence.security.login.LoginManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.ConfluenceUserImpl;
import com.atlassian.confluence.user.PersonalInformation;
import com.atlassian.confluence.user.PersonalInformationManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.UserDetailsManager;
import com.atlassian.confluence.user.actions.UserDetailsMap;
import com.atlassian.core.exception.InfrastructureException;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.model.user.TimestampedUser;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.PropertyRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.mail.Email;
import com.atlassian.mail.MailException;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.atlassian.user.security.password.Credential;
import com.itlab.confluence.plugins.restextender.helper.ToolsHelper;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/user")
public class UserRestApi {
    private static final Logger log = LoggerFactory.getLogger(UserRestApi.class);
    private final UserAccessor userAccessor;
    private final UserDetailsManager userDetailsManager;
    private final CrowdService crowdService;
    private final LoginManager loginManager;
    private final PermissionManager permissionManager;
    private final PersonalInformationManager personalInformationManager;
    private ToolsHelper toolsHelper;

    @Inject
    public UserRestApi(@ConfluenceImport UserAccessor userAccessor, @ConfluenceImport CrowdService crowdService, @ConfluenceImport UserDetailsManager userDetailsManager, @ConfluenceImport PermissionManager permissionManager, ToolsHelper toolsHelper) {
        this.userAccessor = userAccessor;
        this.userDetailsManager = userDetailsManager;
        this.toolsHelper = toolsHelper;
        this.crowdService = crowdService;
        this.permissionManager = permissionManager;
        this.loginManager = (LoginManager)ComponentLocator.getComponent(LoginManager.class);
        this.personalInformationManager = (PersonalInformationManager)ComponentLocator.getComponent(PersonalInformationManager.class);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{userKey}/preview")
    public Response getUserPreview(@PathParam(value="userKey") String userKey, @QueryParam(value="refresh") boolean refresh, @Context HttpServletRequest request) throws JSONException {
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        ConfluenceUser confluenceUser = this.toolsHelper.getConfluenceUserByKey(userKey);
        DateFormatter dateFormatter = this.toolsHelper.getCurrentUserTimeZoneDateFormatter();
        Map<String, Object> response = new HashMap<String, Object>();
        if (confluenceUser == null) {
            response.put("message", "user '" + userKey + "' does not exist");
            return Response.serverError().entity(response).build();
        }
        response.put("userHasConfluenceAccess", this.convertTrueFalseToImg(this.permissionManager.hasPermission(this.toolsHelper.getAuthenticatedConfluenceUser(), Permission.VIEW, PermissionManager.TARGET_APPLICATION)));
        com.atlassian.crowd.embedded.api.User crowdUser = this.getCrowdUser(confluenceUser);
        CrowdDirectoryService crowdDirectoryService = (CrowdDirectoryService)ComponentLocator.getComponent(CrowdDirectoryService.class);
        Directory directory = crowdDirectoryService.findDirectoryById(crowdUser.getDirectoryId());
        response.put("directory", directory.getName() + " (Id: " + directory.getId() + ")");
        if (!refresh) {
            UserProfile userProfile = this.toolsHelper.getUserProfileByName(confluenceUser.getName());
            response.putAll(this.getLoginPreferences(confluenceUser, dateFormatter));
            response = this.toolsHelper.addUserGroupDetails(response, confluenceUser.getName(), "");
            response.put("groups", this.userAccessor.getGroupNames((User)confluenceUser));
            response.put("userName", confluenceUser.getName());
            response.put("userKey", userProfile.getUserKey().getStringValue());
            response.put("isActive", this.convertTrueFalseToImg(!this.userAccessor.isDeactivated((User)confluenceUser)));
            response.put("displayName", confluenceUser.getFullName());
            response.put("emailAddress", confluenceUser.getEmail());
            response.put("avatarUrl", this.userAccessor.getUserProfilePicture((User)confluenceUser).getUriReference());
            try {
                TimestampedUser timestampedUser = (TimestampedUser)crowdUser;
                response.put("updatedDate", dateFormatter.formatDateTime(timestampedUser.getUpdatedDate()));
                response.put("createdDate", dateFormatter.formatDateTime(timestampedUser.getCreatedDate()));
            }
            catch (Exception ex) {
                response.put("updatedDate", "");
                response.put("createdDate", "");
            }
        }
        response.put("atlassianToken", this.toolsHelper.getXrfsToken(false, request));
        return Response.ok(response).build();
    }

    private String convertTrueFalseToImg(boolean trueOrFalse) {
        String baseUrl = this.toolsHelper.getBaseUrl();
        if (trueOrFalse) {
            return "<img class=\"emoticon\" src=\"" + baseUrl + "/images/icons/emoticons/check.png\" height=\"16\" width=\"16\" align=\"absmiddle\" alt=\"\" border=\"0\">";
        }
        return "<img class=\"emoticon\" src=\"" + baseUrl + "/images/icons/emoticons/forbidden.png\" height=\"16\" width=\"16\" align=\"absmiddle\" alt=\"\" border=\"0\">";
    }

    private com.atlassian.crowd.embedded.api.User getCrowdUser(ConfluenceUser confluenceUser) {
        return this.crowdService.getUser(confluenceUser.getName());
    }

    private Map<String, Object> getLoginPreferences(ConfluenceUser confluenceUser, DateFormatter dateFormatter) {
        HashMap<String, Object> loginPreferencesMap = new HashMap<String, Object>();
        LoginInfo loginInfo = this.loginManager.getLoginInfo(confluenceUser.getName());
        SimpleDateFormat sdfOutput = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        if (loginInfo.getLastSuccessfulLoginDate() == null) {
            loginPreferencesMap.put("lastLoginTimeMilliseconds", null);
            loginPreferencesMap.put("lastLoginTimeDate", null);
            loginPreferencesMap.put("lastLoginTimeCompleteHtml", null);
        } else {
            loginPreferencesMap.put("lastLoginTimeMilliseconds", loginInfo.getLastSuccessfulLoginDate().getTime());
            loginPreferencesMap.put("lastLoginTimeDate", sdfOutput.format(loginInfo.getLastSuccessfulLoginDate()));
            loginPreferencesMap.put("lastLoginTimeCompleteHtml", dateFormatter.formatDateTime(loginInfo.getLastSuccessfulLoginDate()));
        }
        if (loginInfo.getLastFailedLoginDate() == null) {
            loginPreferencesMap.put("lastFailedLoginTimeMilliseconds", null);
            loginPreferencesMap.put("lastFailedLoginTimeDate", null);
            loginPreferencesMap.put("lastFailedLoginTimeCompleteHtml", null);
        } else {
            loginPreferencesMap.put("lastFailedLoginTimeMilliseconds", loginInfo.getLastFailedLoginDate().getTime());
            loginPreferencesMap.put("lastFailedLoginTimeDate", sdfOutput.format(loginInfo.getLastFailedLoginDate()));
            loginPreferencesMap.put("lastFailedLoginTimeCompleteHtml", dateFormatter.formatDateTime(loginInfo.getLastFailedLoginDate()));
        }
        loginPreferencesMap.put("currentFailedLoginCount", loginInfo.getCurrentFailedLoginCount());
        loginPreferencesMap.put("totalFailedLoginCount", loginInfo.getTotalFailedLoginCount());
        loginPreferencesMap.put("isElevatedSecurityCheckRequired", this.loginManager.requiresElevatedSecurityCheck(confluenceUser.getName()));
        if (this.toolsHelper.confluenceVersionIsGreaterThanOrEqualTo(9, 1)) {
            boolean enrolled = false;
            List matchingResults = this.toolsHelper.getDataBaseResults(String.format("SELECT * FROM AO_ED669C_TOTP_USER_ENROLLMENT WHERE USER_KEY = '%s'", confluenceUser.getKey().getStringValue()), "user2FV", true);
            if (matchingResults == null) {
                this.toolsHelper.setUserAuthenticationContextAsValid();
                loginPreferencesMap.put("twoStepVerification", "");
            } else {
                if (!matchingResults.isEmpty()) {
                    enrolled = true;
                }
                loginPreferencesMap.put("twoStepVerification", enrolled ? "<span class=\"aui-lozenge aui-lozenge-subtle aui-lozenge-success\">enrolled</span>" : "<span class=\"aui-lozenge aui-lozenge-subtle\">not enrolled</span>");
            }
        }
        return loginPreferencesMap;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/test/{string}")
    public Response test(@PathParam(value="string") String string, @Context HttpServletRequest request) throws JSONException {
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("test", string);
        response.put("testDecode", this.toolsHelper.decodeUrlParam(string));
        return Response.ok(response).build();
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/captcha/{userName}")
    public Response resetCaptcha(@PathParam(value="userName") String userName, @Context HttpServletRequest request) throws JSONException {
        userName = this.toolsHelper.decodeUrlParam(userName);
        if (log.isDebugEnabled()) {
            log.debug("RESTAPI - get properties");
            log.debug("RESTAPI - userName: " + userName);
        }
        HashMap<String, String> response = new HashMap<String, String>();
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (!(this.toolsHelper.isConfluenceAdministrator() || this.toolsHelper.getAuthenticatedConfluenceUser() != null && this.toolsHelper.getAuthenticatedConfluenceUser().getName().equals(userName))) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.toolsHelper.isUserExistByName(userName)) {
            return this.toolsHelper.userNotFound(userName);
        }
        User confluenceUser = this.toolsHelper.getUserByName(userName);
        this.toolsHelper.resetCaptcha(confluenceUser);
        response.put("message", "done");
        return Response.ok(response).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/property/{userName}/{propertyKey}")
    public Response propertiesGet(@PathParam(value="userName") String userName, @PathParam(value="propertyKey") String propertyKey, @Context HttpServletRequest request) throws JSONException {
        userName = this.toolsHelper.decodeUrlParam(userName);
        log.debug("RESTAPI - get properties");
        log.debug("RESTAPI - userName: " + userName);
        log.debug("RESTAPI - propertyKey: " + propertyKey);
        HashMap<String, String> response = new HashMap<String, String>();
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.toolsHelper.isUserExistByName(userName)) {
            return this.toolsHelper.userNotFound(userName);
        }
        User confluenceUser = this.toolsHelper.getUserByName(userName);
        String propertyValue = "";
        propertyValue = propertyKey.equals("aboutMe") ? this.getPersonalInformation(confluenceUser) : this.userDetailsManager.getStringProperty(confluenceUser, propertyKey);
        response.put("value", propertyValue == null ? "" : propertyValue);
        return Response.ok(response).build();
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/property/{userName}/{propertyKey}")
    public Response propertiesSet(String userJSON, @PathParam(value="userName") String userName, @PathParam(value="propertyKey") String propertyKey, @Context HttpServletRequest request) throws JSONException {
        userName = this.toolsHelper.decodeUrlParam(userName);
        log.debug("RESTAPI - get properties");
        log.debug("RESTAPI - userName: " + userName);
        log.debug("RESTAPI - propertyKey: " + propertyKey);
        HashMap<String, String> response = new HashMap<String, String>();
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.toolsHelper.isUserExistByName(userName)) {
            return this.toolsHelper.userNotFound(userName);
        }
        User confluenceUser = this.toolsHelper.getUserByName(userName);
        JSONObject jsonObject = new JSONObject(userJSON);
        String value = jsonObject.getString("value");
        if (propertyKey.equals("aboutMe")) {
            PersonalInformation personalInformation = this.getPersonalInformationEntity(confluenceUser);
            personalInformation.setBodyAsString(propertyKey);
            boolean shouldUpdatePersonalInfo = this.shouldUpdatePersonalInfo(confluenceUser, confluenceUser.getFullName(), this.getPersonalInformation(confluenceUser));
            if (shouldUpdatePersonalInfo) {
                this.personalInformationManager.savePersonalInformation(confluenceUser, this.getPersonalInformation(confluenceUser), confluenceUser.getFullName());
            }
        } else {
            this.userDetailsManager.setStringProperty(confluenceUser, propertyKey, value);
        }
        response.put("message", "success");
        return Response.ok(response).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/getUserDetails/{userName}")
    public Response getUser(@PathParam(value="userName") String userName, @QueryParam(value="dateFormat") String dateFormatApi, @Context HttpServletRequest request) throws JSONException {
        User confluenceUser;
        log.debug("RESTAPI - getUser");
        userName = this.toolsHelper.decodeUrlParam(userName);
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        if (log.isDebugEnabled()) {
            log.debug("RESTAPI - userName:" + userName);
        }
        if ((confluenceUser = this.toolsHelper.getUserByName(userName)) == null) {
            return this.toolsHelper.userNotFound(userName);
        }
        Map<String, Object> response = new HashMap<String, Object>();
        UserProfile userProfile = this.toolsHelper.getUserProfileByName(userName);
        response = this.toolsHelper.addUserGroupDetails(response, confluenceUser, dateFormatApi);
        response.put("name", confluenceUser.getName());
        response.put("key", userProfile.getUserKey().getStringValue());
        response.put("fullName", confluenceUser.getFullName());
        response.put("email", confluenceUser.getEmail());
        response.put("resourceId", this.getPersonalInformationEntity(confluenceUser).getIdAsString());
        if (this.userAccessor.getUserNamesWithConfluenceAccess().contains(confluenceUser.getName())) {
            response.put("hasAccessToUseConfluence", true);
        } else {
            response.put("hasAccessToUseConfluence", false);
        }
        return Response.ok(response).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/getInactiveUsers")
    public Response getInactiveUsers(@QueryParam(value="startAt") int startAt, @QueryParam(value="maxResults") int maxResults, @QueryParam(value="showBasicDetails") boolean showBasicDetails, @QueryParam(value="showExtendedDetails") boolean showExtendedDetails, @QueryParam(value="dateFormat") String dateFormatApi, @Context HttpServletRequest request) throws JSONException {
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        log.debug("RESTAPI - getInactiveUsers");
        HashMap<String, Serializable> response = new HashMap<String, Serializable>();
        ArrayList<HashMap<String, Object>> usersList = new ArrayList<HashMap<String, Object>>();
        int iterator = 0;
        if (maxResults == 0) {
            maxResults = 50;
        }
        log.debug("RESTAPI - getInactiveUsers - startAt:" + startAt);
        log.debug("RESTAPI - getInactiveUsers - maxResults:" + maxResults);
        log.debug("RESTAPI - getInactiveUsers - show: " + maxResults);
        PropertyRestriction restriction = Restriction.on((Property)UserTermKeys.ACTIVE).containing((Object)false);
        EntityQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)restriction).returningAtMost(-1);
        Iterable inactiveUsers = this.crowdService.search((Query)query);
        for (String userName : inactiveUsers) {
            if (iterator > startAt + maxResults) break;
            if (startAt <= iterator && iterator < startAt + maxResults) {
                ConfluenceUser confluenceUser;
                Map<String, Object> map = new HashMap<String, Object>();
                if ((showBasicDetails || showExtendedDetails) && (confluenceUser = (ConfluenceUser)this.toolsHelper.getUserByName(userName)) != null) {
                    if (showExtendedDetails) {
                        map = this.toolsHelper.addUserGroupDetails(map, userName, dateFormatApi);
                    }
                    map.put("key", confluenceUser.getKey().getStringValue());
                    map.put("fullName", confluenceUser.getFullName());
                    map.put("email", confluenceUser.getEmail());
                    log.debug("RESTAPI - getUsers - using - getUserByName");
                }
                map.put("name", userName);
                usersList.add((HashMap<String, Object>)map);
            }
            ++iterator;
        }
        response.put("total", Integer.valueOf(UserRestApi.size(inactiveUsers)));
        response.put("startAt", Integer.valueOf(startAt));
        response.put("maxResults", Integer.valueOf(maxResults));
        response.put("users", usersList);
        return Response.ok(response).build();
    }

    public static int size(Iterable data) {
        if (data instanceof Collection) {
            return ((Collection)data).size();
        }
        int counter = 0;
        for (Object i : data) {
            ++counter;
        }
        return counter;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/getUsersWithConfluenceAccess")
    public Response getUserNamesWithConfluenceAccess(@QueryParam(value="startAt") int startAt, @QueryParam(value="maxResults") int maxResults, @QueryParam(value="showBasicDetails") boolean showBasicDetails, @QueryParam(value="showExtendedDetails") boolean showExtendedDetails, @QueryParam(value="dateFormat") String dateFormatApi, @Context HttpServletRequest request) throws JSONException {
        log.debug("RESTAPI - getUserNamesWithConfluenceAccess");
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        HashMap<String, Serializable> response = new HashMap<String, Serializable>();
        ArrayList<HashMap<String, Object>> usersList = new ArrayList<HashMap<String, Object>>();
        int iterator = 0;
        if (maxResults == 0) {
            maxResults = 50;
        }
        log.debug("RESTAPI - getUsers - startAt:" + startAt);
        log.debug("RESTAPI - getUsers - maxResults:" + maxResults);
        log.debug("RESTAPI - getUsers - show: " + maxResults);
        List users = this.userAccessor.getUserNamesWithConfluenceAccess();
        log.debug("RESTAPI - getUsers - getAllAsString");
        for (String userName : users) {
            if (iterator > startAt + maxResults) break;
            if (startAt <= iterator && iterator < startAt + maxResults) {
                ConfluenceUser confluenceUser;
                Map<String, Object> map = new HashMap<String, Object>();
                if ((showBasicDetails || showExtendedDetails) && (confluenceUser = (ConfluenceUser)this.toolsHelper.getUserByName(userName)) != null) {
                    if (showExtendedDetails) {
                        map = this.toolsHelper.addUserGroupDetails(map, userName, dateFormatApi);
                    }
                    map.put("key", confluenceUser.getKey().getStringValue());
                    map.put("fullName", confluenceUser.getFullName());
                    map.put("email", confluenceUser.getEmail());
                    log.debug("RESTAPI - getUsers - using - getUserByName");
                }
                map.put("name", userName);
                usersList.add((HashMap<String, Object>)map);
            }
            ++iterator;
        }
        log.debug("RESTAPI - getUsers - entIterator");
        response.put("total", Integer.valueOf(users.size()));
        response.put("startAt", Integer.valueOf(startAt));
        response.put("maxResults", Integer.valueOf(maxResults));
        response.put("users", usersList);
        return Response.ok(response).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/getAllUsers")
    public Response getAllUsers(@QueryParam(value="startAt") int startAt, @QueryParam(value="maxResults") int maxResults, @QueryParam(value="showBasicDetails") boolean showBasicDetails, @QueryParam(value="showExtendedDetails") boolean showExtendedDetails, @QueryParam(value="dateFormat") String dateFormatApi, @QueryParam(value="username") String username, @QueryParam(value="email") String email, @Context HttpServletRequest request) throws JSONException {
        log.debug("RESTAPI - getAllUsers");
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        HashMap<String, Serializable> response = new HashMap<String, Serializable>();
        ArrayList<HashMap<String, Object>> usersList = new ArrayList<HashMap<String, Object>>();
        int iterator = 0;
        if (maxResults == 0) {
            maxResults = 50;
        }
        log.debug("RESTAPI - getUsers - startAt:" + startAt);
        log.debug("RESTAPI - getUsers - maxResults:" + maxResults);
        log.debug("RESTAPI - getUsers - show: " + maxResults);
        log.debug("RESTAPI - getUsers - username: " + (username != null ? username : "null"));
        log.debug("RESTAPI - getUsers - email: " + (email != null ? email : "null"));
        EntityQuery query = null;
        PropertyRestriction restriction = null;
        if (username != null && !username.equals("") || email != null && !email.equals("")) {
            if (username != null && !username.equals("")) {
                log.debug("RESTAPI - getUsers - search by username: " + (username != null ? username : "null"));
                restriction = Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)username);
            } else {
                log.debug("RESTAPI - getUsers - search by email: " + (email != null ? email : "null"));
                restriction = Restriction.on((Property)UserTermKeys.EMAIL).containing((Object)email);
            }
            query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)restriction).returningAtMost(-1);
        } else {
            query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).returningAtMost(-1);
        }
        Iterable userWithParams = this.crowdService.search((Query)query);
        response.put("total", Integer.valueOf(UserRestApi.size(userWithParams)));
        for (String userName : userWithParams) {
            if (iterator > startAt + maxResults) break;
            if (startAt <= iterator && iterator < startAt + maxResults) {
                ConfluenceUser confluenceUser;
                Map<String, Object> map = new HashMap<String, Object>();
                if ((showBasicDetails || showExtendedDetails) && (confluenceUser = (ConfluenceUser)this.toolsHelper.getUserByName(userName)) != null) {
                    if (showExtendedDetails) {
                        map = this.toolsHelper.addUserGroupDetails(map, userName, dateFormatApi);
                    }
                    map.put("key", confluenceUser.getKey().getStringValue());
                    map.put("fullName", confluenceUser.getFullName());
                    map.put("email", confluenceUser.getEmail());
                    log.debug("RESTAPI - getUsers - using - getUserByName");
                }
                map.put("name", userName);
                usersList.add((HashMap<String, Object>)map);
            }
            ++iterator;
        }
        response.put("startAt", Integer.valueOf(startAt));
        response.put("maxResults", Integer.valueOf(maxResults));
        response.put("users", usersList);
        return Response.ok(response).build();
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/add")
    public Response addUser(String userJSON, @Context HttpServletRequest request) throws JSONException {
        log.debug("RESTAPI - addUser");
        HashMap<String, String> response = new HashMap<String, String>();
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        JSONObject jsonObject = new JSONObject(userJSON);
        boolean sendMail = false;
        try {
            sendMail = jsonObject.getBoolean("sendMail");
        }
        catch (JSONException e) {
            log.debug("RESTAPI - sendMail - sendMail:empty");
        }
        String bcc = "";
        try {
            bcc = jsonObject.getString("bcc");
        }
        catch (JSONException e) {
            log.debug("RESTAPI - bcc - debug:empty");
        }
        String header = "";
        try {
            header = jsonObject.getString("header");
        }
        catch (JSONException e) {
            log.debug("RESTAPI - header - debug:empty");
        }
        String footer = "";
        try {
            footer = jsonObject.getString("footer");
        }
        catch (JSONException e) {
            log.debug("RESTAPI - header - debug:empty");
        }
        String name = "";
        try {
            name = jsonObject.getString("name");
        }
        catch (JSONException e) {
            log.debug("RESTAPI - addUser - name:empty");
        }
        String fullName = "";
        try {
            fullName = jsonObject.getString("fullName");
        }
        catch (JSONException e) {
            log.debug("RESTAPI - addUser - fullName:empty");
        }
        String email = "";
        try {
            email = jsonObject.getString("email");
        }
        catch (JSONException e) {
            log.debug("RESTAPI - addUser - email:empty");
        }
        String password = "";
        try {
            password = jsonObject.getString("password");
        }
        catch (JSONException e) {
            log.debug("RESTAPI - addUser - password:empty");
        }
        if (password == null || password.equals("")) {
            password = UUID.randomUUID().toString();
        }
        ArrayList<Object> groups = new ArrayList();
        try {
            groups = this.toolsHelper.getJSONarray(jsonObject, "groups");
        }
        catch (JSONException e) {
            log.debug("RESTAPI - addUser - groups:empty");
        }
        if (name.equals("") || email.equals("") || fullName.equals("")) {
            response.put("message", "User parameters: name, fullName, email is required");
            return Response.serverError().entity(response).build();
        }
        if (this.toolsHelper.isUserExistByName(name)) {
            response.put("message", "User with name '" + name + "' already exist");
            return Response.serverError().entity(response).build();
        }
        if (StringUtils.containsAny((CharSequence)name, (CharSequence)"\\,+<>'\"")) {
            response.put("message", "Usernames cannot contain the characters +, <, >, comma, backslash, apostrophe, or quote");
            return Response.serverError().entity(response).build();
        }
        if (!name.matches("[^\\s]+")) {
            response.put("message", "Usernames cannot contain any whitespace characters");
            return Response.serverError().entity(response).build();
        }
        if (this.toolsHelper.getTranslation("anonymous.name").equalsIgnoreCase(name) || "anonymous".equalsIgnoreCase(name)) {
            response.put("message", "This username is reserved for use by Confluence");
            return Response.serverError().entity(response).build();
        }
        if (!name.equals(name.toLowerCase())) {
            response.put("message", "The username must be in lower case");
            return Response.serverError().entity(response).build();
        }
        if (StringUtils.containsAny((CharSequence)fullName, (CharSequence)"<>")) {
            response.put("message", "Full Names cannot contain < or >");
            return Response.serverError().entity(response).build();
        }
        if (this.toolsHelper.getTranslation("anonymous.name").equalsIgnoreCase(fullName) || "anonymous".equalsIgnoreCase(fullName)) {
            response.put("message", "This name is reserved for use by Confluence");
            return Response.serverError().entity(response).build();
        }
        try {
            ConfluenceUserImpl confluenceUser = new ConfluenceUserImpl(name, fullName, email);
            ConfluenceUser newUser = this.userAccessor.createUser((User)confluenceUser, Credential.unencrypted((String)password));
            Group confluenceDefaultGroup = this.userAccessor.getGroup(this.toolsHelper.getDefaultUsersGroup());
            if (confluenceDefaultGroup != null) {
                this.userAccessor.addMembership(confluenceDefaultGroup, (User)newUser);
            }
            for (String string : groups) {
                Group group = this.userAccessor.getGroup(string);
                if (group == null) continue;
                if (this.toolsHelper.isSystemAdministrator()) {
                    this.userAccessor.addMembership(group, (User)newUser);
                    continue;
                }
                if (string.equalsIgnoreCase("confluence-administrators") || this.toolsHelper.objectHasGlobalPermission("group", string, "SYSTEMADMINISTRATOR")) {
                    return this.toolsHelper.permissionViolation();
                }
                this.userAccessor.addMembership(group, (User)newUser);
            }
            response.put("message", "User " + newUser.getName() + " (" + newUser.getFullName() + ") was created");
            if (sendMail) {
                ConfluenceMailServerManager confluenceMailServerManager = (ConfluenceMailServerManager)ComponentLocator.getComponent(ConfluenceMailServerManager.class);
                SMTPMailServer sMTPMailServer = confluenceMailServerManager.getDefaultSMTPMailServer();
                if (sMTPMailServer != null) {
                    Email mail = new Email(email);
                    if (bcc != null && !bcc.equals("")) {
                        mail.setBcc(bcc);
                    }
                    String message = (header != null && !header.equals("") ? header : "") + "<b>User:</b> " + name + "<br><b>Full name:</b> " + fullName + "<br><b>Password:</b> " + password + (footer != null && !footer.equals("") ? footer : "");
                    message = this.toolsHelper.getMailBody(false).replace("@@CONTENT@@", message);
                    mail.setBody(message);
                    mail.setSubject("Your account has been successfully created");
                    mail.setMimeType("text/html;charset=utf-8");
                    ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(SMTPMailServer.class.getClassLoader());
                    sMTPMailServer.send(mail);
                    Thread.currentThread().setContextClassLoader(threadClassLoader);
                    response.put("mailStatus", "successfully sent");
                } else {
                    response.put("mailStatus", "not sent, mail server does not exist");
                }
            }
        }
        catch (LicenseUserLimitExceededException e) {
            response.put("message", "License User Limit Exceeded ");
            return Response.serverError().entity(response).build();
        }
        catch (InfrastructureException e) {
            response.put("message", "Failed to create user: '" + name + "' :: InfrastructureException");
            return Response.serverError().entity(response).build();
        }
        catch (MailException e) {
            response.put("mailStatus", "error while sending :: " + e.getMessage());
        }
        return Response.ok(response).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/rename/{userName}")
    public Response rename(String userJSON, @PathParam(value="userName") String userName, @Context HttpServletRequest request) throws JSONException {
        log.debug("RESTAPI - rename");
        HashMap<String, String> response = new HashMap<String, String>();
        userName = this.toolsHelper.decodeUrlParam(userName);
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        JSONObject jsonObject = new JSONObject(userJSON);
        String name = "";
        try {
            name = jsonObject.get("name").toString();
        }
        catch (JSONException e) {
            log.debug("RESTAPI - addUser - name:empty");
        }
        if (name.equals("")) {
            response.put("message", "parameter 'name' is required");
            return Response.serverError().entity(response).build();
        }
        ConfluenceUser confluenceUser = this.userAccessor.getUserByName(userName);
        if (confluenceUser == null) {
            response.put("message", "User '" + userName + "' does not exist");
            return Response.serverError().entity(response).build();
        }
        if (this.userAccessor.isReadOnly((User)confluenceUser)) {
            response.put("message", "User '" + userName + "' is read only");
            return Response.serverError().entity(response).build();
        }
        if (this.toolsHelper.isUserExistByName(name)) {
            response.put("message", "User with name '" + name + "' already exist");
            return Response.serverError().entity(response).build();
        }
        if (StringUtils.containsAny((CharSequence)name, (CharSequence)"\\,+<>'\"")) {
            response.put("message", "Usernames cannot contain the characters +, <, >, comma, backslash, apostrophe, or quote");
            return Response.serverError().entity(response).build();
        }
        if (!name.matches("[^\\s]+")) {
            response.put("message", "Usernames cannot contain any whitespace characters");
            return Response.serverError().entity(response).build();
        }
        if (this.toolsHelper.getTranslation("anonymous.name").equalsIgnoreCase(name) || "anonymous".equalsIgnoreCase(name)) {
            response.put("message", "This username is reserved for use by Confluence");
            return Response.serverError().entity(response).build();
        }
        if (!name.equals(name.toLowerCase())) {
            response.put("message", "The username must be in lower case");
            return Response.serverError().entity(response).build();
        }
        String oldName = confluenceUser.getName();
        confluenceUser = this.userAccessor.getUserByName(name);
        if (confluenceUser != null) {
            response.put("message", "New user name '" + name + "' exist");
            return Response.serverError().entity(response).build();
        }
        try {
            this.userAccessor.renameUser(this.userAccessor.getUserByName(userName), name);
        }
        catch (Exception e) {
            response.put("message", "Internal error " + e);
            return Response.serverError().entity(response).build();
        }
        response.put("message", "User name '" + oldName + "' was changed into '" + name + "'");
        return Response.ok(response).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/changeDetails/{userName}")
    public Response changeDetails(String userJSON, @PathParam(value="userName") String userName, @Context HttpServletRequest request) throws JSONException {
        log.debug("RESTAPI - changeDetails");
        HashMap<String, String> response = new HashMap<String, String>();
        userName = this.toolsHelper.decodeUrlParam(userName);
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        JSONObject jsonObject = new JSONObject(userJSON);
        String fullName = "";
        try {
            fullName = jsonObject.get("fullName").toString();
            if (StringUtils.containsAny((CharSequence)fullName, (CharSequence)"<>")) {
                response.put("message", "Full Names cannot contain < or >");
                return Response.serverError().entity(response).build();
            }
            if (this.toolsHelper.getTranslation("anonymous.name").equalsIgnoreCase(fullName) || "anonymous".equalsIgnoreCase(fullName)) {
                response.put("message", "This name is reserved for use by Confluence");
                return Response.serverError().entity(response).build();
            }
        }
        catch (JSONException e) {
            log.debug("RESTAPI - changeDetails - fullName:empty");
        }
        String email = "";
        try {
            email = jsonObject.get("email").toString();
        }
        catch (JSONException e) {
            log.debug("RESTAPI - changeDetails - email:empty");
        }
        String password = "";
        try {
            password = jsonObject.get("password").toString();
        }
        catch (JSONException e) {
            log.debug("RESTAPI - changeDetails - password:empty");
        }
        if (email.equals("") && fullName.equals("") && password.equals("")) {
            response.put("message", "Please provide some details to change");
            return Response.serverError().entity(response).build();
        }
        User confluenceUser = this.toolsHelper.getUserByName(userName);
        if (!this.toolsHelper.isUserExistByName(userName)) {
            return this.toolsHelper.userNotFound(userName);
        }
        if (!this.canUpdateUser(confluenceUser)) {
            response.put("message", "User '" + userName + "' is externally managed or read-only user");
            return Response.serverError().entity(response).build();
        }
        boolean shouldUpdatePersonalInfo = false;
        try {
            UserTemplate userTemplate = new UserTemplate(confluenceUser.getName());
            if (!fullName.equals("")) {
                userTemplate.setDisplayName(fullName);
                shouldUpdatePersonalInfo = this.shouldUpdatePersonalInfo(confluenceUser, fullName, this.getPersonalInformation(confluenceUser));
            } else {
                userTemplate.setDisplayName(confluenceUser.getFullName());
            }
            if (!email.equals("")) {
                userTemplate.setEmailAddress(email);
            } else {
                userTemplate.setEmailAddress(confluenceUser.getEmail());
            }
            if (!password.equals("")) {
                this.crowdService.updateUserCredential((com.atlassian.crowd.embedded.api.User)userTemplate, password);
            }
            if (log.isDebugEnabled()) {
                log.debug("save fullName:" + fullName);
                log.debug("save email:" + email);
                log.debug("save password:" + password);
                log.debug("save shouldUpdatePersonalInfo:" + shouldUpdatePersonalInfo);
            }
            userTemplate.setActive(!this.toolsHelper.userIsDeactivated(confluenceUser.getName()));
            this.crowdService.updateUser((com.atlassian.crowd.embedded.api.User)userTemplate);
            UserDetailsMap userDetailsMap = new UserDetailsMap(confluenceUser, this.userDetailsManager);
            userDetailsMap.copyPropertiesToManager();
            if (shouldUpdatePersonalInfo) {
                this.personalInformationManager.savePersonalInformation(confluenceUser, this.getPersonalInformation(confluenceUser), fullName);
            }
        }
        catch (Exception e) {
            String rootCause = ExceptionUtils.getRootCauseMessage((Throwable)e);
            response.put("message", "Failed to update user profile. Cause: " + rootCause);
            return Response.serverError().entity(response).build();
        }
        response.put("message", "User " + confluenceUser.getName() + " (" + confluenceUser.getFullName() + ") was changed");
        return Response.ok(response).build();
    }

    public String getPersonalInformation(User user) {
        return this.getPersonalInformationEntity(user).getBodyContent().getBody();
    }

    private PersonalInformation getPersonalInformationEntity(User user) {
        return this.personalInformationManager.getOrCreatePersonalInformation(user);
    }

    private boolean shouldUpdatePersonalInfo(User user, String fullName, String newInfo) {
        PersonalInformation oldInfo = this.getPersonalInformationEntity(user);
        return oldInfo == null || !newInfo.equals(oldInfo.getBodyContent().getBody()) || this.hasFullNameChanged(user, fullName);
    }

    private boolean hasFullNameChanged(User user, String fullName) {
        return fullName != null && !fullName.trim().equals(user.getFullName());
    }

    private boolean canUpdateUser(User user) {
        return !this.toolsHelper.isExternalUserManagement() && !this.userAccessor.isReadOnly(user);
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/delete/{userName}")
    public Response delete(@PathParam(value="userName") String userName, @Context HttpServletRequest request) throws JSONException {
        log.debug("RESTAPI - delete");
        HashMap<String, String> response = new HashMap<String, String>();
        userName = this.toolsHelper.decodeUrlParam(userName);
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        User confluenceUser = this.toolsHelper.getUserByName(userName);
        if (!this.toolsHelper.isUserExistByName(userName)) {
            return this.toolsHelper.userNotFound(userName);
        }
        if (this.userAccessor.isReadOnly(confluenceUser)) {
            response.put("message", "User '" + userName + "' is read only");
            return Response.serverError().entity(response).build();
        }
        try {
            if (!this.userAccessor.isUserRemovable(confluenceUser)) {
                response.put("message", "User '" + userName + "' cannot be deleted");
                return Response.serverError().entity(response).build();
            }
        }
        catch (Exception e) {
            response.put("message", "Could not check whether user '" + userName + "' is removable. Check your server logs for more information.");
            return Response.serverError().entity(response).build();
        }
        if (this.toolsHelper.isConfluenceAdministrator() && !this.toolsHelper.isSystemAdministrator() && this.toolsHelper.objectHasGlobalPermission("user", userName, "SYSTEMADMINISTRATOR")) {
            return this.toolsHelper.permissionViolation();
        }
        String userNameAfter = confluenceUser.getName();
        String userFullNameAfter = confluenceUser.getFullName();
        try {
            this.userAccessor.removeUser(confluenceUser);
        }
        catch (Exception ex) {
            response.put("message", "Failed to remove user '" + userName + "'");
            return Response.serverError().entity(response).build();
        }
        response.put("message", "User '" + userNameAfter + " (" + userFullNameAfter + ")' was deleted");
        return Response.ok(response).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/activate/{userName}")
    public Response activate(@PathParam(value="userName") String userName, @Context HttpServletRequest request) throws JSONException {
        log.debug("RESTAPI - activate");
        HashMap<String, String> response = new HashMap<String, String>();
        userName = this.toolsHelper.decodeUrlParam(userName);
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        User confluenceUser = this.toolsHelper.getUserByName(userName);
        if (!this.toolsHelper.isUserExistByName(userName)) {
            return this.toolsHelper.userNotFound(userName);
        }
        if (this.userAccessor.isReadOnly(confluenceUser)) {
            response.put("message", "User '" + userName + "' is read only");
            return Response.serverError().entity(response).build();
        }
        this.userAccessor.reactivateUser(confluenceUser);
        response.put("message", "User " + confluenceUser.getName() + " (" + confluenceUser.getFullName() + ") activated");
        return Response.ok(response).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/deactivate/{userName}")
    public Response deactivate(@PathParam(value="userName") String userName, @Context HttpServletRequest request) throws JSONException {
        log.debug("RESTAPI - deactivate");
        HashMap<String, String> response = new HashMap<String, String>();
        userName = this.toolsHelper.decodeUrlParam(userName);
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        User confluenceUser = this.toolsHelper.getUserByName(userName);
        if (!this.toolsHelper.isUserExistByName(userName)) {
            return this.toolsHelper.userNotFound(userName);
        }
        if (this.userAccessor.isReadOnly(confluenceUser)) {
            response.put("message", "User '" + userName + "' is read only");
            return Response.serverError().entity(response).build();
        }
        if (this.toolsHelper.isConfluenceAdministrator() && !this.toolsHelper.isSystemAdministrator() && this.toolsHelper.objectHasGlobalPermission("user", userName, "SYSTEMADMINISTRATOR")) {
            return this.toolsHelper.permissionViolation();
        }
        this.userAccessor.deactivateUser(confluenceUser);
        response.put("message", "User " + confluenceUser.getName() + " (" + confluenceUser.getFullName() + ") deactivated");
        return Response.ok(response).build();
    }
}

