/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender.upgrade;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import com.itlab.confluence.plugins.restextender.helper.ExtenderConfiguration;
import java.util.Collection;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={PluginUpgradeTask.class})
public class BandanaManagerMigrationTask
implements PluginUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(BandanaManagerMigrationTask.class);
    private final ExtenderConfiguration extenderConfiguration;
    private static final String BANDANA_DEPRECATED = "com.itlab.confluence.plugins.restextender.bandanaMigration";
    private static final String DEFAULT_FALSE_VALUE = "false";
    private static final String DEFAULT_EMPTY_VALUE = "";

    public BandanaManagerMigrationTask(ExtenderConfiguration extenderConfiguration) {
        this.extenderConfiguration = extenderConfiguration;
    }

    public int getBuildNumber() {
        return 1;
    }

    public String getShortDescription() {
        return "BandanaManager Migration Task - BandanaManager -> PluginSettings";
    }

    public Collection<Message> doUpgrade() {
        if (!this.isMigrated()) {
            this.migrateBandanaManager();
        }
        return Collections.emptySet();
    }

    public String getPluginKey() {
        return "com.itlab.confluence.plugins.restapi-extender";
    }

    public boolean isMigrated() {
        String migrated = this.extenderConfiguration.getString(BANDANA_DEPRECATED, DEFAULT_FALSE_VALUE);
        if (migrated == null) {
            return false;
        }
        return migrated.toString().equalsIgnoreCase("true");
    }

    public void migrateBandanaManager() {
        log.warn(" --- EXTENDER --- BandanaManager Migration Task --- START --- ");
        BandanaManager bandanaManager = (BandanaManager)ComponentLocator.getComponent(BandanaManager.class);
        for (String key : bandanaManager.getKeys((BandanaContext)new ConfluenceBandanaContext())) {
            if (key == null || key.isEmpty() || !key.toLowerCase().startsWith("com.itlab.confluence.plugins.restapi-extender") && !key.toLowerCase().startsWith("com.itlab.confluence.plugins.restapiextender") && !key.toLowerCase().startsWith("com.itlab.confluence.plugins.extender")) continue;
            log.warn(" --- EXTENDER --- BandanaManager Migration Task --- " + key + " --- init --- ");
            Object value = bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), key);
            if (value == null) {
                this.extenderConfiguration.setString(key, DEFAULT_EMPTY_VALUE);
            } else {
                this.extenderConfiguration.setString(key, value.toString());
            }
            log.warn(" --- EXTENDER --- BandanaManager Migration Task --- " + key + " --- done --- ");
        }
        log.warn(" --- EXTENDER --- BandanaManager Migration Task --- END --- ");
        this.extenderConfiguration.setString(BANDANA_DEPRECATED, "true");
    }
}

