/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender.tokens.rest;

import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.confluence.api.model.audit.AffectedObject;
import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.user.UserProfile;
import com.itlab.confluence.plugins.restextender.helper.ToolsHelper;
import com.itlab.confluence.plugins.restextender.tokens.model.Token;
import com.itlab.confluence.plugins.restextender.tokens.model.TokenContainer;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.RandomStringUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/tokenTools")
public class TokenUtils {
    private static final Logger log = LoggerFactory.getLogger(TokenUtils.class);
    private final ToolsHelper toolsHelper;

    @Inject
    public TokenUtils(ToolsHelper toolsHelper) {
        this.toolsHelper = toolsHelper;
    }

    private boolean isModuleForUserIsEnabled() {
        PluginAccessor pluginAccessor = (PluginAccessor)ComponentLocator.getComponent(PluginAccessor.class);
        ModuleDescriptor pluginModule = pluginAccessor.getEnabledPluginModule("com.itlab.confluence.plugins.restapi-extender:extender-rest-api-tokens-user-profile-xwork");
        if (log.isDebugEnabled()) {
            log.debug("pluginModule = " + (pluginModule == null ? "null" : Boolean.valueOf(pluginModule.isEnabled())));
        }
        if (pluginModule == null) {
            return false;
        }
        return pluginModule.isEnabled();
    }

    @ReadOnlyAccessAllowed
    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/delete")
    public Response clear(String jsonString, @Context HttpServletRequest request) throws JSONException {
        ConfluenceUser currentUser = this.toolsHelper.getAuthenticatedConfluenceUser();
        if (!this.toolsHelper.isConfluenceAdministrator() && currentUser == null) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.toolsHelper.isConfluenceAdministrator() && !this.isModuleForUserIsEnabled()) {
            return this.toolsHelper.permissionViolation();
        }
        JSONObject jsonObject = new JSONObject(jsonString);
        String stringToken = jsonObject.has("token") ? jsonObject.getString("token") : "";
        String id = jsonObject.has("id") ? jsonObject.getString("id") : "";
        TokenContainer tokenContainer = this.toolsHelper.getSavedTokens();
        ArrayList<Token> newTokens = new ArrayList<Token>();
        for (Token token : tokenContainer.getTokens()) {
            if (!token.getToken().equals(stringToken)) {
                if (!ToolsHelper.encrypt(token.getToken()).equals(id)) {
                    newTokens.add(token);
                    continue;
                }
            }
            if (!this.toolsHelper.isConfluenceAdministrator() && token.getAuthorKey() != null && !token.getAuthorKey().equals(currentUser.getKey())) {
                return this.toolsHelper.permissionViolation();
            }
            if (!this.toolsHelper.isConfluenceAdministrator() && token.getUserKey() != null && !token.getUserKey().equals(currentUser.getKey())) {
                return this.toolsHelper.permissionViolation();
            }
            this.addAuditRecord(token, "deleted", request, "Token", "");
        }
        tokenContainer.setTokens(newTokens);
        this.toolsHelper.saveTokens(tokenContainer);
        return Response.ok().build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/config/{option}")
    public Response setConfig(@PathParam(value="option") String option) {
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        if (option.equalsIgnoreCase("limit") || option.equalsIgnoreCase("nolimit")) {
            this.toolsHelper.savedTokensConfig(option.toLowerCase());
        }
        if (option.equalsIgnoreCase("basic") || option.equalsIgnoreCase("bearer") || option.equalsIgnoreCase("all")) {
            this.toolsHelper.setTokensAccessType(option.toLowerCase());
        }
        return Response.ok().build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/get")
    public Response getTokens(@QueryParam(value="startAt") int startAt, @QueryParam(value="maxResults") int maxResults, @QueryParam(value="initCall") boolean initCall, @QueryParam(value="search") @DefaultValue(value="") String search, @QueryParam(value="tokenExpiryDate") @DefaultValue(value="all") String tokenExpiryDate, @QueryParam(value="userKey") @DefaultValue(value="") String tokenUser, @Context HttpServletRequest request) {
        boolean isSearch;
        ConfluenceUser currentUser = this.toolsHelper.getAuthenticatedConfluenceUser();
        if (!this.toolsHelper.isConfluenceAdministrator() && currentUser == null) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.toolsHelper.isConfluenceAdministrator() && !this.isModuleForUserIsEnabled()) {
            return this.toolsHelper.permissionViolation();
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        TokenContainer tokenContainer = this.toolsHelper.getSavedTokens();
        boolean tokenConfigurationSecureMode = this.toolsHelper.getTokenConfigurationSecureMode();
        if (log.isDebugEnabled()) {
            log.debug("startAt = " + startAt);
            log.debug("maxResults = " + maxResults);
            log.debug("search = " + search);
            log.debug("tokenExpiryDate = " + tokenExpiryDate);
            log.debug("tokenUser = " + tokenUser);
        }
        ArrayList<Token> tokens = tokenContainer.getTokens();
        ArrayList arrayTokens = new ArrayList();
        int iterator = 0;
        if (maxResults == 0) {
            maxResults = 100;
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            tokenUser = currentUser.getKey().getStringValue();
        }
        ArrayList<Token> searchTokens = new ArrayList<Token>();
        boolean bl = isSearch = !search.isEmpty() || !tokenExpiryDate.equalsIgnoreCase("all") || !tokenUser.isEmpty();
        if (isSearch && !tokenUser.isEmpty()) {
            for (Token token : tokens) {
                String tokenUserString;
                if (tokenUser.isEmpty() || !(tokenUserString = (token.getUserKey() != null ? token.getUserKey() : "") + (token.getUser() != null ? token.getUser() : "")).toLowerCase().contains(tokenUser.toLowerCase())) continue;
                searchTokens.add(token);
            }
            tokens = searchTokens;
            searchTokens = new ArrayList();
        }
        if (isSearch) {
            for (Token token : tokens) {
                if (search.isEmpty()) {
                    searchTokens.add(token);
                } else if (token.getLabel() != null && token.getLabel().toLowerCase().contains(search.toLowerCase())) {
                    searchTokens.add(token);
                } else if (token.getLimitTo() != null && token.getLimitTo().toLowerCase().contains(search.toLowerCase())) {
                    searchTokens.add(token);
                } else if ((token.getUser() == null || token.getUser() != null && token.getUser().isEmpty()) && "any user".contains(search.toLowerCase())) {
                    searchTokens.add(token);
                }
                if (tokenExpiryDate.equalsIgnoreCase("all") || !searchTokens.contains(token)) continue;
                if (tokenExpiryDate.equalsIgnoreCase("never") && token.getValidUntil() != null) {
                    searchTokens.remove(token);
                    continue;
                }
                if (!tokenExpiryDate.equalsIgnoreCase("expires") || token.getValidUntil() != null) continue;
                searchTokens.remove(token);
            }
        }
        for (Token token : isSearch ? searchTokens : tokens) {
            if (startAt <= iterator && iterator < startAt + maxResults) {
                ConfluenceUser confluenceUser;
                HashMap<String, Object> tokenMap = new HashMap<String, Object>();
                tokenMap.put("dateCreated", token.getDateCreated() == null ? "" : token.getDateCreated());
                tokenMap.put("label", token.getLabel() == null ? "" : token.getLabel());
                tokenMap.put("limitTo", token.getLimitTo() == null ? "" : token.getLimitTo());
                if (!tokenConfigurationSecureMode) {
                    tokenMap.put("token", token.getToken() == null ? "" : token.getToken());
                }
                tokenMap.put("id", token.getToken() == null ? "" : ToolsHelper.encrypt(token.getToken()));
                tokenMap.put("user", token.getUser());
                tokenMap.put("authorKey", token.getAuthorKey() == null ? "" : token.getAuthorKey());
                if (!this.toolsHelper.isConfluenceAdministrator() && token.getAuthorKey() != null && !token.getAuthorKey().equals(currentUser.getKey().getStringValue())) {
                    tokenMap.put("authorKey", "");
                }
                tokenMap.put("userKey", token.getUserKey());
                tokenMap.put("userDisplayName", token.getUserKey());
                if (token.getUserKey() != null && !token.getUserKey().equals("") && !token.getUserKey().equals("not found") && (confluenceUser = this.toolsHelper.getConfluenceUserByKey(token.getUserKey())) != null) {
                    tokenMap.put("user", confluenceUser.getName());
                    tokenMap.put("userDisplayName", confluenceUser.getFullName());
                }
                tokenMap.put("validUntil", token.getValidUntil() == null ? "" : token.getValidUntil());
                if (tokenContainer.getCollectUsageDetails()) {
                    tokenMap.put("ip", token.getIp() == null ? "" : token.getIp());
                    tokenMap.put("lastUsed", token.getLastUsed() == null ? "" : token.getLastUsed());
                    tokenMap.put("counter", token.getCounter());
                }
                arrayTokens.add(tokenMap);
            }
            ++iterator;
        }
        if (tokenContainer.getTokens().isEmpty()) {
            response.put("status", "empty");
        } else {
            response.put("status", "ok");
            response.put("tokens", arrayTokens);
        }
        int total = isSearch ? searchTokens.size() : tokens.size();
        response.put("pages", total / maxResults + (total % maxResults > 0 ? 1 : 0));
        response.put("total", total);
        response.put("startAt", startAt);
        response.put("maxResults", maxResults);
        if (initCall) {
            response.put("collectUsageDetails", tokenContainer.getCollectUsageDetails());
            String systemExpiryDays = System.getProperty("atlassian.pats.max.tokens.expiry.days");
            response.put("atlassian.pats.max.tokens.expiry.days", systemExpiryDays != null && !systemExpiryDays.isEmpty() && this.toolsHelper.isNumeric(systemExpiryDays) ? systemExpiryDays : "");
            response.put("addAuditRecord", tokenContainer.getAddAuditRecord());
            response.put("tokenAccessType", this.toolsHelper.getTokensAccessType());
            response.put("config", this.toolsHelper.getTokensConfig());
        }
        return Response.ok(response).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/edit")
    public Response editToken(String jsonString, @Context HttpServletRequest request) throws JSONException {
        String id;
        ConfluenceUser currentUser = this.toolsHelper.getAuthenticatedConfluenceUser();
        if (!this.toolsHelper.isConfluenceAdministrator() && currentUser == null) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.toolsHelper.isConfluenceAdministrator() && !this.isModuleForUserIsEnabled()) {
            return this.toolsHelper.permissionViolation();
        }
        if (this.toolsHelper.getTokenConfigurationSecureMode()) {
            return this.toolsHelper.permissionViolation();
        }
        JSONObject jsonObject = new JSONObject(jsonString);
        String stringToken = jsonObject.has("token") ? jsonObject.getString("token") : "";
        String string = id = jsonObject.has("id") ? jsonObject.getString("id") : "";
        if (this.toolsHelper.getTokenConfigurationSecureMode()) {
            if (!jsonObject.has("id") || jsonObject.getString("id").equals("")) {
                return this.toolsHelper.fieldRequired("id");
            }
        } else if (!jsonObject.has("token") || jsonObject.getString("token").equals("")) {
            return this.toolsHelper.fieldRequired("token");
        }
        if (!jsonObject.has("label") || jsonObject.getString("label").equals("")) {
            return this.toolsHelper.fieldRequired("label");
        }
        TokenContainer tokenContainer = this.toolsHelper.getSavedTokens();
        ArrayList<Token> newTokens = new ArrayList<Token>();
        for (Token token : tokenContainer.getTokens()) {
            block19: {
                block18: {
                    if (token.getToken().equals(stringToken)) break block18;
                    if (!ToolsHelper.encrypt(token.getToken()).equals(id)) break block19;
                }
                if (!this.toolsHelper.isConfluenceAdministrator() && token.getAuthorKey() != null && !token.getAuthorKey().equals(currentUser.getKey())) {
                    return this.toolsHelper.permissionViolation();
                }
                if (!this.toolsHelper.isConfluenceAdministrator() && token.getUserKey() != null && !token.getUserKey().equals(currentUser.getKey())) {
                    return this.toolsHelper.permissionViolation();
                }
                boolean setLimitTo = false;
                String limitTo = "";
                if (jsonObject.has("limitTo")) {
                    limitTo = jsonObject.getString("limitTo");
                    if (!limitTo.equals("") && (limitTo.contains("\\n") || limitTo.contains("\\\\n"))) {
                        limitTo = limitTo.replaceAll("\\\\n", "<br>").replaceAll("\\n", "<br>");
                    }
                    setLimitTo = true;
                }
                String newData = "Name: " + jsonObject.getString("label") + ", Limit to: " + limitTo.replace("<br>", " - ");
                this.addAuditRecord(token, "changed", request, "Changes", newData);
                if (setLimitTo) {
                    token.setLimitTo(limitTo);
                }
                token.setLabel(jsonObject.getString("label"));
            }
            newTokens.add(token);
        }
        tokenContainer.setTokens(newTokens);
        this.toolsHelper.saveTokens(tokenContainer);
        return Response.ok().build();
    }

    @ReadOnlyAccessAllowed
    @POST
    @Produces(value={"application/json"})
    @Path(value="/set")
    public Response setTokens(String jsonString, @Context HttpServletRequest request) throws JSONException {
        ConfluenceUser currentUser = this.toolsHelper.getAuthenticatedConfluenceUser();
        if (!this.toolsHelper.isConfluenceAdministrator() && currentUser == null) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.toolsHelper.isConfluenceAdministrator() && !this.isModuleForUserIsEnabled()) {
            return this.toolsHelper.permissionViolation();
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        JSONObject jsonObject = new JSONObject(jsonString);
        if (jsonObject.has("collectUsageDetails") && this.toolsHelper.isConfluenceAdministrator()) {
            TokenContainer tokenContainer = this.toolsHelper.getSavedTokens();
            tokenContainer.setCollectUsageDetails(jsonObject.getBoolean("collectUsageDetails"));
            this.toolsHelper.saveTokens(tokenContainer);
            return Response.ok().build();
        }
        if (jsonObject.has("addAuditRecord") && this.toolsHelper.isConfluenceAdministrator()) {
            TokenContainer tokenContainer = this.toolsHelper.getSavedTokens();
            tokenContainer.setAddAuditRecord(jsonObject.getBoolean("addAuditRecord"));
            this.toolsHelper.saveTokens(tokenContainer);
            return Response.ok().build();
        }
        String label = "";
        String userName = "";
        String stringToken = "";
        String daysUntilExpiry = "";
        String limitTo = "";
        if (jsonObject.isNull("label") || jsonObject.getString("label").equals("")) {
            return this.toolsHelper.fieldRequired("label");
        }
        label = jsonObject.getString("label");
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            userName = currentUser.getName();
        } else if (!jsonObject.isNull("userName")) {
            userName = jsonObject.getString("userName");
        }
        if (!jsonObject.isNull("limitTo")) {
            limitTo = jsonObject.getString("limitTo");
        }
        if (!jsonObject.isNull("daysUntilExpiry")) {
            daysUntilExpiry = jsonObject.get("daysUntilExpiry") + "";
        }
        if (!jsonObject.isNull("token")) {
            stringToken = jsonObject.getString("token");
        }
        if (stringToken.equals("")) {
            stringToken = this.generateToken();
        }
        if (!limitTo.equals("") && (limitTo.contains("\\n") || limitTo.contains("\\\\n"))) {
            limitTo = limitTo.replaceAll("\\\\n", "<br>").replaceAll("\\n", "<br>");
        }
        String userKey = "";
        if (userName.equals("")) {
            userKey = "";
        } else {
            ConfluenceUser confluenceUser = this.toolsHelper.getConfluenceUserByName(userName);
            if (confluenceUser == null) {
                response.put("message", "User '" + userName + "' does not exist");
                return Response.serverError().entity(response).build();
            }
            userKey = confluenceUser.getKey().getStringValue();
        }
        if (log.isDebugEnabled()) {
            log.debug("\n\n\nuserKey " + userKey);
            log.debug("userName " + userName);
            log.debug("token " + stringToken);
            log.debug("authorKey " + currentUser.getKey().getStringValue());
            log.debug("daysUntilExpiry " + daysUntilExpiry);
            log.debug("limitTo " + limitTo);
        }
        TokenContainer tokenContainer = this.toolsHelper.getSavedTokens();
        ArrayList<Token> tokens = tokenContainer.getTokens();
        Date date = null;
        String systemExpiryDays = System.getProperty("atlassian.pats.max.tokens.expiry.days");
        if (systemExpiryDays != null && !systemExpiryDays.isEmpty() && this.toolsHelper.isNumeric(systemExpiryDays)) {
            int temp = 0;
            if (this.toolsHelper.isNumeric(daysUntilExpiry)) {
                temp = Integer.parseInt(daysUntilExpiry);
            }
            if (temp < 1) {
                daysUntilExpiry = "1";
            } else if (temp > Integer.parseInt(systemExpiryDays)) {
                daysUntilExpiry = "systemExpiryDays";
            }
        }
        if (this.toolsHelper.isNumeric(daysUntilExpiry)) {
            Calendar now = Calendar.getInstance();
            now.add(5, Integer.parseInt(daysUntilExpiry));
            date = now.getTime();
        }
        response.put("label", label);
        response.put("userName", userName);
        response.put("userKey", userKey);
        response.put("token", stringToken);
        response.put("daysUntilExpiry", date);
        response.put("limitTo", limitTo);
        Token token = new Token(label, currentUser.getKey().getStringValue(), userName, userKey, stringToken, date, limitTo);
        tokens.add(token);
        tokenContainer.setTokens(tokens);
        this.toolsHelper.saveTokens(tokenContainer);
        this.addAuditRecord(token, "added", request, "Token", "");
        return Response.ok(response).build();
    }

    private void addAuditRecord(Token token, String action, HttpServletRequest request, String changeValueName, String changeValueData) {
        String tokenDetails = "Name: " + token.getLabel();
        tokenDetails = tokenDetails + (!this.toolsHelper.getTokenConfigurationSecureMode() ? ", Token: " + token.getToken() : "");
        tokenDetails = tokenDetails + ", User: " + this.getUserDisplayName(token);
        tokenDetails = tokenDetails + (!token.getLimitTo().isEmpty() ? ", Limit to: " + token.getLimitTo().replace("<br>", " - ") : "");
        tokenDetails = tokenDetails + ", Valid until: " + (token.getValidUntil() != null ? token.getValidUntil() : "Indefinitely");
        ArrayList<Map<String, String>> changedValueList = new ArrayList<Map<String, String>>();
        HashMap<String, String> changedValue = new HashMap<String, String>();
        changedValue.put("name", changeValueName);
        changedValue.put("oldValue", !action.equalsIgnoreCase("added") && !action.equalsIgnoreCase("changed") ? tokenDetails : "");
        changedValue.put("newValue", action.equalsIgnoreCase("added") ? tokenDetails : changeValueData);
        changedValueList.add(changedValue);
        AffectedObject targetAffected = AffectedObject.builder().name(token.getLabel()).objectType("REST API Token").build();
        UserProfile currentUserProfile = this.toolsHelper.getCurrentUserProfile();
        String objectType = this.toolsHelper.getUntransformedRawText("audit.logging.affected.object.user");
        AffectedObject targetAffectedUser = AffectedObject.builder().name(currentUserProfile.getUsername()).objectType(objectType).build();
        HashSet<AffectedObject> associatedObjects = new HashSet<AffectedObject>();
        associatedObjects.add(targetAffectedUser);
        associatedObjects.add(targetAffected);
        this.toolsHelper.addAuditRecord("Token \"" + token.getLabel() + "\" was " + action, this.toolsHelper.getUntransformedRawText("audit.logging.category.auth"), targetAffectedUser, changedValueList, action.equalsIgnoreCase("changed") ? new AuditAttribute("Token", tokenDetails) : null);
    }

    private String generateToken() {
        int length = 54;
        boolean useLetters = true;
        boolean useNumbers = true;
        return RandomStringUtils.random((int)length, (boolean)useLetters, (boolean)useNumbers);
    }

    private String getUserDisplayName(Token token) {
        ConfluenceUser confluenceUser;
        String userToken = token.getUserKey();
        if (token.getUserKey() != null && !token.getUserKey().equals("") && !token.getUserKey().equals("not found") && (confluenceUser = this.toolsHelper.getConfluenceUserByKey(token.getUserKey())) != null) {
            userToken = confluenceUser.getFullName() + " [" + confluenceUser.getName() + "]" + (!this.toolsHelper.userIsDeactivated(confluenceUser.getName()) ? "" : " (Inactive)");
        }
        return userToken.isEmpty() ? "any user" : userToken;
    }
}

