/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender.helper;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.confluence.api.model.audit.AffectedObject;
import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DateFormatter;
import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.license.LicenseService;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.persistence.dao.BlogPostDao;
import com.atlassian.confluence.pages.persistence.dao.PageDao;
import com.atlassian.confluence.persistence.JpaQueryFactory;
import com.atlassian.confluence.security.ContentPermission;
import com.atlassian.confluence.security.ContentPermissionSet;
import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.security.administrators.PermissionsAdministrator;
import com.atlassian.confluence.security.administrators.PermissionsAdministratorBuilder;
import com.atlassian.confluence.security.login.LoginInfo;
import com.atlassian.confluence.security.login.LoginManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.settings.Settings;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceDescription;
import com.atlassian.confluence.spaces.persistence.dao.SpaceDao;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.UserDetailsManager;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.confluence.xml.XhtmlEntityResolver;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.model.user.TimestampedUser;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.struts.xsrf.XsrfTokenGenerator;
import com.atlassian.user.User;
import com.itlab.confluence.plugins.restextender.helper.ExtenderConfiguration;
import com.itlab.confluence.plugins.restextender.helper.LicenseHelper;
import com.itlab.confluence.plugins.restextender.tokens.model.Token;
import com.itlab.confluence.plugins.restextender.tokens.model.TokenContainer;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.mail.internet.InternetAddress;
import jakarta.persistence.Query;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.core.Response;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.security.Key;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

@Component
@ExportAsService(value={ToolsHelper.class})
@Named(value="toolsHelper")
public class ToolsHelper {
    private static final Logger log = LoggerFactory.getLogger(ToolsHelper.class);
    private final UserAccessor userAccessor;
    private final UserManager userManager;
    private final SpacePermissionManager spacePermissionManager;
    private final LoginManager loginManager;
    private final CrowdService crowdService;
    private final UserDetailsManager userDetailsManager;
    private final AccessModeService accessModeService;
    private final JpaQueryFactory jpaQueryFactory;
    private final ExtenderConfiguration extenderConfiguration;
    private final SpaceDao spaceDao;
    private final PageDao pageDao;
    private final BlogPostDao blogPostDao;
    private final LicenseService licenseService;
    private final LocaleManager localeManager;
    private final BootstrapManager bootstrapManager;
    private final FormatSettingsManager formatSettingsManager;
    private final SettingsManager settingsManager;
    private LicenseHelper licenseHelper;
    private static final String TOKENS = "com.itlab.confluence.plugins.restextender.tokens";
    private static final String TOKEN_LIMIT = "com.itlab.confluence.plugins.restextender.tokens.limit";
    private static final String TOKEN_ACCESS_TYPE = "com.itlab.confluence.plugins.restextender.tokens.accessType";
    private static final String RESTAPI = "com.itlab.confluence.plugins.restextender.configuration.";
    private static final String SOURCE_EDITOR_GROUPS = "com.itlab.confluence.plugins.restextender.sourceEditor.groups";
    private static final String SOURCE_EDITOR_ALLOW_ALL = "com.itlab.confluence.plugins.restextender.sourceEditor.all";
    private static final String FAVORITE_MACROS_GROUPS = "com.itlab.confluence.plugins.restextender.favoriteMacros.groups";
    private static final String FAVORITE_MACROS_ALLOW_ALL = "com.itlab.confluence.plugins.restextender.favoriteMacros.all";
    private static final String FAVORITE_MACROS = "com.itlab.confluence.plugins.restextender.favoriteMacros.";
    private static final String USER_AUTH_CONTEXT = "com.itlab.confluence.plugins.restextender.userAuthenticationContext.";
    private static final String LOGGING_AND_PROFILING = "com.itlab.confluence.plugins.restextender.logging.and.profiling";
    private static final String WATCH_TREE_CONTENT_LIMIT = "com.itlab.confluence.plugins.restextender.watch.tree.content.limit";
    private static final String COMPLEXITY_REPORT_GROUPS = "com.itlab.confluence.plugins.restextender.complexity.groups";
    private static final String COMPLEXITY_REPORT_ALLOW_ALL = "com.itlab.confluence.plugins.restextender.complexity.all";
    private static final String COMPLEXITY_FIRST_LVL_MESSAGE = "com.itlab.confluence.plugins.restextender.complexity.first.message";
    private static final String COMPLEXITY_SECOND_LVL_MESSAGE = "com.itlab.confluence.plugins.restextender.complexity.second.message";
    private static final String COMPLEXITY_THIRD_LVL_MESSAGE = "com.itlab.confluence.plugins.restextender.complexity.third.message";
    private static final String COMPLEXITY_SECOND_LVL_LIMIT = "com.itlab.confluence.plugins.restextender.complexity.second.limit";
    private static final String COMPLEXITY_THIRD_LVL_LIMIT = "com.itlab.confluence.plugins.restextender.complexity.third.limit";
    private static final String COMPLEXITY_EXCESSIVE_NESTED_TAGS = "com.itlab.confluence.plugins.restextender.complexity.excessiveNestedTags";
    private static final String BREADCRUMBS = "com.itlab.confluence.plugins.restextender.breadcrumbs";
    private static final String CONTENT_COMPACT_VIEW = "com.itlab.confluence.plugins.restextender.content.compact.view";
    private static final String CONTENT_FULL_SCREEN_VIEW = "com.itlab.confluence.plugins.restextender.content.fullScreen.view";
    private static final String NOTIFY_WATCHERS_PRIMARY_BUTTON = "com.itlab.confluence.plugins.restextender.notifyWatchers.button.primary";
    private static final String NOTIFY_WATCHERS_GROUPS = "com.itlab.confluence.plugins.restextender.notifyWatchers.groups";
    private static final String NOTIFY_WATCHERS_ALLOW_ALL = "com.itlab.confluence.plugins.restextender.notifyWatchers.all";
    private static final String SPACE_CONTENT_TOOLS_SINGLE_CLICK_TO_COPY_HEADING_LINKS = "com.itlab.confluence.plugins.restextender.spaceContentTools.singleClickToCopyHeadingLinks.";
    private static final String SPACE_CONTENT_TOOLS_EDITING_COMMENTS = "com.itlab.confluence.plugins.restextender.spaceContentTools.editingComments.";
    private static final String SPACE_CONTENT_TOOLS_EDITING_INLINE_COMMENTS = "com.itlab.confluence.plugins.restextender.spaceContentTools.editingInlineComments.";
    private static final ArrayList APILIST = new ArrayList<String>(Arrays.asList("templateDelete", "spaceAddCategory", "spaceAddPermissionForGroup", "spaceRemoveAllPermissionForGroup", "spaceRemovePermissionForGroup", "spaceAddPermissionForUser", "spaceRemoveAllPermissionForUser", "spaceRemovePermissionForUser", "attachmentDeleteVersionId", "exportSpace", "replaceAll", "addShortcut", "trashPurgeAll", "trashPurgeContent", "trashRestoreContent", "manageSpacePermissionsForUser", "manageSpacePermissionsForGroup", "contentPrepend", "contentAppend", "contentReplaceAll", "changeSpaceStatus", "changeSpaceCreatorSpaceKey", "addContentPermissionUserByName", "removeContentPermissionUserByName", "addContentPermissionGroupByName", "removeContentPermissionGroupByName", "logDebug"));
    private static final ArrayList CONFIGLIST = new ArrayList<String>(Arrays.asList("global.search"));
    private static final String PLUGIN_KEY = "com.itlab.jira.plugins.extender";
    private static final String PLUGIN_INTERNAL_KEY = "@Y29tLml!!0b GFiLmp@pcmEuc Gx1Z2@lucy5le@ @ @";
    private static final String PLUGIN_INTERNAL_BEY = "@@ HRlbmRlci1hNHhP@MjM0NXh!!hcjE0M2E1@";
    private static final String PLUGIN_INTERNAL_ALG = "YS5@wbHV!!naW5z@LmV4dGVuZGVyLQ=@=";
    private static final String PLUGIN_INTERNAL_BLG = " @LUFFU @y1jb2 @0uaX @RsYW @Iu!!amly ";

    @Inject
    public ToolsHelper(LicenseHelper licenseHelper, ExtenderConfiguration extenderConfiguration, @ConfluenceImport UserManager userManager, @ConfluenceImport UserAccessor userAccessor, @ConfluenceImport SpacePermissionManager spacePermissionManager, @ConfluenceImport LoginManager loginManager, @ConfluenceImport CrowdService crowdService, @ConfluenceImport UserDetailsManager userDetailsManager, @ConfluenceImport AccessModeService accessModeService, @ConfluenceImport LicenseService licenseService, @ConfluenceImport BootstrapManager bootstrapManager, @ConfluenceImport LocaleManager localeManager, @ConfluenceImport SettingsManager settingsManager) {
        this.extenderConfiguration = extenderConfiguration;
        this.licenseHelper = licenseHelper;
        this.localeManager = localeManager;
        this.userManager = userManager;
        this.userAccessor = userAccessor;
        this.spacePermissionManager = spacePermissionManager;
        this.loginManager = loginManager;
        this.crowdService = crowdService;
        this.licenseService = licenseService;
        this.userDetailsManager = userDetailsManager;
        this.accessModeService = accessModeService;
        this.spaceDao = (SpaceDao)ComponentLocator.getComponent(SpaceDao.class);
        this.blogPostDao = (BlogPostDao)ComponentLocator.getComponent(BlogPostDao.class);
        this.pageDao = (PageDao)ComponentLocator.getComponent(PageDao.class);
        this.jpaQueryFactory = (JpaQueryFactory)ComponentLocator.getComponent(JpaQueryFactory.class);
        this.bootstrapManager = bootstrapManager;
        this.settingsManager = settingsManager;
        this.formatSettingsManager = (FormatSettingsManager)ComponentLocator.getComponent(FormatSettingsManager.class);
    }

    private String getSpaceContentToolsKey(String type) {
        String key = "";
        key = type.equals("singleClickToCopyHeadingLinks") ? SPACE_CONTENT_TOOLS_SINGLE_CLICK_TO_COPY_HEADING_LINKS : (type.equals("editingInlineComments") ? SPACE_CONTENT_TOOLS_EDITING_INLINE_COMMENTS : SPACE_CONTENT_TOOLS_EDITING_COMMENTS);
        return key;
    }

    public String getSpaceContentTools(String type, String spaceId) {
        String key = this.getSpaceContentToolsKey(type);
        Object value = this.extenderConfiguration.getPluginDataValue(key + spaceId);
        if (value == null || value.equals("") || value.equals("null")) {
            return "true";
        }
        return value.toString();
    }

    public void setSpaceContentTools(String type, String spaceId, String value) {
        String key = this.getSpaceContentToolsKey(type);
        if (value != null && !value.isEmpty() && !value.equals("null") && (value.equals("true") || value.equals("false"))) {
            this.extenderConfiguration.setPluginDataValue(key + spaceId, value);
        }
    }

    public String getLoggingAndProfiling() {
        Object loggingAndProfiling = this.extenderConfiguration.getPluginDataValue(LOGGING_AND_PROFILING);
        if (loggingAndProfiling == null) {
            return "";
        }
        return ToolsHelper.decrypt(loggingAndProfiling.toString());
    }

    public void setLoggingAndProfiling(String loggingAndProfiling) {
        this.extenderConfiguration.setPluginDataValue(LOGGING_AND_PROFILING, ToolsHelper.encrypt(loggingAndProfiling));
    }

    public Document getStorageDocument(String storageFormat) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setExpandEntityReferences(false);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        XhtmlEntityResolver xmlResolver = new XhtmlEntityResolver();
        String entityDTD = "<!ENTITY % HTMLlat1 PUBLIC \"-//W3C//ENTITIES Latin 1 for XHTML//EN\" \"http://www.w3.org/MarkUp/DTD/xhtml-lat1.ent\"> %HTMLlat1;<!ENTITY % HTMLsymbol PUBLIC \"-//W3C//ENTITIES Symbols for XHTML//EN\" \"http://www.w3.org/MarkUp/DTD/xhtml-symbol.ent\"> %HTMLsymbol;<!ENTITY % HTMLspecial PUBLIC \"-//W3C//ENTITIES Special for XHTML//EN\" \"http://www.w3.org/MarkUp/DTD/xhtml-special.ent\"> %HTMLspecial;";
        String xmlStorageFormat = "<!DOCTYPE xml [ " + entityDTD + "]><storage-format>" + storageFormat + "</storage-format>";
        if (log.isDebugEnabled()) {
            log.debug("entityDTD : " + entityDTD);
            log.debug("xmlStorageFormat : " + xmlStorageFormat);
        }
        documentBuilder.setEntityResolver((EntityResolver)xmlResolver);
        InputSource is = new InputSource(new StringReader(xmlStorageFormat));
        return documentBuilder.parse(is);
    }

    public DateFormatter getCurrentUserTimeZoneDateFormatter() {
        Optional userTimeZoneString = this.userAccessor.getUserPreferences(this.getAuthenticatedConfluenceUser()).getString("confluence.user.time.zone");
        TimeZone userTimeZone = userTimeZoneString.map(TimeZone::getTimeZone).orElse(TimeZone.getDefault());
        return new DateFormatter(userTimeZone, this.formatSettingsManager, this.localeManager);
    }

    public int getPageAuthoredPagesCountByUserFormPageDao(ConfluenceUser confluenceUser) {
        if (log.isDebugEnabled()) {
            log.debug("confluenceUser: " + confluenceUser);
        }
        return this.pageDao.getAuthoredPagesCountByUser(confluenceUser);
    }

    public List<ContentEntityObject> getPageContentAuthoredByUser(ConfluenceUser confluenceUser) {
        if (log.isDebugEnabled()) {
            log.debug("confluenceUser: " + confluenceUser);
        }
        ContentEntityManager contentEntityObjectDao = (ContentEntityManager)ComponentLocator.getComponent(ContentEntityManager.class);
        return contentEntityObjectDao.getContentAuthoredByUser(confluenceUser);
    }

    public String getFavoriteMacroForCurrentUser() {
        Object favoriteMacro = this.extenderConfiguration.getPluginDataValue(FAVORITE_MACROS + this.getCurrentUserProfile().getUserKey().getStringValue());
        if (favoriteMacro == null || favoriteMacro.toString().isEmpty()) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug("getFavoriteMacroForCurrentUser favoriteMacro=" + favoriteMacro);
        }
        return favoriteMacro.toString();
    }

    public void setFavoriteMacroForCurrentUser(String favoriteMacroJsonString) {
        if (log.isDebugEnabled()) {
            log.debug("setFavoriteMacroForCurrentUser favoriteMacroJsonString=" + favoriteMacroJsonString);
        }
        if (favoriteMacroJsonString != null && !favoriteMacroJsonString.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug("setFavoriteMacroForCurrentUser favoriteMacroJsonString=" + favoriteMacroJsonString);
            }
            this.extenderConfiguration.setPluginDataValue(FAVORITE_MACROS + this.getCurrentUserProfile().getUserKey().getStringValue(), favoriteMacroJsonString);
        } else {
            this.extenderConfiguration.setPluginDataValue(FAVORITE_MACROS + this.getCurrentUserProfile().getUserKey().getStringValue(), null);
        }
    }

    public void queryTester(String query, String type) {
        List matchingResults = this.getDataBaseResults(query, type);
        for (Object object : matchingResults) {
            List<?> value = ToolsHelper.convertObjectToList(object);
            log.warn("queryTester | " + type + " | " + value);
            for (Object o : value) {
                log.warn("queryTester | " + type + " | " + o);
            }
        }
    }

    public List getDataBaseResults(String queryString, String queryType) {
        return this.getDataBaseResults(queryString, queryType, false);
    }

    public List getDataBaseResults(String queryString, String queryType, boolean isNativeQuery) {
        if (log.isDebugEnabled()) {
            log.debug("getDataBaseResults [" + queryType + "] queryString: " + queryString);
        }
        HashMap transactionTemplateResults = new HashMap();
        TransactionTemplate tt = (TransactionTemplate)ComponentLocator.getComponent(TransactionTemplate.class);
        try {
            tt.execute(() -> {
                Query query = null;
                query = isNativeQuery ? this.jpaQueryFactory.createNativeQuery(queryString) : this.jpaQueryFactory.createQuery(queryString);
                List results = query.getResultList();
                transactionTemplateResults.put("results", results);
                return null;
            });
        }
        catch (Exception ex) {
            if (log.isDebugEnabled()) {
                log.debug("getDataBaseResults [" + queryType + "] Exception: " + ex.getMessage());
            }
            if (log.isDebugEnabled()) {
                log.debug("getDataBaseResults [" + queryType + "] Exception: " + ExceptionUtils.getStackTrace((Throwable)ex));
            }
            return null;
        }
        List matchingResults = new ArrayList();
        if (transactionTemplateResults.get("results") != null) {
            matchingResults = (List)transactionTemplateResults.get("results");
        }
        if (log.isDebugEnabled()) {
            log.debug("getDataBaseResults [" + queryType + "] matchingResults: " + matchingResults.size());
        }
        return matchingResults;
    }

    public static List<?> convertObjectToList(Object obj) {
        List<Object> list = new ArrayList();
        if (obj.getClass().isArray()) {
            list = Arrays.asList((Object[])obj);
        } else if (obj instanceof Collection) {
            list = new ArrayList((Collection)obj);
        }
        return list;
    }

    public String getSpaceDescription(SpaceDescription spaceDescription) {
        String bodyAsString = "";
        try {
            if (this.confluenceVersionIsGreaterThanOrEqualTo(7, 0)) {
                ContentEntityObject versioned = spaceDescription.getLatestVersion();
                Method getBodyAsString = versioned.getClass().getMethod("getBodyAsString", new Class[0]);
                bodyAsString = getBodyAsString.invoke((Object)versioned, new Object[0]) + "";
            } else {
                bodyAsString = spaceDescription.getBodyAsString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bodyAsString;
    }

    public long getTrashData(ContentEntityObject trashObject) {
        long millisecond;
        block3: {
            millisecond = -1L;
            try {
                Method toEpochMilli;
                Object millis;
                Method get;
                Object instant;
                Method getTrashDate;
                Object optional;
                if (this.confluenceVersionIsGreaterThanOrEqualTo(7, 14) && (optional = (getTrashDate = trashObject.getClass().getMethod("getTrashDate", new Class[0])).invoke((Object)trashObject, new Object[0])) != null && (instant = (get = optional.getClass().getMethod("get", new Class[0])).invoke(optional, new Object[0])) != null && (millis = (toEpochMilli = instant.getClass().getMethod("toEpochMilli", new Class[0])).invoke(instant, new Object[0])) instanceof Long) {
                    millisecond = (Long)millis;
                }
            }
            catch (Exception ex) {
                if (!log.isDebugEnabled()) break block3;
                log.debug(ExceptionUtils.getStackTrace((Throwable)ex));
            }
        }
        return millisecond;
    }

    public boolean confluenceVersionIsGreaterThanOrEqualTo(int numberOne, int numberTwo) {
        String versionNumber = GeneralUtil.getVersionNumber();
        String[] versionNumbers = versionNumber.split("\\.");
        return Integer.parseInt(versionNumbers[0]) > numberOne || Integer.parseInt(versionNumbers[0]) == numberOne && Integer.parseInt(versionNumbers[1]) >= numberTwo;
    }

    public boolean isReadOnly() {
        return this.accessModeService.isReadOnlyAccessModeEnabled();
    }

    public Response readOnlyMode() {
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("message", "READ_ONLY mode is enabled");
        return Response.serverError().entity(response).build();
    }

    public boolean isLicenseIsValid() {
        return this.licenseHelper.isLicenseIsValid();
    }

    public boolean isNumeric(String str) {
        try {
            double d = Double.parseDouble(str);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public boolean isSystemAdministrator(UserProfile userProfile) {
        if (log.isDebugEnabled()) {
            log.debug("userProfile: " + userProfile.getUsername());
        }
        if (userProfile != null && this.userManager.isSystemAdmin(userProfile.getUserKey())) {
            if (log.isDebugEnabled()) {
                log.debug("userProfile: " + userProfile.getUsername() + " - true");
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug("userProfile: " + userProfile.getUsername() + " - false");
        }
        return false;
    }

    public boolean isSystemAdministrator(String userName) {
        return this.isSystemAdministrator(this.userManager.getUserProfile(userName));
    }

    public boolean isSystemAdministrator() {
        UserProfile user = this.userManager.getRemoteUser();
        return user != null && this.userManager.isSystemAdmin(user.getUserKey());
    }

    public boolean isConfluenceAdministrator(String userName) {
        return this.isConfluenceAdministrator(this.userManager.getUserProfile(userName));
    }

    public boolean isConfluenceAdministrator() {
        UserProfile userProfile = this.userManager.getRemoteUser();
        return this.isConfluenceAdministrator(userProfile);
    }

    public boolean isConfluenceAdministrator(UserProfile userProfile) {
        if (log.isDebugEnabled()) {
            log.debug("userProfile: " + userProfile.getUsername());
        }
        if (userProfile != null && (this.isSystemAdministrator(userProfile) || this.userManager.isAdmin(userProfile.getUserKey()))) {
            if (log.isDebugEnabled()) {
                log.debug("userProfile: " + userProfile.getUsername() + " - true");
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug("userProfile: " + userProfile.getUsername() + " - false");
        }
        return false;
    }

    public boolean objectHasGlobalPermission(String permissionObject, String objectName, String permissionType) {
        PermissionsAdministratorBuilder permissionsAdministratorBuilder = (PermissionsAdministratorBuilder)ComponentLocator.getComponent(PermissionsAdministratorBuilder.class);
        PermissionsAdministrator permissionsAdministrator = permissionsAdministratorBuilder.buildGlobalPermissionAdministrator();
        for (SpacePermission permission : permissionsAdministrator.getPermissions()) {
            if (permissionObject.equals("group") && permission.isGroupPermission() && permission.getType().equalsIgnoreCase(permissionType) && objectName.equals(permission.getGroup())) {
                return true;
            }
            if (!permissionObject.equals("user") || !permission.isUserPermission() || !permission.getType().equalsIgnoreCase(permissionType) || permission.getUserSubject() == null || !permission.getUserSubject().getName().equals(objectName)) continue;
            return true;
        }
        return false;
    }

    public boolean isUserExistByKey(HttpServletRequest request) {
        UserKey userKey = this.userManager.getRemoteUserKey(request);
        UserProfile userProfile = this.userManager.getUserProfile(userKey);
        return this.userProfileExist(userProfile);
    }

    public void saveTokens(TokenContainer tokenContainer) {
        String content = this.getJaxbContentString(tokenContainer);
        if (content != null) {
            this.extenderConfiguration.setPluginDataValue(TOKENS, ToolsHelper.encrypt(content));
        }
    }

    public boolean isSensitiveCustomer() {
        return this.licenseHelper.isSensitiveCustomer() && this.licenseHelper.isAtlassianLicenseIsEvaluation();
    }

    public boolean isBannedCustomer() {
        return this.licenseHelper.isBannedCustomer() && this.licenseHelper.isAtlassianLicenseIsEvaluation();
    }

    public boolean isDisabledForSpaceAdministrator(String type) {
        Object objIsDisabled = this.extenderConfiguration.getPluginDataValue(RESTAPI + type);
        if (objIsDisabled == null) {
            return false;
        }
        return objIsDisabled.toString().equalsIgnoreCase("true");
    }

    public void setApiConfiguration(String apiType, String disabled) {
        if (APILIST.contains(apiType) || CONFIGLIST.contains(apiType)) {
            this.extenderConfiguration.setPluginDataValue(RESTAPI + apiType, disabled);
        }
    }

    public String getTokensAccessType() {
        Object optionObject = this.extenderConfiguration.getPluginDataValue(TOKEN_ACCESS_TYPE);
        if (optionObject == null) {
            return "bearer";
        }
        if (optionObject.toString().equalsIgnoreCase("basic")) {
            return "basic";
        }
        if (optionObject.toString().equalsIgnoreCase("bearer")) {
            return "bearer";
        }
        return "all";
    }

    public void setTokensAccessType(String accessType) {
        if (accessType == null || accessType.equalsIgnoreCase("basic")) {
            this.extenderConfiguration.setPluginDataValue(TOKEN_ACCESS_TYPE, accessType);
        } else if (accessType.equalsIgnoreCase("bearer") || accessType.equalsIgnoreCase("all")) {
            this.extenderConfiguration.setPluginDataValue(TOKEN_ACCESS_TYPE, accessType);
        }
    }

    public String getTokensConfig() {
        Object optionObject = this.extenderConfiguration.getPluginDataValue(TOKEN_LIMIT);
        if (optionObject == null) {
            return "nolimit";
        }
        if (optionObject.toString().equalsIgnoreCase("limit")) {
            return "limit";
        }
        return "nolimit";
    }

    public void savedTokensConfig(String option) {
        if (option != null && option.equalsIgnoreCase("limit")) {
            if (log.isDebugEnabled()) {
                log.debug("save limit OPTION: " + option);
            }
            this.extenderConfiguration.setPluginDataValue(TOKEN_LIMIT, "limit");
        } else {
            if (log.isDebugEnabled()) {
                log.debug("save nolimit OPTION: " + option);
            }
            this.extenderConfiguration.setPluginDataValue(TOKEN_LIMIT, "nolimit");
        }
    }

    private String getTokensContainer() {
        Object containerString = this.extenderConfiguration.getPluginDataValue(TOKENS);
        if (containerString == null) {
            return "";
        }
        return ToolsHelper.decrypt(containerString.toString());
    }

    public TokenContainer getSavedTokens() {
        try {
            Token token2;
            String content = this.getTokensContainer();
            if (content == null || content.equals("")) {
                return new TokenContainer();
            }
            TokenContainer tokenContainer = (TokenContainer)this.getUnmarshallerObject("TokenContainer").unmarshal((Reader)new StringReader(content));
            boolean migrate = false;
            ArrayList<Token> tokens = tokenContainer.getTokens();
            for (int i = tokens.size() - 1; i >= 0 && (token2 = tokens.get(i)).getUserKey() == null; --i) {
                migrate = true;
                log.warn("[TOKEN-MIGRATE-TO-KEY] --- START --- ");
                if (token2.getUser().equals("")) {
                    log.warn("[TOKEN-MIGRATE-TO-KEY]   - user: " + token2.getUser() + " set empty key");
                    token2.setUserKey("");
                    continue;
                }
                if (token2.getUser().equals("")) continue;
                ConfluenceUser confluenceUser = this.getConfluenceUserByName(token2.getUser());
                if (confluenceUser == null) {
                    log.warn("[TOKEN-MIGRATE-TO-KEY]   - user: " + token2.getUser() + " not found");
                    token2.setUserKey("not found");
                    continue;
                }
                log.warn("[TOKEN-MIGRATE-TO-KEY]   - user: " + token2.getUser() + " set key: " + confluenceUser.getKey());
                token2.setUserKey(confluenceUser.getKey().getStringValue());
            }
            if (migrate) {
                log.warn("[TOKEN-MIGRATE-TO-KEY] save migrated tokens into tokenContainer");
                for (Token token2 : tokenContainer.getTokens()) {
                    log.warn("[TOKEN-MIGRATE-TO-KEY] saved token for token.getUser(): " + token2.getUser() + " :: token.getUserKey(): " + token2.getUserKey());
                }
                this.saveTokens(tokenContainer);
                log.warn("[TOKEN-MIGRATE-TO-KEY] --- DONE --- ");
            }
            return tokenContainer;
        }
        catch (Exception ex) {
            if (log.isDebugEnabled()) {
                log.debug(ExceptionUtils.getStackTrace((Throwable)ex));
            }
            return new TokenContainer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getJaxbContentString(Object object) {
        String content;
        block12: {
            content = null;
            JAXBContext jaxbContext = null;
            Thread currentThread = Thread.currentThread();
            ClassLoader initialClassLoader = currentThread.getContextClassLoader();
            if (object instanceof TokenContainer) {
                currentThread.setContextClassLoader(TokenContainer.class.getClassLoader());
            }
            try {
                if (object instanceof TokenContainer) {
                    jaxbContext = JAXBContext.newInstance((Class[])new Class[]{TokenContainer.class});
                }
            }
            catch (Exception ex) {
                if (log.isDebugEnabled()) {
                    log.debug(ExceptionUtils.getStackTrace((Throwable)ex));
                }
            }
            finally {
                currentThread.setContextClassLoader(initialClassLoader);
            }
            try {
                Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
                jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                StringWriter stringWriter = new StringWriter();
                jaxbMarshaller.marshal(object, (Writer)stringWriter);
                content = stringWriter.toString();
            }
            catch (Exception ex) {
                if (!log.isDebugEnabled()) break block12;
                log.debug(ExceptionUtils.getStackTrace((Throwable)ex));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("content " + content);
        }
        return content;
    }

    public boolean isUserExistByName(String userName) {
        UserProfile userProfile = this.userManager.getUserProfile(userName);
        return this.userProfileExist(userProfile);
    }

    public boolean userIsDeactivated(String userName) {
        return this.userAccessor.isDeactivated(userName);
    }

    public User getUserByName(String userName) {
        return this.userAccessor.getUserByName(userName);
    }

    public ConfluenceUser getAuthenticatedConfluenceUser() {
        return AuthenticatedUserThreadLocal.get();
    }

    public User getAuthenticatedUser() {
        return AuthenticatedUserThreadLocal.get();
    }

    public ConfluenceUser getConfluenceUserByName(String userName) {
        return this.userAccessor.getUserByName(userName);
    }

    public boolean currentUserIsInConfluenceAdministratorGroup() {
        return this.userAccessor.getGroupNames((User)this.getAuthenticatedConfluenceUser()).contains("confluence-administrators");
    }

    public ConfluenceUser getConfluenceUserByKey(String userKeyString) {
        UserKey userKey = new UserKey(userKeyString);
        return this.userAccessor.getExistingUserByKey(userKey);
    }

    public UserProfile getUserProfileByName(String userName) {
        return this.userManager.getUserProfile(userName);
    }

    public UserProfile getCurrentUserProfile() {
        return this.userManager.getRemoteUser();
    }

    public UserProfile getUserProfile(String userKeyString) {
        UserKey userKey = new UserKey(userKeyString);
        return this.userManager.getUserProfile(userKey);
    }

    public Response permissionViolation() {
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("message", "permission violation");
        return Response.serverError().entity(response).build();
    }

    public Response licenseIsInvalid() {
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("message", "license is not valid");
        return Response.serverError().entity(response).build();
    }

    public Response userNotFound(String userName) {
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("message", "user '" + userName + "' not found");
        return Response.serverError().entity(response).build();
    }

    private boolean userProfileExist(UserProfile userProfile) {
        return userProfile != null;
    }

    public Response fieldRequired(String fieldName) {
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("message", "field '" + fieldName + "' is required");
        return Response.serverError().entity(response).build();
    }

    public Response taskIdNotExist(String taskId) {
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("message", "task id '" + taskId + "' not found");
        return Response.serverError().entity(response).build();
    }

    public Response spaceNotExist(String spaceKey) {
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("message", "space with a key '" + spaceKey + "' does not exist");
        return Response.serverError().entity(response).build();
    }

    public Response attachmentIdNotExist(Long contentId) {
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("message", "attachment with id '" + contentId + "' does not exist");
        return Response.serverError().entity(response).build();
    }

    public Response contentIdNotExist(Long contentId) {
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("message", "content with id '" + contentId + "' does not exist");
        return Response.serverError().entity(response).build();
    }

    public Response contentNameNotExist(String contentName) {
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("message", "content with a name '" + contentName + "' does not exist");
        return Response.serverError().entity(response).build();
    }

    public Response spaceIsNotGlobal(String spaceKey) {
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("message", "space with a key '" + spaceKey + "' is a personal space");
        return Response.serverError().entity(response).build();
    }

    public Response spaceExists(String spaceKey) {
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("message", "space with a key '" + spaceKey + "' already exists");
        return Response.serverError().entity(response).build();
    }

    public Response invalidSpaceKey(String spaceKey) {
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("message", "space keys may only consist of ASCII letters or numbers (A-Z, a-z, 0-9)");
        return Response.serverError().entity(response).build();
    }

    public String unescapeHtml(String text) {
        if (text == null) {
            return "";
        }
        return StringEscapeUtils.unescapeHtml4((String)text);
    }

    public Response customMessageError(String message, boolean addStatusCanceled) {
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("message", message);
        if (addStatusCanceled) {
            response.put("status", "canceled");
        }
        return Response.serverError().entity(response).build();
    }

    public Response customMessageError(String message) {
        return this.customMessageError(message, false);
    }

    public Response groupNotExit(String groupName) {
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("message", "group '" + groupName + "' not found");
        return Response.serverError().entity(response).build();
    }

    public Response permissionTypeNotExist(String permissionType) {
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("message", "permission type '" + permissionType + "' not found");
        return Response.serverError().entity(response).build();
    }

    public ArrayList<String> getJSONarray(JSONObject jsonObject, String object) {
        log.debug("getJSONarray - jsonObject:'" + jsonObject.toString() + "' object:'" + object + "'");
        ArrayList<String> arrayStringJSON = new ArrayList<String>();
        if (jsonObject.has(object)) {
            Object objectToTest = jsonObject.get(object);
            if (objectToTest instanceof JSONArray) {
                JSONArray jsonArray = jsonObject.getJSONArray(object);
                for (int i = 0; i < jsonArray.length(); ++i) {
                    arrayStringJSON.add(jsonArray.getString(i));
                }
            } else {
                arrayStringJSON.add(objectToTest.toString());
            }
        }
        return arrayStringJSON;
    }

    public ArrayList<Long> getLongJSONarray(JSONObject jsonObject, String object) {
        log.debug("getLongJSONarray - jsonObject:'" + jsonObject.toString() + "' object:'" + object + "'");
        ArrayList<Long> arrayList = new ArrayList<Long>();
        JSONArray jsonArray = jsonObject.getJSONArray(object);
        if (jsonArray != null) {
            int len = jsonArray.length();
            for (int i = 0; i < len; ++i) {
                arrayList.add(Long.parseLong(jsonArray.get(i).toString()));
            }
        }
        return arrayList;
    }

    public boolean isCurrentUserHasSpaceViewPermission(Space space) {
        ConfluenceUser confluenceUser = this.getAuthenticatedConfluenceUser();
        ArrayList<String> permissions = new ArrayList<String>(Arrays.asList("VIEWSPACE"));
        return this.spacePermissionManager.hasAllPermissions(permissions, space, confluenceUser);
    }

    public boolean isCurrentUserHasSpaceCreatePagePermission(Space space) {
        if (space == null) {
            return false;
        }
        ConfluenceUser confluenceUser = this.getAuthenticatedConfluenceUser();
        ArrayList<String> permissions = new ArrayList<String>(Arrays.asList("EDITSPACE"));
        return this.spacePermissionManager.hasAllPermissions(permissions, space, confluenceUser);
    }

    public boolean isUserIsSpaceAdministrator(Space space, ConfluenceUser confluenceUser) {
        if (space == null || confluenceUser == null) {
            return false;
        }
        ArrayList<String> permissions = new ArrayList<String>(Arrays.asList("SETSPACEPERMISSIONS"));
        return this.spacePermissionManager.hasAllPermissions(permissions, space, confluenceUser);
    }

    public boolean istUserIsSpaceAdministrator(Space space, String userName) {
        if (space == null) {
            return false;
        }
        UserProfile userProfile = this.userManager.getUserProfile(userName);
        if (userProfile == null) {
            return false;
        }
        ConfluenceUser confluenceUser = (ConfluenceUser)this.getUserByName(userProfile.getUsername());
        if (confluenceUser == null) {
            return false;
        }
        ArrayList<String> permissions = new ArrayList<String>(Arrays.asList("SETSPACEPERMISSIONS"));
        return this.spacePermissionManager.hasAllPermissions(permissions, space, confluenceUser);
    }

    public boolean isCurrentUserIsSpaceAdministrator(Space space) {
        if (space == null) {
            return false;
        }
        ConfluenceUser confluenceUser = this.getAuthenticatedConfluenceUser();
        if (confluenceUser == null) {
            return false;
        }
        ArrayList<String> permissions = new ArrayList<String>(Arrays.asList("SETSPACEPERMISSIONS"));
        return this.spacePermissionManager.hasAllPermissions(permissions, space, confluenceUser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Unmarshaller getUnmarshallerObject(String className) {
        JAXBContext jaxbContext = null;
        Thread currentThread = Thread.currentThread();
        ClassLoader initialClassLoader = currentThread.getContextClassLoader();
        if (className.contains("TokenContainer")) {
            currentThread.setContextClassLoader(TokenContainer.class.getClassLoader());
        }
        try {
            if (className.contains("TokenContainer")) {
                jaxbContext = JAXBContext.newInstance((Class[])new Class[]{TokenContainer.class});
            }
        }
        catch (Exception ex) {
            if (log.isDebugEnabled()) {
                log.debug(ExceptionUtils.getStackTrace((Throwable)ex));
            }
        }
        finally {
            currentThread.setContextClassLoader(initialClassLoader);
        }
        try {
            return jaxbContext.createUnmarshaller();
        }
        catch (Exception ex) {
            if (log.isDebugEnabled()) {
                log.debug(ExceptionUtils.getStackTrace((Throwable)ex));
            }
            throw new RuntimeException(ex);
        }
    }

    public Map<String, Object> addUserGroupDetails(Map<String, Object> mapIn, User confluenceUser, String dateFormatApi) {
        for (String group : this.userDetailsManager.getProfileGroups()) {
            ArrayList userGroups = new ArrayList();
            HashMap<String, String> details = new HashMap<String, String>();
            Iterator iterator = this.userDetailsManager.getProfileKeys(group).iterator();
            while (iterator.hasNext()) {
                String key;
                String property = this.userDetailsManager.getStringProperty(confluenceUser, key = (String)iterator.next());
                details.put(key, property == null ? "" : property);
            }
            userGroups.add(details);
            mapIn.put(group, userGroups);
        }
        String fullDateFormat = "";
        fullDateFormat = dateFormatApi == null || dateFormatApi.equals("") ? "yyyy-MM-dd HH:mm:ss" : dateFormatApi + " HH:mm:ss";
        SimpleDateFormat sdfFull = new SimpleDateFormat(fullDateFormat);
        TimestampedUser timestampedUser = null;
        LoginInfo loginInfo = this.loginManager.getLoginInfo(confluenceUser.getName());
        try {
            timestampedUser = (TimestampedUser)this.crowdService.getUser(confluenceUser.getName());
        }
        catch (Exception ex) {
            log.debug("cant get CachedCrowdUser : " + confluenceUser.getName());
        }
        mapIn.put("createdDate", timestampedUser == null ? null : timestampedUser.getCreatedDate());
        mapIn.put("updatedDate", timestampedUser == null ? null : timestampedUser.getUpdatedDate());
        mapIn.put("lastSuccessfulLoginDate", loginInfo.getLastSuccessfulLoginDate());
        mapIn.put("lastFailedLoginDate", loginInfo.getLastFailedLoginDate());
        mapIn.put("createdDateString", timestampedUser == null ? null : sdfFull.format(timestampedUser.getCreatedDate()));
        mapIn.put("updatedDateString", timestampedUser == null ? null : sdfFull.format(timestampedUser.getUpdatedDate()));
        mapIn.put("lastSuccessfulLoginDateString", loginInfo.getLastSuccessfulLoginDate() == null ? null : sdfFull.format(loginInfo.getLastSuccessfulLoginDate()));
        mapIn.put("lastFailedLoginDateString", loginInfo.getLastFailedLoginDate() == null ? null : sdfFull.format(loginInfo.getLastFailedLoginDate()));
        if (this.userAccessor.getUserNamesWithConfluenceAccess().contains(confluenceUser.getName())) {
            mapIn.put("hasAccessToUseConfluence", true);
        } else {
            mapIn.put("hasAccessToUseConfluence", false);
        }
        return mapIn;
    }

    public void resetCaptcha(User user) {
        this.loginManager.resetFailedLoginCount(user);
    }

    public Map<String, Object> addUserGroupDetails(Map<String, Object> mapIn, String userName, String dateFormatApi) {
        return this.addUserGroupDetails(mapIn, this.getUserByName(userName), dateFormatApi);
    }

    public ArrayList<Map<String, Object>> getConfiguration() {
        ArrayList<Map<String, Object>> configList = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < CONFIGLIST.size(); ++i) {
            Object apiConfiguration = this.extenderConfiguration.getPluginDataValue(RESTAPI + CONFIGLIST.get(i));
            if (apiConfiguration == null) continue;
            HashMap<String, Object> value = new HashMap<String, Object>();
            value.put(RESTAPI + CONFIGLIST.get(i), apiConfiguration);
            configList.add(value);
        }
        return configList;
    }

    public ArrayList getDisabledApiConfiguration() {
        ArrayList apiDisabled = new ArrayList();
        for (int i = 0; i < APILIST.size(); ++i) {
            boolean isDisabled;
            Object apiConfiguration = this.extenderConfiguration.getPluginDataValue(RESTAPI + APILIST.get(i));
            if (apiConfiguration == null || !(isDisabled = apiConfiguration.toString().equalsIgnoreCase("true"))) continue;
            apiDisabled.add(APILIST.get(i));
        }
        return apiDisabled;
    }

    public Page getLastModifiedFormPageDao(Space space) {
        return this.getLastModifiedFormPageDao(space, 1);
    }

    public Page getLastModifiedFormPageDao(Space space, int maxResults) {
        List spaceContentEntityObject = this.pageDao.getRecentlyUpdatedPages(maxResults, space.getKey());
        if (!spaceContentEntityObject.isEmpty()) {
            return (Page)spaceContentEntityObject.get(0);
        }
        return null;
    }

    public BlogPost getBlogPostFormPageDao(String spaceKey, String blogPostName) {
        try {
            BlogPost blogPost = this.blogPostDao.getBlogPostByTitle(spaceKey, blogPostName);
            return blogPost;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public BlogPost getBlogPostFormPageDao(Space space, String blogPostName) {
        return this.getBlogPostFormPageDao(space.getKey(), blogPostName);
    }

    public BlogPost getBlogPostFormPageDao(Long blogPostId) {
        if (log.isDebugEnabled()) {
            log.debug("blogPostId: " + blogPostId);
        }
        try {
            BlogPost blogPost = this.blogPostDao.getById(blogPostId.longValue());
            return blogPost;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Space getSpaceFromSpaceDao(String spaceKey) {
        return this.spaceDao.getSpace(spaceKey);
    }

    public Space getSpaceFromSpaceDao(Long spaceId) {
        return this.spaceDao.getById(spaceId.longValue());
    }

    public List<Space> getAllSpacesFormSpaceDao() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1900, 0, 1);
        return this.spaceDao.getSpacesCreatedAfter(calendar.getTime());
    }

    public Page getPageFormPageDao(String spaceKey, String pageName) {
        return this.getPageFormPageDao(this.getSpaceFromSpaceDao(spaceKey), pageName);
    }

    public Page getPageFormPageDao(Space space, String pageName) {
        try {
            Page page = this.pageDao.getPage(space, pageName);
            return page;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Page getPageFormPageDao(Long pageId) {
        if (log.isDebugEnabled()) {
            log.debug("pageId: " + pageId);
        }
        try {
            Page page = this.pageDao.getPageById(pageId.longValue());
            return page;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public SpacePermissionManager getSpacePermissionManager() {
        return this.spacePermissionManager;
    }

    public boolean isLicensedForDataCenter() {
        return this.licenseService.isLicensedForDataCenter();
    }

    public String getJsonBodyForAuditRecord(HttpServletRequest httpRequest) {
        String queryString = httpRequest.getQueryString() != null && !httpRequest.getQueryString().equals("") ? "?" + httpRequest.getQueryString() : "";
        String content = "";
        String description = "";
        try {
            content = IOUtils.toString((InputStream)httpRequest.getInputStream(), (String)this.getStandardCharsets());
            if (content == null) {
                content = "";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!queryString.equals("")) {
            description = description + queryString;
        }
        if (!content.equals("")) {
            if (!description.equals("")) {
                description = description + "; ";
            }
            description = description + content;
        }
        String jsonBody = description;
        return jsonBody;
    }

    public String getStandardCharsets() {
        return GeneralUtil.getCharacterEncoding();
    }

    public String decodeUrlParam(String param) {
        return HtmlUtil.urlDecode((String)param);
    }

    private I18NBean getI18Bean() {
        Locale locale = this.localeManager.getLocale(this.getAuthenticatedUser());
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ((I18NBeanFactory)ComponentLocator.getComponent(I18NBeanFactory.class)).getI18NBean(locale);
    }

    public String getUntransformedRawText(String key) {
        return this.getI18Bean().getUntransformedRawText(key);
    }

    public String getTranslation(String key) {
        return this.getI18Bean().getText(key);
    }

    public String getTranslation(String key, List<String> args) {
        return this.getI18Bean().getText(key, args);
    }

    public void addAuditRecord(String description, String category, AffectedObject targetAffectedUser, List<Map<String, String>> changedValues, AuditAttribute auditAttribute) {
        block5: {
            ArrayList<ChangedValue> changedValueList = new ArrayList<ChangedValue>();
            for (Map<String, String> value : changedValues) {
                changedValueList.add(new ChangedValue(value.get("name"), value.get("oldValue"), value.get("newValue")));
            }
            try {
                AuditService auditService = (AuditService)ComponentLocator.getComponent(AuditService.class);
                if (auditAttribute != null) {
                    auditService.audit(AuditEvent.fromI18nKeys((String)category, (String)description, (CoverageLevel)CoverageLevel.BASE).affectedObject(AuditResource.builder((String)targetAffectedUser.getName(), (String)targetAffectedUser.getObjectType()).build()).changedValue((ChangedValue)changedValueList.get(0)).changedValues(changedValueList).extraAttribute(auditAttribute).build());
                } else {
                    auditService.audit(AuditEvent.fromI18nKeys((String)category, (String)description, (CoverageLevel)CoverageLevel.BASE).affectedObject(AuditResource.builder((String)targetAffectedUser.getName(), (String)targetAffectedUser.getObjectType()).build()).changedValue((ChangedValue)changedValueList.get(0)).changedValues(changedValueList).build());
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block5;
                log.debug("addAuditRecordException 1 " + e.getMessage());
            }
        }
    }

    public com.atlassian.confluence.api.model.people.User getPeopleUser(UserProfile userProfile) {
        return new com.atlassian.confluence.api.model.people.User(null, userProfile.getUsername(), userProfile.getFullName(), userProfile.getUserKey());
    }

    public SettingsManager getSettingsManager() {
        return this.settingsManager;
    }

    public Settings getGlobalSettings() {
        return this.getSettingsManager().getGlobalSettings();
    }

    public boolean isExternalUserManagement() {
        return this.getGlobalSettings().isExternalUserManagement();
    }

    public String getBaseUrl() {
        return this.getGlobalSettings().getBaseUrl();
    }

    public String getDefaultUsersGroup() {
        return this.getGlobalSettings().getDefaultUsersGroup();
    }

    public String getSharedHomeDirectory() {
        try {
            return this.bootstrapManager.getSharedHome().toString();
        }
        catch (Exception ex) {
            if (log.isDebugEnabled()) {
                log.debug(ExceptionUtils.getStackTrace((Throwable)ex));
            }
            return "";
        }
    }

    public String getBootstrapKey(String bootstrapKey) {
        try {
            return this.bootstrapManager.getFilePathProperty(bootstrapKey).toString();
        }
        catch (Exception ex) {
            if (log.isDebugEnabled()) {
                log.debug(ExceptionUtils.getStackTrace((Throwable)ex));
            }
            return "";
        }
    }

    public String getLocalHomeDirectory() {
        try {
            return this.bootstrapManager.getLocalHome().toString();
        }
        catch (Exception ex) {
            if (log.isDebugEnabled()) {
                log.debug(ExceptionUtils.getStackTrace((Throwable)ex));
            }
            return "";
        }
    }

    private static String replace(String valueFrom, String valueTo) {
        return valueFrom.replace(" ", "").replace("!", "");
    }

    private static String replaceAll(String valueFrom, String valueTo) {
        return valueFrom.replace("@", "");
    }

    public Iterable<? extends ContentPermission> getContentPermissionsCopy(ContentPermissionSet contentPermissionSet) {
        return contentPermissionSet.getContentPermissionsCopy();
    }

    public String getXrfsToken(boolean generate, HttpServletRequest request) {
        XsrfTokenGenerator xsrfTokenGenerator = (XsrfTokenGenerator)ComponentLocator.getComponent(XsrfTokenGenerator.class);
        if (generate) {
            return xsrfTokenGenerator.generateToken(request);
        }
        if (request != null) {
            return xsrfTokenGenerator.generateToken(request);
        }
        return "";
    }

    public boolean skipParamSpaceValidation(String spaceKey, BlogPost blogPost) {
        if (blogPost == null) {
            return true;
        }
        return this.skipParamSpaceValidation(spaceKey, blogPost.getSpace());
    }

    public boolean skipParamSpaceValidation(String spaceKey, Page page) {
        if (page == null) {
            return true;
        }
        return this.skipParamSpaceValidation(spaceKey, page.getSpace());
    }

    public boolean skipParamSpaceValidation(String spaceKey, Space space) {
        if (space == null) {
            return true;
        }
        return this.skipParamSpaceValidation(spaceKey, space.getKey());
    }

    public boolean skipParamSpaceValidation(String spaceKeyOne, String spaceKeyTwo) {
        if (log.isDebugEnabled()) {
            log.debug("skipParamSpaceValidation : spaceKeyOne=" + spaceKeyOne);
            log.debug("skipParamSpaceValidation : spaceKeyTwo=" + spaceKeyTwo);
        }
        return spaceKeyOne == null || spaceKeyOne.equals("") || spaceKeyOne.equals(spaceKeyTwo);
    }

    public boolean getTokenConfigurationSecureMode() {
        String tokenSecureMode = this.getBootstrapKey("extender.token.secure.mode");
        return tokenSecureMode != null && tokenSecureMode.equals("true");
    }

    public static String encrypt(String valueToEnc) {
        try {
            Key key = ToolsHelper.getKeySpec(PLUGIN_INTERNAL_BLG);
            Cipher c = ToolsHelper.getCipSpec(PLUGIN_INTERNAL_BLG);
            c.init(1, key);
            byte[] encValue = c.doFinal(valueToEnc.getBytes());
            if (log.isDebugEnabled()) {
                log.debug("encrypt: " + valueToEnc);
                log.debug("encrypt: " + Base64.getEncoder().encodeToString(encValue));
            }
            return Base64.getEncoder().encodeToString(encValue);
        }
        catch (Exception ex) {
            if (log.isDebugEnabled()) {
                log.debug(ExceptionUtils.getStackTrace((Throwable)ex));
            }
            return "";
        }
    }

    private static String decrypt(String encryptedValue) {
        try {
            Key key = ToolsHelper.getKeySpec(PLUGIN_INTERNAL_BLG);
            Cipher c = ToolsHelper.getCipSpec(PLUGIN_INTERNAL_BLG);
            c.init(2, key);
            byte[] decodedValue = Base64.getDecoder().decode(encryptedValue);
            byte[] decValue = c.doFinal(decodedValue);
            if (log.isDebugEnabled()) {
                log.debug("decrypt: " + encryptedValue);
                log.debug("decrypt: " + new String(decValue));
            }
            return new String(decValue);
        }
        catch (Exception ex) {
            if (log.isDebugEnabled()) {
                log.debug(ExceptionUtils.getStackTrace((Throwable)ex));
            }
            return "";
        }
    }

    protected static String getSaltString() {
        String SALTCHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890";
        StringBuilder salt = new StringBuilder();
        SecureRandom rnd = new SecureRandom();
        while (salt.length() < 18) {
            int index = (int)(rnd.nextFloat() * (float)SALTCHARS.length());
            salt.append(SALTCHARS.charAt(index));
        }
        String saltStr = salt.toString();
        return saltStr;
    }

    private static Key getKeySpec(String value) {
        String temp = ToolsHelper.replace(ToolsHelper.replaceAll(PLUGIN_INTERNAL_BEY.trim(), "#"), "%").trim();
        String salt = ToolsHelper.getSaltString();
        return new SecretKeySpec((new String(Base64.getDecoder().decode(ToolsHelper.replace(ToolsHelper.replaceAll(PLUGIN_INTERNAL_KEY, "#"), "%").trim() + temp)) + salt).replace(PLUGIN_KEY, "").replace(salt, "").replace("-", "").getBytes(), new String(Base64.getDecoder().decode(ToolsHelper.replace(ToolsHelper.replaceAll(value.trim(), "["), "]") + ToolsHelper.replace(ToolsHelper.replaceAll(PLUGIN_INTERNAL_ALG.trim(), "#"), "%").trim())).replace(PLUGIN_KEY, "").replace("-", ""));
    }

    private static Cipher getCipSpec(String value) {
        String salt = ToolsHelper.getSaltString();
        try {
            return Cipher.getInstance((salt + new String(Base64.getDecoder().decode(ToolsHelper.replace(ToolsHelper.replaceAll(value.trim(), "["), "]") + ToolsHelper.replace(ToolsHelper.replaceAll(PLUGIN_INTERNAL_ALG.trim(), "#"), "%").trim()))).replace(salt, "").replace(PLUGIN_KEY, "").replace("-", ""));
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public String getContentCompactViewKey() {
        ConfluenceUser confluenceUser = this.getAuthenticatedConfluenceUser();
        if (confluenceUser != null && confluenceUser.getKey() != null) {
            return "com.itlab.confluence.plugins.restextender.content.compact.view." + confluenceUser.getKey().getStringValue();
        }
        return "";
    }

    public String getContentFullScreenViewKey() {
        ConfluenceUser confluenceUser = this.getAuthenticatedConfluenceUser();
        if (confluenceUser != null && confluenceUser.getKey() != null) {
            return "com.itlab.confluence.plugins.restextender.content.fullScreen.view." + confluenceUser.getKey().getStringValue();
        }
        return "";
    }

    public String getBreadcrumbsKey() {
        ConfluenceUser confluenceUser = this.getAuthenticatedConfluenceUser();
        if (confluenceUser != null && confluenceUser.getKey() != null) {
            return "com.itlab.confluence.plugins.restextender.breadcrumbs." + confluenceUser.getKey().getStringValue();
        }
        return "";
    }

    public String getFavoriteMacrosGroups() {
        return FAVORITE_MACROS_GROUPS;
    }

    public String getFavoriteMacrosAllowAll() {
        return FAVORITE_MACROS_ALLOW_ALL;
    }

    public String getSourceEditorGroups() {
        return SOURCE_EDITOR_GROUPS;
    }

    public String getSourceEditorAllowAll() {
        return SOURCE_EDITOR_ALLOW_ALL;
    }

    public String getWatchTreeContentLimit() {
        return WATCH_TREE_CONTENT_LIMIT;
    }

    public Long getWatchTreeContentLimitAsLong() {
        try {
            Object watchTreeContentLimit = this.getBandanaObjectByType(this.getWatchTreeContentLimit());
            if (watchTreeContentLimit == null || watchTreeContentLimit.toString().isEmpty() || watchTreeContentLimit.toString().equalsIgnoreCase("null") || !this.isNumeric(watchTreeContentLimit.toString())) {
                return 2000L;
            }
            return Long.parseLong(watchTreeContentLimit.toString());
        }
        catch (Exception e) {
            return 2000L;
        }
    }

    public String getComplexityReportsGroups() {
        return COMPLEXITY_REPORT_GROUPS;
    }

    public String getComplexityReportsAllowAll() {
        return COMPLEXITY_REPORT_ALLOW_ALL;
    }

    public String getComplexityFirstLevelMessage() {
        return COMPLEXITY_FIRST_LVL_MESSAGE;
    }

    public String getComplexitySecondLevelMessage() {
        return COMPLEXITY_SECOND_LVL_MESSAGE;
    }

    public String getComplexityThirdLevelMessage() {
        return COMPLEXITY_THIRD_LVL_MESSAGE;
    }

    public String getComplexitySecondLevelLimit() {
        return COMPLEXITY_SECOND_LVL_LIMIT;
    }

    public String getComplexityThirdLevelLimit() {
        return COMPLEXITY_THIRD_LVL_LIMIT;
    }

    public String getComplexityExcessiveNestedTags() {
        return COMPLEXITY_EXCESSIVE_NESTED_TAGS;
    }

    public String getNotifyWatchersPrimaryButton() {
        return NOTIFY_WATCHERS_PRIMARY_BUTTON;
    }

    public String getNotifyWatchersGroups() {
        return NOTIFY_WATCHERS_GROUPS;
    }

    public String getNotifyWatchersAllowAll() {
        return NOTIFY_WATCHERS_ALLOW_ALL;
    }

    private String getUserAuthenticationContext() {
        return USER_AUTH_CONTEXT;
    }

    public void setUserAuthenticationContextAsValid() {
        this.setBandanaObjectByType(this.getUserAuthenticationContext() + this.getAuthenticatedConfluenceUser().getKey().getStringValue(), "valid");
    }

    public void setUserAuthenticationContextAsNotValid() {
        this.removeBandanaObjectByType(this.getUserAuthenticationContext() + this.getAuthenticatedConfluenceUser().getKey().getStringValue());
    }

    public boolean isUserAuthenticationContextIsValid() {
        Object twoStepVerification = this.getBandanaObjectByType(this.getUserAuthenticationContext() + this.getAuthenticatedConfluenceUser().getKey().getStringValue());
        return twoStepVerification != null && twoStepVerification.toString().equals("valid");
    }

    public boolean isNotifyWatchersVisibleForUser() {
        return this.isVisibleForUser("notifyWatchers", this.getNotifyWatchersAllowAll(), this.getNotifyWatchersGroups());
    }

    public boolean isComplexityAnalysisVisibleForUser() {
        return this.isVisibleForUser("complexityAnalysis", this.getComplexityReportsAllowAll(), this.getComplexityReportsGroups());
    }

    public boolean isSourceEditorVisibleForUser() {
        return this.isVisibleForUser("sourceEditor", this.getSourceEditorAllowAll(), this.getSourceEditorGroups());
    }

    public boolean isFavoriteMacrosVisibleForUser() {
        return this.isVisibleForUser("favoriteMacros", this.getFavoriteMacrosAllowAll(), this.getFavoriteMacrosGroups());
    }

    private boolean isVisibleForUser(String configurationType, String categoryAllowAll, String categoryGroups) {
        Object allowAll = this.getBandanaObjectByType(categoryAllowAll);
        if (configurationType.equalsIgnoreCase("favoriteMacros") ? allowAll == null || allowAll.toString().isEmpty() || allowAll.toString().equalsIgnoreCase("allowAll") : allowAll != null && allowAll.toString() != null && allowAll.toString().equalsIgnoreCase("allowAll")) {
            return true;
        }
        Object groups = this.getBandanaObjectByType(categoryGroups);
        List userGroups = this.userAccessor.getGroupNamesForUserName(this.getAuthenticatedConfluenceUser().getName());
        return this.userIsInGroup(groups, userGroups);
    }

    private boolean userIsInGroup(Object groups, List<String> userGroups) {
        if (groups != null) {
            if (groups.toString().contains("@@@")) {
                String[] groupsTable = groups.toString().split("@@@");
                for (int i = 0; i < groupsTable.length; ++i) {
                    if (!userGroups.contains(groupsTable[i])) continue;
                    return true;
                }
            } else if (!groups.toString().equals("") && userGroups.contains(groups.toString())) {
                return true;
            }
        }
        return false;
    }

    public void setBandanaObjectByType(String dataKey, Object value) {
        String strValue = "";
        strValue = value == null ? "" : value.toString();
        this.extenderConfiguration.setPluginDataValue(dataKey, strValue);
    }

    public Object getBandanaObjectByType(String dataKey) {
        return this.extenderConfiguration.getPluginDataValue(dataKey);
    }

    public void removeBandanaObjectByType(String dataKey) {
        this.extenderConfiguration.removePluginDataValue(dataKey);
    }

    public String getMailBody() {
        return this.getMailBody(true);
    }

    public String getMailBody(boolean addFooter) {
        return "<html xmlns=http://www.w3.org/1999/xhtml><head></head><body style=\"color: #333; font-family: Arial, sans-serif; font-size: 14px;\"><table id=\"background-table\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse; mso-table-lspace: 0pt; mso-table-rspace: 0pt; background-color: #f5f5f5; border-collapse: collapse; mso-table-lspace: 0pt; mso-table-rspace: 0pt\"><tr><td id=\"header-pattern-spacer\" style=\"padding: 0px; border-collapse: collapse;\">&nbsp;</td></tr><tr><td id=\"email-content-container\" style=\"padding: 0px; border-collapse: collapse; padding: 0 20px\"><table id=\"email-content-table\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" width=\"100%\" style=\"border-collapse: collapse; mso-table-lspace: 0pt; mso-table-rspace: 0pt; border-spacing: 0; border-collapse: separate\"><tr><!-- there needs to be content in the cell for it to render in some clients --><td id=\"email-content-table-a\" class=\"email-content-rounded-top mobile-expand\" style=\"padding: 0px; border-collapse: collapse; color: #fff; padding: 0px; height: 0px; background-color: #fff; border-left: 1px solid #ccc; border-top: 1px solid #ccc; border-right: 1px solid #ccc; border-bottom: 0; border-top-right-radius: 5px; border-top-left-radius: 5px; mso-line-height-rule: exactly\"></td></tr><tr><td id=\"email-content-table-b\" class=\"email-content-main mobile-expandwrapper-special-margin\" style=\"padding: 0px; border-collapse: collapse; border-left: 1px solid #ccc; border-right: 1px solid #ccc; border-top: 0; border-bottom: 0; padding: 10px 15px 5px 16px; background-color: #fff; padding-bottom: 5px; padding-top: 10px;\">@@CONTENT@@</td></tr><tr><td id=\"email-content-table-c\" class=\"email-content-rounded-bottom mobile-expand\" style=\"padding: 0px; border-collapse: collapse; color: #fff; padding: 0 15px 0 16px; height: 5px; line-height: 5px; background-color: #fff; border-top: 0; border-left: 1px solid #ccc; border-bottom: 1px solid #ccc; border-right: 1px solid #ccc; border-bottom-right-radius: 5px; border-bottom-left-radius: 5px; mso-line-height-rule: exactly\">&nbsp;</td></tr></table></td></tr><tr><td id=\"footer-pattern\" style=\"padding: 0px; border-collapse: collapse; padding: 12px 20px\"><table id=\"footer-pattern-container\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" style=\"border-collapse: collapse; mso-table-lspace: 0pt; mso-table-rspace: 0pt\"><tr><td id=\"footer-pattern-text\" class=\"mobile-resize-text\" width=\"100%\" style=\"padding: 0px; border-collapse: collapse; color: #999; font-size: 10px; line-height: 18px; font-family: Arial, sans-serif; mso-line-height-rule: exactly; mso-text-raise: 2px\">" + (addFooter ? "This message was sent by Confluence Administrator" : "") + "</td> </tr></table></td></tr></table></body></html>";
    }

    public boolean isValidEmail(String email) {
        if (email == null || email.indexOf(64) < 1) {
            return false;
        }
        try {
            new InternetAddress(email);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isPluginRemoved() {
        if (this.licenseHelper.isSensitiveCustomer()) {
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug("this.licenseHelper.isLicenseIsValid(): " + this.licenseHelper.isLicenseIsValid());
            log.debug("this.licenseHelper.isAtlassianLicenseIsEvaluation(): " + this.licenseHelper.isAtlassianLicenseIsEvaluation());
        }
        return true;
    }

    public Object getTimePerformedCompleteHtml(long startTime) {
        return this.getTimePerformedCompleteHtml(new Date(startTime));
    }

    public Object getTimePerformedCompleteHtml(Date date) {
        DateFormatter dateFormatter = this.getCurrentUserTimeZoneDateFormatter();
        return this.escapeHtml(dateFormatter.formatDateTime(date));
    }

    public String escapeHtml(String text) {
        return this.easyEscapeHtml(text);
    }

    public String easyEscapeHtml(String text) {
        if (text == null) {
            return "";
        }
        return text.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }
}

