/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender.helper;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class RequestWrapper
extends HttpServletRequestWrapper {
    private byte[] cachedBody;
    CachedBodyServletInputStream cachedBodyServletInputStream;

    public RequestWrapper(HttpServletRequest request) throws IOException {
        super(request);
        int bytesRead;
        ServletInputStream requestInputStream = request.getInputStream();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] temp = new byte[1024];
        while ((bytesRead = requestInputStream.read(temp)) != -1) {
            buffer.write(temp, 0, bytesRead);
        }
        this.cachedBody = buffer.toByteArray();
        this.cachedBodyServletInputStream = new CachedBodyServletInputStream(this.cachedBody);
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.cachedBodyServletInputStream;
    }

    public BufferedReader getReader() {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.cachedBody);
        return new BufferedReader(new InputStreamReader((InputStream)byteArrayInputStream, StandardCharsets.UTF_8));
    }

    public String getBody() {
        return new String(this.cachedBody, StandardCharsets.UTF_8);
    }

    private static class CachedBodyServletInputStream
    extends ServletInputStream {
        private final ByteArrayInputStream byteArrayInputStream;

        public CachedBodyServletInputStream(byte[] cachedBody) {
            this.byteArrayInputStream = new ByteArrayInputStream(cachedBody);
        }

        public boolean isFinished() {
            return this.byteArrayInputStream.available() == 0;
        }

        public boolean isReady() {
            return true;
        }

        public void setReadListener(ReadListener readListener) {
            throw new UnsupportedOperationException();
        }

        public int read() {
            return this.byteArrayInputStream.read();
        }

        public synchronized void mark(int readlimit) {
            this.byteArrayInputStream.mark(readlimit);
        }

        public synchronized void reset() {
            this.byteArrayInputStream.reset();
        }

        public boolean markSupported() {
            return true;
        }
    }
}

