/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender.contentView;

import com.itlab.confluence.plugins.restextender.helper.ToolsHelper;
import java.util.HashMap;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/contentView")
public class ContentViewApi {
    private static final Logger log = LoggerFactory.getLogger(ContentViewApi.class);
    private final ToolsHelper toolsHelper;

    @Inject
    public ContentViewApi(ToolsHelper toolsHelper) {
        this.toolsHelper = toolsHelper;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/compact/state/{state}")
    public Response setCompactState(@PathParam(value="state") String state) {
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("user", "anonymous");
        response.put("state", "");
        if (this.toolsHelper.getAuthenticatedConfluenceUser() != null && state != null && !state.isEmpty() && (state.equals("on") || state.equals("off"))) {
            this.toolsHelper.setBandanaObjectByType(this.toolsHelper.getContentCompactViewKey(), state);
        }
        return Response.ok().build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/fullScreen/state/{state}")
    public Response setFullScreenState(@PathParam(value="state") String state) {
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("user", "anonymous");
        response.put("state", "");
        if (this.toolsHelper.getAuthenticatedConfluenceUser() != null && state != null && !state.isEmpty() && (state.equals("on") || state.equals("off"))) {
            this.toolsHelper.setBandanaObjectByType(this.toolsHelper.getContentFullScreenViewKey(), state);
        }
        return Response.ok().build();
    }
}

