/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender.userDirectories;

import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectorySynchronisationInformation;
import com.atlassian.crowd.embedded.api.DirectorySynchronisationRoundInformation;
import com.atlassian.crowd.exception.DirectoryInstantiationException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.directory.SynchronisationMode;
import com.atlassian.sal.api.component.ComponentLocator;
import com.itlab.confluence.plugins.restextender.helper.ToolsHelper;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/userDirectories")
public class UserDirectoriesRestApi {
    private static final Logger log = LoggerFactory.getLogger(UserDirectoriesRestApi.class);
    private final ToolsHelper toolsHelper;
    private final DirectoryManager directoryManager;

    @Inject
    public UserDirectoriesRestApi(ToolsHelper toolsHelper) {
        this.toolsHelper = toolsHelper;
        this.directoryManager = (DirectoryManager)ComponentLocator.getComponent(DirectoryManager.class);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/all")
    public Response getAllUserDirectories(@Context HttpServletRequest request) throws DirectoryInstantiationException, DirectoryNotFoundException {
        if (log.isDebugEnabled()) {
            log.debug("getAllUserDirectories");
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        CrowdDirectoryService crowdDirectoryService = (CrowdDirectoryService)ComponentLocator.getComponent(CrowdDirectoryService.class);
        response.put("results", "" + crowdDirectoryService.findAllDirectories().size());
        ArrayList directoryArray = new ArrayList();
        int position = 1;
        for (Directory directory : crowdDirectoryService.findAllDirectories()) {
            HashMap<String, Object> directoryMap = new HashMap<String, Object>();
            directoryMap.put("name", directory.getName());
            directoryMap.put("description", directory.getDescription());
            directoryMap.put("position", position);
            directoryMap.put("type", directory.getType().toString());
            ++position;
            directoryMap.put("id", directory.getId());
            directoryMap.put("active", directory.isActive());
            DirectorySynchronisationInformation directorySynchronisationInformation = this.directoryManager.getDirectorySynchronisationInformation(directory.getId().longValue());
            if (directorySynchronisationInformation != null) {
                DirectorySynchronisationRoundInformation directorySynchronisationRoundInformation = directorySynchronisationInformation.getLastRound();
                directoryMap.put("lastSyncStartDate", directorySynchronisationRoundInformation.getStartTime());
                directoryMap.put("lastSyncStartDateCompleteHtml", this.toolsHelper.getTimePerformedCompleteHtml(directorySynchronisationRoundInformation.getStartTime()));
                directoryMap.put("lastSyncDuration", directorySynchronisationRoundInformation.getDurationMs());
                directoryMap.put("lastSyncDurationSec", (int)(directorySynchronisationRoundInformation.getDurationMs() / 1000L % 60L));
                directoryMap.put("lastSyncStatusKey", directorySynchronisationRoundInformation.getStatusKey());
            } else {
                directoryMap.put("lastSyncStartDate", null);
                directoryMap.put("lastSyncStartDateCompleteHtml", null);
                directoryMap.put("lastSyncDuration", null);
                directoryMap.put("lastSyncDurationSec", null);
                directoryMap.put("lastSyncStatusKey", null);
            }
            directoryArray.add(directoryMap);
        }
        response.put("userDirectories", directoryArray);
        return Response.ok(response).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{directoryId}/details")
    public Response getDirectoryDetails(@PathParam(value="directoryId") long directoryId, @QueryParam(value="preview") boolean preview, @Context HttpServletRequest request) throws DirectoryInstantiationException, DirectoryNotFoundException {
        if (log.isDebugEnabled()) {
            log.debug("getDirectoryDetails");
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        if (!this.toolsHelper.isSystemAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        CrowdDirectoryService crowdDirectoryService = (CrowdDirectoryService)ComponentLocator.getComponent(CrowdDirectoryService.class);
        Directory directory = crowdDirectoryService.findDirectoryById(directoryId);
        if (directory == null) {
            response.put("message", "directory '" + directoryId + "' is not active");
            response.put("status", "error");
            return Response.serverError().entity(response).build();
        }
        response.put("id", directory.getId());
        response.put("name", directory.getName());
        if (preview) {
            response.put("active", this.convertTrueFalseToImg(directory.isActive() + ""));
        } else {
            response.put("active", directory.isActive());
        }
        response.put("type", directory.getType());
        if (directory.getCreatedDate() != null) {
            response.put("createdDate", directory.getCreatedDate());
            response.put("createdDateCompleteHtml", this.toolsHelper.getTimePerformedCompleteHtml(directory.getCreatedDate()));
        } else {
            response.put("createdDate", null);
            response.put("createdDateCompleteHtml", null);
        }
        if (directory.getUpdatedDate() != null) {
            response.put("updatedDate", directory.getUpdatedDate());
            response.put("updatedDateCompleteHtml", this.toolsHelper.getTimePerformedCompleteHtml(directory.getUpdatedDate()));
        } else {
            response.put("updatedDate", null);
            response.put("updatedDateCompleteHtml", null);
        }
        response.put("allowedOperations", directory.getAllowedOperations());
        response.put("implementationClass", directory.getImplementationClass());
        response.put("encryptionType", directory.getEncryptionType());
        DirectorySynchronisationInformation directorySynchronisationInformation = this.directoryManager.getDirectorySynchronisationInformation(directory.getId().longValue());
        if (directorySynchronisationInformation != null) {
            DirectorySynchronisationRoundInformation directorySynchronisationRoundInformation = directorySynchronisationInformation.getLastRound();
            response.put("lastSyncStartDate", directorySynchronisationRoundInformation.getStartTime());
            response.put("lastSyncStartDateCompleteHtml", this.toolsHelper.getTimePerformedCompleteHtml(directorySynchronisationRoundInformation.getStartTime()));
            response.put("lastSyncDuration", directorySynchronisationRoundInformation.getDurationMs());
            response.put("lastSyncDurationSec", (int)(directorySynchronisationRoundInformation.getDurationMs() / 1000L % 60L));
            if (preview) {
                response.put("lastSyncStatusKey", directorySynchronisationRoundInformation.getStatusKey().replace("directory.caching.sync.completed.", ""));
            } else {
                response.put("lastSyncStatusKey", directorySynchronisationRoundInformation.getStatusKey());
            }
        } else {
            response.put("lastSyncStartDate", null);
            response.put("lastSyncStartDateCompleteHtml", null);
            response.put("lastSyncDuration", null);
            response.put("lastSyncDurationSec", null);
            response.put("lastSyncStatusKey", null);
        }
        HashMap<String, String> attributesMap = new HashMap<String, String>();
        for (Map.Entry entry : directory.getAttributes().entrySet()) {
            String value = (String)entry.getValue();
            String key = (String)entry.getKey();
            if (key != null && key.toLowerCase().endsWith(".password") && !key.toLowerCase().endsWith(".user.password")) {
                value = "********";
            }
            attributesMap.put(key, value);
        }
        response.put("attributes", attributesMap);
        return Response.ok(response).build();
    }

    private String convertTrueFalseToImg(String value) {
        String baseUrl = this.toolsHelper.getBaseUrl();
        value = value.equals("true") ? "<img class=\"emoticon\" src=\"" + baseUrl + "/images/icons/emoticons/check.png\" height=\"16\" width=\"16\" align=\"absmiddle\" alt=\"\" border=\"0\">" : "<img class=\"emoticon\" src=\"" + baseUrl + "/images/icons/emoticons/forbidden.png\" height=\"16\" width=\"16\" align=\"absmiddle\" alt=\"\" border=\"0\">";
        return value;
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="{directoryId}/synchronize")
    public Response synchronizeUserDirectories(@PathParam(value="directoryId") Long directoryId, @QueryParam(value="fullSynchronisation") boolean fullSynchronisation, @QueryParam(value="runInBackground") boolean runInBackground, @Context HttpServletRequest request) {
        if (log.isDebugEnabled()) {
            log.debug("synchronizeUserDirectories: directoryId:" + directoryId);
            log.debug("synchronizeUserDirectories: fullSynchronisation:" + fullSynchronisation);
            log.debug("synchronizeUserDirectories: runInBackground:" + runInBackground);
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        HashMap<String, String> response = new HashMap<String, String>();
        try {
            SynchronisationMode synchronisationMode;
            Directory directory = this.directoryManager.findDirectoryById(directoryId.longValue());
            if (!directory.isActive()) {
                response.put("message", "directory '" + directoryId + "' is not active");
                response.put("status", "error");
                return Response.serverError().entity(response).build();
            }
            if (!this.directoryManager.isSynchronisable(directoryId.longValue())) {
                response.put("message", "directory '" + directoryId + "' is not synchronisable");
                response.put("status", "error");
                return Response.serverError().entity(response).build();
            }
            if (this.directoryManager.isSynchronising(directoryId.longValue())) {
                response.put("message", "directory '" + directoryId + "' is currently being synced, cannot start a new synchronization");
                response.put("status", "error");
                return Response.serverError().entity(response).build();
            }
            SynchronisationMode synchronisationMode2 = synchronisationMode = fullSynchronisation ? SynchronisationMode.FULL : SynchronisationMode.INCREMENTAL;
            if (runInBackground) {
                this.directoryManager.synchroniseCache(directoryId.longValue(), synchronisationMode, runInBackground);
            } else {
                this.directoryManager.synchroniseCache(directoryId.longValue(), synchronisationMode);
            }
        }
        catch (DirectoryNotFoundException e) {
            response.put("message", "directory '" + directoryId + "' not found");
            response.put("status", "error");
            return Response.serverError().entity(response).build();
        }
        catch (Exception ex) {
            response.put("message", "internal '" + directoryId + "' error");
            response.put("status", "error");
            response.put("details", ExceptionUtils.getStackTrace((Throwable)ex));
            if (log.isDebugEnabled()) {
                log.debug(ExceptionUtils.getStackTrace((Throwable)ex));
            }
            return Response.serverError().entity(response).build();
        }
        if (runInBackground) {
            response.put("message", "synchronization request for directory '" + directoryId + "' has been sent");
            response.put("status", "success");
        } else {
            response.put("message", "directory '" + directoryId + "' has been synchronized");
            response.put("status", "success");
        }
        return Response.ok(response).build();
    }
}

