/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender.loggingAndProfiling;

import com.itlab.confluence.plugins.restextender.helper.LoggingAndProfilingHelper;
import com.itlab.confluence.plugins.restextender.helper.ToolsHelper;
import jakarta.inject.Inject;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/logging")
public class LoggingAndProfilingApi {
    private static final Logger log = LoggerFactory.getLogger(LoggingAndProfilingApi.class);
    private final ToolsHelper toolsHelper;
    private final LoggingAndProfilingHelper loggingAndProfilingHelper;

    @Inject
    public LoggingAndProfilingApi(LoggingAndProfilingHelper loggingAndProfilingHelper, ToolsHelper toolsHelper) {
        this.toolsHelper = toolsHelper;
        this.loggingAndProfilingHelper = loggingAndProfilingHelper;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/definition")
    public Response getDefinition() throws JSONException {
        if (!this.toolsHelper.isSystemAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        HashMap response = new HashMap();
        JSONArray jsonArray = this.loggingAndProfilingHelper.getLoggingDefinition();
        ArrayList logging = new ArrayList();
        for (int i = 0; i < jsonArray.length(); ++i) {
            HashMap<String, String> logMap = new HashMap<String, String>();
            JSONObject logJsonObject = (JSONObject)jsonArray.get(i);
            logMap.put("packageName", logJsonObject.getString("packageName"));
            logMap.put("loggingLevel", logJsonObject.getString("loggingLevel"));
            if (logJsonObject.has("actualLevel") && !logJsonObject.isNull("actualLevel") && !logJsonObject.getString("actualLevel").isEmpty()) {
                logMap.put("actualLevel", logJsonObject.getString("actualLevel"));
            } else {
                logMap.put("actualLevel", "");
            }
            logging.add(logMap);
        }
        response.put("results", logging);
        return Response.ok(response).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/change")
    public Response addOrChangeDefinition(String jsonString) throws JSONException {
        if (!this.toolsHelper.isSystemAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        JSONObject jsonObject = new JSONObject(jsonString);
        JSONArray jsonArray = this.loggingAndProfilingHelper.getLoggingDefinition();
        boolean addNew = true;
        String packageName = this.loggingAndProfilingHelper.clearString(jsonObject.getString("packageName"));
        String loggingLevel = jsonObject.getString("loggingLevel");
        String actualLevel = jsonObject.getString("actualLevel");
        if (packageName.isEmpty()) {
            return Response.ok().build();
        }
        if (!this.loggingAndProfilingHelper.getLogLevels().contains(loggingLevel)) {
            return Response.ok().build();
        }
        if (!this.loggingAndProfilingHelper.getLogLevels().contains(actualLevel)) {
            actualLevel = "";
        }
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject logJsonObject = (JSONObject)jsonArray.get(i);
            if (!logJsonObject.getString("packageName").equals(packageName)) continue;
            logJsonObject.put("loggingLevel", (Object)loggingLevel);
            this.loggingAndProfilingHelper.changeLogging(packageName, loggingLevel);
            addNew = false;
            break;
        }
        if (addNew) {
            JSONObject newlogJsonObject = new JSONObject();
            newlogJsonObject.put("packageName", (Object)packageName);
            newlogJsonObject.put("loggingLevel", (Object)loggingLevel);
            newlogJsonObject.put("actualLevel", (Object)actualLevel);
            jsonArray.put((Object)newlogJsonObject);
            this.loggingAndProfilingHelper.changeLogging(packageName, loggingLevel);
        }
        this.loggingAndProfilingHelper.setLoggingAndProfiling(jsonArray.toString());
        return Response.ok().build();
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/remove")
    public Response deleteDefinition(String jsonString) throws JSONException {
        if (!this.toolsHelper.isSystemAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        JSONObject jsonObject = new JSONObject(jsonString);
        JSONArray jsonArray = this.loggingAndProfilingHelper.getLoggingDefinition();
        JSONArray newJsonArray = new JSONArray();
        String packageName = this.loggingAndProfilingHelper.clearString(jsonObject.getString("packageName"));
        String loggingLevel = jsonObject.getString("loggingLevel");
        if (packageName.isEmpty()) {
            return Response.serverError().build();
        }
        if (!this.loggingAndProfilingHelper.getLogLevels().contains(loggingLevel)) {
            return Response.serverError().build();
        }
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject logJsonObject = (JSONObject)jsonArray.get(i);
            if (logJsonObject.getString("packageName").equals(packageName) && logJsonObject.getString("loggingLevel").equals(loggingLevel)) {
                if (logJsonObject.has("actualLevel") && !logJsonObject.isNull("actualLevel") && !logJsonObject.getString("actualLevel").isEmpty()) {
                    this.loggingAndProfilingHelper.changeLogging(packageName, logJsonObject.getString("actualLevel"));
                    continue;
                }
                this.loggingAndProfilingHelper.changeLogging(packageName, "INFO");
                continue;
            }
            newJsonArray.put((Object)logJsonObject);
        }
        this.loggingAndProfilingHelper.setLoggingAndProfiling(newJsonArray.toString());
        return Response.ok().build();
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/resetConfiguration")
    public Response resetConfiguration() throws JSONException {
        if (!this.toolsHelper.isSystemAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        this.loggingAndProfilingHelper.setLoggingAndProfiling("");
        return Response.ok().build();
    }
}

