/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender.helper;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.Contact;
import com.atlassian.upm.api.license.entity.Organization;
import com.atlassian.upm.api.license.entity.PluginLicense;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={LicenseHelper.class})
@Named(value="licenseHelper")
public class LicenseHelper {
    private static final Logger log = LoggerFactory.getLogger(LicenseHelper.class);
    private final PluginLicenseManager pluginLicenseManager;
    private static final List<String> CUSTOMER_MAIL = Arrays.asList(new String[0]);
    private static final List<String> CUSTOMER_NAME = Arrays.asList(new String[0]);
    private static final List<String> BANNED_CUSTOMER_NAME = Arrays.asList("Xactware", "SIEA", "SIEA, LLC", "SIEA LLC", "Teradata", "Amadeus", "Isos Technology", "Hydro Qu&eacute;bec", "Hydro-Quebec", "Hydro Quebec", "Hydro-Qu&eacute;bec", "Hydro-Qu\u00e9bec", "Hydro Qu\u00e9bec", "OG-1", "OG-2", "OG-3", "OG-4", "OG-5", "OG-6", "OG-7", "OG-8", "OG 1", "OG 2", "OG 3", "OG 4", "OG 5", "OG 6", "OG 7", "OG 8", "Goga", "Daimler Truck AG", "Daimler Truck", "Truck AG", "DT AG", "DTAG", "Daimler", "KCNTT", "OneValley", "OneValley, Inc.", "OneValley, Inc", "OneValley Inc.", "OneValley Inc", "GSVlabs", "Bayer", "Games Global Limited", "Toolstrek", "SRT", "SRT_IT", "SRT IT", "N/N", "N/N Production", "N/N Development", "MDA", "MDA Space", "MDAspace", "Trial Marketplace Bot", "Marketplace Bot", "Turn 10 Studios", "dot-", "Rocket Software", "RocketSoftware", "Rocket Software, Inc.", "Rocket Software Inc", "Rocket Software Inc.", "UBS", "nguyenquoctu1992@gmail.com", "nguy", "Qu\u1ed1c T\u1ef1", "Quoc Tu", "Quoc Ty", "Quoc Yu", "Tu Nguyen Quoc", "Nguyen Quoc", "Tu Nguyen");
    private static final List<String> BANNED_CUSTOMER_MAIL = Arrays.asList("@verisk.", "@xactware.", "@ship.scea.", "@scea.", "@teradata.", "@amadeus.", "@isostech.", "@hydroquebec.com", "@mdo.hydro.qc.ca", "@ab-games.com", "@og-team.com", "@morxin.", "@em.", "@mercedes-benz.", "@daimlertruck.", "huyenquyennang@gmail.com", "vychandaichui@gmail.com", "duykhanhlinhtang@gmail.com", "nghchi@gmail.com", "conganthanh932@gmail.com", "@theonevalley.", "@onevalley.", "@bayer.", "@gamesglobal.", "@toolstrek.", "@srt-lpwan.", "@mdacorporation.", "@mdaspace.", "@mda.", "@TrialMarketplaceBot.com", "@turn10studio.", ".ru", "@agaseo.", "@hidelux.", "@tupanda.", "@nexxterp.", "@rocketsoftware.com", "@foundtoo.", "@agaseo.", "@hidelux.", "@tupanda.", "@nexxterp.", "@ubs.", "nguyenquoctu1992@gmail.com");

    @Inject
    public LicenseHelper(@ConfluenceImport PluginLicenseManager pluginLicenseManager) {
        this.pluginLicenseManager = pluginLicenseManager;
    }

    public boolean isBannedCustomer() {
        return this.isSensitiveCustomer(BANNED_CUSTOMER_NAME, BANNED_CUSTOMER_MAIL);
    }

    public boolean isSensitiveCustomer() {
        return this.isSensitiveCustomer(CUSTOMER_NAME, CUSTOMER_MAIL);
    }

    private boolean isSensitiveCustomer(List<String> customerNames, List<String> customerMails) {
        try {
            PluginLicense pluginLicense;
            if (this.pluginLicenseManager != null && this.pluginLicenseManager.getLicense() != null && this.pluginLicenseManager.getLicense().isDefined() && ((PluginLicense)this.pluginLicenseManager.getLicense().get()).isEvaluation() && (pluginLicense = (PluginLicense)this.pluginLicenseManager.getLicense().get()).isEvaluation()) {
                Organization organization;
                if (pluginLicense.getContacts() != null) {
                    Iterable list = pluginLicense.getContacts();
                    for (Contact contact : list) {
                        String contactMail = contact.getEmail();
                        for (String customerMail : customerMails) {
                            if (contactMail == null || !contactMail.toLowerCase().contains(customerMail.toLowerCase())) continue;
                            return true;
                        }
                    }
                }
                if (pluginLicense.getOrganization() != null && (organization = pluginLicense.getOrganization()) != null) {
                    for (String organizationName : customerNames) {
                        if (organization.getName() == null || !organization.getName().trim().equalsIgnoreCase(organizationName) && !organization.getName().trim().toLowerCase().startsWith(organizationName)) continue;
                        return true;
                    }
                }
            }
        }
        catch (Exception ex) {
            log.debug("Exception " + ex.getMessage());
        }
        return false;
    }

    public boolean isAtlassianLicenseIsEvaluation() {
        boolean isEvaluation;
        block3: {
            isEvaluation = false;
            try {
                if (this.pluginLicenseManager != null && this.pluginLicenseManager.getLicense() != null && this.pluginLicenseManager.getLicense().isDefined()) {
                    PluginLicense pluginLicense = (PluginLicense)this.pluginLicenseManager.getLicense().get();
                    isEvaluation = pluginLicense.isEvaluation();
                }
            }
            catch (Exception ex) {
                if (!log.isDebugEnabled()) break block3;
                log.debug("Exception: " + ExceptionUtils.getStackTrace((Throwable)ex));
            }
        }
        return isEvaluation;
    }

    public boolean isAtlassianLicenseIsValid() {
        boolean isLicenseIsValid;
        block5: {
            isLicenseIsValid = false;
            try {
                if (this.pluginLicenseManager != null && this.pluginLicenseManager.getLicense() != null && this.pluginLicenseManager.getLicense().isDefined()) {
                    PluginLicense pluginLicense = (PluginLicense)this.pluginLicenseManager.getLicense().get();
                    boolean bl = isLicenseIsValid = !pluginLicense.getError().isDefined();
                    if (this.isBannedCustomer() && pluginLicense.isEvaluation()) {
                        return new Random().nextBoolean();
                    }
                }
            }
            catch (Exception ex) {
                if (!log.isDebugEnabled()) break block5;
                log.debug("Exception: " + ExceptionUtils.getStackTrace((Throwable)ex));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("isAtlassianLicenseIsValid: - " + (isLicenseIsValid ? "VALID" : "NOT VALID"));
        }
        return isLicenseIsValid;
    }

    public boolean isLicenseIsValid() {
        boolean isLicenseIsValid = this.isAtlassianLicenseIsValid();
        return isLicenseIsValid;
    }
}

