/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender.helper;

import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.cluster.ClusterNodeExecution;
import com.atlassian.confluence.cluster.ClusterNodeInformation;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.sal.api.component.ComponentLocator;
import com.itlab.confluence.plugins.restextender.helper.ToolsHelper;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={LoggingAndProfilingHelper.class})
@Named(value="loggingAndProfilingHelper")
public class LoggingAndProfilingHelper {
    private static final Logger log = LoggerFactory.getLogger(LoggingAndProfilingHelper.class);
    private ClusterManager clusterManager;
    private final ToolsHelper toolsHelper;
    private static final List<String> LOG_LEVEL = Arrays.asList("ALL", "TRACE", "DEBUG", "INFO", "WARN", "ERROR", "FATAL");

    @Inject
    public LoggingAndProfilingHelper(ToolsHelper toolsHelper) {
        this.toolsHelper = toolsHelper;
        this.clusterManager = (ClusterManager)ComponentLocator.getComponent(ClusterManager.class);
    }

    public void setLoggingAndProfiling(String jsonString) {
        this.toolsHelper.setLoggingAndProfiling(jsonString);
    }

    public JSONArray getLoggingDefinition() {
        JSONArray loggingJsonArray = null;
        String loggingDefinition = this.toolsHelper.getLoggingAndProfiling();
        if (loggingDefinition == null || loggingDefinition.isEmpty()) {
            loggingJsonArray = new JSONArray();
        }
        if (log.isDebugEnabled()) {
            log.debug("loggingDefinition {}", (Object)loggingDefinition);
        }
        try {
            if (!loggingDefinition.isEmpty()) {
                loggingJsonArray = new JSONArray(loggingDefinition);
            }
        }
        catch (Exception ex) {
            loggingJsonArray = new JSONArray();
        }
        return loggingJsonArray;
    }

    public void changeLogging(String packageName, String loggingLevel) {
        block11: {
            block10: {
                try {
                    Class<?> memoizingComponentReferenceClass = Class.forName("com.atlassian.confluence.util.MemoizingComponentReference");
                    Method containerComponentMethod = memoizingComponentReferenceClass.getMethod("containerComponent", String.class);
                    Object loggingConfigServiceRef = containerComponentMethod.invoke(null, "loggingConfigService");
                    Method getMethod = loggingConfigServiceRef.getClass().getMethod("get", new Class[0]);
                    Object loggingConfigService = getMethod.invoke(loggingConfigServiceRef, new Object[0]);
                    Method setLevelForLoggerMethod = loggingConfigService.getClass().getMethod("setLevelForLogger", String.class, String.class);
                    setLevelForLoggerMethod.invoke(loggingConfigService, packageName, loggingLevel);
                    if (log.isDebugEnabled()) {
                        log.debug("\nchangeLogging loggingConfigService DONE");
                    }
                }
                catch (Exception ex) {
                    if (!log.isDebugEnabled()) break block10;
                    log.debug("\nchangeLogging loggingConfigService EXCEPTION = " + ExceptionUtils.getStackTrace((Throwable)ex));
                }
            }
            if (log.isDebugEnabled() && log.isDebugEnabled()) {
                for (ClusterNodeInformation clusterNodeInformation : this.getAllNodes()) {
                    log.debug("clusterNodeInformation {}", (Object)clusterNodeInformation.toString());
                    log.debug("clusterNodeInformation isLocal {}", (Object)clusterNodeInformation.isLocal());
                    log.debug("clusterNodeInformation humanReadableNodeName {}", (Object)clusterNodeInformation.humanReadableNodeName().orElse("NONAME"));
                    log.debug("clusterNodeInformation getAnonymizedNodeIdentifier {}", (Object)clusterNodeInformation.getAnonymizedNodeIdentifier());
                    log.debug("clusterNodeInformation getLocalSocketAddress {}", (Object)clusterNodeInformation.getLocalSocketAddress().getAddress());
                }
            }
            if (!this.getAllNodes().isEmpty()) {
                SaveLoggersTask saveLoggersTask = new SaveLoggersTask(packageName, loggingLevel);
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("Send LOGERS to all nodes");
                    }
                    this.execute(saveLoggersTask);
                    if (log.isDebugEnabled()) {
                        log.debug("Send LOGERS to all nodes DONE");
                    }
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block11;
                    log.debug("Send LOGERS to all nodes EXCEPTION = " + ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
        }
    }

    public String clearString(String text) {
        return text.trim().replaceAll(System.getProperty("line.separator"), "").replaceAll("\\s+", "");
    }

    private <T> T execute(Callable<T> task) throws Exception {
        for (ClusterNodeInformation clusterNodeInformation : this.getAllNodes()) {
            ClusterNodeExecution execution = this.clusterManager.submitToNode(StringUtils.trimToNull((String)clusterNodeInformation.getAnonymizedNodeIdentifier()), task, "cluster-manager-executor");
            execution.getCompletionStage().toCompletableFuture().get();
        }
        return null;
    }

    public List<ClusterNodeInformation> getAllNodes() {
        return this.clusterManager.getAllNodesInformation().stream().collect(Collectors.toList());
    }

    public org.apache.logging.log4j.Logger getLogger(String loggerName) {
        org.apache.logging.log4j.Logger logger = null;
        try {
            logger = LogManager.getLogger((String)loggerName);
        }
        catch (Exception e) {
            return null;
        }
        return logger;
    }

    public List<String> getLogLevels() {
        return LOG_LEVEL;
    }

    public void onAppStart() throws JSONException {
        JSONArray jsonArray = this.getLoggingDefinition();
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject logJsonObject = (JSONObject)jsonArray.get(i);
            if (log.isDebugEnabled()) {
                log.debug("onAppStart packageName=" + logJsonObject.getString("packageName") + " | actualLevel=" + logJsonObject.getString("loggingLevel"));
            }
            this.changeLogging(logJsonObject.getString("packageName"), logJsonObject.getString("loggingLevel"));
        }
    }

    public void onAppShutdown() throws JSONException {
        JSONArray jsonArray = this.getLoggingDefinition();
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject logJsonObject = (JSONObject)jsonArray.get(i);
            String actualLevel = "INFO";
            if (logJsonObject.has("actualLevel") && !logJsonObject.isNull("actualLevel") && !logJsonObject.getString("actualLevel").isEmpty()) {
                actualLevel = logJsonObject.getString("loggingLevel");
            }
            if (log.isDebugEnabled()) {
                log.debug("onAppShutdown packageName=" + logJsonObject.getString("packageName") + " | actualLevel=" + actualLevel);
            }
            this.changeLogging(logJsonObject.getString("packageName"), actualLevel);
        }
    }

    private static class SaveLoggersTask
    implements Callable<Void>,
    Serializable {
        String packageName;
        String loggingLevel;

        SaveLoggersTask(String packageName, String loggingLevel) {
            this.packageName = packageName;
            this.loggingLevel = loggingLevel;
        }

        @Override
        public Void call() throws Exception {
            this.changeLogging(this.packageName, this.loggingLevel);
            return null;
        }

        public void changeLogging(String packageName, String loggingLevel) {
            block3: {
                try {
                    Class<?> memoizingComponentReferenceClass = Class.forName("com.atlassian.confluence.util.MemoizingComponentReference");
                    Method containerComponentMethod = memoizingComponentReferenceClass.getMethod("containerComponent", String.class);
                    Object loggingConfigServiceRef = containerComponentMethod.invoke(null, "loggingConfigService");
                    Method getMethod = loggingConfigServiceRef.getClass().getMethod("get", new Class[0]);
                    Object loggingConfigService = getMethod.invoke(loggingConfigServiceRef, new Object[0]);
                    Method setLevelForLoggerMethod = loggingConfigService.getClass().getMethod("setLevelForLogger", String.class, String.class);
                    setLevelForLoggerMethod.invoke(loggingConfigService, packageName, loggingLevel);
                    if (log.isDebugEnabled()) {
                        log.debug("\nSaveLoggersTask loggingConfigService DONE");
                    }
                }
                catch (Exception ex) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug("\nSaveLoggersTask loggingConfigService EXCEPTION = " + ExceptionUtils.getStackTrace((Throwable)ex));
                }
            }
        }
    }
}

