/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender.pluginState;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.event.events.PluginDisablingEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public abstract class PluginStateListener
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(PluginStateListener.class);
    private static final String PLUGIN_KEY = "com.itlab.confluence.plugins.restapi-extender";
    private final EventPublisher eventPublisher;

    @Inject
    public PluginStateListener(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    @EventListener
    public void pluginStartup(PluginEnabledEvent event) {
        if (event != null && event.getPlugin() != null && event.getPlugin().getKey() != null && PLUGIN_KEY.equals(event.getPlugin().getKey())) {
            if (log.isDebugEnabled()) {
                log.debug("\n\n Extender for Confluence - plugin startup \n\n");
            }
            this.onAppStart();
        }
    }

    @EventListener
    public void pluginShutdown(PluginDisablingEvent event) {
        if (event != null && event.getPlugin() != null && event.getPlugin().getKey() != null && PLUGIN_KEY.equals(event.getPlugin().getKey())) {
            if (log.isDebugEnabled()) {
                log.debug("\n\n Extender for Confluence - plugin shutdown \n\n");
            }
            this.onAppShutdown();
        }
    }

    public void afterPropertiesSet() {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() {
        this.eventPublisher.unregister((Object)this);
    }

    protected abstract void onAppStart();

    protected abstract void onAppShutdown();
}

