/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender.condition;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugin.web.Condition;
import com.atlassian.sal.api.component.ComponentLocator;
import com.itlab.confluence.plugins.restextender.helper.ToolsHelper;
import java.util.Map;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceToolsOptions
implements Condition {
    private static final Logger log = LoggerFactory.getLogger(SpaceToolsOptions.class);
    private final ToolsHelper toolsHelper;
    private final SpaceManager spaceManager;

    @Inject
    public SpaceToolsOptions(ToolsHelper toolsHelper) {
        this.toolsHelper = toolsHelper;
        this.spaceManager = (SpaceManager)ComponentLocator.getComponent(SpaceManager.class);
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        Space space;
        if (context == null || context.isEmpty() || context.get("spaceid") == null) {
            return false;
        }
        try {
            long spaceId = Long.parseLong(context.get("spaceid").toString());
            space = this.spaceManager.getSpace(spaceId);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        if (space == null) {
            return false;
        }
        return this.toolsHelper.isConfluenceAdministrator() || this.toolsHelper.isCurrentUserIsSpaceAdministrator(space);
    }
}

