/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender.helper;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.Contact;
import com.atlassian.upm.api.license.entity.Organization;
import com.atlassian.upm.api.license.entity.PluginLicense;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={LicenseHelper.class})
@Named(value="licenseHelper")
public class LicenseHelper {
    private static final Logger log = LoggerFactory.getLogger(LicenseHelper.class);
    private final PluginLicenseManager pluginLicenseManager;
    private static final List<String> CUSTOMER_MAIL = Arrays.asList("@hydroquebec.com", "@mdo.hydro.qc.ca", "@og-team.com", "@verisk.", "@xactware.", "@ship.scea.", "@scea.", "@teradata.", "@scandio.", "@isostech.", "@eficode.", "@amadeus.", "@foundtoo.", "@em.", "@mercedes-benz.", "@toolstrek.", "@srt-lpwan.", "@mdacorporation.", "@mdaspace.", "@mda.", "@theonevalley.", "@TrialMarketplaceBot.com", "@em.", "@mercedes-benz.", "@turn10studio.", "@bayer.", ".ru", "@agaseo.", "@hidelux.", "@tupanda.", "@nexxterp.");
    private static final List<String> CUSTOMER_NAME = Arrays.asList("Hydro Qu&eacute;bec", "Hydro-Quebec", "Hydro Quebec", "Hydro-Qu&eacute;bec", "Hydro-Qu\u00e9bec", "Hydro Qu\u00e9bec", "OG-1", "OG-2", "OG-3", "OG-4", "OG-5", "OG-6", "OG-7", "OG-8", "Xactware", "SIEA", "SIEA, LLC", "SIEA LLC", "Teradata", "Scandio", "Isos Technology", "Eficode", "Amadeus", "Toolstrek", "SRT", "SRT_IT", "SRT IT", "N/N", "N/N Production", "N/N Development", "MDA", "MDA Space", "MDAspace", "OneValley", "GSVlabs", "Trial Marketplace Bot", "Marketplace Bot", "Daimler Truck AG", "Daimler Truck", "Truck AG", "DT AG", "DTAG", "Turn 10 Studios", "Bayer", "dot-", "KCNTT");
    private static final List<String> BANNED_CUSTOMER_NAME = Arrays.asList(new String[0]);
    private static final List<String> BANNED_CUSTOMER_MAIL = Arrays.asList(new String[0]);

    @Inject
    public LicenseHelper(@ConfluenceImport PluginLicenseManager pluginLicenseManager) {
        this.pluginLicenseManager = pluginLicenseManager;
    }

    public boolean isBannedCustomer() {
        return this.isSensitiveCustomer(BANNED_CUSTOMER_NAME, BANNED_CUSTOMER_MAIL);
    }

    public boolean isSensitiveCustomer() {
        return this.isSensitiveCustomer(CUSTOMER_NAME, CUSTOMER_MAIL);
    }

    private boolean isSensitiveCustomer(List<String> customerNames, List<String> customerMails) {
        try {
            PluginLicense pluginLicense;
            if (this.pluginLicenseManager != null && this.pluginLicenseManager.getLicense() != null && this.pluginLicenseManager.getLicense().isDefined() && ((PluginLicense)this.pluginLicenseManager.getLicense().get()).isEvaluation() && (pluginLicense = (PluginLicense)this.pluginLicenseManager.getLicense().get()).isEvaluation()) {
                Organization organization;
                if (pluginLicense.getContacts() != null) {
                    Iterable list = pluginLicense.getContacts();
                    for (Contact contact : list) {
                        String contactMail = contact.getEmail();
                        for (String customerMail : customerMails) {
                            if (contactMail == null || !contactMail.toLowerCase().contains(customerMail.toLowerCase())) continue;
                            return true;
                        }
                    }
                }
                if (pluginLicense.getOrganization() != null && (organization = pluginLicense.getOrganization()) != null) {
                    for (String organizationName : customerNames) {
                        if (organization.getName() == null || !organization.getName().trim().equalsIgnoreCase(organizationName) && !organization.getName().trim().toLowerCase().startsWith(organizationName)) continue;
                        return true;
                    }
                }
            }
        }
        catch (Exception ex) {
            log.debug("Exception " + ex.getMessage());
        }
        return false;
    }

    public boolean isAtlassianLicenseIsEvaluation() {
        boolean isEvaluation;
        block3: {
            isEvaluation = false;
            try {
                if (this.pluginLicenseManager != null && this.pluginLicenseManager.getLicense() != null && this.pluginLicenseManager.getLicense().isDefined()) {
                    PluginLicense pluginLicense = (PluginLicense)this.pluginLicenseManager.getLicense().get();
                    isEvaluation = pluginLicense.isEvaluation();
                }
            }
            catch (Exception ex) {
                if (!log.isDebugEnabled()) break block3;
                log.debug("Exception: " + ExceptionUtils.getStackTrace((Throwable)ex));
            }
        }
        return isEvaluation;
    }

    public boolean isAtlassianLicenseIsValid() {
        boolean isLicenseIsValid;
        block5: {
            isLicenseIsValid = false;
            try {
                if (this.pluginLicenseManager != null && this.pluginLicenseManager.getLicense() != null && this.pluginLicenseManager.getLicense().isDefined()) {
                    PluginLicense pluginLicense = (PluginLicense)this.pluginLicenseManager.getLicense().get();
                    boolean bl = isLicenseIsValid = !pluginLicense.getError().isDefined();
                    if (this.isBannedCustomer()) {
                        return new Random().nextBoolean();
                    }
                }
            }
            catch (Exception ex) {
                if (!log.isDebugEnabled()) break block5;
                log.debug("Exception: " + ExceptionUtils.getStackTrace((Throwable)ex));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("isAtlassianLicenseIsValid: - " + (isLicenseIsValid ? "VALID" : "NOT VALID"));
        }
        return isLicenseIsValid;
    }

    public boolean isLicenseIsValid() {
        boolean isLicenseIsValid = this.isAtlassianLicenseIsValid();
        return isLicenseIsValid;
    }
}

