/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender.content;

import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.confluence.core.DefaultSaveContext;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.ContentPermissionSet;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceType;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.user.User;
import com.itlab.confluence.plugins.restextender.helper.ToolsHelper;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/content")
public class ContentRestApi {
    private static final Logger log = LoggerFactory.getLogger(ContentRestApi.class);
    private final PageManager pageManager;
    private final PermissionManager permissionManager;
    private final AttachmentManager attachmentManager;
    private final ContentPermissionManager contentPermissionManager;
    private ToolsHelper toolsHelper;

    @Inject
    public ContentRestApi(@ConfluenceImport PageManager pageManager, @ConfluenceImport PermissionManager permissionManager, @ConfluenceImport AttachmentManager attachmentManager, @ConfluenceImport ContentPermissionManager contentPermissionManager, ToolsHelper toolsHelper) {
        this.pageManager = pageManager;
        this.toolsHelper = toolsHelper;
        this.permissionManager = permissionManager;
        this.contentPermissionManager = contentPermissionManager;
        this.attachmentManager = attachmentManager;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/tools/space/{spaceId}")
    public Response getSpaceContentTools(@PathParam(value="spaceId") long spaceId) {
        Space space = this.toolsHelper.getSpaceFromSpaceDao(spaceId);
        if (space == null) {
            return this.toolsHelper.spaceNotExist(spaceId + "");
        }
        if (!this.toolsHelper.isConfluenceAdministrator() && !this.toolsHelper.isCurrentUserIsSpaceAdministrator(space)) {
            return this.toolsHelper.permissionViolation();
        }
        return this.getSpaceContentToolsResponse(spaceId);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/tools/content/{contentId}")
    public Response getSpaceContentToolsByContentId(@PathParam(value="contentId") long contentId) {
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        Page page = null;
        BlogPost blogPost = null;
        if (this.toolsHelper.getPageFormPageDao(contentId) != null) {
            page = this.toolsHelper.getPageFormPageDao(contentId);
        } else {
            blogPost = this.toolsHelper.getBlogPostFormPageDao(contentId);
        }
        if (!this.contentPermissionManager.hasContentLevelPermission(this.toolsHelper.getAuthenticatedUser(), "View", (ContentEntityObject)(page != null ? page : blogPost))) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.getPageFormPageDao(contentId) != null) {
            return this.getSpaceContentToolsResponse(page.getSpace().getId());
        }
        if (this.toolsHelper.getBlogPostFormPageDao(contentId) != null) {
            return this.getSpaceContentToolsResponse(blogPost.getSpace().getId());
        }
        return this.toolsHelper.contentIdNotExist(contentId);
    }

    private Response getSpaceContentToolsResponse(long spaceId) {
        Space space = this.toolsHelper.getSpaceFromSpaceDao(spaceId);
        if (space == null) {
            return this.toolsHelper.spaceNotExist(spaceId + "");
        }
        HashMap<String, Boolean> response = new HashMap<String, Boolean>();
        String value = this.toolsHelper.getSpaceContentTools("singleClickToCopyHeadingLinks", spaceId + "");
        response.put("singleClickToCopyHeadingLinks", value == null || value.equals("") || value.equals("true"));
        value = this.toolsHelper.getSpaceContentTools("editingComments", spaceId + "");
        response.put("editingComments", value == null || value.equals("") || value.equals("true"));
        return Response.ok(response).build();
    }

    @ReadOnlyAccessAllowed
    @POST
    @Produces(value={"application/json"})
    @Path(value="/tools/space/{spaceId}/{option}/{value}")
    public Response setSpaceContentTools(@PathParam(value="spaceId") long spaceId, @PathParam(value="option") String option, @PathParam(value="value") boolean value) {
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        Space space = this.toolsHelper.getSpaceFromSpaceDao(spaceId);
        if (space == null) {
            return this.toolsHelper.spaceNotExist(spaceId + "");
        }
        if (!this.toolsHelper.isConfluenceAdministrator() && !this.toolsHelper.isCurrentUserIsSpaceAdministrator(space)) {
            return this.toolsHelper.permissionViolation();
        }
        if (option.equals("singleClickToCopyHeadingLinks") || option.equals("editingComments") || option.equals("deletingComments")) {
            this.toolsHelper.setSpaceContentTools(option, spaceId + "", value + "");
        }
        return Response.ok().build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{contentId}")
    public Response getAttachmentVersions(@PathParam(value="contentId") long contentId, @QueryParam(value="dateFormat") String dateFormatApi) {
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        Page page = null;
        BlogPost blogPost = null;
        if (this.toolsHelper.getPageFormPageDao(contentId) != null) {
            page = this.toolsHelper.getPageFormPageDao(contentId);
        } else if (this.toolsHelper.getBlogPostFormPageDao(contentId) != null) {
            blogPost = this.toolsHelper.getBlogPostFormPageDao(contentId);
        } else {
            return this.toolsHelper.contentIdNotExist(contentId);
        }
        if (!this.toolsHelper.isConfluenceAdministrator() && !this.toolsHelper.isCurrentUserIsSpaceAdministrator(this.toolsHelper.getPageFormPageDao(contentId).getSpace())) {
            return this.toolsHelper.permissionViolation();
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        ArrayList allPermissionsList = new ArrayList();
        allPermissionsList.addAll(this.contentPermissionManager.getContentPermissionSets((ContentEntityObject)(page != null ? page : blogPost), "View"));
        allPermissionsList.addAll(this.contentPermissionManager.getContentPermissionSets((ContentEntityObject)(page != null ? page : blogPost), "Edit"));
        long lastPermissionModificationLong = -1L;
        Date lastPermissionModificationDate = null;
        for (ContentPermissionSet contentPermissionSet : allPermissionsList) {
            Date creationDate = contentPermissionSet.getCreationDate();
            if (creationDate.getTime() <= lastPermissionModificationLong) continue;
            lastPermissionModificationLong = creationDate.getTime();
            lastPermissionModificationDate = creationDate;
        }
        String fullDateFormat = "";
        fullDateFormat = dateFormatApi == null || dateFormatApi.equals("") ? "yyyy-MM-dd HH:mm:ss" : dateFormatApi + " HH:mm:ss";
        SimpleDateFormat sdfFull = new SimpleDateFormat(fullDateFormat);
        if (lastPermissionModificationDate != null) {
            response.put("lastPermissionModificationDate", lastPermissionModificationDate);
            response.put("lastPermissionModificationDateString", sdfFull.format(lastPermissionModificationDate));
        } else {
            response.put("lastPermissionModificationDate", "");
            response.put("lastPermissionModificationDateString", "");
        }
        if (page != null) {
            response.put("hasChildren", !page.getChildren().isEmpty());
            response.put("hasParent", page.getParent() != null);
            response.put("position", page.getPosition());
            response.put("id", page.getContentId().asLong());
            response.put("name", page.getNameForComparison());
            response.put("version", page.getVersion());
            response.put("type", page.getType());
            response.put("status", page.getContentStatus());
            response.put("spaceKey", page.getSpaceKey());
            response.put("spaceName", page.getSpace().getName());
            response.put("creationDate", page.getCreationDate());
            response.put("creationDateString", sdfFull.format(page.getCreationDate()));
            response.put("creatorName", page.getCreator() != null ? page.getCreator().getName() : "not exist");
            response.put("lastModificationDate", page.getLastModificationDate());
            response.put("lastModificationDateString", sdfFull.format(page.getLastModificationDate()));
            response.put("lastModifierName", page.getLastModifier() != null ? page.getLastModifier().getName() : "not exist");
            response.put("hasComments", !page.getComments().isEmpty());
            response.put("hasLabels", !page.getLabels().isEmpty());
        } else {
            response.put("id", blogPost.getContentId().asLong());
            response.put("name", blogPost.getNameForComparison());
            response.put("version", blogPost.getVersion());
            response.put("type", blogPost.getType());
            response.put("status", blogPost.getContentStatus());
            response.put("spaceKey", blogPost.getSpaceKey());
            response.put("spaceName", blogPost.getSpace().getName());
            response.put("creationDate", blogPost.getCreationDate());
            response.put("creationDateString", sdfFull.format(blogPost.getCreationDate()));
            response.put("creatorName", blogPost.getCreator() != null ? blogPost.getCreator().getName() : "not exist");
            response.put("lastModificationDate", blogPost.getLastModificationDate());
            response.put("lastModificationDateString", sdfFull.format(blogPost.getLastModificationDate()));
            response.put("lastModifierName", blogPost.getLastModifier() != null ? blogPost.getLastModifier().getName() : "not exist");
            response.put("hasComments", !blogPost.getComments().isEmpty());
            response.put("hasLabels", !blogPost.getLabels().isEmpty());
        }
        return Response.ok(response).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/{contentId}/prepend")
    public Response prepend(String jsonString, @PathParam(value="contentId") long contentId, @QueryParam(value="spaceKey") String spaceKey) {
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        Page page = null;
        BlogPost blogPost = null;
        Space space = null;
        if (this.toolsHelper.getPageFormPageDao(contentId) != null) {
            page = this.toolsHelper.getPageFormPageDao(contentId);
            space = page.getSpace();
        } else if (this.toolsHelper.getBlogPostFormPageDao(contentId) != null) {
            blogPost = this.toolsHelper.getBlogPostFormPageDao(contentId);
            space = blogPost.getSpace();
        } else {
            return this.toolsHelper.contentIdNotExist(contentId);
        }
        if (!(this.toolsHelper.isConfluenceAdministrator() || this.toolsHelper.isCurrentUserIsSpaceAdministrator(space) || this.toolsHelper.isDisabledForSpaceAdministrator("contentPrepend"))) {
            return this.toolsHelper.permissionViolation();
        }
        JSONObject jsonObject = new JSONObject(jsonString);
        if (!jsonObject.has("text")) {
            return this.toolsHelper.fieldRequired("text");
        }
        String text = jsonObject.getString("text");
        if (!this.toolsHelper.skipParamSpaceValidation(spaceKey, this.toolsHelper.getPageFormPageDao(contentId))) {
            return this.toolsHelper.permissionViolation();
        }
        TransactionTemplate transactionTemplate = (TransactionTemplate)ComponentLocator.getComponent(TransactionTemplate.class);
        if (page != null) {
            transactionTemplate.execute(() -> {
                Page pageToChange = this.toolsHelper.getPageFormPageDao(contentId);
                String newBody = text + pageToChange.getEntity().getBodyAsString();
                this.pageManager.saveNewVersion((ContentEntityObject)pageToChange, pageToModify -> pageToModify.getEntity().setBodyAsString(newBody));
                return null;
            });
        } else {
            transactionTemplate.execute(() -> {
                BlogPost blogPostToChange = this.toolsHelper.getBlogPostFormPageDao(contentId);
                String newBody = text + blogPostToChange.getEntity().getBodyAsString();
                this.pageManager.saveNewVersion((ContentEntityObject)blogPostToChange, pageToModify -> pageToModify.getEntity().setBodyAsString(newBody));
                return null;
            });
        }
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("status", "done");
        return Response.ok(response).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/{contentId}/append")
    public Response append(String jsonString, @PathParam(value="contentId") long contentId, @QueryParam(value="spaceKey") String spaceKey) {
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        Page page = null;
        BlogPost blogPost = null;
        Space space = null;
        if (this.toolsHelper.getPageFormPageDao(contentId) != null) {
            page = this.toolsHelper.getPageFormPageDao(contentId);
            space = page.getSpace();
        } else if (this.toolsHelper.getBlogPostFormPageDao(contentId) != null) {
            blogPost = this.toolsHelper.getBlogPostFormPageDao(contentId);
            space = blogPost.getSpace();
        } else {
            return this.toolsHelper.contentIdNotExist(contentId);
        }
        if (!(this.toolsHelper.isConfluenceAdministrator() || this.toolsHelper.isCurrentUserIsSpaceAdministrator(space) || this.toolsHelper.isDisabledForSpaceAdministrator("contentAppend"))) {
            return this.toolsHelper.permissionViolation();
        }
        JSONObject jsonObject = new JSONObject(jsonString);
        if (!jsonObject.has("text")) {
            return this.toolsHelper.fieldRequired("text");
        }
        String text = jsonObject.getString("text");
        if (!this.toolsHelper.skipParamSpaceValidation(spaceKey, this.toolsHelper.getPageFormPageDao(contentId))) {
            return this.toolsHelper.permissionViolation();
        }
        TransactionTemplate transactionTemplate = (TransactionTemplate)ComponentLocator.getComponent(TransactionTemplate.class);
        if (page != null) {
            transactionTemplate.execute(() -> {
                Page pageToChange = this.toolsHelper.getPageFormPageDao(contentId);
                String newBody = pageToChange.getEntity().getBodyAsString() + text;
                this.pageManager.saveNewVersion((ContentEntityObject)pageToChange, pageToModify -> pageToModify.getEntity().setBodyAsString(newBody));
                return null;
            });
        } else {
            transactionTemplate.execute(() -> {
                BlogPost blogPostToChange = this.toolsHelper.getBlogPostFormPageDao(contentId);
                String newBody = blogPostToChange.getEntity().getBodyAsString() + text;
                this.pageManager.saveNewVersion((ContentEntityObject)blogPostToChange, pageToModify -> pageToModify.getEntity().setBodyAsString(newBody));
                return null;
            });
        }
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("status", "done");
        return Response.ok(response).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/{contentId}/replaceAll")
    public Response replaceAll(String jsonString, @PathParam(value="contentId") long contentId, @QueryParam(value="spaceKey") String spaceKey) {
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        Page page = null;
        BlogPost blogPost = null;
        Space space = null;
        if (this.toolsHelper.getPageFormPageDao(contentId) != null) {
            page = this.toolsHelper.getPageFormPageDao(contentId);
            space = page.getSpace();
        } else if (this.toolsHelper.getBlogPostFormPageDao(contentId) != null) {
            blogPost = this.toolsHelper.getBlogPostFormPageDao(contentId);
            space = blogPost.getSpace();
        } else {
            return this.toolsHelper.contentIdNotExist(contentId);
        }
        if (!(this.toolsHelper.isConfluenceAdministrator() || this.toolsHelper.isCurrentUserIsSpaceAdministrator(space) || this.toolsHelper.isDisabledForSpaceAdministrator("contentReplaceAll"))) {
            return this.toolsHelper.permissionViolation();
        }
        JSONObject jsonObject = new JSONObject(jsonString);
        AtomicInteger numberOfReplacements = new AtomicInteger();
        if (!jsonObject.has("find")) {
            return this.toolsHelper.fieldRequired("find");
        }
        if (!jsonObject.has("replace")) {
            return this.toolsHelper.fieldRequired("replace");
        }
        boolean ignoreCase = jsonObject.has("ignoreCase") ? jsonObject.getBoolean("ignoreCase") : false;
        String find = jsonObject.getString("find");
        String replace = jsonObject.getString("replace");
        if (!this.toolsHelper.skipParamSpaceValidation(spaceKey, this.toolsHelper.getPageFormPageDao(contentId))) {
            return this.toolsHelper.permissionViolation();
        }
        TransactionTemplate transactionTemplate = (TransactionTemplate)ComponentLocator.getComponent(TransactionTemplate.class);
        if (page != null) {
            transactionTemplate.execute(() -> {
                String newBody;
                Page pageToChange = this.toolsHelper.getPageFormPageDao(contentId);
                String body = pageToChange.getEntity().getBodyAsString();
                if (ignoreCase) {
                    newBody = StringUtils.replaceIgnoreCase((String)body, (String)find, (String)replace);
                    numberOfReplacements.set(StringUtils.countMatches((CharSequence)body.toLowerCase(), (CharSequence)find.toLowerCase()));
                } else {
                    newBody = body.replace(find, replace);
                    numberOfReplacements.set(StringUtils.countMatches((CharSequence)body, (CharSequence)find));
                }
                this.pageManager.saveNewVersion((ContentEntityObject)pageToChange, pageToModify -> pageToModify.getEntity().setBodyAsString(newBody));
                return null;
            });
        } else {
            transactionTemplate.execute(() -> {
                String newBody;
                BlogPost blogPostToChange = this.toolsHelper.getBlogPostFormPageDao(contentId);
                String body = blogPostToChange.getEntity().getBodyAsString();
                if (ignoreCase) {
                    newBody = StringUtils.replaceIgnoreCase((String)body, (String)find, (String)replace);
                    numberOfReplacements.set(StringUtils.countMatches((CharSequence)body.toLowerCase(), (CharSequence)find.toLowerCase()));
                } else {
                    newBody = body.replace(find, replace);
                    numberOfReplacements.set(StringUtils.countMatches((CharSequence)body, (CharSequence)find));
                }
                this.pageManager.saveNewVersion((ContentEntityObject)blogPostToChange, pageToModify -> pageToModify.getEntity().setBodyAsString(newBody));
                return null;
            });
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("status", "done");
        response.put("numberOfReplacements", numberOfReplacements);
        response.put("ignoreCase", ignoreCase);
        return Response.ok(response).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/attachment/{attachmentId}/versions")
    public Response getAttachmentVersions(@PathParam(value="attachmentId") long attachmentId, @QueryParam(value="startAt") int startAt, @QueryParam(value="maxResults") int maxResults, @QueryParam(value="spaceKey") String spaceKey) {
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        Attachment attachment = this.attachmentManager.getAttachment(attachmentId);
        if (attachment == null) {
            return this.toolsHelper.attachmentIdNotExist(attachmentId);
        }
        if (!this.toolsHelper.currentUserIsInConfluenceAdministratorGroup() && !this.contentPermissionManager.hasContentLevelPermission(this.toolsHelper.getAuthenticatedUser(), "View", attachment.getContainer())) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.toolsHelper.skipParamSpaceValidation(spaceKey, attachment.getSpace().getKey())) {
            return this.toolsHelper.permissionViolation();
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        List attachmentVersions = this.attachmentManager.getAllVersions(attachment);
        ArrayList attachmentVersionsList = new ArrayList();
        response.put("fileExtension", attachment.getFileExtension());
        response.put("name", attachment.getFileName());
        response.put("id", attachment.getId());
        int iterator = 0;
        if (maxResults == 0) {
            maxResults = 10;
        }
        for (Attachment attachmentVersion : attachmentVersions) {
            if (startAt <= iterator && iterator < startAt + maxResults) {
                HashMap<String, Object> attachmentMap = new HashMap<String, Object>();
                attachmentMap.put("fileName", attachment.getFileName());
                attachmentMap.put("version", attachmentVersion.getVersion());
                attachmentMap.put("comment", attachmentVersion.getVersionComment() == null ? "" : attachmentVersion.getVersionComment());
                attachmentMap.put("fileSize", attachmentVersion.getFileSize());
                attachmentMap.put("creatorName", attachmentVersion.getCreator() != null ? attachmentVersion.getCreator().getName() : "unknown user");
                attachmentMap.put("creationDate", attachmentVersion.getCreationDate());
                attachmentMap.put("fileSizeNice", attachmentVersion.getNiceFileSize());
                attachmentVersionsList.add(attachmentMap);
            }
            ++iterator;
        }
        response.put("total", attachmentVersions.size());
        response.put("startAt", startAt);
        response.put("maxResults", maxResults);
        response.put("versions", attachmentVersionsList);
        return Response.ok(response).build();
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/attachment/{attachmentId}/delete")
    public Response deleteAttachmentAllVersion(@PathParam(value="attachmentId") long attachmentId, @QueryParam(value="muteNotification") boolean muteNotification, @QueryParam(value="spaceKey") String spaceKey) {
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        Attachment attachment = this.attachmentManager.getAttachment(attachmentId);
        if (attachment == null) {
            return this.toolsHelper.attachmentIdNotExist(attachmentId);
        }
        User user = this.toolsHelper.getAuthenticatedUser();
        if (!(this.toolsHelper.currentUserIsInConfluenceAdministratorGroup() || this.contentPermissionManager.hasContentLevelPermission(user, "Edit", attachment.getContainer()) && this.toolsHelper.getSpacePermissionManager().hasPermission("REMOVEATTACHMENT", attachment.getSpace(), user))) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.toolsHelper.skipParamSpaceValidation(spaceKey, attachment.getSpace().getKey())) {
            return this.toolsHelper.permissionViolation();
        }
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("message", "Attachment '" + attachment.getFileName() + "' deleted.");
        if (this.toolsHelper.isConfluenceAdministrator() && muteNotification) {
            this.attachmentManager.removeAttachmentWithoutNotifications(attachment);
        } else {
            this.attachmentManager.removeAttachmentFromServer(attachment);
        }
        response.put("status", "done");
        return Response.ok(response).build();
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/attachment/{attachmentId}/delete/{versionId}")
    public Response deleteAttachmentVersion(@PathParam(value="attachmentId") long attachmentId, @PathParam(value="versionId") long versionId, @QueryParam(value="spaceKey") String spaceKey) {
        HashMap<String, String> response;
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        Attachment attachment = this.attachmentManager.getAttachment(attachmentId);
        if (attachment == null) {
            return this.toolsHelper.attachmentIdNotExist(attachmentId);
        }
        if (!(this.toolsHelper.currentUserIsInConfluenceAdministratorGroup() || this.contentPermissionManager.hasContentLevelPermission(this.toolsHelper.getAuthenticatedUser(), "View", attachment.getContainer()) && this.toolsHelper.isCurrentUserIsSpaceAdministrator(attachment.getSpace()) && !this.toolsHelper.isDisabledForSpaceAdministrator("attachmentDeleteVersionId"))) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.toolsHelper.skipParamSpaceValidation(spaceKey, attachment.getSpace().getKey())) {
            return this.toolsHelper.permissionViolation();
        }
        Attachment attachmentToDelete = null;
        List attachmentVersions = this.attachmentManager.getAllVersions(attachment);
        for (Attachment findAttachmentToDelete : attachmentVersions) {
            if ((long)findAttachmentToDelete.getVersion() != versionId) continue;
            attachmentToDelete = findAttachmentToDelete;
            break;
        }
        if (attachmentToDelete == null) {
            response = new HashMap<String, String>();
            response.put("message", "version '" + versionId + "' of the '" + attachment.getFileName() + "' attachment does not exist");
            return Response.serverError().entity(response).build();
        }
        response = new HashMap();
        response.put("message", "version '" + versionId + "' of the '" + attachment.getFileName() + "' attachment has been removed");
        this.attachmentManager.removeAttachmentVersionFromServer(attachmentToDelete);
        response.put("status", "done");
        return Response.ok(response).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/{a:movePage|reorderPage}")
    public Response moveReorderPage(String jsonString, @QueryParam(value="spaceKey") String spaceKey) {
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        HashMap<String, String> response = new HashMap<String, String>();
        ArrayList<String> errors = new ArrayList<String>();
        JSONObject jsonObject = new JSONObject(jsonString);
        if (!jsonObject.has("sourcePageId")) {
            return this.toolsHelper.fieldRequired("sourcePageId");
        }
        if (!jsonObject.has("targetPageId")) {
            return this.toolsHelper.fieldRequired("targetPageId");
        }
        if (!jsonObject.has("position")) {
            return this.toolsHelper.fieldRequired("position");
        }
        Page sourcePage = this.toolsHelper.getPageFormPageDao(jsonObject.getLong("sourcePageId"));
        Page targetPage = this.toolsHelper.getPageFormPageDao(jsonObject.getLong("targetPageId"));
        String movePoint = jsonObject.getString("position").toLowerCase();
        if (sourcePage == null) {
            response.put("message", this.toolsHelper.getTranslation("movepage.source.notfound"));
            return Response.serverError().entity(response).build();
        }
        if (targetPage == null) {
            response.put("message", this.toolsHelper.getTranslation("movepage.target.notfound"));
            return Response.serverError().entity(response).build();
        }
        if (!(movePoint.equals("append") || movePoint.equals("above") || movePoint.equals("below"))) {
            response.put("message", this.toolsHelper.getTranslation("movepage.point.invalid", Collections.singletonList(movePoint)));
            return Response.serverError().entity(response).build();
        }
        if (sourcePage.equals((Object)targetPage)) {
            response.put("message", "The source page cannot be the same as the target page.");
            return Response.serverError().entity(response).build();
        }
        if (sourcePage.getSpace() != targetPage.getSpace()) {
            User user;
            Space targetSpace = targetPage.getSpace();
            List<String> existPageTitles = this.listOfPermittedPageTitlesAlreadyExist(sourcePage, targetSpace);
            if (!existPageTitles.isEmpty()) {
                String targetSpaceName = targetSpace.getName();
                for (String title : existPageTitles) {
                    errors.add(this.toolsHelper.getTranslation("page.already.exists.inspace", Arrays.asList(title, targetSpaceName)));
                }
            }
            if ((sourcePage.hasPermissions("View") || sourcePage.hasPermissions("Edit")) && !this.permissionManager.hasPermission(user = this.toolsHelper.getAuthenticatedUser(), Permission.SET_PERMISSIONS, (Object)targetPage)) {
                errors.add(this.toolsHelper.getTranslation("save.restrictions.not.permitted"));
            }
        }
        if ("append".equals(movePoint)) {
            if (targetPage.getAncestors().contains(sourcePage)) {
                errors.add(this.toolsHelper.getTranslation("movepage.target.invalid"));
            }
        } else if (targetPage.getParent() != null && targetPage.getParent().getAncestors().contains(sourcePage)) {
            errors.add(this.toolsHelper.getTranslation("movepage.target.invalid"));
        }
        if (!errors.isEmpty()) {
            response.put("message", String.join((CharSequence)"; ", errors));
            return Response.serverError().entity(response).build();
        }
        if (!this.toolsHelper.skipParamSpaceValidation(spaceKey, sourcePage)) {
            return this.toolsHelper.permissionViolation();
        }
        if ("below".equals(movePoint)) {
            this.pageManager.movePageAfter(sourcePage, targetPage);
        } else if ("above".equals(movePoint)) {
            this.pageManager.movePageBefore(sourcePage, targetPage);
        } else if (!(targetPage.hasChildren() && targetPage.getChildren().contains(sourcePage) || !"append".equals(movePoint))) {
            this.pageManager.movePageAsChild(sourcePage, targetPage);
        }
        response.put("message", "Page '" + sourcePage.getTitle() + " (Id: " + sourcePage.getIdAsString() + ")' moved.");
        response.put("status", "done");
        return Response.ok(response).build();
    }

    private List<String> listOfPermittedPageTitlesAlreadyExist(Page sourcePage, Space targetSpace) {
        ArrayList<String> existTitles = new ArrayList<String>();
        if (this.toolsHelper.getPageFormPageDao(targetSpace.getKey(), sourcePage.getTitle()) != null) {
            existTitles.add(sourcePage.getTitle());
        }
        List descendantTitles = this.pageManager.getDescendantTitles(sourcePage);
        for (String title : descendantTitles) {
            Page page = this.toolsHelper.getPageFormPageDao(targetSpace.getKey(), title);
            User user = this.toolsHelper.getAuthenticatedUser();
            if (page == null || !this.permissionManager.hasPermission(user, Permission.EDIT, (Object)page)) continue;
            existTitles.add(title);
        }
        return existTitles;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/countContent/{userName}")
    public Response countContentCreator(@PathParam(value="userName") String userName) {
        userName = this.toolsHelper.decodeUrlParam(userName);
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        ConfluenceUser confluenceUser = this.toolsHelper.getConfluenceUserByName(userName);
        if (confluenceUser == null) {
            return this.toolsHelper.userNotFound(userName);
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("contentCount", this.toolsHelper.getPageAuthoredPagesCountByUserFormPageDao(userName));
        response.put("message", "success");
        return Response.ok(response).build();
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/changeCreator/space/{spaceKey}/user/{userNameOrKey}")
    public Response changeSpaceCreatorBySpaceKey(String jsonString, @PathParam(value="userNameOrKey") String userNameOrKey, @PathParam(value="spaceKey") String spaceKey) {
        userNameOrKey = this.toolsHelper.decodeUrlParam(userNameOrKey);
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        if (this.toolsHelper.getConfluenceUserByName(userNameOrKey) == null && this.toolsHelper.getConfluenceUserByKey(userNameOrKey) == null) {
            return this.toolsHelper.userNotFound(userNameOrKey);
        }
        JSONObject jsonObject = new JSONObject(jsonString);
        HashMap<String, Object> response = new HashMap<String, Object>();
        String newCreatorName = "";
        if (jsonObject.isNull("newCreatorName") || jsonObject.getString("newCreatorName").equals("")) {
            return this.toolsHelper.fieldRequired("newCreatorName");
        }
        newCreatorName = jsonObject.getString("newCreatorName");
        Space space = this.toolsHelper.getSpaceFromSpaceDao(spaceKey);
        if (space == null) {
            return this.toolsHelper.spaceNotExist(spaceKey);
        }
        if (space.getSpaceType().equals((Object)SpaceType.PERSONAL)) {
            return this.toolsHelper.spaceIsNotGlobal(spaceKey);
        }
        ConfluenceUser confluenceUser = this.toolsHelper.getConfluenceUserByName(newCreatorName);
        if (confluenceUser == null) {
            return this.toolsHelper.userNotFound(newCreatorName);
        }
        if (log.isDebugEnabled()) {
            log.debug("spaceKey : " + spaceKey);
            log.debug("userNameOrKey : " + userNameOrKey);
            log.debug("newCreatorName : " + newCreatorName);
        }
        ArrayList<Long> contentsChanged = new ArrayList<Long>();
        ArrayList contentsSkipped = new ArrayList();
        int contentCount = 0;
        List<ContentEntityObject> contentEntityObjects = this.toolsHelper.getPageContentAuthoredByUser(userNameOrKey);
        for (ContentEntityObject contentEntityObject : contentEntityObjects) {
            String contentType;
            if (log.isDebugEnabled()) {
                log.debug("getType " + contentEntityObject.getType());
                log.debug("getId " + contentEntityObject.getId());
            }
            if (!(contentType = contentEntityObject.getType()).equalsIgnoreCase("blogpost") && !contentType.equalsIgnoreCase("page") || !contentEntityObject.toPageContext().getSpaceKey().equalsIgnoreCase(spaceKey)) continue;
            contentEntityObject.setCreator(confluenceUser);
            this.pageManager.saveContentEntity(contentEntityObject, null);
            contentsChanged.add(contentEntityObject.getId());
            ++contentCount;
        }
        response.put("contentsSkipped", contentsSkipped);
        response.put("contentsChanged", contentsChanged);
        response.put("total", contentCount);
        response.put("message", "success");
        return Response.ok(response).build();
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/changeCreator/contentId")
    public Response changeSpaceCreatorByContentId(String jsonString, @QueryParam(value="spaceKey") String spaceKey) {
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        JSONObject jsonObject = new JSONObject(jsonString);
        HashMap<String, Object> response = new HashMap<String, Object>();
        String newCreatorName = "";
        if (jsonObject.isNull("contentIds") || !jsonObject.isNull("contentIds") && jsonObject.getJSONArray("contentIds").length() < 1) {
            return this.toolsHelper.fieldRequired("contentIds");
        }
        ArrayList<Long> contentIds = this.toolsHelper.getLongJSONarray(jsonObject, "contentIds");
        if (jsonObject.isNull("newCreatorName") || jsonObject.getString("newCreatorName").equals("")) {
            return this.toolsHelper.fieldRequired("newCreatorName");
        }
        newCreatorName = jsonObject.getString("newCreatorName");
        User user = this.toolsHelper.getUserByName(newCreatorName);
        if (user == null) {
            return this.toolsHelper.userNotFound(newCreatorName);
        }
        if (log.isDebugEnabled()) {
            log.debug("contentIds : " + contentIds);
            log.debug("creatorName : " + newCreatorName);
        }
        ArrayList<Long> contentsChanged = new ArrayList<Long>();
        ArrayList<Long> contentsSkipped = new ArrayList<Long>();
        int contentCount = 0;
        for (Long contentId : contentIds) {
            Page page = this.toolsHelper.getPageFormPageDao(contentId);
            BlogPost blogPost = this.toolsHelper.getBlogPostFormPageDao(contentId);
            if (page != null && this.toolsHelper.skipParamSpaceValidation(spaceKey, page) || blogPost != null && this.toolsHelper.skipParamSpaceValidation(spaceKey, blogPost)) {
                if (page != null) {
                    page.setCreator((ConfluenceUser)user);
                    this.pageManager.saveContentEntity((ContentEntityObject)page, DefaultSaveContext.SUPPRESS_NOTIFICATIONS);
                    contentsChanged.add(page.getId());
                } else {
                    blogPost.setCreator((ConfluenceUser)user);
                    this.pageManager.saveContentEntity((ContentEntityObject)blogPost, DefaultSaveContext.SUPPRESS_NOTIFICATIONS);
                    contentsChanged.add(blogPost.getId());
                }
                ++contentCount;
                continue;
            }
            contentsSkipped.add(contentId);
        }
        response.put("contentsSkipped", contentsSkipped);
        response.put("contentsChanged", contentsChanged);
        response.put("total", contentCount);
        response.put("message", "success");
        return Response.ok(response).build();
    }
}

