/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender.complexity;

import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.itlab.confluence.plugins.restextender.helper.ToolsHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

@Path(value="/complexity")
public class ComplexityAnalysisApi {
    private static final Logger log = LoggerFactory.getLogger(ComplexityAnalysisApi.class);
    private final ToolsHelper toolsHelper;

    @Inject
    public ComplexityAnalysisApi(ToolsHelper toolsHelper) {
        this.toolsHelper = toolsHelper;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/getGroups")
    public Response getGroups() {
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        HashMap response = new HashMap();
        ArrayList<String> groupsArray = new ArrayList<String>();
        Object groups = this.toolsHelper.getBandanaObjectByType(this.toolsHelper.getComplexityReportsGroups());
        if (groups != null) {
            if (groups.toString().contains("@@@")) {
                String[] groupsTable = groups.toString().split("@@@");
                groupsArray.addAll(Arrays.asList(groupsTable));
            } else if (!groups.toString().isEmpty()) {
                groupsArray.add(groups.toString());
            }
        }
        response.put("groups", groupsArray);
        return Response.ok(response).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/allowAll")
    public Response allowAll() {
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        this.toolsHelper.setBandanaObjectByType(this.toolsHelper.getComplexityReportsAllowAll(), "allowAll");
        return Response.ok().build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/disallowAll")
    public Response disallowAll() {
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        this.toolsHelper.setBandanaObjectByType(this.toolsHelper.getComplexityReportsAllowAll(), "disallowAll");
        return Response.ok().build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/removeGroup/{groupName}")
    public Response removeGroup(@PathParam(value="groupName") String groupName) {
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        StringBuilder newGroups = new StringBuilder();
        Object groups = this.toolsHelper.getBandanaObjectByType(this.toolsHelper.getComplexityReportsGroups());
        if (groups != null) {
            if (groups.toString().contains("@@@")) {
                String[] groupsTable;
                for (String groupTableName : groupsTable = groups.toString().split("@@@")) {
                    if (groupTableName.equalsIgnoreCase(groupName)) continue;
                    if (newGroups.length() > 0) {
                        newGroups.append("@@@");
                    }
                    newGroups.append(groupTableName);
                }
            } else if (!groups.toString().isEmpty()) {
                newGroups = new StringBuilder(groups.toString().replace(groupName, ""));
            }
            this.toolsHelper.setBandanaObjectByType(this.toolsHelper.getComplexityReportsGroups(), newGroups.toString());
        }
        return Response.ok().build();
    }

    @POST
    @ReadOnlyAccessAllowed
    @Produces(value={"application/json"})
    @Path(value="/configuration")
    public Response setConfig(String requestJson, @Context HttpServletRequest request) {
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        JSONObject jsonObject = new JSONObject(requestJson);
        this.toolsHelper.setBandanaObjectByType(this.toolsHelper.getComplexityFirstLevelMessage(), jsonObject.getString("complexityFirstLevel"));
        this.toolsHelper.setBandanaObjectByType(this.toolsHelper.getComplexitySecondLevelMessage(), jsonObject.getString("complexitySecondLevel"));
        this.toolsHelper.setBandanaObjectByType(this.toolsHelper.getComplexityThirdLevelMessage(), jsonObject.getString("complexityThirdLevel"));
        this.toolsHelper.setBandanaObjectByType(this.toolsHelper.getComplexitySecondLevelLimit(), jsonObject.getString("complexitySecondLevelLimit"));
        this.toolsHelper.setBandanaObjectByType(this.toolsHelper.getComplexityThirdLevelLimit(), jsonObject.getString("complexityThirdLevelLimit"));
        this.toolsHelper.setBandanaObjectByType(this.toolsHelper.getComplexityExcessiveNestedTags(), jsonObject.getString("excessiveNestedTags"));
        return Response.ok().build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/configuration")
    public Response getConfig() {
        Object excessiveNestedTags;
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        Map<String, Object> response = new HashMap<String, Object>();
        response.put("limitComplexity", "");
        Object allowAll = this.toolsHelper.getBandanaObjectByType(this.toolsHelper.getComplexityReportsAllowAll());
        if (allowAll != null && allowAll.toString() != null && allowAll.toString().equalsIgnoreCase("allowAll")) {
            response.put("limitComplexity", "allowAll");
        }
        if ((excessiveNestedTags = this.toolsHelper.getBandanaObjectByType(this.toolsHelper.getComplexityExcessiveNestedTags())) != null && excessiveNestedTags.toString() != null && excessiveNestedTags.toString().equalsIgnoreCase("true")) {
            response.put("excessiveNestedTags", "true");
        } else {
            response.put("excessiveNestedTags", "false");
        }
        response = this.addComplexityConfiguration(response);
        return Response.ok(response).build();
    }

    private Map<String, Object> addComplexityConfiguration(Map<String, Object> response) {
        Object complexityLevelMessage = this.toolsHelper.getBandanaObjectByType(this.toolsHelper.getComplexityFirstLevelMessage());
        if (complexityLevelMessage == null || complexityLevelMessage.toString().isEmpty() || complexityLevelMessage.toString().equalsIgnoreCase("null")) {
            response.put("complexityFirstLevelMessage", "Your page is very complex and is likely experiencing performance issues. This is generally caused by broken page formatting code but it may also simply be due to the size of your page and the type of information stored (eg, lots of tables). If you need help resolving this problem, please raise a support request.");
        } else {
            response.put("complexityFirstLevelMessage", complexityLevelMessage.toString());
        }
        complexityLevelMessage = this.toolsHelper.getBandanaObjectByType(this.toolsHelper.getComplexitySecondLevelMessage());
        if (complexityLevelMessage == null || complexityLevelMessage.toString().isEmpty() || complexityLevelMessage.toString().equalsIgnoreCase("null")) {
            response.put("complexitySecondLevelMessage", "Your page is getting complex and may begin experiencing performance issues. This is generally caused by broken page formatting code but it may also simply be due to the size of your page and the type of information stored (eg, lots of tables). If you need help resolving this problem, please raise a support request.");
        } else {
            response.put("complexitySecondLevelMessage", complexityLevelMessage.toString());
        }
        complexityLevelMessage = this.toolsHelper.getBandanaObjectByType(this.toolsHelper.getComplexityThirdLevelMessage());
        if (complexityLevelMessage == null || complexityLevelMessage.toString().isEmpty() || complexityLevelMessage.toString().equalsIgnoreCase("null")) {
            response.put("complexityThirdLevelMessage", "Your page looks good.");
        } else {
            response.put("complexityThirdLevelMessage", complexityLevelMessage.toString());
        }
        Object complexityLevelLimit = this.toolsHelper.getBandanaObjectByType(this.toolsHelper.getComplexityThirdLevelLimit());
        if (complexityLevelLimit == null || complexityLevelLimit.toString().isEmpty() || complexityLevelLimit.toString().equalsIgnoreCase("null")) {
            response.put("complexityThirdLevelLimit", "10000");
        } else {
            response.put("complexityThirdLevelLimit", complexityLevelLimit.toString());
        }
        complexityLevelLimit = this.toolsHelper.getBandanaObjectByType(this.toolsHelper.getComplexitySecondLevelLimit());
        if (complexityLevelLimit == null || complexityLevelLimit.toString().isEmpty() || complexityLevelLimit.toString().equalsIgnoreCase("null")) {
            response.put("complexitySecondLevelLimit", "25000");
        } else {
            response.put("complexitySecondLevelLimit", complexityLevelLimit.toString());
        }
        return response;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/addGroup/{groupName}")
    public Response setGroups(@PathParam(value="groupName") String groupName) {
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        Object groups = this.toolsHelper.getBandanaObjectByType(this.toolsHelper.getComplexityReportsGroups());
        if (groups != null && !groups.toString().isEmpty()) {
            this.toolsHelper.setBandanaObjectByType(this.toolsHelper.getComplexityReportsGroups(), groups.toString() + "@@@" + groupName);
        } else {
            this.toolsHelper.setBandanaObjectByType(this.toolsHelper.getComplexityReportsGroups(), groupName);
        }
        return Response.ok().build();
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="/content/{contentId}")
    public Response getSimpleReport(@PathParam(value="contentId") long contentId, @QueryParam(value="showDetails") boolean showDetails, @QueryParam(value="showContent") boolean showContent) {
        HashMap<String, Object> response;
        block14: {
            if (!this.toolsHelper.isLicenseIsValid()) {
                return this.toolsHelper.licenseIsInvalid();
            }
            Page page = null;
            BlogPost blogPost = null;
            if (this.toolsHelper.getPageFormPageDao(contentId) != null) {
                page = this.toolsHelper.getPageFormPageDao(contentId);
            } else if (this.toolsHelper.getBlogPostFormPageDao(contentId) != null) {
                blogPost = this.toolsHelper.getBlogPostFormPageDao(contentId);
            } else {
                return this.toolsHelper.contentIdNotExist(contentId);
            }
            String contentStorageFormat = "";
            contentStorageFormat = page != null ? page.getBodyAsString() : blogPost.getBodyAsString();
            response = new HashMap<String, Object>();
            response.put("contentType", page != null ? "page" : "blogPost");
            long contentComplexityAllTags = 0L;
            try {
                Document document = this.toolsHelper.getStorageDocument(contentStorageFormat);
                TransformerFactory tf = TransformerFactory.newInstance();
                Transformer transformer = tf.newTransformer();
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "2");
                HashMap<String, Long> tags = new HashMap<String, Long>();
                NodeList nodeList = document.getElementsByTagName("*");
                contentComplexityAllTags = nodeList.getLength() - 1;
                tags.put("all", contentComplexityAllTags);
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    String nodeName = nodeList.item(i).getNodeName();
                    long size = tags.get(nodeName) == null ? 0L : (Long)tags.get(nodeName) + 1L;
                    tags.put(nodeName, size);
                }
                tags.remove("storage-format");
                boolean excessiveNestedTagsBoolean = false;
                boolean hasExcessiveNestedTags = false;
                Object excessiveNestedTags = this.toolsHelper.getBandanaObjectByType(this.toolsHelper.getComplexityExcessiveNestedTags());
                if (excessiveNestedTags != null && excessiveNestedTags.toString() != null && excessiveNestedTags.toString().equalsIgnoreCase("true")) {
                    excessiveNestedTagsBoolean = true;
                    hasExcessiveNestedTags = this.hasExcessiveNestedTags(contentStorageFormat);
                }
                Map<String, Object> configuration = this.addComplexityConfiguration(new HashMap<String, Object>());
                if (showDetails && this.toolsHelper.isConfluenceAdministrator()) {
                    response.put("tags", tags);
                    response.put("configuration", configuration);
                    response.put("excessiveNestedTags", excessiveNestedTagsBoolean);
                    response.put("hasExcessiveNestedTags", hasExcessiveNestedTags);
                    if (showContent) {
                        response.put("storageFormat", contentStorageFormat);
                    }
                }
                response.put("status", "done");
                long complexityThirdLevelLimit = Long.parseLong(configuration.get("complexityThirdLevelLimit") + "");
                long complexitySecondLevelLimit = Long.parseLong(configuration.get("complexitySecondLevelLimit") + "");
                String badgeSpanStart = "<span id=\"extender-content-complexity\" class=\"aui-lozenge aui-lozenge-";
                String badgeSpanEnd = "\" style=\"cursor: default;\" extender-tooltip=\"";
                if (contentComplexityAllTags <= complexityThirdLevelLimit) {
                    response.put("badge", badgeSpanStart + "success" + badgeSpanEnd + configuration.get("complexityThirdLevelMessage").toString().replaceAll("@@br@@", "<br>").replaceAll("\"", "&#34;") + "\">Optimal</span>");
                }
                if (contentComplexityAllTags > complexityThirdLevelLimit && contentComplexityAllTags <= complexitySecondLevelLimit) {
                    response.put("badge", badgeSpanStart + "moved" + badgeSpanEnd + configuration.get("complexitySecondLevelMessage").toString().replaceAll("@@br@@", "<br>").replaceAll("\"", "&#34;") + "\">High</span>");
                }
                if (excessiveNestedTagsBoolean && hasExcessiveNestedTags || contentComplexityAllTags > complexitySecondLevelLimit) {
                    response.put("badge", badgeSpanStart + "removed" + badgeSpanEnd + configuration.get("complexityFirstLevelMessage").toString().replaceAll("@@br@@", "<br>").replaceAll("\"", "&#34;") + "\">Extreme</span>");
                }
            }
            catch (Exception ex) {
                response.put("status", "error");
                if (!log.isDebugEnabled()) break block14;
                log.debug("Exception: " + ExceptionUtils.getStackTrace((Throwable)ex));
            }
        }
        return Response.ok(response).build();
    }

    private static String safeChar(String input) {
        char[] allowed = "0123456789abcdefghijklmnopqrstuvwxyz='\"-_<>/\\".toCharArray();
        char[] charArray = input.toString().toCharArray();
        StringBuilder result = new StringBuilder();
        for (char c : charArray) {
            for (char a : allowed) {
                if (c != a) continue;
                result.append(a);
            }
        }
        return result.toString();
    }

    private boolean hasExcessiveNestedTags(String contentStorageFormat) {
        return Pattern.matches(".*<\\/span><\\/span><\\/span><\\/span><\\/span><\\/span>.*", ComplexityAnalysisApi.safeChar(contentStorageFormat.toLowerCase()));
    }
}

