/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender.space.backup;

import com.atlassian.confluence.importexport.DefaultImportContext;
import com.atlassian.confluence.importexport.ImportContext;
import com.atlassian.confluence.importexport.ImportExportException;
import com.atlassian.confluence.importexport.ImportExportManager;
import com.atlassian.confluence.importexport.actions.ImportLongRunningTask;
import com.atlassian.confluence.importexport.impl.ExportDescriptor;
import com.atlassian.confluence.importexport.impl.UnexpectedImportZipFileContents;
import com.atlassian.confluence.search.IndexManager;
import com.atlassian.confluence.util.longrunning.LongRunningTaskId;
import com.atlassian.confluence.util.longrunning.LongRunningTaskManager;
import com.atlassian.core.task.longrunning.LongRunningTask;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.servlet.ServletContextFactory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.user.User;
import com.itlab.confluence.plugins.restextender.helper.ExtenderConfiguration;
import com.itlab.confluence.plugins.restextender.helper.ToolsHelper;
import java.io.File;
import java.util.HashMap;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/import")
public class ImportRestApi {
    private static final Logger log = LoggerFactory.getLogger(ImportRestApi.class);
    private final ImportExportManager importExportManager;
    private final LongRunningTaskManager longRunningTaskManager;
    private final ServletContextFactory servletContextFactory;
    private final ExtenderConfiguration extenderConfiguration;
    private final IndexManager indexManager;
    private final EventPublisher eventPublisher;
    private ToolsHelper toolsHelper;
    private static final String IMPORT_TASK = "com.itlab.confluence.plugins.restextender.import.taskId";
    public static final String RESTORE_DIR = "restore";

    @Inject
    public ImportRestApi(@ConfluenceImport LongRunningTaskManager longRunningTaskManager, @ConfluenceImport ServletContextFactory servletContextFactory, @ConfluenceImport EventPublisher eventPublisher, ToolsHelper toolsHelper, ExtenderConfiguration extenderConfiguration) {
        this.toolsHelper = toolsHelper;
        this.importExportManager = (ImportExportManager)ComponentLocator.getComponent(ImportExportManager.class);
        this.longRunningTaskManager = longRunningTaskManager;
        this.servletContextFactory = servletContextFactory;
        this.eventPublisher = eventPublisher;
        this.extenderConfiguration = extenderConfiguration;
        this.indexManager = (IndexManager)ComponentLocator.getComponent(IndexManager.class);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/task/{taskId}")
    public Response getTaskIdInfo(@PathParam(value="taskId") String taskId) {
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        LongRunningTask longRunningTask = this.longRunningTaskManager.getLongRunningTask(this.toolsHelper.getAuthenticatedUser(), LongRunningTaskId.valueOf((String)taskId.toString()));
        if (!this.longRunningTaskExist(longRunningTask)) {
            return this.toolsHelper.taskIdNotExist(taskId);
        }
        response.put("name", longRunningTask.getName());
        response.put("currentStatus", longRunningTask.getCurrentStatus());
        response.put("isComplete", longRunningTask.isComplete());
        response.put("isSuccessful", longRunningTask.isSuccessful());
        response.put("percentageComplete", longRunningTask.getPercentageComplete());
        response.put("prettyElapsedTime", longRunningTask.getPrettyElapsedTime());
        response.put("prettyTimeRemaining", longRunningTask.getPrettyTimeRemaining());
        return Response.ok(response).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/file")
    public Response importFile(String jsonString) {
        Object taskIdObject;
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        HashMap<String, String> response = new HashMap<String, String>();
        User user = this.toolsHelper.getAuthenticatedUser();
        JSONObject jsonObject = new JSONObject(jsonString);
        boolean synchronous = false;
        if (jsonObject.has("synchronous")) {
            synchronous = jsonObject.getBoolean("synchronous");
        }
        if (this.isLongRunningTaskSupported() && (taskIdObject = this.extenderConfiguration.getPluginDataValue(IMPORT_TASK)) != null && !"".equals(taskIdObject.toString())) {
            LongRunningTask longRunningTask = this.longRunningTaskManager.getLongRunningTask(user, LongRunningTaskId.valueOf((String)taskIdObject.toString()));
            if (log.isDebugEnabled()) {
                log.debug("getName " + longRunningTask.getName());
                log.debug("isComplete " + longRunningTask.isComplete());
                log.debug("getCurrentStatus " + longRunningTask.getCurrentStatus());
                log.debug("isSuccessful " + longRunningTask.isSuccessful());
            }
            if (!this.longRunningTaskExist(longRunningTask) || longRunningTask.isComplete() || !longRunningTask.isComplete() && !longRunningTask.isSuccessful()) {
                log.debug("done");
            } else {
                response.put("status", "waiting");
                response.put("message", "another import is in progress");
                response.put("taskId", taskIdObject.toString());
                return Response.ok(response).build();
            }
        }
        String dirType = "";
        try {
            dirType = jsonObject.getString("dirType");
        }
        catch (Exception ex) {
            log.debug("RESTAPI - dirType - debug:empty");
        }
        String fileName = "";
        try {
            fileName = jsonObject.getString("fileName");
        }
        catch (Exception ex) {
            log.debug("RESTAPI - fileName - debug:empty");
        }
        if (fileName == null || fileName.equals("")) {
            return this.toolsHelper.fieldRequired("fileName");
        }
        boolean reindex = false;
        try {
            reindex = jsonObject.getBoolean("reindex");
        }
        catch (Exception ex) {
            log.debug("RESTAPI - reindex - debug:empty");
        }
        try {
            File localRestoreFile;
            File restoreDirectory;
            String homeDir = "";
            if (dirType.equals("")) {
                homeDir = this.toolsHelper.isLicensedForDataCenter() ? this.toolsHelper.getSharedHomeDirectory() : this.toolsHelper.getLocalHomeDirectory();
            } else if (dirType.equalsIgnoreCase("sharedHomeDirectory")) {
                homeDir = this.toolsHelper.getSharedHomeDirectory();
                if (homeDir.equals("")) {
                    homeDir = this.toolsHelper.getLocalHomeDirectory();
                }
            } else {
                homeDir = this.toolsHelper.getLocalHomeDirectory();
            }
            if (log.isDebugEnabled()) {
                log.debug("homeDir: " + homeDir);
            }
            if ((restoreDirectory = new File(homeDir + File.separator + RESTORE_DIR)).isDirectory()) {
                localRestoreFile = new File(restoreDirectory, fileName);
                if (localRestoreFile == null) {
                    return this.toolsHelper.customMessageError("error loading restore file", true);
                }
                if (!localRestoreFile.exists()) {
                    return this.toolsHelper.customMessageError("restore file does not exist: " + fileName, true);
                }
                if (!localRestoreFile.isFile()) {
                    return this.toolsHelper.customMessageError("restore file exists but is not a file: " + fileName, true);
                }
            } else {
                return this.toolsHelper.customMessageError("restore directory doesn't exist, you need to create a directory called 'restore' in your Confluence home folder and then copy your restore file there", true);
            }
            ExportDescriptor exportDescriptor = ExportDescriptor.getExportDescriptor((File)localRestoreFile);
            DefaultImportContext context = this.createImportContext(localRestoreFile, exportDescriptor);
            context.setRebuildIndex(reindex);
            LongRunningTask task = this.createImportTask(context);
            if (this.isLongRunningTaskSupported() && !synchronous) {
                LongRunningTaskId taskId = this.longRunningTaskManager.startLongRunningTask(null, task);
                this.extenderConfiguration.setPluginDataValue(IMPORT_TASK, taskId.toString());
                if (log.isDebugEnabled()) {
                    log.debug("Started log-running task " + taskId + " import file " + fileName);
                }
                response.put("status", "in progress");
                response.put("message", "importing file");
                response.put("taskId", taskId + "");
            } else {
                task.run();
                response.put("status", "done");
            }
        }
        catch (ImportExportException iee) {
            if (log.isDebugEnabled()) {
                log.debug(iee.getMessage(), (Throwable)iee);
            }
            return this.toolsHelper.customMessageError("import export exception: " + fileName, true);
        }
        catch (UnexpectedImportZipFileContents unexpectedImportZipFileContents) {
            if (log.isDebugEnabled()) {
                log.debug(unexpectedImportZipFileContents.getMessage(), (Throwable)unexpectedImportZipFileContents);
            }
            return this.toolsHelper.customMessageError("unexpected import zip file contents: " + fileName, true);
        }
        return Response.ok(response).build();
    }

    private DefaultImportContext createImportContext(File restoreFile, ExportDescriptor exportDescriptor) {
        DefaultImportContext defaultImportContext = new DefaultImportContext(restoreFile.getAbsolutePath(), exportDescriptor, this.toolsHelper.getAuthenticatedConfluenceUser());
        defaultImportContext.setDeleteWorkingFile(false);
        defaultImportContext.setDefaultUsersGroup(exportDescriptor.getDefaultUserGroup());
        defaultImportContext.setSpaceKeyOfSpaceImport(exportDescriptor.getSpaceKey());
        return defaultImportContext;
    }

    private LongRunningTask createImportTask(DefaultImportContext context) {
        return new ImportLongRunningTask(this.eventPublisher, this.indexManager, this.importExportManager, (ImportContext)context);
    }

    private boolean isLongRunningTaskSupported() {
        if (this.servletContextFactory == null || this.servletContextFactory.getServletContext() == null) {
            return true;
        }
        String runningServer = this.servletContextFactory.getServletContext().getServerInfo().toLowerCase();
        String unsupportedContainers = this.servletContextFactory.getServletContext().getInitParameter("unsupportedContainersForExportLongRunningTask");
        if (StringUtils.isNotBlank((CharSequence)unsupportedContainers)) {
            String[] containers = unsupportedContainers.split(",");
            for (int i = 0; i < containers.length; ++i) {
                String container = StringUtils.trim((String)containers[i]);
                if (!runningServer.contains(container)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean longRunningTaskExist(LongRunningTask longRunningTask) {
        return longRunningTask != null && longRunningTask.getName() != null;
    }
}

