/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender.attachment.cleanup;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.user.User;
import com.itlab.confluence.plugins.restextender.helper.ToolsHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/attachmentCleanup")
public class AttachmentCleanup {
    private static final Logger log = LoggerFactory.getLogger(AttachmentCleanup.class);
    private final ToolsHelper toolsHelper;
    private final AttachmentManager attachmentManager;
    private final ContentPermissionManager contentPermissionManager;

    @Inject
    public AttachmentCleanup(@ConfluenceImport AttachmentManager attachmentManager, @ConfluenceImport ContentPermissionManager contentPermissionManager, ToolsHelper toolsHelper) {
        this.toolsHelper = toolsHelper;
        this.contentPermissionManager = contentPermissionManager;
        this.attachmentManager = attachmentManager;
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="/content/{contentId}")
    public Response getSimpleReport(@PathParam(value="contentId") long contentId, @QueryParam(value="showDetails") boolean showDetails, @QueryParam(value="status") boolean status) {
        Page page = null;
        BlogPost blogPost = null;
        if (this.toolsHelper.getPageFormPageDao(contentId) != null) {
            page = this.toolsHelper.getPageFormPageDao(contentId);
        } else if (this.toolsHelper.getBlogPostFormPageDao(contentId) != null) {
            blogPost = this.toolsHelper.getBlogPostFormPageDao(contentId);
        } else {
            return this.toolsHelper.contentIdNotExist(contentId);
        }
        boolean granted = false;
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (this.toolsHelper.currentUserIsInConfluenceAdministratorGroup() || this.contentPermissionManager.hasContentLevelPermission(this.toolsHelper.getCurrentUser(), "Edit", (ContentEntityObject)(page != null ? page : blogPost)) && this.toolsHelper.getSpacePermissionManager().hasPermission("REMOVEATTACHMENT", (page != null ? page : blogPost).getSpace(), (User)user)) {
            granted = true;
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            granted = false;
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> unusedAttachments = new ArrayList<Map<String, Object>>();
        response.put("status", granted);
        response.put("contentType", page != null ? "page" : "blogPost");
        if (status) {
            return Response.ok(response).build();
        }
        if (granted && !status) {
            String contentStorageFormatNoMarkup;
            String contentStorageFormat;
            String string = contentStorageFormat = page != null ? page.getBodyAsString() : blogPost.getBodyAsString();
            if (contentStorageFormat == null) {
                contentStorageFormat = "";
            }
            String string2 = contentStorageFormatNoMarkup = page != null ? page.getBodyAsStringWithoutMarkup() : blogPost.getBodyAsStringWithoutMarkup();
            if (contentStorageFormatNoMarkup == null) {
                contentStorageFormatNoMarkup = "";
            }
            contentStorageFormatNoMarkup = StringEscapeUtils.unescapeHtml4((String)contentStorageFormat);
            ArrayList<String> temporaryFileNames = new ArrayList<String>();
            ArrayList<Attachment> skipAttachmentsFileNames = new ArrayList<Attachment>();
            List contentAttachments = this.attachmentManager.getLatestVersionsOfAttachments((ContentEntityObject)(page != null ? page : blogPost));
            for (Attachment attachment : contentAttachments) {
                if (attachment.getFileName().toLowerCase().startsWith("~") && attachment.getFileName().toLowerCase().endsWith(".tmp")) {
                    skipAttachmentsFileNames.add(attachment);
                    continue;
                }
                this.checkAttachment(showDetails, attachment, contentStorageFormat, temporaryFileNames, contentStorageFormatNoMarkup, page, blogPost, unusedAttachments);
            }
            for (Attachment attachment : skipAttachmentsFileNames) {
                this.checkAttachment(showDetails, attachment, contentStorageFormat, temporaryFileNames, contentStorageFormatNoMarkup, page, blogPost, unusedAttachments);
            }
            response.put("totalAttachments", contentAttachments.size());
            response.put("totalUnusedAttachments", unusedAttachments.size());
        }
        response.put("unusedAttachments", unusedAttachments);
        return Response.ok(response).build();
    }

    private void checkAttachment(boolean showDetails, Attachment attachment, String contentStorageFormat, List<String> temporaryFileNames, String contentStorageFormatNoMarkup, Page page, BlogPost blogPost, List<Map<String, Object>> unusedAttachments) {
        String renderedVersionComment;
        String fileName = attachment.getFileName();
        long fileId = attachment.getId();
        fileName = fileName.replaceAll("&", "&amp;");
        fileName = fileName.replaceAll(">", "&gt;");
        fileName = fileName.replaceAll("<", "&lt;");
        boolean isDiagramFile = false;
        if (attachment.getRenderedVersionComment() != null && ((renderedVersionComment = attachment.getRenderedVersionComment().toLowerCase()).contains("gliffy") || renderedVersionComment.contains("draw.io"))) {
            isDiagramFile = true;
        }
        boolean usedDiagramFile = false;
        boolean usedId = contentStorageFormat.contains(fileId + "");
        if (isDiagramFile) {
            String fileNameWoExtension = attachment.getFileName().replace(".png", "");
            if (log.isDebugEnabled()) {
                log.debug("isDiagramFile=" + isDiagramFile + " -- fileNameWoExtension=" + fileNameWoExtension);
                log.debug("isDiagramFile=" + isDiagramFile + " -- contentStorageFormat=" + contentStorageFormat);
            }
            if (contentStorageFormat.contains(fileNameWoExtension)) {
                usedDiagramFile = true;
                temporaryFileNames.add("~" + fileNameWoExtension + ".tmp");
            }
        }
        if (!(contentStorageFormat.contains("\"" + fileName + "\"") || contentStorageFormatNoMarkup.contains(attachment.getFileName()) || this.checkPageVersions((ContentEntityObject)(page != null ? page : blogPost), fileName) || usedDiagramFile || usedId || temporaryFileNames.contains(fileName))) {
            HashMap<String, Object> unusedAttachment = new HashMap<String, Object>();
            unusedAttachment.put("name", fileName);
            unusedAttachment.put("id", fileId);
            unusedAttachment.put("fileSize", attachment.getFileSize());
            unusedAttachment.put("niceFileSize", attachment.getNiceFileSize());
            unusedAttachments.add(unusedAttachment);
            long attachmentSize = 0L;
            if (showDetails) {
                List attachmentVersions = this.attachmentManager.getAllVersions(attachment);
                for (Attachment attachmentVersion : attachmentVersions) {
                    if (log.isDebugEnabled()) {
                        log.debug(attachmentVersion.getFileName() + " - " + attachmentVersion.getFileSize() + " - " + attachmentVersion.getFileSize() + " - " + attachmentVersion.getNiceFileSize() + " - " + attachmentVersion.getVersion());
                    }
                    attachmentSize += attachmentVersion.getFileSize();
                }
                unusedAttachment.put("fileSizeAllVersions", attachmentSize);
            }
        }
    }

    public boolean checkPageVersions(ContentEntityObject contentEntityObject, String fileName) {
        boolean attachIsUsed = false;
        int prevVersionContentCount = 0;
        String fileNameWoExtension = fileName.replace(".png", "");
        long contentId = contentEntityObject.getId();
        Page page = null;
        BlogPost blogPost = null;
        if (this.toolsHelper.getPageFormPageDao(contentId) != null) {
            page = this.toolsHelper.getPageFormPageDao(contentId);
        } else if (this.toolsHelper.getBlogPostFormPageDao(contentId) != null) {
            blogPost = this.toolsHelper.getBlogPostFormPageDao(contentId);
        }
        int version = (page != null ? page : blogPost).getPreviousVersion();
        while (version > 0 && !attachIsUsed && prevVersionContentCount <= 10) {
            String body = (page != null ? page : blogPost).getBodyAsString();
            if (body.contains("\"" + fileName + "\"") || body.contains(">" + fileNameWoExtension + "<")) {
                attachIsUsed = true;
            }
            version = (page != null ? page : blogPost).getPreviousVersion();
            ++prevVersionContentCount;
        }
        return attachIsUsed;
    }
}

