/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender.helper;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExportAsService(value={ExtenderConfiguration.class})
@Named(value="extenderConfiguration")
public class ExtenderConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ExtenderConfiguration.class);
    private static final int LENGTH_LIMIT = 98500;
    private static final String DEFAULT_EMPTY_VALUE = "";
    private final PluginSettings pluginSettings;

    @Inject
    public ExtenderConfiguration(@ConfluenceImport PluginSettingsFactory settingsFactory) {
        this.pluginSettings = settingsFactory.createGlobalSettings();
    }

    public Object getPluginDataValue(String dataKey) {
        return this.getString(dataKey, DEFAULT_EMPTY_VALUE);
    }

    public void setPluginDataValue(String dataKey, String value) {
        this.setString(dataKey, value);
    }

    public String getString(String key, String defaultValue) {
        Object objectPart;
        Object value = this.pluginSettings.get(key);
        if (value == null) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)(value + DEFAULT_EMPTY_VALUE))) {
            return defaultValue;
        }
        String stringValue = value.toString();
        if (log.isDebugEnabled()) {
            log.debug("0 - GET INIT - Length: " + stringValue.length());
            log.debug("0 - GET key  - " + key);
            log.debug("0 - GET part - " + stringValue);
        }
        for (int index = 1; index < 500 && (objectPart = this.pluginSettings.get(key + "." + index)) != null; ++index) {
            String part = objectPart.toString();
            if (log.isDebugEnabled()) {
                log.debug(index + " - GET INIT - Length: " + part.length());
                log.debug(index + " - GET key  - " + key + "." + index);
                log.debug(index + " - GET part - " + part);
            }
            stringValue = stringValue + part;
        }
        return stringValue;
    }

    public void setString(String key, String value) {
        if (value != null) {
            int index = 0;
            List<String> parts = ExtenderConfiguration.getParts(value, 98500);
            if (parts.isEmpty()) {
                this.pluginSettings.put(key, (Object)value);
            } else {
                for (String part : parts) {
                    if (log.isDebugEnabled()) {
                        log.debug(index + " - SET INIT - Length: " + part.length());
                        log.debug(index + " - SET key  - " + (index > 0 ? key + "." + index : key));
                        log.debug(index + " - SET part - " + part);
                    }
                    this.pluginSettings.put(index > 0 ? key + "." + index : key, (Object)part);
                    ++index;
                }
            }
            for (int i = index; i < 500; ++i) {
                Object objectPart;
                if (log.isDebugEnabled()) {
                    log.debug(index + " - CLEAR key - " + (i > 0 ? key + "." + i : key));
                }
                if ((objectPart = this.pluginSettings.get(key + "." + i)) != null) {
                    this.pluginSettings.remove(key + "." + i);
                    continue;
                }
                break;
            }
        } else {
            this.pluginSettings.put(key, (Object)value);
        }
    }

    private static List<String> getParts(String string, int partitionSize) {
        ArrayList<String> parts = new ArrayList<String>();
        int len = string.length();
        for (int i = 0; i < len; i += partitionSize) {
            parts.add(string.substring(i, Math.min(len, i + partitionSize)));
        }
        return parts;
    }
}

