/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender.favoriteMacros;

import com.itlab.confluence.plugins.restextender.helper.ToolsHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/favoriteMacros")
public class FavoriteMacrosApi {
    private static final Logger log = LoggerFactory.getLogger(FavoriteMacrosApi.class);
    private final ToolsHelper toolsHelper;

    @Inject
    public FavoriteMacrosApi(ToolsHelper toolsHelper) {
        this.toolsHelper = toolsHelper;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/get")
    public Response getFavoriteMacro() {
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        HashMap response = new HashMap();
        String userFavoriteMacro = this.toolsHelper.getFavoriteMacroForCurrentUser();
        ArrayList macroList = new ArrayList();
        if (userFavoriteMacro == null || userFavoriteMacro.isEmpty()) {
            response.put("macros", macroList);
        } else {
            if (log.isDebugEnabled()) {
                log.debug("getFavoriteMacro userFavoriteMacro=" + userFavoriteMacro);
            }
            JSONObject jsonObject = new JSONObject(userFavoriteMacro);
            if (log.isDebugEnabled()) {
                log.debug("getFavoriteMacro jsonObject=" + jsonObject);
            }
            if (jsonObject.has("macros")) {
                JSONArray macros = jsonObject.getJSONArray("macros");
                for (int i = 0; i < macros.length(); ++i) {
                    HashMap<String, String> macroMap = new HashMap<String, String>();
                    JSONObject macrosJSONObject = macros.getJSONObject(i);
                    macroMap.put("macroName", macrosJSONObject.getString("macroName"));
                    macroList.add(macroMap);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("getFavoriteMacro jsonObject=" + macroList);
            }
            response.put("macros", macroList);
        }
        return Response.ok(response).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/reset")
    public Response resetFavoriteMacro(String requestJson, @Context HttpServletRequest request) {
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        this.toolsHelper.setFavoriteMacroForCurrentUser(null);
        return Response.ok().build();
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/remove")
    public Response removeFavoriteMacro(String stringRequestJson, @Context HttpServletRequest request) {
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        JSONObject requestFavoriteMacroJson = new JSONObject(stringRequestJson);
        JSONObject actualUserFavoriteMacroJson = new JSONObject();
        JSONArray requestFavoriteMacro = new JSONArray();
        JSONArray actualUserFavoriteMacro = new JSONArray();
        ArrayList newUserFavoriteMacro = new ArrayList();
        String userFavoriteMacro = this.toolsHelper.getFavoriteMacroForCurrentUser();
        if (userFavoriteMacro != null && !userFavoriteMacro.isEmpty()) {
            actualUserFavoriteMacroJson = new JSONObject(userFavoriteMacro);
        }
        if (actualUserFavoriteMacroJson.has("macros") && !actualUserFavoriteMacroJson.isNull("macros")) {
            actualUserFavoriteMacro = actualUserFavoriteMacroJson.getJSONArray("macros");
        }
        HashSet<String> macroNamesToDelete = new HashSet<String>();
        if (requestFavoriteMacroJson.has("macros") && !requestFavoriteMacroJson.isNull("macros")) {
            requestFavoriteMacro = requestFavoriteMacroJson.getJSONArray("macros");
        }
        for (int i = 0; i < requestFavoriteMacro.length(); ++i) {
            macroNamesToDelete.add(requestFavoriteMacro.getJSONObject(i).getString("macroName"));
        }
        for (int j = 0; j < actualUserFavoriteMacro.length(); ++j) {
            String macroName = actualUserFavoriteMacro.getJSONObject(j).getString("macroName");
            HashMap<String, String> macroDefinition = new HashMap<String, String>();
            if (macroNamesToDelete.contains(macroName)) continue;
            macroDefinition.put("macroName", macroName);
            newUserFavoriteMacro.add(macroDefinition);
        }
        JSONObject userFavoriteMacroObjectToSave = new JSONObject();
        JSONArray userFavoriteMacroArrayToSave = new JSONArray();
        for (Map map : newUserFavoriteMacro) {
            JSONObject userFavoriteMacroJson = new JSONObject(map);
            userFavoriteMacroArrayToSave.put((Object)userFavoriteMacroJson);
        }
        userFavoriteMacroObjectToSave.put("macros", (Object)userFavoriteMacroArrayToSave);
        this.toolsHelper.setFavoriteMacroForCurrentUser(userFavoriteMacroObjectToSave.toString());
        return Response.ok().build();
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/add")
    public Response addFavoriteMacro(String stringRequestJson, @Context HttpServletRequest request) {
        HashMap<String, String> macroDefinition;
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        JSONObject requestFavoriteMacroJson = new JSONObject(stringRequestJson);
        JSONObject actualUserFavoriteMacroJson = new JSONObject();
        JSONArray requestFavoriteMacro = new JSONArray();
        JSONArray actualUserFavoriteMacro = new JSONArray();
        ArrayList newUserFavoriteMacro = new ArrayList();
        String userFavoriteMacro = this.toolsHelper.getFavoriteMacroForCurrentUser();
        if (userFavoriteMacro != null && !userFavoriteMacro.isEmpty()) {
            actualUserFavoriteMacroJson = new JSONObject(userFavoriteMacro);
        }
        if (actualUserFavoriteMacroJson.has("macros") && !actualUserFavoriteMacroJson.isNull("macros")) {
            actualUserFavoriteMacro = actualUserFavoriteMacroJson.getJSONArray("macros");
        }
        if (requestFavoriteMacroJson.has("macros") && !requestFavoriteMacroJson.isNull("macros")) {
            requestFavoriteMacro = requestFavoriteMacroJson.getJSONArray("macros");
        }
        if (requestFavoriteMacro.length() == 1) {
            for (int j = 0; j < actualUserFavoriteMacro.length(); ++j) {
                macroDefinition = new HashMap<String, String>();
                macroDefinition.put("macroName", actualUserFavoriteMacro.getJSONObject(j).getString("macroName"));
                newUserFavoriteMacro.add(macroDefinition);
            }
        }
        for (int i = 0; i < requestFavoriteMacro.length(); ++i) {
            macroDefinition = new HashMap();
            macroDefinition.put("macroName", requestFavoriteMacro.getJSONObject(i).getString("macroName"));
            if (newUserFavoriteMacro.contains(macroDefinition)) continue;
            newUserFavoriteMacro.add(macroDefinition);
        }
        JSONObject userFavoriteMacroObjectToSave = new JSONObject();
        JSONArray userFavoriteMacroArrayToSave = new JSONArray();
        for (Map map : newUserFavoriteMacro) {
            JSONObject userFavoriteMacroJson = new JSONObject(map);
            userFavoriteMacroArrayToSave.put((Object)userFavoriteMacroJson);
        }
        userFavoriteMacroObjectToSave.put("macros", (Object)userFavoriteMacroArrayToSave);
        this.toolsHelper.setFavoriteMacroForCurrentUser(userFavoriteMacroObjectToSave.toString());
        return Response.ok().build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/getGroups")
    public Response getGroups() {
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        HashMap response = new HashMap();
        ArrayList<String> groupsArray = new ArrayList<String>();
        Object groups = this.toolsHelper.getBandanaObjectByType(this.toolsHelper.getFavoriteMacrosGroups());
        if (groups != null) {
            if (groups.toString().contains("@@@")) {
                String[] groupsTable = groups.toString().split("@@@");
                groupsArray.addAll(Arrays.asList(groupsTable));
            } else if (!groups.toString().isEmpty()) {
                groupsArray.add(groups.toString());
            }
        }
        response.put("groups", groupsArray);
        return Response.ok(response).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/allowAll")
    public Response allowAll() {
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        this.toolsHelper.setBandanaObjectByType(this.toolsHelper.getFavoriteMacrosAllowAll(), "allowAll");
        return Response.ok().build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/disallowAll")
    public Response disallowAll() {
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        this.toolsHelper.setBandanaObjectByType(this.toolsHelper.getFavoriteMacrosAllowAll(), "disallowAll");
        return Response.ok().build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/removeGroup/{groupName}")
    public Response removeGroup(@PathParam(value="groupName") String groupName) {
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        StringBuilder newGroups = new StringBuilder();
        Object groups = this.toolsHelper.getBandanaObjectByType(this.toolsHelper.getFavoriteMacrosGroups());
        if (groups != null) {
            if (groups.toString().contains("@@@")) {
                String[] groupsTable;
                for (String groupTableName : groupsTable = groups.toString().split("@@@")) {
                    if (groupTableName.equalsIgnoreCase(groupName)) continue;
                    if (newGroups.length() > 0) {
                        newGroups.append("@@@");
                    }
                    newGroups.append(groupTableName);
                }
            } else if (!groups.toString().isEmpty()) {
                newGroups = new StringBuilder(groups.toString().replace(groupName, ""));
            }
            this.toolsHelper.setBandanaObjectByType(this.toolsHelper.getFavoriteMacrosGroups(), newGroups.toString());
        }
        return Response.ok().build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/configuration")
    public Response getConfig() {
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("limitFavoriteMacros", "allowAll");
        Object allowAll = this.toolsHelper.getBandanaObjectByType(this.toolsHelper.getFavoriteMacrosAllowAll());
        if (allowAll != null && allowAll.toString() != null && allowAll.toString().equalsIgnoreCase("disallowAll")) {
            response.put("limitFavoriteMacros", "disallowAll");
        }
        return Response.ok(response).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/addGroup/{groupName}")
    public Response setGroups(@PathParam(value="groupName") String groupName) {
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        Object groups = this.toolsHelper.getBandanaObjectByType(this.toolsHelper.getFavoriteMacrosGroups());
        if (groups != null && !groups.toString().isEmpty()) {
            this.toolsHelper.setBandanaObjectByType(this.toolsHelper.getFavoriteMacrosGroups(), groups.toString() + "@@@" + groupName);
        } else {
            this.toolsHelper.setBandanaObjectByType(this.toolsHelper.getFavoriteMacrosGroups(), groupName);
        }
        return Response.ok().build();
    }
}

