/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender.changeContext;

import com.atlassian.confluence.api.model.audit.AffectedObject;
import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.seraph.auth.DefaultAuthenticator;
import com.atlassian.user.User;
import com.itlab.confluence.plugins.restextender.helper.ToolsHelper;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/session")
public class SwitchContextApi {
    private static final Logger log = LoggerFactory.getLogger(SwitchContextApi.class);
    private final ToolsHelper toolsHelper;
    private final UserManager userManager;

    @Inject
    public SwitchContextApi(@ConfluenceImport UserManager userManager, ToolsHelper toolsHelper) {
        this.toolsHelper = toolsHelper;
        this.userManager = userManager;
    }

    @ReadOnlyAccessAllowed
    @POST
    @Produces(value={"application/json"})
    @Path(value="/validate")
    public Response switchToAnotherUser(@Context HttpServletRequest request, String jsonString) {
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        JSONObject jsonObject = new JSONObject(jsonString);
        ConfluenceUser targetUser = null;
        String targetUserKey = "";
        UserProfile targetUserProfile = null;
        UserProfile currentUserProfile = this.toolsHelper.getCurrentUserProfile();
        if (!jsonObject.has("toUser")) {
            return this.toolsHelper.fieldRequired("toUser");
        }
        targetUserKey = jsonObject.getString("toUser");
        targetUser = this.toolsHelper.getConfluenceUserByKey(targetUserKey);
        targetUserProfile = this.toolsHelper.getUserProfile(this.toolsHelper.getConfluenceUserByKey(targetUserKey).getKey().getStringValue());
        if (targetUser == null) {
            response.put("message", "User '" + targetUserKey + "' not exist.");
            return Response.serverError().entity(response).build();
        }
        if (targetUserKey.equals(currentUserProfile.getUserKey().getStringValue())) {
            response.put("message", "It's You ... please choose another Confluence user.");
            return Response.serverError().entity(response).build();
        }
        if (this.toolsHelper.isConfluenceAdministrator() && !this.toolsHelper.isSystemAdministrator() && this.toolsHelper.isSystemAdministrator(targetUser.getName())) {
            response.put("message", "You cannot switch to a user with a higher permission level than your own.");
            return Response.serverError().entity(response).build();
        }
        boolean isSystemAdministrator = this.toolsHelper.isSystemAdministrator(targetUserProfile.getUsername());
        boolean isAdministrator = this.toolsHelper.isConfluenceAdministrator(targetUserProfile);
        response.put("isAdministrator", isAdministrator);
        response.put("isSystemAdministrator", isSystemAdministrator);
        if (log.isDebugEnabled()) {
            log.debug("[E4J] Switch user from: " + currentUserProfile.getFullName() + " [" + currentUserProfile.getUsername() + "] (isAdministrator: " + this.toolsHelper.isSystemAdministrator(currentUserProfile) + ", isSystemAdministrator: " + this.toolsHelper.isConfluenceAdministrator(currentUserProfile) + ") to: " + targetUser.getFullName() + " [" + targetUser.getName() + "] (isAdministrator: " + isAdministrator + ", isSystemAdministrator: " + isSystemAdministrator + ")");
        }
        request.getSession().setAttribute("extender_default_user", (Object)currentUserProfile.getUsername());
        String objectType = this.toolsHelper.getUntransformedRawText("audit.logging.affected.object.user");
        AffectedObject currentAffectedUser = AffectedObject.builder().name(currentUserProfile.getUsername()).objectType(objectType).build();
        AffectedObject targetAffectedUser = AffectedObject.builder().name(targetUser.getName()).objectType(objectType).build();
        HashSet<AffectedObject> associatedObjects = new HashSet<AffectedObject>();
        associatedObjects.add(currentAffectedUser);
        associatedObjects.add(targetAffectedUser);
        ArrayList<Map<String, String>> changedValueList = new ArrayList<Map<String, String>>();
        HashMap<String, String> changedValue = new HashMap<String, String>();
        changedValue.put("name", "Authenticated user");
        changedValue.put("oldValue", currentUserProfile.getUsername());
        changedValue.put("newValue", targetUser.getName());
        changedValueList.add(changedValue);
        String description = String.format("User '%s' switched to user '%s' (via Extender for Confluence -> Switch User)", currentUserProfile.getFullName() + " (" + currentUserProfile.getUsername() + ")", targetUser.getFullName() + " (" + targetUser.getName() + ")");
        this.toolsHelper.addAuditRecord(description, this.toolsHelper.getUntransformedRawText("audit.logging.category.user.management"), targetAffectedUser, changedValueList, null);
        UserInSessionPutter userInSessionPutter = new UserInSessionPutter(this.toolsHelper);
        userInSessionPutter.putUserIntoSession((Principal)targetUser, request);
        return Response.ok(response).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/currentUser")
    public Response getCurrentUserData(@Context HttpServletRequest request, @QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="userName") String userName) {
        HashMap<String, Boolean> response = new HashMap<String, Boolean>();
        if (userName != null && !userName.equalsIgnoreCase("") && this.toolsHelper.isConfluenceAdministrator()) {
            userName = this.toolsHelper.decodeUrlParam(userName);
            response.put("isCurrentUserConfluenceAdministrator", this.toolsHelper.isConfluenceAdministrator());
            response.put("isCurrentUserSystemConfluenceAdministrator", this.toolsHelper.isSystemAdministrator());
        } else {
            userName = this.toolsHelper.getCurrentUserProfile().getUsername();
        }
        response.put("isConfluenceAdministrator", this.toolsHelper.isConfluenceAdministrator(userName));
        response.put("isSystemConfluenceAdministrator", this.toolsHelper.isSystemAdministrator(userName));
        if (spaceKey != null && !spaceKey.equalsIgnoreCase("") && this.toolsHelper.getSpaceFromSpaceDao(spaceKey) != null) {
            response.put("isSpaceAdministrator", this.toolsHelper.istUserIsSpaceAdministrator(this.toolsHelper.getSpaceFromSpaceDao(spaceKey), userName));
        }
        return Response.ok(response).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/get")
    public Response getUser(@Context HttpServletRequest request) {
        HashMap<String, String> response = new HashMap<String, String>();
        Object userName = request.getSession().getAttribute("extender_default_user");
        String userString = "";
        if (userName != null && !userName.equals("") && this.toolsHelper.isUserExistByName(userName.toString())) {
            User user = this.toolsHelper.getUserByName(userName.toString());
            userString = userString + user.getFullName() + " (" + user.getName() + ")";
        }
        ConfluenceUser currentUser = this.toolsHelper.getCurrentUser();
        String currentUserString = "";
        if (currentUser != null) {
            currentUserString = currentUserString + currentUser.getFullName() + " (" + currentUser.getName() + ")";
        }
        response.put("user", userString);
        response.put("currentUser", currentUserString);
        return Response.ok(response).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/back")
    public Response getTokens(@Context HttpServletRequest request) {
        Object userName = request.getSession().getAttribute("extender_default_user");
        if (userName == null || userName.equals("") || !this.toolsHelper.isUserExistByName(userName.toString())) {
            return Response.serverError().build();
        }
        UserProfile targetUser = this.toolsHelper.getUserProfileByName(userName.toString());
        UserProfile logInUser = this.userManager.getRemoteUser();
        if (log.isDebugEnabled()) {
            log.debug("[E4J] Switch user back from: " + logInUser.getFullName() + " [" + logInUser.getUsername() + "] (isAdministrator: " + this.toolsHelper.isConfluenceAdministrator(logInUser) + ", isSystemAdministrator: " + this.toolsHelper.isSystemAdministrator(logInUser) + ") to: " + targetUser.getFullName() + " [" + targetUser.getUsername() + "] (isAdministrator: " + this.toolsHelper.isConfluenceAdministrator(targetUser) + ", isSystemAdministrator: " + this.toolsHelper.isSystemAdministrator(targetUser) + ")");
        }
        User user = this.toolsHelper.getUserByName(userName.toString());
        request.getSession().setAttribute("extender_default_user", (Object)"");
        UserInSessionPutter userInSessionPutter = new UserInSessionPutter(this.toolsHelper);
        userInSessionPutter.putUserIntoSession((Principal)user, request);
        return Response.ok().build();
    }

    private class UserInSessionPutter
    extends DefaultAuthenticator {
        private final ToolsHelper toolsHelper;

        private UserInSessionPutter(ToolsHelper toolsHelper) {
            this.toolsHelper = toolsHelper;
        }

        protected Principal getUser(String username) {
            return this.toolsHelper.getUserByName(username);
        }

        protected boolean authenticate(Principal user, String password) {
            return false;
        }

        public void putUserIntoSession(Principal user, HttpServletRequest httpServletRequest) {
            this.putPrincipalInSessionContext(httpServletRequest, user);
        }
    }
}

