/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender.watchContent;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.user.User;
import com.itlab.confluence.plugins.restextender.helper.ToolsHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/watch")
public class WatchContentApi {
    private static final Logger log = LoggerFactory.getLogger(WatchContentApi.class);
    private final ToolsHelper toolsHelper;
    private final PageManager pageManager;
    private final NotificationManager notificationManager;
    private final PermissionManager permissionManager;

    @Inject
    public WatchContentApi(@ConfluenceImport NotificationManager notificationManager, @ConfluenceImport PageManager pageManager, @ConfluenceImport PermissionManager permissionManager, ToolsHelper toolsHelper) {
        this.toolsHelper = toolsHelper;
        this.notificationManager = notificationManager;
        this.pageManager = pageManager;
        this.permissionManager = permissionManager;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/tree/content/{contentId}/state")
    public Response statusWatchContentTree(@PathParam(value="contentId") long contentId, @QueryParam(value="debug") boolean debug) {
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("user", "anonymous");
        response.put("state", "");
        ConfluenceUser confluenceUser = this.toolsHelper.getAuthenticatedUser();
        if (confluenceUser != null) {
            response.put("user", "authenticatedUser");
        }
        Page page = this.toolsHelper.getPageFormPageDao(contentId);
        if (this.toolsHelper.getAuthenticatedUser() != null && page != null) {
            boolean watchTree = true;
            ArrayList pageTree = new ArrayList();
            pageTree.addAll(this.pageManager.getDescendants(page));
            pageTree.remove(page);
            if (debug) {
                this.addPageToResponse(response, confluenceUser, pageTree, "debugAllPages");
            }
            pageTree = (ArrayList)pageTree.stream().filter(pageToCheck -> this.permissionManager.hasPermission(confluenceUser, Permission.VIEW, pageToCheck)).collect(Collectors.toList());
            if (debug) {
                this.addPageToResponse(response, confluenceUser, pageTree, "debugFilteredPages");
            }
            for (Page pageToCheck2 : pageTree) {
                if (!this.permissionManager.hasPermission(confluenceUser, Permission.VIEW, (Object)pageToCheck2) || this.notificationManager.isWatchingContent((User)confluenceUser, (ContentEntityObject)pageToCheck2)) continue;
                watchTree = false;
                break;
            }
            if (watchTree && !pageTree.isEmpty()) {
                response.put("state", "tree");
            }
        }
        response.put("i18-watching.page", this.toolsHelper.getTranslation("confluence.watch.title.watching.page"));
        response.put("i18-watching.page.description", this.toolsHelper.getTranslation("confluence.watch.title.watching.page.description"));
        return Response.ok(response).build();
    }

    private void addPageToResponse(Map<String, Object> response, ConfluenceUser confluenceUser, ArrayList<Page> pageTree, String debugAllPage) {
        ArrayList debugPageTree = new ArrayList();
        for (Page page : pageTree) {
            HashMap<String, Object> pageMap = new HashMap<String, Object>();
            pageMap.put("pageName", page.getTitle());
            pageMap.put("pageId", page.getId());
            pageMap.put("hasViewPermission", this.permissionManager.hasPermission(confluenceUser, Permission.VIEW, (Object)page));
            pageMap.put("isWatchingContent", this.notificationManager.isWatchingContent((User)confluenceUser, (ContentEntityObject)page));
            debugPageTree.add(pageMap);
        }
        response.put(debugAllPage, debugPageTree);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/tree/content/{contentId}/{addWatcher}")
    public Response addWatchContentTree(@PathParam(value="contentId") long contentId, @PathParam(value="addWatcher") boolean addWatcher, @QueryParam(value="debug") boolean debug) {
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("user", "anonymous");
        response.put("state", "");
        ConfluenceUser confluenceUser = this.toolsHelper.getAuthenticatedUser();
        if (confluenceUser != null) {
            response.put("user", "authenticatedUser");
        }
        Page page = this.toolsHelper.getPageFormPageDao(contentId);
        if (this.toolsHelper.getAuthenticatedUser() != null && page != null) {
            if (this.permissionManager.hasPermission(confluenceUser, Permission.VIEW, (Object)page)) {
                this.watchContentId(addWatcher, (User)confluenceUser, (ContentEntityObject)page);
            }
            ArrayList pageTree = new ArrayList();
            pageTree.addAll(this.pageManager.getDescendants(page));
            pageTree.remove(page);
            pageTree = (ArrayList)pageTree.stream().filter(pageToCheck -> this.permissionManager.hasPermission(confluenceUser, Permission.VIEW, pageToCheck)).collect(Collectors.toList());
            TransactionTemplate transactionTemplate = (TransactionTemplate)ComponentLocator.getComponent(TransactionTemplate.class);
            ArrayList finalPageTree = pageTree;
            transactionTemplate.execute(() -> {
                for (Page pageInTransaction : finalPageTree) {
                    if (!this.permissionManager.hasPermission(confluenceUser, Permission.VIEW, (Object)pageInTransaction)) continue;
                    this.watchContentId(addWatcher, (User)confluenceUser, (ContentEntityObject)pageInTransaction);
                }
                return null;
            });
        }
        response.put("i18-watching.page", this.toolsHelper.getTranslation("confluence.watch.title.watching.page"));
        response.put("i18-watching.page.description", this.toolsHelper.getTranslation("confluence.watch.title.watching.page.description"));
        response.put("state", "done");
        return Response.ok(response).build();
    }

    private void watchContentId(boolean addWatcher, User user, ContentEntityObject contentEntityObject) {
        if (addWatcher) {
            this.notificationManager.addContentNotification(user, contentEntityObject);
        } else {
            this.notificationManager.removeContentNotification(user, contentEntityObject);
        }
    }
}

