/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender.resources;

import com.atlassian.core.filters.ServletContextThreadLocal;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.webresource.api.data.WebResourceDataProvider;
import com.itlab.confluence.plugins.restextender.helper.ToolsHelper;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataProvider
implements WebResourceDataProvider {
    private static final Logger log = LoggerFactory.getLogger(DataProvider.class);
    private final ToolsHelper toolsHelper;

    @Inject
    public DataProvider(ToolsHelper toolsHelper) {
        this.toolsHelper = toolsHelper;
    }

    public Jsonable get() {
        return writer -> {
            block2: {
                try {
                    this.getBodyContentJsonObject().write(writer);
                }
                catch (Exception ex) {
                    if (!log.isDebugEnabled()) break block2;
                    log.debug("Exception: " + ExceptionUtils.getStackTrace((Throwable)ex));
                }
            }
        };
    }

    private JSONObject getBodyContentJsonObject() throws JSONException {
        JSONObject pluginData = new JSONObject();
        pluginData.put("baseUrl", (Object)this.toolsHelper.getBaseUrl());
        pluginData.put("isConfluenceAdministrator", this.toolsHelper.isConfluenceAdministrator());
        pluginData.put("isLicenseIsValid", this.toolsHelper.isLicenseIsValid());
        pluginData.put("isPluginRemoved", this.toolsHelper.isSensitiveCustomer());
        pluginData.put("isSourceEditorVisible", this.toolsHelper.isSourceEditorVisibleForUser());
        pluginData.put("isComplexityAnalysisVisibleForUser", this.toolsHelper.isComplexityAnalysisVisibleForUser());
        pluginData.put("isNotifyWatchersVisibleForUser", this.toolsHelper.isNotifyWatchersVisibleForUser());
        pluginData.put("isFavoriteMacrosVisibleForUser", this.toolsHelper.isFavoriteMacrosVisibleForUser());
        pluginData.put("changeContextBack", this.changeContextBack());
        this.addBreadcrumbsData(pluginData);
        this.addContentViewData(pluginData);
        return pluginData;
    }

    private boolean changeContextBack() {
        HttpServletRequest req = ServletContextThreadLocal.getRequest();
        if (req == null || req.getSession() == null) {
            return false;
        }
        Object param = req.getSession().getAttribute("extender_default_user");
        return this.toolsHelper.isLicenseIsValid() && param != null && !param.equals("") && this.toolsHelper.isUserExistByName(param.toString());
    }

    private void addBreadcrumbsData(JSONObject pluginData) {
        pluginData.put("breadcrumbs-user", (Object)"anonymous");
        pluginData.put("breadcrumbs-state", (Object)"");
        if (this.toolsHelper.isLicenseIsValid()) {
            Object userBreadcrumbsKey;
            if (this.toolsHelper.getAuthenticatedUser() != null) {
                pluginData.put("breadcrumbs-user", (Object)"authenticatedUser");
            }
            if ((userBreadcrumbsKey = this.toolsHelper.getBandanaObjectByType(this.toolsHelper.getBreadcrumbsKey())) != null && !userBreadcrumbsKey.toString().isEmpty()) {
                pluginData.put("breadcrumbs-state", (Object)userBreadcrumbsKey.toString());
            }
        }
    }

    private void addContentViewData(JSONObject pluginData) {
        pluginData.put("contentCompactView-user", (Object)"anonymous");
        pluginData.put("contentCompactView-state", (Object)"");
        pluginData.put("contentFullScreenView-user", (Object)"anonymous");
        pluginData.put("contentFullScreenView-state", (Object)"");
        if (this.toolsHelper.isLicenseIsValid()) {
            Object viewKey;
            if (this.toolsHelper.getAuthenticatedUser() != null) {
                pluginData.put("contentCompactView-user", (Object)"authenticatedUser");
                pluginData.put("contentFullScreenView-user", (Object)"authenticatedUser");
            }
            if ((viewKey = this.toolsHelper.getBandanaObjectByType(this.toolsHelper.getContentCompactViewKey())) != null && !viewKey.toString().isEmpty()) {
                pluginData.put("contentCompactView-state", (Object)viewKey.toString());
            }
            if ((viewKey = this.toolsHelper.getBandanaObjectByType(this.toolsHelper.getContentFullScreenViewKey())) != null && !viewKey.toString().isEmpty()) {
                pluginData.put("contentFullScreenView-state", (Object)viewKey.toString());
            }
        }
    }
}

