/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender.helper;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExportAsService(value={ExtenderConfiguration.class})
@Named(value="extenderConfiguration")
public class ExtenderConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ExtenderConfiguration.class);
    private static final String DEFAULT_EMPTY_VALUE = "";
    private final PluginSettings pluginSettings;

    @Inject
    public ExtenderConfiguration(@ConfluenceImport PluginSettingsFactory settingsFactory) {
        this.pluginSettings = settingsFactory.createGlobalSettings();
    }

    public Object getPluginDataValue(String dataKey) {
        return this.getString(dataKey, DEFAULT_EMPTY_VALUE);
    }

    public void setPluginDataValue(String dataKey, String value) {
        this.setString(dataKey, value);
    }

    public String getString(String key, String defaultValue) {
        Object value = this.pluginSettings.get(key);
        if (value == null) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)(value + DEFAULT_EMPTY_VALUE))) {
            return defaultValue;
        }
        return value + DEFAULT_EMPTY_VALUE;
    }

    public void setString(String key, String value) {
        this.pluginSettings.put(key, (Object)value);
    }
}

