/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender.group;

import com.atlassian.confluence.core.DateFormatter;
import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.security.login.LoginInfo;
import com.atlassian.confluence.security.login.LoginManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.UserQuery;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestriction;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestrictionImpl;
import com.atlassian.crowd.search.query.entity.restriction.MatchMode;
import com.atlassian.crowd.search.query.entity.restriction.TermRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.atlassian.user.search.page.Pager;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.itlab.confluence.plugins.restextender.group.ResponseGroup;
import com.itlab.confluence.plugins.restextender.helper.ToolsHelper;
import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/group")
public class GroupRestApi {
    private static final Logger log = LoggerFactory.getLogger(GroupRestApi.class);
    private final UserAccessor userAccessor;
    private final ToolsHelper toolsHelper;
    private final CrowdService crowdService;
    private final LocaleManager localeManager;
    private final LoginManager loginManager;
    private final FormatSettingsManager formatSettingsManager;
    private final GroupManager groupManager;

    @Inject
    public GroupRestApi(ToolsHelper toolsHelper, @ConfluenceImport UserAccessor userAccessor, @ConfluenceImport GroupManager groupManager) {
        this.userAccessor = userAccessor;
        this.toolsHelper = toolsHelper;
        this.groupManager = groupManager;
        this.crowdService = (CrowdService)ComponentLocator.getComponent(CrowdService.class);
        this.loginManager = (LoginManager)ComponentLocator.getComponent(LoginManager.class);
        this.localeManager = (LocaleManager)ComponentLocator.getComponent(LocaleManager.class);
        this.formatSettingsManager = (FormatSettingsManager)ComponentLocator.getComponent(FormatSettingsManager.class);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/preview")
    public Response getGroupPreview(@QueryParam(value="groupName") String groupName, @QueryParam(value="userSearchFilter") String userSearchFilter, @QueryParam(value="activeFilter") String activeFilter, @QueryParam(value="startAt") int startAt) {
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        int maxResults = 50;
        int iterator = 0;
        if (log.isDebugEnabled()) {
            log.debug("groupName " + groupName);
        }
        HashMap<String, Serializable> response = new HashMap<String, Serializable>();
        ArrayList users = new ArrayList();
        Iterable<ConfluenceUser> applicationUsers = this.getUsersFilteredByGroupAndCriteria(groupName, userSearchFilter, activeFilter);
        for (ConfluenceUser applicationUser : applicationUsers) {
            if (startAt <= iterator && iterator < startAt + maxResults) {
                HashMap<String, Object> userMap = new HashMap<String, Object>();
                DateFormatter dateFormatter = this.userAccessor.getConfluenceUserPreferences((User)this.toolsHelper.getAuthenticatedUser()).getDateFormatter(this.formatSettingsManager, this.localeManager);
                userMap.put("name", applicationUser.getName());
                userMap.put("key", applicationUser.getKey().getStringValue());
                userMap.put("displayName", applicationUser.getFullName());
                userMap.put("emailAddress", applicationUser.getEmail() != null ? applicationUser.getEmail() : "");
                boolean isActive = !this.userAccessor.isDeactivated((User)applicationUser);
                userMap.put("isActive", isActive);
                userMap.put("lastLogin", isActive);
                LoginInfo loginInfo = this.loginManager.getLoginInfo(applicationUser.getName());
                if (loginInfo.getLastSuccessfulLoginDate() == null) {
                    userMap.put("lastLoginTimeCompleteHtml", "");
                } else {
                    userMap.put("lastLoginTimeCompleteHtml", dateFormatter.formatDateTime(loginInfo.getLastSuccessfulLoginDate()));
                }
                userMap.put("avatarUrl", this.userAccessor.getUserProfilePicture((User)applicationUser).getUriReference());
                users.add(userMap);
            }
            if (++iterator <= startAt + maxResults) continue;
            break;
        }
        int total = GroupRestApi.size(applicationUsers);
        response.put("users", users);
        response.put("total", Integer.valueOf(total));
        response.put("maxResults", Integer.valueOf(maxResults));
        response.put("startAt", Integer.valueOf(startAt));
        response.put("pages", Integer.valueOf(total / maxResults + (total % maxResults > 0 ? 1 : 0)));
        return Response.ok(response).build();
    }

    public static int size(Iterable data) {
        if (data instanceof Collection) {
            return ((Collection)data).size();
        }
        int counter = 0;
        for (Object i : data) {
            ++counter;
        }
        return counter;
    }

    private Iterable<ConfluenceUser> getUsersFilteredByGroupAndCriteria(String groupName, String userSearchFilter, String activeFilter) {
        Iterable<String> userNames = this.getUserNamesFilteredByCriteria(groupName, userSearchFilter, activeFilter);
        if (groupName != null) {
            Set userNamesSet = userNames instanceof Set ? (Set)userNames : ImmutableSet.copyOf(userNames);
            return this.makeLazyApplicationUsersFromNames((Iterable<String>)Sets.intersection((Set)userNamesSet, (Set)ImmutableSet.copyOf(this.getUsersFilteredByGroup(groupName))));
        }
        return this.makeLazyApplicationUsersFromNames(userNames);
    }

    Iterable<String> getUserNamesFilteredByCriteria(String groupName, String userSearchFilter, String activeFilter) {
        List userNamesList;
        ArrayList<String> userNames = new ArrayList();
        if (userSearchFilter.equalsIgnoreCase("")) {
            userNames = this.userAccessor.getMemberNamesAsList(this.userAccessor.getGroup(groupName));
        } else {
            SearchRestriction searchRestriction = this.makeCrowdRestriction(userSearchFilter);
            UserQuery query = new UserQuery(String.class, searchRestriction, 0, -1);
            userNames = this.crowdService.search((Query)query);
        }
        boolean isActiveUser = activeFilter.equalsIgnoreCase("true");
        Predicate<com.atlassian.crowd.embedded.api.User> usersMatchingActivityFilter = user -> user.isActive() == isActiveUser;
        List list = userNamesList = userNames instanceof List ? (List)userNames : ImmutableList.copyOf(userNames);
        if (activeFilter.equalsIgnoreCase("false") || activeFilter.equalsIgnoreCase("true")) {
            return () -> userNamesList.stream().map(arg_0 -> ((CrowdService)this.crowdService).getUser(arg_0)).filter(usersMatchingActivityFilter).map(Principal::getName).iterator();
        }
        return userNames;
    }

    private Iterable<ConfluenceUser> makeLazyApplicationUsersFromNames(Iterable<String> userNames) {
        return Iterables.transform(userNames, userName -> this.userAccessor.getUserByName(userName));
    }

    private Iterable<String> getUsersFilteredByGroup(String groupName) {
        MembershipQuery membershipQuery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(groupName).returningAtMost(-1);
        return this.crowdService.search((Query)membershipQuery);
    }

    private SearchRestriction makeCrowdRestriction(String userSearchFilter) {
        SearchRestriction userSearchRestrictions = this.makeUserSearchRestrictions(userSearchFilter);
        return userSearchRestrictions;
    }

    private SearchRestriction makeUserSearchRestrictions(String searchFilter) {
        return Strings.isNullOrEmpty((String)searchFilter) ? null : new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.OR, (Collection)ImmutableList.of((Object)new TermRestriction(UserTermKeys.USERNAME, MatchMode.CONTAINS, (Object)searchFilter), (Object)new TermRestriction(UserTermKeys.DISPLAY_NAME, MatchMode.CONTAINS, (Object)searchFilter), (Object)new TermRestriction(UserTermKeys.EMAIL, MatchMode.CONTAINS, (Object)searchFilter)));
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/deleteInactiveUsers")
    public Response getGroupPreview(@QueryParam(value="groupName") String groupName) {
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        Iterable<ConfluenceUser> applicationUsers = this.getUsersFilteredByGroupAndCriteria(groupName, "", "false");
        com.atlassian.user.Group group = null;
        try {
            group = this.groupManager.getGroup(groupName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (group != null) {
            for (ConfluenceUser applicationUser : applicationUsers) {
                if (applicationUser == null) continue;
                try {
                    if (!this.groupManager.hasMembership(group, (User)applicationUser)) continue;
                    this.groupManager.removeMembership(group, (User)applicationUser);
                }
                catch (Exception exception) {}
            }
        }
        return Response.ok().build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/getGroups")
    public Response listGroups(@QueryParam(value="startAt") int startAt, @QueryParam(value="maxResults") int maxResults, @Context HttpServletRequest request) throws JSONException {
        log.debug("RESTAPI - getGroups");
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        ArrayList<String> groupsArray = new ArrayList<String>();
        HashMap<String, Object> response = new HashMap<String, Object>();
        int iterator = 0;
        if (maxResults == 0) {
            maxResults = 50;
        }
        Pager groups = this.userAccessor.getGroups();
        int total = 0;
        for (com.atlassian.user.Group group : groups) {
            if (startAt <= iterator && iterator < startAt + maxResults) {
                groupsArray.add(group.getName());
            }
            ++iterator;
            ++total;
        }
        response.put("total", total);
        response.put("startAt", startAt);
        response.put("maxResults", maxResults);
        response.put("groups", groupsArray);
        response.put("status", "success");
        return Response.ok(response).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/addGroups")
    public Response addGroups(String groups, @Context HttpServletRequest request) throws JSONException {
        log.debug("RESTAPI - addGroups");
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        ResponseGroup response = new ResponseGroup();
        JSONObject jsonObject = new JSONObject(groups);
        ArrayList<String> arrayGroupsToAdd = this.toolsHelper.getJSONarray(jsonObject, "groups");
        log.debug("RESTAPI - addGroups '" + arrayGroupsToAdd + "' " + arrayGroupsToAdd.size());
        if (arrayGroupsToAdd.isEmpty()) {
            log.debug("RESTAPI - addGroups '" + arrayGroupsToAdd + "'");
            response.setStatus("error");
            response.setMessage("no groups to add");
            return Response.serverError().entity((Object)this.toJSON(response)).build();
        }
        ArrayList<String> groupsAdded = new ArrayList<String>();
        ArrayList<String> groupsSkipped = new ArrayList<String>();
        log.debug("RESTAPI - addGroups '" + arrayGroupsToAdd + "'");
        for (String strConfluenceGroup : arrayGroupsToAdd) {
            com.atlassian.user.Group confluenceGroup = this.userAccessor.getGroup(strConfluenceGroup);
            if (confluenceGroup == null) {
                this.userAccessor.createGroup(strConfluenceGroup);
                groupsAdded.add(strConfluenceGroup);
                continue;
            }
            groupsSkipped.add(strConfluenceGroup);
        }
        response.setGroupsAdded(groupsAdded);
        response.setGroupsSkipped(groupsSkipped);
        response.setStatus("success");
        if (response.getGroupsSkipped().size() > 0) {
            response.setMessage("groups added, some groups skipped");
        } else {
            response.setMessage("all groups added");
        }
        return Response.ok((Object)this.toJSON(response)).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/removeGroups")
    public Response removeGroups(String groups, @Context HttpServletRequest request) throws JSONException {
        log.debug("RESTAPI - removeGroups");
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        ResponseGroup response = new ResponseGroup();
        JSONObject jsonObject = new JSONObject(groups);
        ArrayList<String> arrayGroupsToRemove = this.toolsHelper.getJSONarray(jsonObject, "groups");
        log.debug("RESTAPI - removeGroups '" + arrayGroupsToRemove + "' " + arrayGroupsToRemove.size());
        if (arrayGroupsToRemove.isEmpty()) {
            log.debug("RESTAPI - removeGroups '" + arrayGroupsToRemove + "'");
            response.setStatus("error");
            response.setMessage("no groups to remove");
            return Response.serverError().entity((Object)this.toJSON(response)).build();
        }
        ArrayList<String> groupsRemoved = new ArrayList<String>();
        ArrayList<String> groupsSkipped = new ArrayList<String>();
        ArrayList<String> actionNotPermitted = new ArrayList<String>();
        log.debug("RESTAPI - removeGroups '" + arrayGroupsToRemove + "'");
        for (String strConfluenceGroup : arrayGroupsToRemove) {
            com.atlassian.user.Group confluenceGroup = this.userAccessor.getGroup(strConfluenceGroup);
            if (confluenceGroup != null) {
                if (strConfluenceGroup.equalsIgnoreCase("confluence-administrators")) {
                    groupsSkipped.add(strConfluenceGroup);
                    continue;
                }
                if (this.toolsHelper.isSystemAdministrator()) {
                    TransactionTemplate transactionTemplate = (TransactionTemplate)ComponentLocator.getComponent(TransactionTemplate.class);
                    transactionTemplate.execute(() -> {
                        try {
                            Group crowdGroup = this.crowdService.getGroup(strConfluenceGroup);
                            this.crowdService.removeGroup(crowdGroup);
                            groupsRemoved.add(strConfluenceGroup);
                        }
                        catch (Exception ex) {
                            actionNotPermitted.add(strConfluenceGroup);
                        }
                        return null;
                    });
                    continue;
                }
                if (this.toolsHelper.objectHasGlobalPermission("group", strConfluenceGroup, "SYSTEMADMINISTRATOR")) {
                    groupsSkipped.add(strConfluenceGroup);
                    continue;
                }
                this.userAccessor.removeGroup(confluenceGroup);
                groupsRemoved.add(strConfluenceGroup);
                continue;
            }
            groupsSkipped.add(strConfluenceGroup);
        }
        response.setGroupsRemoved(groupsRemoved);
        response.setGroupsSkipped(groupsSkipped);
        response.setActionNotPermitted(actionNotPermitted);
        response.setStatus("success");
        if (response.getGroupsSkipped().size() > 0) {
            response.setMessage("groups removed, some groups skipped");
        } else {
            response.setMessage("all groups removed");
        }
        return Response.ok((Object)this.toJSON(response)).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/removeUsers/{groupName}")
    public Response removeUsers(String users, @PathParam(value="groupName") String groupName, @Context HttpServletRequest request) throws JSONException {
        log.debug("RESTAPI - removeUsers");
        groupName = this.toolsHelper.decodeUrlParam(groupName);
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        ResponseGroup response = new ResponseGroup();
        JSONObject jsonObject = new JSONObject(users);
        ArrayList<String> arrayUsersToRemove = this.toolsHelper.getJSONarray(jsonObject, "users");
        com.atlassian.user.Group confluenceUsersGroup = this.userAccessor.getGroup(groupName);
        if (confluenceUsersGroup == null) {
            response.buildMessage("error", "group '" + groupName + "' not found");
            return Response.serverError().entity((Object)this.toJSON(response)).build();
        }
        if (arrayUsersToRemove.size() == 0) {
            response.buildMessage("error", "no users to remove");
            return Response.serverError().entity((Object)this.toJSON(response)).build();
        }
        if (this.toolsHelper.isConfluenceAdministrator() && !this.toolsHelper.isSystemAdministrator() && (groupName.equalsIgnoreCase("confluence-administrators") || this.toolsHelper.objectHasGlobalPermission("group", groupName, "SYSTEMADMINISTRATOR"))) {
            return this.toolsHelper.permissionViolation();
        }
        ArrayList<String> usersRemoved = new ArrayList<String>();
        ArrayList<String> usersSkipped = new ArrayList<String>();
        ArrayList<String> usersNotInGroup = new ArrayList<String>();
        ArrayList<String> usersNotExist = new ArrayList<String>();
        ArrayList<String> actionNotPermitted = new ArrayList<String>();
        log.debug("RESTAPI - removeUsers Remove this user '" + arrayUsersToRemove + "' from group '" + groupName + "'");
        for (String strConfluenceUser : arrayUsersToRemove) {
            ConfluenceUser confluenceUser = this.userAccessor.getUserByName(strConfluenceUser);
            if (confluenceUser != null) {
                if (this.userAccessor.hasMembership(confluenceUsersGroup, (User)confluenceUser)) {
                    String finalGroupName = groupName;
                    TransactionTemplate transactionTemplate = (TransactionTemplate)ComponentLocator.getComponent(TransactionTemplate.class);
                    transactionTemplate.execute(() -> {
                        try {
                            com.atlassian.crowd.embedded.api.User crowdUser = this.crowdService.getUser(strConfluenceUser);
                            Group crowdGroup = this.crowdService.getGroup(finalGroupName);
                            this.crowdService.removeUserFromGroup(crowdUser, crowdGroup);
                            usersRemoved.add(strConfluenceUser);
                        }
                        catch (Exception ex) {
                            if (log.isDebugEnabled()) {
                                log.debug("Exception: " + ExceptionUtils.getStackTrace((Throwable)ex));
                            }
                            actionNotPermitted.add(strConfluenceUser);
                            usersSkipped.add(strConfluenceUser);
                        }
                        return null;
                    });
                    continue;
                }
                usersSkipped.add(strConfluenceUser);
                usersNotInGroup.add(strConfluenceUser);
                continue;
            }
            usersSkipped.add(strConfluenceUser);
            usersNotExist.add(strConfluenceUser);
        }
        response.setUsersRemoved(usersRemoved);
        response.setUsersSkipped(usersSkipped);
        response.setUsersNotInGroup(usersNotInGroup);
        response.setUsersNotExist(usersNotExist);
        response.setActionNotPermitted(actionNotPermitted);
        if (response.getUsersSkipped().size() > 0) {
            response.buildMessage("success", "users removed from group, but some users skipped");
        } else {
            response.buildMessage("success", "all users removed from group");
        }
        return Response.ok((Object)this.toJSON(response)).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/addUsers/{groupName}")
    public Response addUsers(String users, @PathParam(value="groupName") String groupName, @Context HttpServletRequest request) throws JSONException {
        log.debug("RESTAPI - addUsers");
        groupName = this.toolsHelper.decodeUrlParam(groupName);
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        ResponseGroup response = new ResponseGroup();
        JSONObject jsonObject = new JSONObject(users);
        ArrayList<String> arrayUsersToAdd = this.toolsHelper.getJSONarray(jsonObject, "users");
        com.atlassian.user.Group confluenceUsersGroup = this.userAccessor.getGroup(groupName);
        if (confluenceUsersGroup == null) {
            response.buildMessage("error", "group '" + groupName + "' not found");
            return Response.serverError().entity((Object)this.toJSON(response)).build();
        }
        if (arrayUsersToAdd.size() == 0) {
            response.buildMessage("error", "no users to add");
            return Response.serverError().entity((Object)this.toJSON(response)).build();
        }
        if (this.toolsHelper.isConfluenceAdministrator() && !this.toolsHelper.isSystemAdministrator() && (groupName.equalsIgnoreCase("confluence-administrators") || this.toolsHelper.objectHasGlobalPermission("group", groupName, "SYSTEMADMINISTRATOR"))) {
            return this.toolsHelper.permissionViolation();
        }
        ArrayList<String> usersAdded = new ArrayList<String>();
        ArrayList<String> usersSkipped = new ArrayList<String>();
        ArrayList<String> usersAlreadyInGroup = new ArrayList<String>();
        ArrayList<String> usersNotExist = new ArrayList<String>();
        ArrayList<String> actionNotPermitted = new ArrayList<String>();
        log.debug("RESTAPI - addUsers Add this user '" + arrayUsersToAdd + "' to group '" + groupName + "'");
        for (String strConfluenceUser : arrayUsersToAdd) {
            ConfluenceUser confluenceUser = this.userAccessor.getUserByName(strConfluenceUser);
            if (confluenceUser != null) {
                if (!this.userAccessor.hasMembership(confluenceUsersGroup, (User)confluenceUser)) {
                    String finalGroupName = groupName;
                    TransactionTemplate transactionTemplate = (TransactionTemplate)ComponentLocator.getComponent(TransactionTemplate.class);
                    transactionTemplate.execute(() -> {
                        try {
                            com.atlassian.crowd.embedded.api.User crowdUser = this.crowdService.getUser(strConfluenceUser);
                            Group crowdGroup = this.crowdService.getGroup(finalGroupName);
                            this.crowdService.addUserToGroup(crowdUser, crowdGroup);
                            usersAdded.add(strConfluenceUser);
                        }
                        catch (Exception ex) {
                            if (log.isDebugEnabled()) {
                                log.debug("Exception: " + ExceptionUtils.getStackTrace((Throwable)ex));
                            }
                            actionNotPermitted.add(strConfluenceUser);
                            usersSkipped.add(strConfluenceUser);
                        }
                        return null;
                    });
                    continue;
                }
                usersSkipped.add(strConfluenceUser);
                usersAlreadyInGroup.add(strConfluenceUser);
                continue;
            }
            usersSkipped.add(strConfluenceUser);
            usersNotExist.add(strConfluenceUser);
        }
        response.setUsersAdded(usersAdded);
        response.setUsersSkipped(usersSkipped);
        response.setUsersAlreadyInGroup(usersAlreadyInGroup);
        response.setUsersNotExist(usersNotExist);
        response.setActionNotPermitted(actionNotPermitted);
        if (!response.getUsersSkipped().isEmpty()) {
            response.buildMessage("success", "users added to group, but some users skipped");
        } else {
            response.buildMessage("success", "all users added to group");
        }
        return Response.ok((Object)this.toJSON(response)).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/getUsers/{groupName}")
    public Response getUsers(@PathParam(value="groupName") String groupName, @QueryParam(value="startAt") int startAt, @QueryParam(value="showBasicDetails") boolean showBasicDetails, @QueryParam(value="showExtendedDetails") boolean showExtendedDetails, @QueryParam(value="maxResults") int maxResults, @QueryParam(value="dateFormat") String dateFormatApi, @Context HttpServletRequest request) {
        log.debug("RESTAPI - getUsers from group:" + groupName);
        groupName = this.toolsHelper.decodeUrlParam(groupName);
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        com.atlassian.user.Group confluenceUsersGroup = this.userAccessor.getGroup(groupName);
        if (confluenceUsersGroup == null) {
            response.put("error", "group '" + groupName + "' not found");
            return Response.serverError().entity(response).build();
        }
        ArrayList<HashMap<String, Object>> usersArray = new ArrayList<HashMap<String, Object>>();
        if (maxResults == 0) {
            maxResults = 100;
        }
        if (log.isDebugEnabled()) {
            log.debug(" ----- START GET GROUP USERS '" + groupName + "' --- '");
        }
        List confluenceUsersGroupUsers = this.userAccessor.getMemberNamesAsList(confluenceUsersGroup);
        if (log.isDebugEnabled()) {
            log.debug(" ----- STOP GET GROUP USERS '" + groupName + "' --- '");
        }
        int maxUsers = startAt + maxResults > confluenceUsersGroupUsers.size() ? confluenceUsersGroupUsers.size() : startAt + maxResults;
        for (int i = startAt; i < maxUsers; ++i) {
            Map<String, Object> userMap = new HashMap<String, Object>();
            if (showBasicDetails || showExtendedDetails) {
                ConfluenceUser confluenceUser = (ConfluenceUser)this.toolsHelper.getUserByName((String)confluenceUsersGroupUsers.get(i));
                if (confluenceUser == null) continue;
                if (showBasicDetails || showExtendedDetails) {
                    if (showExtendedDetails) {
                        userMap = this.toolsHelper.addUserGroupDetails(userMap, confluenceUser.getName(), dateFormatApi);
                    }
                    userMap.put("key", confluenceUser.getKey().getStringValue());
                    userMap.put("fullName", confluenceUser.getFullName());
                    userMap.put("email", confluenceUser.getEmail());
                }
                userMap.put("name", confluenceUser.getName());
                usersArray.add((HashMap<String, Object>)userMap);
                continue;
            }
            userMap.put("name", confluenceUsersGroupUsers.get(i));
            usersArray.add((HashMap<String, Object>)userMap);
        }
        response.put("total", confluenceUsersGroupUsers.size());
        response.put("startAt", startAt);
        response.put("maxResults", maxResults);
        response.put("users", usersArray);
        response.put("status", "success");
        return Response.ok(response).build();
    }

    private String toJSON(ResponseGroup json) {
        String returnJson = new JSONObject((Object)json).toString();
        returnJson = returnJson.replaceAll("\"class\":\"class com.itlab.confluence.plugins.restextender.group.ResponseGroup\"", "");
        returnJson = returnJson.replaceAll(",,", ",");
        returnJson = returnJson.replaceAll("\\{,", "{");
        returnJson = returnJson.replaceAll(",\\}", "}");
        return returnJson;
    }
}

