/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender.resources;

import com.atlassian.core.filters.ServletContextThreadLocal;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.webresource.api.data.WebResourceDataProvider;
import com.itlab.confluence.plugins.restextender.helper.ToolsHelper;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataProvider
implements WebResourceDataProvider {
    private static final Logger log = LoggerFactory.getLogger(DataProvider.class);
    private final ToolsHelper toolsHelper;

    @Inject
    public DataProvider(ToolsHelper toolsHelper) {
        this.toolsHelper = toolsHelper;
    }

    public Jsonable get() {
        return writer -> {
            block2: {
                try {
                    this.getBodyContentJsonObject().write(writer);
                }
                catch (Exception ex) {
                    if (!log.isDebugEnabled()) break block2;
                    log.debug("Exception: " + ExceptionUtils.getStackTrace((Throwable)ex));
                }
            }
        };
    }

    private JSONObject getBodyContentJsonObject() throws JSONException {
        JSONObject pluginData = new JSONObject();
        pluginData.put("baseUrl", (Object)this.toolsHelper.getBaseUrl());
        pluginData.put("isConfluenceAdministrator", this.toolsHelper.isConfluenceAdministrator());
        pluginData.put("isLicenseIsValid", this.toolsHelper.isLicenseIsValid());
        pluginData.put("isPluginRemoved", this.toolsHelper.isSensitiveCustomer());
        pluginData.put("isSourceEditorVisible", this.toolsHelper.isSourceEditorVisibleForUser());
        pluginData.put("isComplexityAnalysisVisibleForUser", this.toolsHelper.isComplexityAnalysisVisibleForUser());
        pluginData.put("isNotifyWatchersVisibleForUser", this.toolsHelper.isNotifyWatchersVisibleForUser());
        pluginData.put("changeContextBack", this.changeContextBack());
        return pluginData;
    }

    private boolean changeContextBack() {
        HttpServletRequest req = ServletContextThreadLocal.getRequest();
        if (req == null || req.getSession() == null) {
            return false;
        }
        Object param = req.getSession().getAttribute("extender_default_user");
        return this.toolsHelper.isLicenseIsValid() && param != null && !param.equals("") && this.toolsHelper.isUserExistByName(param.toString());
    }
}

