/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender.permission;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.ContentPermission;
import com.atlassian.confluence.security.ContentPermissionSet;
import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.security.administrators.PermissionsAdministrator;
import com.atlassian.confluence.security.administrators.PermissionsAdministratorBuilder;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.itlab.confluence.plugins.restextender.helper.ToolsHelper;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/permission")
public class PermissionRestApi {
    private static final Logger log = LoggerFactory.getLogger(PermissionRestApi.class);
    private final GroupManager groupManager;
    private final ContentPermissionManager contentPermissionManager;
    private final UserAccessor userAccessor;
    private final PageManager pageManager;
    private ToolsHelper toolsHelper;
    List<String> globalPermissions = new ArrayList<String>(Arrays.asList("USECONFLUENCE", "PERSONALSPACE", "CREATESPACE", "ADMINISTRATECONFLUENCE", "SYSTEMADMINISTRATOR"));

    @Inject
    public PermissionRestApi(@ConfluenceImport GroupManager groupManager, @ConfluenceImport ContentPermissionManager contentPermissionManager, @ConfluenceImport UserAccessor userAccessor, @ConfluenceImport PageManager pageManager, ToolsHelper toolsHelper) {
        this.groupManager = groupManager;
        this.userAccessor = userAccessor;
        this.contentPermissionManager = contentPermissionManager;
        this.toolsHelper = toolsHelper;
        this.pageManager = pageManager;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/content/{contentId}/getInheritedContentTreePermissions")
    public Response getInheritedContentTreePermissions(@PathParam(value="contentId") long contentId, @QueryParam(value="showContentDetails") boolean showContentDetails, @QueryParam(value="permissionType") String permissionType, @QueryParam(value="startAt") int startAt, @QueryParam(value="peopleWhoCanView") boolean peopleWhoCanView, @QueryParam(value="maxResults") int maxResults, @QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="dateFormat") String dateFormatApi) throws EntityException {
        Page page;
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (log.isDebugEnabled()) {
            log.debug("contentId :: " + contentId);
        }
        if ((page = this.toolsHelper.getPageFormPageDao(contentId)) == null) {
            return this.toolsHelper.contentIdNotExist(contentId);
        }
        if (!this.toolsHelper.skipParamSpaceValidation(spaceKey, page)) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.toolsHelper.isConfluenceAdministrator() && !this.toolsHelper.isCurrentUserIsSpaceAdministrator(page.getSpace())) {
            return this.toolsHelper.permissionViolation();
        }
        return this.getInheritedContentPermissionsResponse(page, showContentDetails, true, permissionType, startAt, maxResults, peopleWhoCanView, dateFormatApi);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/content/{contentId}/getInheritedContentPermissions")
    public Response getInheritedContentPermissions(@PathParam(value="contentId") long contentId, @QueryParam(value="showContentDetails") boolean showContentDetails, @QueryParam(value="permissionType") String permissionType, @QueryParam(value="startAt") int startAt, @QueryParam(value="peopleWhoCanView") boolean peopleWhoCanView, @QueryParam(value="maxResults") int maxResults, @QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="dateFormat") String dateFormatApi) throws EntityException {
        Page page;
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (log.isDebugEnabled()) {
            log.debug("contentId :: " + contentId);
        }
        if ((page = this.toolsHelper.getPageFormPageDao(contentId)) == null) {
            return this.toolsHelper.contentIdNotExist(contentId);
        }
        if (!this.toolsHelper.skipParamSpaceValidation(spaceKey, page)) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.toolsHelper.isConfluenceAdministrator() && !this.toolsHelper.isCurrentUserIsSpaceAdministrator(page.getSpace())) {
            return this.toolsHelper.permissionViolation();
        }
        return this.getInheritedContentPermissionsResponse(page, showContentDetails, false, permissionType, startAt, maxResults, peopleWhoCanView, dateFormatApi);
    }

    private Set<String> getGroupFullContentPermissionList(Set<String> fullContentPermissionList, String groupName, Space space, List<Page> tree, String permissionType) {
        boolean hasSpaceViewPermission = false;
        boolean hasSpaceEditPermission = false;
        if (permissionType.equalsIgnoreCase("all") || permissionType.equalsIgnoreCase("view")) {
            hasSpaceViewPermission = this.spaceHasAnonymousPermission(space, "VIEWSPACE") ? true : this.groupHasSpacePermission(groupName, space, "VIEWSPACE");
        }
        if (permissionType.equalsIgnoreCase("all") || permissionType.equalsIgnoreCase("edit")) {
            hasSpaceEditPermission = this.spaceHasAnonymousPermission(space, "EDITSPACE") ? true : this.groupHasSpacePermission(groupName, space, "EDITSPACE");
        }
        boolean inheriteViewPermission = hasSpaceViewPermission;
        boolean inheriteEditPermission = hasSpaceEditPermission;
        for (Page pageFromTree : tree) {
            if (permissionType.equalsIgnoreCase("all") || permissionType.equalsIgnoreCase("view")) {
                boolean bl = inheriteViewPermission = inheriteViewPermission ? this.groupHasInheritedContentPermission(inheriteViewPermission, groupName, "View", (ContentEntityObject)pageFromTree) : false;
            }
            if (permissionType.equalsIgnoreCase("all") || permissionType.equalsIgnoreCase("edit")) {
                inheriteEditPermission = hasSpaceEditPermission ? this.groupHasInheritedContentPermission(inheriteViewPermission, groupName, "Edit", (ContentEntityObject)pageFromTree) : false;
            }
            String temp = "";
            if ((permissionType.equalsIgnoreCase("all") || permissionType.equalsIgnoreCase("view")) && !fullContentPermissionList.contains(temp = "group@@" + groupName + "@@" + pageFromTree.getIdAsString() + "@@view" + inheriteViewPermission)) {
                fullContentPermissionList.add(temp);
            }
            if (!permissionType.equalsIgnoreCase("all") && !permissionType.equalsIgnoreCase("edit") || fullContentPermissionList.contains(temp = "group@@" + groupName + "@@" + pageFromTree.getIdAsString() + "@@edit" + inheriteEditPermission)) continue;
            fullContentPermissionList.add(temp);
        }
        return fullContentPermissionList;
    }

    private Set<String> getUserFullContentPermissionList(Set<String> fullContentPermissionList, String userName, Space space, List<Page> tree, String permissionType) {
        boolean hasSpaceViewPermission = false;
        boolean hasSpaceEditPermission = false;
        ConfluenceUser user = this.toolsHelper.getConfluenceUserByName(userName);
        if (permissionType.equalsIgnoreCase("all") || permissionType.equalsIgnoreCase("view")) {
            hasSpaceViewPermission = this.spaceHasAnonymousPermission(space, "VIEWSPACE") ? true : this.toolsHelper.getSpacePermissionManager().hasPermission("VIEWSPACE", space, (User)user);
        }
        if (permissionType.equalsIgnoreCase("all") || permissionType.equalsIgnoreCase("edit")) {
            hasSpaceEditPermission = this.spaceHasAnonymousPermission(space, "EDITSPACE") ? true : this.toolsHelper.getSpacePermissionManager().hasPermission("EDITSPACE", space, (User)user);
        }
        boolean inheriteViewPermission = hasSpaceViewPermission;
        boolean inheriteEditPermission = hasSpaceEditPermission;
        for (Page pageFromTree : tree) {
            if (permissionType.equalsIgnoreCase("all") || permissionType.equalsIgnoreCase("view")) {
                boolean bl = inheriteViewPermission = inheriteViewPermission ? this.userHasInheritedContentPermissionPersonalOrGroup((User)user, "View", (ContentEntityObject)pageFromTree) : false;
            }
            if (permissionType.equalsIgnoreCase("all") || permissionType.equalsIgnoreCase("edit")) {
                inheriteEditPermission = hasSpaceEditPermission ? this.userHasInheritedContentPermissionPersonalOrGroup((User)user, "Edit", (ContentEntityObject)pageFromTree) : false;
            }
            String temp = "";
            if ((permissionType.equalsIgnoreCase("all") || permissionType.equalsIgnoreCase("view")) && !fullContentPermissionList.contains(temp = "user@@" + userName + "@@" + pageFromTree.getIdAsString() + "@@view" + inheriteViewPermission)) {
                fullContentPermissionList.add(temp);
            }
            if (!permissionType.equalsIgnoreCase("all") && !permissionType.equalsIgnoreCase("edit") || fullContentPermissionList.contains(temp = "user@@" + userName + "@@" + pageFromTree.getIdAsString() + "@@edit" + inheriteEditPermission)) continue;
            fullContentPermissionList.add(temp);
        }
        return fullContentPermissionList;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/content/{contentId}/getContentTreeRestrictions")
    public Response getContentTreeRestrictions(@PathParam(value="contentId") long contentId, @QueryParam(value="showContentDetails") boolean showContentDetails, @QueryParam(value="startAt") int startAt, @QueryParam(value="peopleWhoCanView") boolean peopleWhoCanView, @QueryParam(value="maxResults") int maxResults, @QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="dateFormat") String dateFormatApi) throws EntityException {
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        Page page = this.toolsHelper.getPageFormPageDao(contentId);
        if (page == null) {
            return this.toolsHelper.contentIdNotExist(contentId);
        }
        if (!this.toolsHelper.skipParamSpaceValidation(spaceKey, page)) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.toolsHelper.isConfluenceAdministrator() && !this.toolsHelper.isCurrentUserIsSpaceAdministrator(page.getSpace())) {
            return this.toolsHelper.permissionViolation();
        }
        if (log.isDebugEnabled()) {
            log.debug("contentId :: " + contentId);
        }
        Map<String, Object> response = new HashMap<String, Object>();
        response.put("contentId", page.getId());
        if (showContentDetails) {
            response.put("spaceKey", page.getSpace().getKey());
            response.put("spaceName", page.getSpace().getName());
            response.put("contentName", page.getTitle());
            response.put("contentType", page.getContentTypeObject().getType());
            response.put("contentCreatorName", page.getCreator() != null ? page.getCreator().getName() : "not exist");
        }
        ArrayList<Page> tree = new ArrayList<Page>();
        if (page.getParent() != null) {
            this.buildTree(tree, page);
        } else {
            tree.add(page);
        }
        Collections.reverse(tree);
        int level = 1;
        ArrayList<Map<String, Object>> treeArray = new ArrayList<Map<String, Object>>();
        for (Page pageFromTree : tree) {
            Map<String, Object> treeMap = new HashMap<String, Object>();
            if (showContentDetails) {
                treeMap.put("contentName", pageFromTree.getTitle());
                treeMap.put("contentType", pageFromTree.getContentTypeObject().getType());
                treeMap.put("contentCreatorName", pageFromTree.getCreator() != null ? pageFromTree.getCreator().getName() : "not exist");
            }
            treeMap.put("contentId", pageFromTree.getId());
            treeMap.put("level", level);
            treeMap = this.addLastPermissionModificationDate(treeMap, dateFormatApi, (ContentEntityObject)pageFromTree, "all");
            treeMap.put("restrictions", this.getContentRestrictionMap((ContentEntityObject)pageFromTree, startAt, maxResults, peopleWhoCanView));
            ++level;
            treeArray.add(treeMap);
        }
        response.put("contentTree", treeArray);
        response = this.addLastPermissionModificationDate(response, dateFormatApi, (ContentEntityObject)page, "all");
        return Response.ok(response).build();
    }

    private Response getInheritedContentPermissionsResponse(Page page, boolean showContentDetails, boolean fullTree, String permissionType, int startAt, int maxResults, boolean peopleWhoCanView, String dateFormatApi) {
        Map viewMap;
        Map editMap;
        Map<String, Object> pageRestrictions;
        Map<String, Object> response = new HashMap<String, Object>();
        if (permissionType == null || !permissionType.equalsIgnoreCase("edit") && !permissionType.equalsIgnoreCase("view")) {
            permissionType = "all";
        }
        Set<String> fullContentPermissionList = new HashSet<String>();
        ArrayList<String> groupsWithPermissionsList = new ArrayList<String>();
        ArrayList<String> usersWithPermissionsList = new ArrayList<String>();
        Map groupsWithPermissions = this.toolsHelper.getSpacePermissionManager().getGroupsForPermissionType("VIEWSPACE", page.getSpace());
        Map usersWithPermissions = this.toolsHelper.getSpacePermissionManager().getUsersForPermissionType("VIEWSPACE", page.getSpace());
        for (Map.Entry entry : groupsWithPermissions.entrySet()) {
            groupsWithPermissionsList.add((String)entry.getKey());
        }
        for (Map.Entry entry : usersWithPermissions.entrySet()) {
            usersWithPermissionsList.add((String)entry.getKey());
        }
        if (log.isDebugEnabled()) {
            log.debug("groupsWithPermissionsList: " + groupsWithPermissionsList);
            log.debug("usersWithPermissionsList: " + usersWithPermissionsList);
        }
        response.put("contentId", page.getId());
        if (showContentDetails) {
            response.put("spaceKey", page.getSpace().getKey());
            response.put("spaceName", page.getSpace().getName());
            response.put("contentName", page.getTitle());
            response.put("contentType", page.getContentTypeObject().getType());
            response.put("contentCreatorName", page.getCreator() != null ? page.getCreator().getName() : "not exist");
        }
        ArrayList<Page> tree = new ArrayList<Page>();
        if (page.getParent() != null) {
            this.buildTree(tree, page);
        } else {
            tree.add(page);
        }
        Collections.reverse(tree);
        int level = 1;
        for (String userName : usersWithPermissionsList) {
            fullContentPermissionList = this.getUserFullContentPermissionList(fullContentPermissionList, userName, page.getSpace(), tree, permissionType);
        }
        for (Page pageFromTree : tree) {
            Set users;
            pageRestrictions = this.getContentRestrictionMap((ContentEntityObject)pageFromTree, startAt, maxResults, peopleWhoCanView);
            if (pageRestrictions.get("edit") != null && (editMap = (Map)pageRestrictions.get("edit")).get("users") != null) {
                users = (Set)editMap.get("users");
                for (String userContentRestriction : users) {
                    fullContentPermissionList = this.getUserFullContentPermissionList(fullContentPermissionList, userContentRestriction, page.getSpace(), tree, permissionType);
                }
            }
            if (pageRestrictions.get("view") == null || (viewMap = (Map)pageRestrictions.get("view")).get("users") == null) continue;
            users = (Set)viewMap.get("users");
            for (String userContentRestriction : users) {
                fullContentPermissionList = this.getUserFullContentPermissionList(fullContentPermissionList, userContentRestriction, page.getSpace(), tree, permissionType);
            }
        }
        for (String groupName : groupsWithPermissionsList) {
            fullContentPermissionList = this.getGroupFullContentPermissionList(fullContentPermissionList, groupName, page.getSpace(), tree, permissionType);
        }
        for (Page pageFromTree : tree) {
            Set groups;
            pageRestrictions = this.getContentRestrictionMap((ContentEntityObject)pageFromTree, startAt, maxResults, peopleWhoCanView);
            if (pageRestrictions.get("edit") != null && (editMap = (Map)pageRestrictions.get("edit")).get("groups") != null) {
                groups = (Set)editMap.get("groups");
                for (String groupContentRestriction : groups) {
                    fullContentPermissionList = this.getGroupFullContentPermissionList(fullContentPermissionList, groupContentRestriction, page.getSpace(), tree, permissionType);
                }
            }
            if (pageRestrictions.get("view") == null || (viewMap = (Map)pageRestrictions.get("view")).get("groups") == null) continue;
            groups = (Set)viewMap.get("groups");
            for (String groupContentRestriction : groups) {
                fullContentPermissionList = this.getGroupFullContentPermissionList(fullContentPermissionList, groupContentRestriction, page.getSpace(), tree, permissionType);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("fullContentPermissionList: " + fullContentPermissionList);
        }
        if (fullTree) {
            ArrayList<HashMap<String, Object>> treeArray = new ArrayList<HashMap<String, Object>>();
            for (Page pageFromTree : tree) {
                Map<String, Object> treeMap = new HashMap<String, Object>();
                if (showContentDetails) {
                    treeMap.put("contentName", pageFromTree.getTitle());
                    treeMap.put("contentType", pageFromTree.getContentTypeObject().getType());
                    treeMap.put("contentCreatorName", pageFromTree.getCreator() != null ? pageFromTree.getCreator().getName() : "not exist");
                }
                treeMap.put("contentId", pageFromTree.getId());
                treeMap.put("level", level);
                treeMap.put("permissions", this.getInheritedContentTreePermissionsResponse((ContentEntityObject)pageFromTree, fullContentPermissionList, startAt, maxResults, peopleWhoCanView));
                treeMap = this.addLastPermissionModificationDate(treeMap, dateFormatApi, (ContentEntityObject)pageFromTree, permissionType);
                ++level;
                treeArray.add((HashMap<String, Object>)treeMap);
            }
            response.put("contentTree", treeArray);
        } else {
            response.put("level", tree.size());
            response.put("permissions", this.getInheritedContentTreePermissionsResponse((ContentEntityObject)tree.get(tree.size() - 1), fullContentPermissionList, startAt, maxResults, peopleWhoCanView));
        }
        response = this.addLastPermissionModificationDate(response, dateFormatApi, (ContentEntityObject)page, permissionType);
        return Response.ok(response).build();
    }

    private Map<String, Object> getInheritedContentTreePermissionsResponse(ContentEntityObject contentObject, Set<String> fullContentPermissionList, int startAt, int maxResults, boolean peopleWhoCanView) {
        HashMap viewPermissions = new HashMap();
        HashMap editPermissions = new HashMap();
        HashSet<String> viewGroups = new HashSet<String>();
        HashSet<String> viewUsers = new HashSet<String>();
        HashSet<String> editGroups = new HashSet<String>();
        HashSet<String> editUsers = new HashSet<String>();
        if (maxResults == 0) {
            maxResults = 50;
        }
        int viewUsersTotal = 0;
        int editUsersTotal = 0;
        int viewGroupsTotal = 0;
        int editGroupsTotal = 0;
        String contentId = contentObject.getIdAsString();
        for (String text : fullContentPermissionList) {
            Group confluenceUsersGroup;
            if (!text.contains("@@" + contentId + "@@")) continue;
            if (text.startsWith("user") && text.contains("@@viewtrue")) {
                if (startAt <= viewUsersTotal && viewUsersTotal < startAt + maxResults) {
                    viewUsers.add(text.split("@@")[1]);
                }
                ++viewUsersTotal;
                continue;
            }
            if (text.startsWith("user") && text.contains("@@edittrue")) {
                if (startAt <= editUsersTotal && editUsersTotal < startAt + maxResults) {
                    editUsers.add(text.split("@@")[1]);
                }
                ++editUsersTotal;
                continue;
            }
            if (text.startsWith("group") && text.contains("@@viewtrue")) {
                if (peopleWhoCanView) {
                    confluenceUsersGroup = this.userAccessor.getGroup(text.split("@@")[1]);
                    if (confluenceUsersGroup == null) continue;
                    for (String userName : this.userAccessor.getMemberNamesAsList(confluenceUsersGroup)) {
                        if (startAt <= editUsersTotal && editUsersTotal < startAt + maxResults) {
                            viewUsers.add(userName);
                        }
                        ++viewUsersTotal;
                    }
                    continue;
                }
                if (startAt <= viewGroupsTotal && viewGroupsTotal < startAt + maxResults) {
                    viewGroups.add(text.split("@@")[1]);
                }
                ++viewGroupsTotal;
                continue;
            }
            if (!text.startsWith("group") || !text.contains("@@edittrue")) continue;
            if (peopleWhoCanView) {
                confluenceUsersGroup = this.userAccessor.getGroup(text.split("@@")[1]);
                if (confluenceUsersGroup == null) continue;
                for (String userName : this.userAccessor.getMemberNamesAsList(confluenceUsersGroup)) {
                    if (startAt <= editUsersTotal && editUsersTotal < startAt + maxResults) {
                        editUsers.add(userName);
                    }
                    ++editUsersTotal;
                }
                continue;
            }
            if (startAt <= editGroupsTotal && editGroupsTotal < startAt + maxResults) {
                editGroups.add(text.split("@@")[1]);
            }
            ++editGroupsTotal;
        }
        if (!viewGroups.isEmpty()) {
            viewPermissions.put("groups", viewGroups);
        }
        if (!viewUsers.isEmpty()) {
            viewPermissions.put("users", viewUsers);
        }
        if (!editGroups.isEmpty()) {
            editPermissions.put("groups", editGroups);
        }
        if (!editUsers.isEmpty()) {
            editPermissions.put("users", editUsers);
        }
        HashMap<String, Object> allPermissions = new HashMap<String, Object>();
        if (!(viewGroups.isEmpty() && viewUsers.isEmpty() && editGroups.isEmpty() && editUsers.isEmpty())) {
            allPermissions.put("edit", editPermissions);
            allPermissions.put("view", viewPermissions);
        }
        allPermissions.put("viewUsersTotal", viewUsersTotal);
        allPermissions.put("editUsersTotal", editUsersTotal);
        if (!peopleWhoCanView) {
            allPermissions.put("viewGroupsTotal", viewGroupsTotal);
            allPermissions.put("editGroupsTotal", editGroupsTotal);
        }
        return allPermissions;
    }

    private Map<String, Object> getContentRestrictionMap(ContentEntityObject contentObject, int startAt, int maxResults, boolean peopleWhoCanView) {
        List viewPermissionsList = this.contentPermissionManager.getContentPermissionSets(contentObject, "View");
        List editPermissionsList = this.contentPermissionManager.getContentPermissionSets(contentObject, "Edit");
        String everyone = "can view";
        HashMap viewPermissions = new HashMap();
        HashMap editPermissions = new HashMap();
        if (maxResults == 0) {
            maxResults = 50;
        }
        int viewUsersTotal = 0;
        int editUsersTotal = 0;
        int viewGroupsTotal = 0;
        int editGroupsTotal = 0;
        HashSet<String> viewGroups = new HashSet<String>();
        HashSet<String> viewUsers = new HashSet<String>();
        for (ContentPermissionSet contentPermissionSet : viewPermissionsList) {
            if (log.isDebugEnabled()) {
                log.debug(contentObject.getContentId().toString() + " :viewPermissions: " + contentPermissionSet.getType().toLowerCase());
            }
            for (String groupName : contentPermissionSet.getGroupNames()) {
                if (log.isDebugEnabled()) {
                    log.debug(contentObject.getContentId().toString() + " :viewPermissions: group: " + groupName + " | " + contentPermissionSet.getOwningContent().getIdAsString());
                }
                if (!contentObject.getIdAsString().equals(contentPermissionSet.getOwningContent().getIdAsString()) || viewGroups.contains(groupName)) continue;
                if (startAt <= viewGroupsTotal && viewGroupsTotal < startAt + maxResults) {
                    viewGroups.add(groupName);
                }
                ++viewGroupsTotal;
            }
            for (UserKey userKey : contentPermissionSet.getUserKeys()) {
                if (log.isDebugEnabled()) {
                    log.debug(contentObject.getContentId().toString() + " :viewPermissions: userKey: " + userKey + " | " + contentPermissionSet.getOwningContent().getIdAsString());
                }
                ConfluenceUser confluenceUser = this.toolsHelper.getConfluenceUserByKey(userKey.getStringValue());
                if (!contentObject.getIdAsString().equals(contentPermissionSet.getOwningContent().getIdAsString()) || confluenceUser == null || viewUsers.contains(confluenceUser.getName())) continue;
                if (startAt <= viewUsersTotal && viewUsersTotal < startAt + maxResults) {
                    viewUsers.add(confluenceUser.getName());
                }
                ++viewUsersTotal;
            }
            if (!peopleWhoCanView) continue;
            for (String groupName : viewGroups) {
                Group confluenceUsersGroup = this.userAccessor.getGroup(groupName);
                if (confluenceUsersGroup == null) continue;
                for (String userName : this.userAccessor.getMemberNamesAsList(confluenceUsersGroup)) {
                    if (startAt <= viewUsersTotal && viewUsersTotal < startAt + maxResults) {
                        viewUsers.add(userName);
                    }
                    ++viewUsersTotal;
                }
            }
            viewGroupsTotal = 0;
            viewGroups = new HashSet();
        }
        if (!viewGroups.isEmpty()) {
            viewPermissions.put("groups", viewGroups);
        }
        if (!viewUsers.isEmpty()) {
            viewPermissions.put("users", viewUsers);
        }
        HashSet<String> editGroups = new HashSet<String>();
        HashSet<String> editUsers = new HashSet<String>();
        for (ContentPermissionSet contentPermissionSet : editPermissionsList) {
            if (log.isDebugEnabled()) {
                log.debug(contentObject.getContentId().toString() + " :editPermissions: " + contentPermissionSet.getType().toLowerCase());
            }
            for (String groupName : contentPermissionSet.getGroupNames()) {
                if (log.isDebugEnabled()) {
                    log.debug(contentObject.getContentId().toString() + " :editPermissions: group: " + groupName + " | " + contentPermissionSet.getOwningContent().getIdAsString());
                }
                if (!contentObject.getIdAsString().equals(contentPermissionSet.getOwningContent().getIdAsString()) || editGroups.contains(groupName)) continue;
                if (startAt <= editGroupsTotal && editGroupsTotal < startAt + maxResults) {
                    editGroups.add(groupName);
                }
                ++editGroupsTotal;
                if (!viewGroups.contains(groupName)) continue;
                everyone = "has no access";
            }
            for (UserKey userKey : contentPermissionSet.getUserKeys()) {
                if (log.isDebugEnabled()) {
                    log.debug(contentObject.getContentId().toString() + " :editPermissions: userKey: " + userKey + " | " + contentPermissionSet.getOwningContent().getIdAsString());
                }
                ConfluenceUser confluenceUser = this.toolsHelper.getConfluenceUserByKey(userKey.getStringValue());
                if (!contentObject.getIdAsString().equals(contentPermissionSet.getOwningContent().getIdAsString()) || confluenceUser == null || editUsers.contains(confluenceUser.getName())) continue;
                if (startAt <= editUsersTotal && editUsersTotal < startAt + maxResults) {
                    editUsers.add(confluenceUser.getName());
                }
                ++editUsersTotal;
                if (!viewUsers.contains(confluenceUser.getName())) continue;
                everyone = "has no access";
            }
            if (!peopleWhoCanView) continue;
            for (String groupName : editGroups) {
                Group confluenceUsersGroup = this.userAccessor.getGroup(groupName);
                if (confluenceUsersGroup == null) continue;
                for (String userName : this.userAccessor.getMemberNamesAsList(confluenceUsersGroup)) {
                    if (startAt <= viewUsersTotal && viewUsersTotal < startAt + maxResults) {
                        viewUsers.add(userName);
                    }
                    ++editUsersTotal;
                }
            }
            editGroupsTotal = 0;
            editGroups = new HashSet();
        }
        if (!editGroups.isEmpty()) {
            editPermissions.put("groups", editGroups);
        }
        if (!editUsers.isEmpty()) {
            editPermissions.put("users", editUsers);
        }
        HashMap<String, Object> allPermissions = new HashMap<String, Object>();
        if (log.isDebugEnabled()) {
            log.debug(contentObject.getIdAsString() + " viewGroups: " + viewGroups);
            log.debug(contentObject.getIdAsString() + " viewUsers: " + viewUsers);
            log.debug(contentObject.getIdAsString() + " editGroups: " + editGroups);
            log.debug(contentObject.getIdAsString() + " editUsers: " + editUsers);
        }
        if (!(viewGroups.isEmpty() && viewUsers.isEmpty() && editGroups.isEmpty() && editUsers.isEmpty())) {
            allPermissions.put("edit", editPermissions);
            allPermissions.put("view", viewPermissions);
            allPermissions.put("everyone", everyone);
        }
        allPermissions.put("viewUsersTotal", viewUsersTotal);
        allPermissions.put("editUsersTotal", editUsersTotal);
        if (!peopleWhoCanView) {
            allPermissions.put("viewGroupsTotal", viewGroupsTotal);
            allPermissions.put("editGroupsTotal", editGroupsTotal);
        }
        return allPermissions;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/global/permissionTypes")
    public Response getGlobalPermissions() {
        return Response.ok(this.globalPermissions).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/global/getAllGlobalPermissions")
    public Response globalGetAllPermissions(@QueryParam(value="startAt") int startAt, @QueryParam(value="maxResults") int maxResults) {
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        int iterator = 0;
        if (maxResults == 0) {
            maxResults = 100;
        }
        HashMap<String, Serializable> response = new HashMap<String, Serializable>();
        PermissionsAdministratorBuilder permissionsAdministratorBuilder = (PermissionsAdministratorBuilder)ComponentLocator.getComponent(PermissionsAdministratorBuilder.class);
        PermissionsAdministrator permissionsAdministrator = permissionsAdministratorBuilder.buildGlobalPermissionAdministrator();
        ArrayList allPermissions = new ArrayList();
        for (SpacePermission spacePermission : permissionsAdministrator.getPermissions()) {
            if (startAt <= iterator && iterator < startAt + maxResults) {
                HashMap<String, Object> permissionObject = new HashMap<String, Object>();
                permissionObject.put("isGroupPermission", spacePermission.isGroupPermission());
                if (spacePermission.isGroupPermission()) {
                    permissionObject.put("groupName", spacePermission.getGroup());
                }
                permissionObject.put("isAnonymousPermission", spacePermission.isAnonymousPermission());
                permissionObject.put("isUserPermission", spacePermission.isUserPermission());
                if (spacePermission.isUserPermission()) {
                    if (spacePermission.getUserSubject() != null) {
                        permissionObject.put("userName", spacePermission.getUserSubject().getName());
                    } else {
                        permissionObject.put("userName", "unknown user");
                    }
                }
                permissionObject.put("permissionType", spacePermission.getType());
                allPermissions.add(permissionObject);
            }
            ++iterator;
        }
        response.put("permissions", allPermissions);
        response.put("total", Integer.valueOf(permissionsAdministrator.getPermissions().size()));
        response.put("startAt", Integer.valueOf(startAt));
        response.put("maxResults", Integer.valueOf(maxResults));
        return Response.ok(response).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/global/group/getAllGlobalPermissions")
    public Response getAllGroupsGlobalPermissions(@QueryParam(value="startAt") int startAt, @QueryParam(value="maxResults") int maxResults) {
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        int iterator = 0;
        if (maxResults == 0) {
            maxResults = 100;
        }
        HashMap<String, Serializable> response = new HashMap<String, Serializable>();
        PermissionsAdministratorBuilder permissionsAdministratorBuilder = (PermissionsAdministratorBuilder)ComponentLocator.getComponent(PermissionsAdministratorBuilder.class);
        PermissionsAdministrator permissionsAdministrator = permissionsAdministratorBuilder.buildGlobalPermissionAdministrator();
        ArrayList allPermissions = new ArrayList();
        int totalPermissions = 0;
        for (SpacePermission spacePermission : permissionsAdministrator.getPermissions()) {
            if (startAt <= iterator && iterator < startAt + maxResults) {
                HashMap<String, String> permissionObject = new HashMap<String, String>();
                if (spacePermission.isGroupPermission()) {
                    permissionObject.put("groupName", spacePermission.getGroup());
                    permissionObject.put("permissionType", spacePermission.getType());
                    allPermissions.add(permissionObject);
                }
            }
            if (spacePermission.isGroupPermission()) {
                ++totalPermissions;
            }
            ++iterator;
        }
        response.put("permissions", allPermissions);
        response.put("total", Integer.valueOf(totalPermissions));
        response.put("startAt", Integer.valueOf(startAt));
        response.put("maxResults", Integer.valueOf(maxResults));
        return Response.ok(response).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/global/user/getAllGlobalPermissions")
    public Response getAllUsersGlobalPermissions(@QueryParam(value="startAt") int startAt, @QueryParam(value="maxResults") int maxResults) {
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        int iterator = 0;
        if (maxResults == 0) {
            maxResults = 100;
        }
        HashMap<String, Serializable> response = new HashMap<String, Serializable>();
        PermissionsAdministratorBuilder permissionsAdministratorBuilder = (PermissionsAdministratorBuilder)ComponentLocator.getComponent(PermissionsAdministratorBuilder.class);
        PermissionsAdministrator permissionsAdministrator = permissionsAdministratorBuilder.buildGlobalPermissionAdministrator();
        ArrayList allPermissions = new ArrayList();
        int totalPermissions = 0;
        for (SpacePermission spacePermission : permissionsAdministrator.getPermissions()) {
            if (startAt <= iterator && iterator < startAt + maxResults) {
                HashMap<String, String> permissionObject = new HashMap<String, String>();
                if (spacePermission.isUserPermission()) {
                    if (spacePermission.getUserSubject() != null) {
                        permissionObject.put("userName", spacePermission.getUserSubject().getName());
                    } else {
                        permissionObject.put("userName", "unknown user");
                    }
                    permissionObject.put("permissionType", spacePermission.getType());
                    allPermissions.add(permissionObject);
                }
            }
            if (spacePermission.isUserPermission()) {
                ++totalPermissions;
            }
            ++iterator;
        }
        response.put("permissions", allPermissions);
        response.put("total", Integer.valueOf(totalPermissions));
        response.put("startAt", Integer.valueOf(startAt));
        response.put("maxResults", Integer.valueOf(maxResults));
        return Response.ok(response).build();
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/global/group/{groupName}/permission/{permissionType}/addGlobalPermission")
    public Response globalAddGroupPermission(String jsonString, @PathParam(value="groupName") String groupName, @PathParam(value="permissionType") String permissionType) throws EntityException {
        groupName = this.toolsHelper.decodeUrlParam(groupName);
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (this.groupManager.getGroup(groupName) == null) {
            return this.toolsHelper.groupNotExit(groupName);
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        if (this.toolsHelper.isConfluenceAdministrator() && !this.toolsHelper.isSystemAdministrator()) {
            if (permissionType.equalsIgnoreCase("SYSTEMADMINISTRATOR")) {
                return this.toolsHelper.permissionViolation();
            }
            if (this.toolsHelper.objectHasGlobalPermission("group", groupName, "SYSTEMADMINISTRATOR")) {
                return this.toolsHelper.permissionViolation();
            }
        }
        if (groupName.equalsIgnoreCase("confluence-administrators")) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.isValidGlobalPermissionType(permissionType)) {
            return this.toolsHelper.permissionTypeNotExist(permissionType);
        }
        HashMap<String, String> response = new HashMap<String, String>();
        if (!this.toolsHelper.objectHasGlobalPermission("group", groupName, permissionType)) {
            SpacePermission newSpacePermission = SpacePermission.createGroupSpacePermission((String)permissionType, null, (String)groupName);
            this.toolsHelper.getSpacePermissionManager().savePermission(newSpacePermission);
            response.put("status", "permission added");
        } else {
            response.put("status", "permission is omitted, group '" + groupName + "' has '" + permissionType + "' permission");
        }
        return Response.ok(response).build();
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/global/user/{userName}/permission/{permissionType}/addGlobalPermission")
    public Response globalAddUserPermission(String jsonString, @PathParam(value="userName") String userName, @PathParam(value="permissionType") String permissionType) throws EntityException {
        userName = this.toolsHelper.decodeUrlParam(userName);
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!this.toolsHelper.isUserExistByName(userName)) {
            return this.toolsHelper.userNotFound(userName);
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        if (this.toolsHelper.isConfluenceAdministrator() && !this.toolsHelper.isSystemAdministrator() && permissionType.equalsIgnoreCase("SYSTEMADMINISTRATOR")) {
            return this.toolsHelper.permissionViolation();
        }
        if (this.toolsHelper.isConfluenceAdministrator() && !this.toolsHelper.isSystemAdministrator() && this.toolsHelper.isSystemAdministrator(userName)) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.isValidGlobalPermissionType(permissionType)) {
            return this.toolsHelper.permissionTypeNotExist(permissionType);
        }
        User user = this.toolsHelper.getUserByName(userName);
        HashMap<String, String> response = new HashMap<String, String>();
        if (!this.toolsHelper.objectHasGlobalPermission("user", userName, permissionType)) {
            SpacePermission newSpacePermission = SpacePermission.createUserSpacePermission((String)permissionType, null, (ConfluenceUser)((ConfluenceUser)user));
            this.toolsHelper.getSpacePermissionManager().savePermission(newSpacePermission);
            response.put("status", "permission added");
        } else {
            response.put("status", "permission is omitted, user '" + userName + "' has '" + permissionType + "' permission");
        }
        return Response.ok(response).build();
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/global/group/{groupName}/permission/{permissionType}/removeGlobalPermission")
    public Response globalRemoveGroupPermission(String jsonString, @PathParam(value="groupName") String groupName, @PathParam(value="permissionType") String permissionType) throws EntityException {
        groupName = this.toolsHelper.decodeUrlParam(groupName);
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (this.groupManager.getGroup(groupName) == null) {
            return this.toolsHelper.groupNotExit(groupName);
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        if (this.toolsHelper.isConfluenceAdministrator() && !this.toolsHelper.isSystemAdministrator()) {
            if (permissionType.equalsIgnoreCase("SYSTEMADMINISTRATOR")) {
                return this.toolsHelper.permissionViolation();
            }
            if (this.toolsHelper.objectHasGlobalPermission("group", groupName, "SYSTEMADMINISTRATOR")) {
                return this.toolsHelper.permissionViolation();
            }
        }
        if (groupName.equalsIgnoreCase("confluence-administrators")) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.isValidGlobalPermissionType(permissionType)) {
            return this.toolsHelper.permissionTypeNotExist(permissionType);
        }
        HashMap<String, String> response = new HashMap<String, String>();
        if (this.toolsHelper.objectHasGlobalPermission("group", groupName, permissionType)) {
            PermissionsAdministratorBuilder permissionsAdministratorBuilder = (PermissionsAdministratorBuilder)ComponentLocator.getComponent(PermissionsAdministratorBuilder.class);
            PermissionsAdministrator permissionsAdministrator = permissionsAdministratorBuilder.buildGlobalPermissionAdministrator();
            for (SpacePermission permission : permissionsAdministrator.getPermissions()) {
                if (!permission.isGroupPermission() || !permission.getGroup().equalsIgnoreCase(groupName) || !permission.getType().equalsIgnoreCase(permissionType)) continue;
                this.toolsHelper.getSpacePermissionManager().removePermission(permission);
            }
            response.put("status", "permission removed");
        } else {
            response.put("status", "permission is omitted, group '" + groupName + "' does not have '" + permissionType + "' permission");
        }
        return Response.ok(response).build();
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/global/user/{userName}/permission/{permissionType}/removeGlobalPermission")
    public Response globalRemoveUserPermission(String jsonString, @PathParam(value="userName") String userName, @PathParam(value="permissionType") String permissionType) throws EntityException {
        userName = this.toolsHelper.decodeUrlParam(userName);
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!this.toolsHelper.isUserExistByName(userName)) {
            return this.toolsHelper.userNotFound(userName);
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        if (this.toolsHelper.isConfluenceAdministrator() && !this.toolsHelper.isSystemAdministrator() && permissionType.equalsIgnoreCase("SYSTEMADMINISTRATOR")) {
            return this.toolsHelper.permissionViolation();
        }
        if (this.toolsHelper.isConfluenceAdministrator() && !this.toolsHelper.isSystemAdministrator() && this.toolsHelper.isSystemAdministrator(userName)) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.isValidGlobalPermissionType(permissionType)) {
            return this.toolsHelper.permissionTypeNotExist(permissionType);
        }
        HashMap<String, String> response = new HashMap<String, String>();
        if (this.toolsHelper.objectHasGlobalPermission("user", userName, permissionType)) {
            PermissionsAdministratorBuilder permissionsAdministratorBuilder = (PermissionsAdministratorBuilder)ComponentLocator.getComponent(PermissionsAdministratorBuilder.class);
            PermissionsAdministrator permissionsAdministrator = permissionsAdministratorBuilder.buildGlobalPermissionAdministrator();
            for (SpacePermission permission : permissionsAdministrator.getPermissions()) {
                if (!permission.isUserPermission() || !permission.getType().equalsIgnoreCase(permissionType) || permission.getUserSubject() == null || !permission.getUserSubject().getName().equals(userName)) continue;
                this.toolsHelper.getSpacePermissionManager().removePermission(permission);
            }
            response.put("status", "permission removed");
        } else {
            response.put("status", "permission is omitted, user '" + userName + "' does not have '" + permissionType + "' permission");
        }
        return Response.ok(response).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/content/user/{userName}/getAllContentPermissions")
    public Response getUserContentPermission(@PathParam(value="userName") String userName, @QueryParam(value="startAt") int startAt, @QueryParam(value="maxResults") int maxResults, @QueryParam(value="includeUserGroups") boolean includeUserGroups, @Context HttpServletRequest request) {
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        ConfluenceUser confluenceUser = this.toolsHelper.getConfluenceUserByName(userName = this.toolsHelper.decodeUrlParam(userName));
        if (confluenceUser == null) {
            return this.toolsHelper.userNotFound(userName);
        }
        int iterator = 0;
        if (maxResults == 0) {
            maxResults = 50;
        }
        if (log.isDebugEnabled()) {
            log.debug("RESTAPI - getUserContentPermission - startAt:" + startAt);
            log.debug("RESTAPI - getUserContentPermission - maxResults:" + maxResults);
            log.debug("RESTAPI - getUserContentPermission - show: " + maxResults);
            log.debug("RESTAPI - getUserContentPermission - includeUserGroups: " + includeUserGroups);
        }
        ArrayList<String> userGroups = new ArrayList<String>();
        for (String group : this.userAccessor.getGroupNames((User)confluenceUser)) {
            userGroups.add(group.replaceAll("'", "''"));
        }
        List matchingResults = this.toolsHelper.getDataBaseResults("SELECT p.USERNAME, p.GROUPNAME, p.CP_TYPE, s.CONTENT_ID, c.SPACEID FROM CONTENT_PERM p JOIN CONTENT_PERM_SET s ON p.CPS_ID = s.ID JOIN CONTENT c ON s.CONTENT_ID = c.CONTENTID WHERE p.USERNAME = '" + confluenceUser.getKey() + "'" + (includeUserGroups ? "OR GROUPNAME in ('" + String.join((CharSequence)"','", userGroups) + "')" : ""), "permissionsForUser");
        HashMap<String, Serializable> response = new HashMap<String, Serializable>();
        ArrayList permissionList = new ArrayList();
        HashMap tempSpaces = new HashMap();
        for (Object object : matchingResults) {
            if (iterator > startAt + maxResults) break;
            if (startAt > iterator || iterator >= startAt + maxResults) continue;
            List<?> value = ToolsHelper.convertObjectToList(object);
            HashMap<String, Object> permissionMap = new HashMap<String, Object>();
            if (tempSpaces.get(value.get(4)) != null) {
                permissionMap.put("spaceKey", tempSpaces.get(value.get(4)));
            } else {
                Space space = this.toolsHelper.getSpaceFromSpaceDao(Long.parseLong(value.get(4).toString()));
                if (space != null) {
                    permissionMap.put("spaceKey", space.getKey());
                    tempSpaces.put(value.get(4), space.getKey());
                } else {
                    permissionMap.put("spaceKey", "not exist");
                }
            }
            permissionMap.put("spaceId", value.get(4));
            permissionMap.put("contentId", value.get(3));
            permissionMap.put("permissionType", value.get(2));
            if (value.get(1) != null && !value.get(1).toString().equals("")) {
                permissionMap.put("grantedByGroup", true);
                permissionMap.put("grantedIndividually", false);
                permissionMap.put("groupName", value.get(1));
            } else {
                permissionMap.put("grantedByGroup", false);
                permissionMap.put("grantedIndividually", true);
            }
            permissionList.add(permissionMap);
            if (!log.isDebugEnabled()) continue;
            log.debug("OBJECT: " + value.get(1) + " - " + value.get(2) + " - " + value.get(3) + " - " + value.get(4));
        }
        response.put("total", Integer.valueOf(matchingResults.size()));
        response.put("startAt", Integer.valueOf(startAt));
        response.put("maxResults", Integer.valueOf(maxResults));
        response.put("contentPermissions", permissionList);
        return Response.ok(response).build();
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/content/group/{groupName}/removeAllContentPermission")
    public Response removeAllGroupContentPermissions(@PathParam(value="groupName") String groupName) throws EntityException {
        groupName = this.toolsHelper.decodeUrlParam(groupName);
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (this.groupManager.getGroup(groupName) == null) {
            return this.toolsHelper.groupNotExit(groupName);
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        this.contentPermissionManager.removeAllGroupPermissions(groupName);
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("status", "done");
        return Response.ok(response).build();
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/content/user/{userName}/removeAllContentPermission")
    public Response removeAllUserContentPermissions(@PathParam(value="userName") String userName) {
        userName = this.toolsHelper.decodeUrlParam(userName);
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!this.toolsHelper.isUserExistByName(userName)) {
            return this.toolsHelper.userNotFound(userName);
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        ConfluenceUser confluenceUser = this.userAccessor.getUserByName(userName);
        this.contentPermissionManager.removeAllUserPermissions(confluenceUser);
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("status", "done");
        return Response.ok(response).build();
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/content/group/{groupName}/permission/{permissionType}/addContentPermission")
    public Response addGroupContentIdPermissionView(String jsonString, @PathParam(value="groupName") String groupName, @PathParam(value="permissionType") String permissionType, @QueryParam(value="spaceKey") String spaceKey) throws EntityException {
        return this.addGroupContentIdPermission(groupName, jsonString, permissionType, spaceKey);
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/content/group/{groupName}/permission/{permissionType}/space/{spaceKey}/addContentPermission")
    public Response addGroupContentNamePermissionView(String jsonString, @PathParam(value="groupName") String groupName, @PathParam(value="permissionType") String permissionType, @PathParam(value="spaceKey") String spaceKey) throws EntityException {
        return this.addGroupContentNamePermission(groupName, spaceKey, jsonString, permissionType);
    }

    private Response addGroupContentNamePermission(String groupName, String spaceKey, String jsonString, String permissionType) throws EntityException {
        groupName = this.toolsHelper.decodeUrlParam(groupName);
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (this.groupManager.getGroup(groupName) == null) {
            return this.toolsHelper.groupNotExit(groupName);
        }
        Space space = this.toolsHelper.getSpaceFromSpaceDao(spaceKey);
        if (space == null) {
            return this.toolsHelper.spaceNotExist(spaceKey);
        }
        if (!(this.toolsHelper.isConfluenceAdministrator() || this.toolsHelper.isCurrentUserIsSpaceAdministrator(space) || this.toolsHelper.isDisabledForSpaceAdministrator("addContentPermissionGroupByName"))) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.isValidPermissionType(permissionType)) {
            return this.toolsHelper.permissionTypeNotExist(permissionType);
        }
        JSONObject jsonObject = new JSONObject(jsonString);
        ArrayList<String> contentList = this.toolsHelper.getJSONarray(jsonObject, "contents");
        ArrayList<String> added = new ArrayList<String>();
        ArrayList<String> skipped = new ArrayList<String>();
        for (String contentName : contentList) {
            Page page = this.toolsHelper.getPageFormPageDao(spaceKey, contentName);
            if (page != null) {
                if (log.isDebugEnabled()) {
                    log.debug("groupName :: " + groupName);
                    log.debug("contentId :: " + contentName);
                    log.debug("permissionType :: " + permissionType);
                }
                boolean skippedFlag = false;
                skippedFlag = permissionType.equals("edit") ? this.addGroupContentPermission("Edit", (ContentEntityObject)page, groupName) : this.addGroupContentPermission("View", (ContentEntityObject)page, groupName);
                if (skippedFlag) {
                    skipped.add(contentName);
                    continue;
                }
                added.add(contentName);
                continue;
            }
            skipped.add(contentName);
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("skipped", skipped);
        response.put("added", added);
        response.put("total", added.size());
        response.put("status", "done");
        return Response.ok(response).build();
    }

    private Response addGroupContentIdPermission(String groupName, String jsonString, String permissionType, String spaceKey) throws EntityException {
        groupName = this.toolsHelper.decodeUrlParam(groupName);
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (this.groupManager.getGroup(groupName) == null) {
            return this.toolsHelper.groupNotExit(groupName);
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.isValidPermissionType(permissionType)) {
            return this.toolsHelper.permissionTypeNotExist(permissionType);
        }
        JSONObject jsonObject = new JSONObject(jsonString);
        ArrayList<Long> contentList = this.toolsHelper.getLongJSONarray(jsonObject, "contents");
        ArrayList<Long> added = new ArrayList<Long>();
        ArrayList<Long> skipped = new ArrayList<Long>();
        for (Long contentId : contentList) {
            Page page = this.toolsHelper.getPageFormPageDao(contentId);
            if (page != null && this.toolsHelper.skipParamSpaceValidation(spaceKey, page)) {
                if (log.isDebugEnabled()) {
                    log.debug("groupName :: " + groupName);
                    log.debug("contentId :: " + contentId);
                    log.debug("permissionType :: " + permissionType);
                }
                boolean skippedFlag = false;
                skippedFlag = permissionType.equals("edit") ? this.addGroupContentPermission("Edit", (ContentEntityObject)page, groupName) : this.addGroupContentPermission("View", (ContentEntityObject)page, groupName);
                if (skippedFlag) {
                    skipped.add(contentId);
                    continue;
                }
                added.add(contentId);
                continue;
            }
            skipped.add(contentId);
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("skipped", skipped);
        response.put("added", added);
        response.put("total", added.size());
        response.put("status", "done");
        return Response.ok(response).build();
    }

    private boolean addGroupContentPermission(String permissionType, ContentEntityObject contentObject, String groupName) {
        if (!this.groupIsAddedToContentPermission(contentObject, permissionType, groupName)) {
            ContentPermission newPermission = ContentPermission.createGroupPermission((String)permissionType, (String)groupName);
            this.contentPermissionManager.addContentPermission(newPermission, contentObject);
            return false;
        }
        return true;
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/content/user/{userName}/permission/{permissionType}/addContentPermission")
    public Response addUserContentIdPermissionView(String jsonString, @PathParam(value="userName") String userName, @PathParam(value="permissionType") String permissionType, @QueryParam(value="spaceKey") String spaceKey) {
        return this.addUserContentIdPermission(userName, jsonString, permissionType, spaceKey);
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/content/user/{userName}/permission/{permissionType}/space/{spaceKey}/addContentPermission")
    public Response addUserContentNamePermissionView(String jsonString, @PathParam(value="userName") String userName, @PathParam(value="permissionType") String permissionType, @PathParam(value="spaceKey") String spaceKey) {
        return this.addUserContentNamePermission(userName, spaceKey, jsonString, permissionType);
    }

    private Response addUserContentIdPermission(String userName, String jsonString, String permissionType, String spaceKey) {
        userName = this.toolsHelper.decodeUrlParam(userName);
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!this.toolsHelper.isUserExistByName(userName)) {
            return this.toolsHelper.userNotFound(userName);
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.isValidPermissionType(permissionType)) {
            return this.toolsHelper.permissionTypeNotExist(permissionType);
        }
        JSONObject jsonObject = new JSONObject(jsonString);
        ArrayList<Long> contentList = this.toolsHelper.getLongJSONarray(jsonObject, "contents");
        ArrayList<Long> added = new ArrayList<Long>();
        ArrayList<Long> skipped = new ArrayList<Long>();
        for (Long contentId : contentList) {
            Page page = this.toolsHelper.getPageFormPageDao(contentId);
            if (page != null && this.toolsHelper.skipParamSpaceValidation(spaceKey, page)) {
                if (log.isDebugEnabled()) {
                    log.debug("userName :: " + userName);
                    log.debug("contentId :: " + contentId);
                }
                boolean skippedFlag = false;
                ConfluenceUser confluenceUser = this.userAccessor.getUserByName(userName);
                skippedFlag = permissionType.equals("edit") ? this.addUserContentPermission("Edit", (ContentEntityObject)page, confluenceUser) : this.addUserContentPermission("View", (ContentEntityObject)page, confluenceUser);
                if (skippedFlag) {
                    skipped.add(contentId);
                    continue;
                }
                added.add(contentId);
                continue;
            }
            skipped.add(contentId);
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("skipped", skipped);
        response.put("added", added);
        response.put("total", added.size());
        response.put("status", "done");
        return Response.ok(response).build();
    }

    private Response addUserContentNamePermission(String userName, String spaceKey, String jsonString, String permissionType) {
        userName = this.toolsHelper.decodeUrlParam(userName);
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!this.toolsHelper.isUserExistByName(userName)) {
            return this.toolsHelper.userNotFound(userName);
        }
        Space space = this.toolsHelper.getSpaceFromSpaceDao(spaceKey);
        if (space == null) {
            return this.toolsHelper.spaceNotExist(spaceKey);
        }
        if (!(this.toolsHelper.isConfluenceAdministrator() || this.toolsHelper.isCurrentUserIsSpaceAdministrator(space) || this.toolsHelper.isDisabledForSpaceAdministrator("addContentPermissionUserByName"))) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.isValidPermissionType(permissionType)) {
            return this.toolsHelper.permissionTypeNotExist(permissionType);
        }
        JSONObject jsonObject = new JSONObject(jsonString);
        ArrayList<String> contentList = this.toolsHelper.getJSONarray(jsonObject, "contents");
        ArrayList<String> added = new ArrayList<String>();
        ArrayList<String> skipped = new ArrayList<String>();
        for (String contentName : contentList) {
            Page page = this.toolsHelper.getPageFormPageDao(spaceKey, contentName);
            if (page != null) {
                if (log.isDebugEnabled()) {
                    log.debug("userName :: " + userName);
                    log.debug("spaceKey :: " + spaceKey);
                    log.debug("contentName :: " + contentName);
                    log.debug("contentName :: " + contentName.replaceAll("@hash@", "#").replaceAll("@HASH@", "#"));
                }
                boolean skippedFlag = false;
                ConfluenceUser confluenceUser = this.userAccessor.getUserByName(userName);
                skippedFlag = permissionType.equals("edit") ? this.addUserContentPermission("Edit", (ContentEntityObject)page, confluenceUser) : this.addUserContentPermission("View", (ContentEntityObject)page, confluenceUser);
                if (skippedFlag) {
                    skipped.add(contentName);
                    continue;
                }
                added.add(contentName);
                continue;
            }
            skipped.add(contentName);
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("skipped", skipped);
        response.put("added", added);
        response.put("total", added.size());
        response.put("status", "done");
        return Response.ok(response).build();
    }

    private boolean addUserContentPermission(String permissionType, ContentEntityObject contentObject, ConfluenceUser user) {
        if (!this.userIsAddedToContentPermission(contentObject, permissionType, user)) {
            ContentPermission permission = ContentPermission.createUserPermission((String)permissionType, (ConfluenceUser)user);
            this.contentPermissionManager.addContentPermission(permission, contentObject);
            return false;
        }
        return true;
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/content/group/{groupName}/permission/{permissionType}/removeContentPermission")
    public Response removeGroupContentIdPermissionView(String jsonString, @PathParam(value="groupName") String groupName, @PathParam(value="permissionType") String permissionType, @QueryParam(value="spaceKey") String spaceKey) throws EntityException {
        return this.removeGroupContentIdPermission(groupName, jsonString, permissionType, spaceKey);
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/content/group/{groupName}/permission/{permissionType}/space/{spaceKey}/removeContentPermission")
    public Response removeGroupContentNamePermissionView(String jsonString, @PathParam(value="groupName") String groupName, @PathParam(value="permissionType") String permissionType, @PathParam(value="spaceKey") String spaceKey) throws EntityException {
        return this.removeGroupContentNamePermission(groupName, spaceKey, jsonString, permissionType);
    }

    private Response removeGroupContentNamePermission(String groupName, String spaceKey, String jsonString, String permissionType) throws EntityException {
        groupName = this.toolsHelper.decodeUrlParam(groupName);
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (this.groupManager.getGroup(groupName) == null) {
            return this.toolsHelper.groupNotExit(groupName);
        }
        Space space = this.toolsHelper.getSpaceFromSpaceDao(spaceKey);
        if (space == null) {
            return this.toolsHelper.spaceNotExist(spaceKey);
        }
        if (!(this.toolsHelper.isConfluenceAdministrator() || this.toolsHelper.isCurrentUserIsSpaceAdministrator(space) || this.toolsHelper.isDisabledForSpaceAdministrator("removeContentPermissionGroupByName"))) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.isValidPermissionType(permissionType)) {
            return this.toolsHelper.permissionTypeNotExist(permissionType);
        }
        JSONObject jsonObject = new JSONObject(jsonString);
        ArrayList<String> contentList = this.toolsHelper.getJSONarray(jsonObject, "contents");
        ArrayList<String> removed = new ArrayList<String>();
        ArrayList<String> skipped = new ArrayList<String>();
        for (String contentName : contentList) {
            Page page = this.toolsHelper.getPageFormPageDao(spaceKey, contentName);
            if (page != null) {
                if (log.isDebugEnabled()) {
                    log.debug("groupName :: " + groupName);
                    log.debug("spaceKey :: " + spaceKey);
                    log.debug("contentName :: " + contentName);
                    log.debug("contentName :: " + contentName.replaceAll("@hash@", "#").replaceAll("@HASH@", "#"));
                }
                boolean skippedFlag = false;
                skippedFlag = permissionType.equalsIgnoreCase("edit") ? this.removeGroupContentPermission("Edit", (ContentEntityObject)page, groupName) : this.removeGroupContentPermission("View", (ContentEntityObject)page, groupName);
                if (skippedFlag) {
                    skipped.add(contentName);
                    continue;
                }
                removed.add(contentName);
                continue;
            }
            skipped.add(contentName);
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("skipped", skipped);
        response.put("removed", removed);
        response.put("total", removed.size());
        response.put("status", "done");
        return Response.ok(response).build();
    }

    private Response removeGroupContentIdPermission(String groupName, String jsonString, String permissionType, String spaceKey) throws EntityException {
        groupName = this.toolsHelper.decodeUrlParam(groupName);
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (this.groupManager.getGroup(groupName) == null) {
            return this.toolsHelper.groupNotExit(groupName);
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.isValidPermissionType(permissionType)) {
            return this.toolsHelper.permissionTypeNotExist(permissionType);
        }
        JSONObject jsonObject = new JSONObject(jsonString);
        ArrayList<Long> contentList = this.toolsHelper.getLongJSONarray(jsonObject, "contents");
        ArrayList<Long> removed = new ArrayList<Long>();
        ArrayList<Long> skipped = new ArrayList<Long>();
        for (Long contentId : contentList) {
            Page page = this.toolsHelper.getPageFormPageDao(contentId);
            if (page != null && this.toolsHelper.skipParamSpaceValidation(spaceKey, page)) {
                if (log.isDebugEnabled()) {
                    log.debug("groupName :: " + groupName);
                    log.debug("contentId :: " + contentId);
                    log.debug("permissionType :: " + permissionType);
                }
                boolean skippedFlag = false;
                skippedFlag = permissionType.equalsIgnoreCase("edit") ? this.removeGroupContentPermission("Edit", (ContentEntityObject)page, groupName) : this.removeGroupContentPermission("View", (ContentEntityObject)page, groupName);
                if (skippedFlag) {
                    skipped.add(contentId);
                    continue;
                }
                removed.add(contentId);
                continue;
            }
            skipped.add(contentId);
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("skipped", skipped);
        response.put("removed", removed);
        response.put("total", removed.size());
        response.put("status", "done");
        return Response.ok(response).build();
    }

    private boolean removeGroupContentPermission(String permissionType, ContentEntityObject contentObject, String groupName) {
        List permissions = this.contentPermissionManager.getContentPermissionSets(contentObject, permissionType);
        ArrayList<ContentPermission> contentPermissionToRemove = new ArrayList<ContentPermission>();
        for (ContentPermissionSet contentPermissionSet : permissions) {
            if (contentPermissionSet.getOwningContent().getId() != contentObject.getId()) continue;
            for (ContentPermission contentPermission : this.toolsHelper.getContentPermissionsCopy(contentPermissionSet)) {
                if (!contentPermission.isGroupPermission() || !contentPermission.getType().equals(permissionType) || !contentPermission.getGroupName().equals(groupName)) continue;
                contentPermissionToRemove.add(contentPermission);
            }
        }
        for (ContentPermission contentPermission : contentPermissionToRemove) {
            this.contentPermissionManager.removeContentPermission(contentPermission);
        }
        return contentPermissionToRemove.isEmpty();
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/content/user/{userName}/permission/{permissionType}/removeContentPermission")
    public Response removeUserContentIdPermissionView(String jsonString, @PathParam(value="userName") String userName, @PathParam(value="permissionType") String permissionType) {
        return this.removeUserContentIdPermission(userName, jsonString, permissionType);
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/content/user/{userName}/permission/{permissionType}/space/{spaceKey}/removeContentPermission")
    public Response removeUserContentNamePermissionView(String jsonString, @PathParam(value="userName") String userName, @PathParam(value="permissionType") String permissionType, @PathParam(value="spaceKey") String spaceKey) {
        return this.removeUserContentNamePermission(userName, spaceKey, jsonString, permissionType);
    }

    private Response removeUserContentNamePermission(String userName, String spaceKey, String jsonString, String permissionType) {
        userName = this.toolsHelper.decodeUrlParam(userName);
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!this.toolsHelper.isUserExistByName(userName)) {
            return this.toolsHelper.userNotFound(userName);
        }
        Space space = this.toolsHelper.getSpaceFromSpaceDao(spaceKey);
        if (space == null) {
            return this.toolsHelper.spaceNotExist(spaceKey);
        }
        if (!(this.toolsHelper.isConfluenceAdministrator() || this.toolsHelper.isCurrentUserIsSpaceAdministrator(space) || this.toolsHelper.isDisabledForSpaceAdministrator("removeContentPermissionUserByName"))) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.isValidPermissionType(permissionType)) {
            return this.toolsHelper.permissionTypeNotExist(permissionType);
        }
        JSONObject jsonObject = new JSONObject(jsonString);
        ArrayList<String> contentList = this.toolsHelper.getJSONarray(jsonObject, "contents");
        ArrayList<String> removed = new ArrayList<String>();
        ArrayList<String> skipped = new ArrayList<String>();
        for (String contentName : contentList) {
            Page page = this.toolsHelper.getPageFormPageDao(spaceKey, contentName);
            if (page != null) {
                removed.add(contentName);
                if (log.isDebugEnabled()) {
                    log.debug("userName :: " + userName);
                    log.debug("spaceKey :: " + spaceKey);
                    log.debug("contentName :: " + contentName);
                    log.debug("contentName :: " + contentName.replaceAll("@hash@", "#").replaceAll("@HASH@", "#"));
                }
                ConfluenceUser confluenceUser = this.userAccessor.getUserByName(userName);
                if (permissionType.equalsIgnoreCase("edit")) {
                    this.removeUserContentPermission("Edit", (ContentEntityObject)page, confluenceUser);
                    continue;
                }
                this.removeUserContentPermission("View", (ContentEntityObject)page, confluenceUser);
                continue;
            }
            skipped.add(contentName);
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("skipped", skipped);
        response.put("removed", removed);
        response.put("total", removed.size());
        response.put("status", "done");
        return Response.ok(response).build();
    }

    private Response removeUserContentIdPermission(String userName, String jsonString, String permissionType) {
        userName = this.toolsHelper.decodeUrlParam(userName);
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!this.toolsHelper.isUserExistByName(userName)) {
            return this.toolsHelper.userNotFound(userName);
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.isValidPermissionType(permissionType)) {
            return this.toolsHelper.permissionTypeNotExist(permissionType);
        }
        JSONObject jsonObject = new JSONObject(jsonString);
        ArrayList<Long> contentList = this.toolsHelper.getLongJSONarray(jsonObject, "contents");
        ArrayList<Long> removed = new ArrayList<Long>();
        ArrayList<Long> skipped = new ArrayList<Long>();
        for (Long contentId : contentList) {
            Page page = this.toolsHelper.getPageFormPageDao(contentId);
            if (page != null) {
                removed.add(contentId);
                if (log.isDebugEnabled()) {
                    log.debug("userName :: " + userName);
                    log.debug("contentId :: " + contentId);
                }
                ConfluenceUser confluenceUser = this.userAccessor.getUserByName(userName);
                if (permissionType.equals("edit")) {
                    this.removeUserContentPermission("Edit", (ContentEntityObject)page, confluenceUser);
                    continue;
                }
                this.removeUserContentPermission("View", (ContentEntityObject)page, confluenceUser);
                continue;
            }
            skipped.add(contentId);
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("skipped", skipped);
        response.put("removed", removed);
        response.put("total", removed.size());
        response.put("status", "done");
        return Response.ok(response).build();
    }

    private void removeUserContentPermission(String permissionType, ContentEntityObject contentObject, ConfluenceUser user) {
        List permissions = this.contentPermissionManager.getContentPermissionSets(contentObject, permissionType);
        ArrayList<ContentPermission> contentPermissionToRemove = new ArrayList<ContentPermission>();
        for (ContentPermissionSet contentPermissionSet : permissions) {
            if (contentPermissionSet.getOwningContent().getId() != contentObject.getId()) continue;
            for (ContentPermission contentPermission : this.toolsHelper.getContentPermissionsCopy(contentPermissionSet)) {
                if (!contentPermission.isUserPermission() || !contentPermission.getUserSubject().getKey().equals((Object)user.getKey())) continue;
                contentPermissionToRemove.add(contentPermission);
            }
        }
        for (ContentPermission contentPermission : contentPermissionToRemove) {
            this.contentPermissionManager.removeContentPermission(contentPermission);
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/content/{contentId}/user/{userName}/getContentPermission")
    public Response getUserContentRestrictionsPageAll(@PathParam(value="userName") String userName, @PathParam(value="contentId") Long contentId, @QueryParam(value="showContentDetails") boolean showContentDetails, @QueryParam(value="spaceKey") String spaceKey) {
        return this.getUserContentWithRestrictions(userName, contentId, showContentDetails, false, false, false, spaceKey);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/content/{contentName}/user/{userName}/space/{spaceKey}/getContentPermission")
    public Response getUserContentRestrictionsPageByNameAll(@PathParam(value="userName") String userName, @PathParam(value="spaceKey") String spaceKey, @PathParam(value="contentName") String contentName, @QueryParam(value="showContentDetails") boolean showContentDetails) {
        return this.getUserContentWithRestrictionsByName(userName, spaceKey, contentName, showContentDetails, false, false, false);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/content/{contentId}/group/{groupName}/getContentPermission")
    public Response getGroupContentRestrictionsPageAll(@PathParam(value="groupName") String groupName, @PathParam(value="contentId") Long contentId, @QueryParam(value="showContentDetails") boolean showContentDetails, @QueryParam(value="spaceKey") String spaceKey) throws EntityException {
        return this.getGroupContentWithRestrictions(groupName, contentId, showContentDetails, false, false, false, spaceKey);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/content/{contentName}/group/{groupName}/space/{spaceKey}/getContentPermission")
    public Response getGroupContentRestrictionsPageByNameAll(@PathParam(value="groupName") String groupName, @PathParam(value="spaceKey") String spaceKey, @PathParam(value="contentName") String contentName, @QueryParam(value="showContentDetails") boolean showContentDetails) throws EntityException {
        return this.getGroupContentWithRestrictionsByName(groupName, spaceKey, contentName, showContentDetails, false, false, false);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/content/{contentId}/user/{userName}/getInheritedContentPermission")
    public Response getUserInheriteContentRestrictionsPageAll(@PathParam(value="userName") String userName, @PathParam(value="contentId") Long contentId, @QueryParam(value="showContentDetails") boolean showContentDetails, @QueryParam(value="showSpaceAdministrators") boolean showSpaceAdministrators, @QueryParam(value="showBasicDetails") boolean showBasicDetails, @QueryParam(value="spaceKey") String spaceKey) {
        return this.getUserContentWithRestrictions(userName, contentId, showContentDetails, true, showSpaceAdministrators, showBasicDetails, spaceKey);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/content/{contentName}/user/{userName}/space/{spaceKey}/getInheritedContentPermission")
    public Response getUserInheriteContentRestrictionsPageByNameAll(@PathParam(value="userName") String userName, @PathParam(value="spaceKey") String spaceKey, @PathParam(value="contentName") String contentName, @QueryParam(value="showContentDetails") boolean showContentDetails, @QueryParam(value="showSpaceAdministrators") boolean showSpaceAdministrators, @QueryParam(value="showBasicDetails") boolean showBasicDetails) {
        return this.getUserContentWithRestrictionsByName(userName, spaceKey, contentName, showContentDetails, true, showSpaceAdministrators, showBasicDetails);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/content/{contentId}/group/{groupName}/getInheritedContentPermission")
    public Response getGroupInheriteGroupContentRestrictionsPageAll(@PathParam(value="groupName") String groupName, @PathParam(value="contentId") Long contentId, @QueryParam(value="showContentDetails") boolean showContentDetails, @QueryParam(value="showSpaceAdministrators") boolean showSpaceAdministrators, @QueryParam(value="showBasicDetails") boolean showBasicDetails, @QueryParam(value="spaceKey") String spaceKey) throws EntityException {
        return this.getGroupContentWithRestrictions(groupName, contentId, showContentDetails, true, showSpaceAdministrators, showBasicDetails, spaceKey);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/content/{contentName}/group/{groupName}/space/{spaceKey}/getInheritedContentPermission")
    public Response getGroupInheriteGroupContentRestrictionsPageByNameAll(@PathParam(value="groupName") String groupName, @PathParam(value="spaceKey") String spaceKey, @PathParam(value="contentName") String contentName, @QueryParam(value="showContentDetails") boolean showContentDetails, @QueryParam(value="showSpaceAdministrators") boolean showSpaceAdministrators, @QueryParam(value="showBasicDetails") boolean showBasicDetails) throws EntityException {
        return this.getGroupContentWithRestrictionsByName(groupName, spaceKey, contentName, showContentDetails, true, showSpaceAdministrators, showBasicDetails);
    }

    private Response getGroupContentWithRestrictionsByName(String groupName, String spaceKey, String contentName, boolean showContentDetails, boolean contentTree, boolean showSpaceAdministrators, boolean showBasicDetails) throws EntityException {
        Page page;
        groupName = this.toolsHelper.decodeUrlParam(groupName);
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.groupManager.getGroup(groupName) == null) {
            return this.toolsHelper.groupNotExit(groupName);
        }
        Space space = this.toolsHelper.getSpaceFromSpaceDao(spaceKey);
        if (space == null) {
            return this.toolsHelper.spaceNotExist(spaceKey);
        }
        if (!this.toolsHelper.isConfluenceAdministrator() && !this.toolsHelper.isCurrentUserIsSpaceAdministrator(space)) {
            return this.toolsHelper.permissionViolation();
        }
        if (log.isDebugEnabled()) {
            log.debug("groupName :: " + groupName);
            log.debug("spaceKey :: " + spaceKey);
            log.debug("contentTree :: " + contentTree);
            log.debug("contentName :: " + contentName);
            log.debug("contentName :: " + contentName.replaceAll("@hash@", "#").replaceAll("@HASH@", "#"));
        }
        if ((page = this.toolsHelper.getPageFormPageDao(spaceKey, contentName.replaceAll("@hash@", "#").replaceAll("@HASH@", "#"))) == null) {
            return this.toolsHelper.contentNameNotExist(contentName);
        }
        return this.getGroupContentWithRestrictionsGlobal(page, groupName, showContentDetails, contentTree, showSpaceAdministrators, showBasicDetails);
    }

    private Response getGroupContentWithRestrictions(String groupName, Long contentId, boolean showContentDetails, boolean contentTree, boolean showSpaceAdministrators, boolean showBasicDetails, String spaceKey) throws EntityException {
        groupName = this.toolsHelper.decodeUrlParam(groupName);
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.groupManager.getGroup(groupName) == null) {
            return this.toolsHelper.groupNotExit(groupName);
        }
        Page page = this.toolsHelper.getPageFormPageDao(contentId);
        if (page == null) {
            return this.toolsHelper.contentIdNotExist(contentId);
        }
        if (!this.toolsHelper.isConfluenceAdministrator() && !this.toolsHelper.isCurrentUserIsSpaceAdministrator(page.getSpace())) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.toolsHelper.skipParamSpaceValidation(spaceKey, page)) {
            return this.toolsHelper.permissionViolation();
        }
        if (log.isDebugEnabled()) {
            log.debug("groupName :: " + groupName);
            log.debug("contentId :: " + contentId);
            log.debug("contentTree :: " + contentTree);
        }
        return this.getGroupContentWithRestrictionsGlobal(page, groupName, showContentDetails, contentTree, showSpaceAdministrators, showBasicDetails);
    }

    private Response getGroupContentWithRestrictionsGlobal(Page page, String groupName, boolean showContentDetails, boolean contentTree, boolean showSpaceAdministrators, boolean showBasicDetails) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        boolean hasSpaceViewPermission = this.spaceHasAnonymousPermission(page.getSpace(), "VIEWSPACE") ? true : this.groupHasSpacePermission(groupName, page.getSpace(), "VIEWSPACE");
        boolean hasSpaceEditPermission = this.spaceHasAnonymousPermission(page.getSpace(), "EDITSPACE") ? true : this.groupHasSpacePermission(groupName, page.getSpace(), "EDITSPACE");
        response.put("contentId", page.getId());
        if (showContentDetails) {
            response.put("spaceKey", page.getSpace().getKey());
            response.put("spaceName", page.getSpace().getName());
            response.put("contentName", page.getTitle());
            response.put("contentType", page.getContentTypeObject().getType());
            response.put("contentCreatorName", page.getCreator() != null ? page.getCreator().getName() : "not exist");
        }
        boolean inheriteViewPermission = hasSpaceViewPermission;
        boolean inheriteEditPermission = hasSpaceEditPermission;
        if (contentTree) {
            response.put("hasSpaceViewPermission", hasSpaceViewPermission);
            response.put("hasSpaceEditPermission", hasSpaceEditPermission);
            ArrayList<Page> tree = new ArrayList<Page>();
            if (page.getParent() != null) {
                this.buildTree(tree, page);
            } else {
                tree.add(page);
            }
            Collections.reverse(tree);
            int level = 1;
            ArrayList treeArray = new ArrayList();
            for (Page pageFromTree : tree) {
                HashMap<String, Object> treeMap = new HashMap<String, Object>();
                inheriteViewPermission = inheriteViewPermission ? this.groupHasInheritedContentPermission(inheriteViewPermission, groupName, "View", (ContentEntityObject)pageFromTree) : false;
                boolean bl = inheriteEditPermission = hasSpaceEditPermission ? this.groupHasInheritedContentPermission(inheriteViewPermission, groupName, "Edit", (ContentEntityObject)pageFromTree) : false;
                if (showContentDetails) {
                    treeMap.put("contentName", pageFromTree.getTitle());
                    treeMap.put("contentType", pageFromTree.getContentTypeObject().getType());
                    treeMap.put("contentCreatorName", pageFromTree.getCreator() != null ? pageFromTree.getCreator().getName() : "not exist");
                }
                treeMap.put("contentId", pageFromTree.getId());
                treeMap.put("level", level);
                treeMap.put("hasContentViewPermission", inheriteViewPermission);
                treeMap.put("hasContentEditPermission", inheriteEditPermission);
                ++level;
                treeArray.add(treeMap);
            }
            response.put("hasContentViewPermission", inheriteViewPermission);
            response.put("hasContentEditPermission", inheriteEditPermission);
            response.put("contentTree", treeArray);
        } else {
            response.put("hasContentViewPermission", this.groupHasContentPermission(groupName, "View", (ContentEntityObject)page));
            response.put("hasContentEditPermission", this.groupHasContentPermission(groupName, "Edit", (ContentEntityObject)page));
        }
        if (showSpaceAdministrators) {
            response.put("spaceAdministrators", this.getSpaceAdministrators(page.getSpace(), showBasicDetails));
        }
        return Response.ok(response).build();
    }

    private Response getUserContentWithRestrictionsByName(String userName, String spaceKey, String contentName, boolean showContentDetails, boolean contentTree, boolean showSpaceAdministrators, boolean showBasicDetails) {
        Page page;
        userName = this.toolsHelper.decodeUrlParam(userName);
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (!this.toolsHelper.isUserExistByName(userName)) {
            return this.toolsHelper.userNotFound(userName);
        }
        Space space = this.toolsHelper.getSpaceFromSpaceDao(spaceKey);
        if (space == null) {
            return this.toolsHelper.spaceNotExist(spaceKey);
        }
        if (!this.toolsHelper.isConfluenceAdministrator() && !this.toolsHelper.isCurrentUserIsSpaceAdministrator(space)) {
            return this.toolsHelper.permissionViolation();
        }
        if (log.isDebugEnabled()) {
            log.debug("userName :: " + userName);
            log.debug("spaceKey :: " + spaceKey);
            log.debug("contentName :: " + contentName);
            log.debug("contentName :: " + contentName.replaceAll("@hash@", "#").replaceAll("@HASH@", "#"));
        }
        if ((page = this.toolsHelper.getPageFormPageDao(spaceKey, contentName.replaceAll("@hash@", "#").replaceAll("@HASH@", "#"))) == null) {
            return this.toolsHelper.contentNameNotExist(contentName);
        }
        return this.getUserContentWithRestrictionsGlobal(page, userName, showContentDetails, contentTree, showSpaceAdministrators, showBasicDetails);
    }

    private Response getUserContentWithRestrictions(String userName, Long contentId, boolean showContentDetails, boolean contentTree, boolean showSpaceAdministrators, boolean showBasicDetails, String spaceKey) {
        userName = this.toolsHelper.decodeUrlParam(userName);
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (!this.toolsHelper.isUserExistByName(userName)) {
            return this.toolsHelper.userNotFound(userName);
        }
        Page page = this.toolsHelper.getPageFormPageDao(contentId);
        if (page == null) {
            return this.toolsHelper.contentIdNotExist(contentId);
        }
        if (!this.toolsHelper.isConfluenceAdministrator() && !this.toolsHelper.isCurrentUserIsSpaceAdministrator(page.getSpace())) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.toolsHelper.skipParamSpaceValidation(spaceKey, page)) {
            return this.toolsHelper.permissionViolation();
        }
        if (log.isDebugEnabled()) {
            log.debug("userName :: " + userName);
            log.debug("contentId :: " + contentId);
        }
        return this.getUserContentWithRestrictionsGlobal(page, userName, showContentDetails, contentTree, showSpaceAdministrators, showBasicDetails);
    }

    private Response getUserContentWithRestrictionsGlobal(Page page, String userName, boolean showContentDetails, boolean contentTree, boolean showSpaceAdministrators, boolean showBasicDetails) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        User user = this.toolsHelper.getUserByName(userName);
        boolean hasSpaceViewPermission = this.spaceHasAnonymousPermission(page.getSpace(), "VIEWSPACE") ? true : this.toolsHelper.getSpacePermissionManager().hasPermission("VIEWSPACE", page.getSpace(), user);
        boolean hasSpaceEditPermission = this.spaceHasAnonymousPermission(page.getSpace(), "EDITSPACE") ? true : this.toolsHelper.getSpacePermissionManager().hasPermission("EDITSPACE", page.getSpace(), user);
        response.put("contentId", page.getId());
        if (showContentDetails) {
            response.put("spaceKey", page.getSpace().getKey());
            response.put("spaceName", page.getSpace().getName());
            response.put("contentName", page.getTitle());
            response.put("contentType", page.getContentTypeObject().getType());
            response.put("contentCreatorName", page.getCreator() != null ? page.getCreator().getName() : "not exist");
        }
        boolean inheriteViewPermission = hasSpaceViewPermission;
        boolean inheriteEditPermission = hasSpaceEditPermission;
        if (contentTree) {
            response.put("hasSpaceViewPermission", hasSpaceViewPermission);
            response.put("hasSpaceEditPermission", hasSpaceEditPermission);
            ArrayList<Page> tree = new ArrayList<Page>();
            if (page.getParent() != null) {
                this.buildTree(tree, page);
            } else {
                tree.add(page);
            }
            Collections.reverse(tree);
            int level = 1;
            ArrayList treeArray = new ArrayList();
            for (Page pageFromTree : tree) {
                HashMap<String, Object> treeMap = new HashMap<String, Object>();
                inheriteViewPermission = inheriteViewPermission ? this.userHasInheritedContentPermissionPersonalOrGroup(user, "View", (ContentEntityObject)pageFromTree) : false;
                boolean bl = inheriteEditPermission = hasSpaceEditPermission ? this.userHasInheritedContentPermissionPersonalOrGroup(user, "Edit", (ContentEntityObject)pageFromTree) : false;
                if (showContentDetails) {
                    treeMap.put("contentName", pageFromTree.getTitle());
                    treeMap.put("contentType", pageFromTree.getContentTypeObject().getType());
                    treeMap.put("contentCreatorName", pageFromTree.getCreator() != null ? pageFromTree.getCreator().getName() : "not exist");
                }
                treeMap.put("contentId", pageFromTree.getId());
                treeMap.put("level", level);
                treeMap.put("hasContentViewPermission", inheriteViewPermission);
                treeMap.put("hasContentEditPermission", inheriteEditPermission);
                ++level;
                treeArray.add(treeMap);
            }
            response.put("hasContentViewPermission", inheriteViewPermission);
            response.put("hasContentEditPermission", inheriteEditPermission);
            response.put("contentTree", treeArray);
        } else {
            response.put("hasContentViewPermission", this.userIsAddedToContentPermission((ContentEntityObject)page, "View", userName));
            response.put("hasContentEditPermission", this.userIsAddedToContentPermission((ContentEntityObject)page, "Edit", userName));
        }
        if (showSpaceAdministrators) {
            response.put("spaceAdministrators", this.getSpaceAdministrators(page.getSpace(), showBasicDetails));
        }
        return Response.ok(response).build();
    }

    private boolean spaceHasAnonymousPermission(Space space, String permissionType) {
        List permissions = space.getPermissions();
        for (SpacePermission spacePermission : permissions) {
            if (!spacePermission.isAnonymousPermission() || !spacePermission.getType().equals(permissionType)) continue;
            return true;
        }
        return false;
    }

    private boolean groupHasSpacePermission(String groupName, Space space, String permissionType) {
        Map groupsWithPermissions = this.toolsHelper.getSpacePermissionManager().getGroupsForPermissionType(permissionType, space);
        if (log.isDebugEnabled()) {
            log.debug("groupsWithPermissions ::: " + groupsWithPermissions);
        }
        return groupsWithPermissions.get(groupName) != null;
    }

    private void buildTree(List<Page> tree, Page page) {
        tree.add(page);
        if (page.getParent() != null) {
            this.buildTree(tree, page.getParent());
        }
    }

    private boolean groupHasContentPermission(String groupName, String permissionType, ContentEntityObject contentObject) {
        List permissions = this.contentPermissionManager.getContentPermissionSets(contentObject, permissionType);
        if (permissions == null || permissions.isEmpty()) {
            return false;
        }
        for (ContentPermissionSet contentPermissionSet : permissions) {
            if (contentPermissionSet.getOwningContent().getId() != contentObject.getId()) continue;
            for (ContentPermission contentPermission : this.toolsHelper.getContentPermissionsCopy(contentPermissionSet)) {
                if (!contentPermission.isGroupPermission() || !contentPermission.getType().equals(permissionType) || !contentPermission.getGroupName().equals(groupName)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean groupHasInheritedContentPermission(boolean inheritePermission, String groupName, String permissionType, ContentEntityObject contentObject) {
        if (log.isDebugEnabled()) {
            log.debug(" check permission :: inheritePermission=" + inheritePermission);
            log.debug(" check permission :: groupName=" + groupName);
            log.debug(" check permission :: permissionType=" + permissionType);
            log.debug(" check permission :: contentObject=" + contentObject.getId());
        }
        if (!inheritePermission) {
            if (log.isDebugEnabled()) {
                log.debug(" return false :: inheritePermission=" + inheritePermission);
            }
            return false;
        }
        List permissions = this.contentPermissionManager.getContentPermissionSets(contentObject, permissionType);
        if (permissions == null || permissions.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug(" return true :: permissions.isEmpty()");
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug(" check permission  :: permissions=" + permissions.toString());
        }
        boolean permissionFound = false;
        for (ContentPermissionSet contentPermissionSet : permissions) {
            if (contentPermissionSet.getOwningContent().getId() != contentObject.getId()) continue;
            permissionFound = true;
            if (log.isDebugEnabled()) {
                log.debug(" check content :: content=" + contentObject.getId());
                log.debug(" check content :: getType=" + contentPermissionSet.getType());
            }
            if (contentPermissionSet.getType().equalsIgnoreCase("all")) {
                if (log.isDebugEnabled()) {
                    log.debug(" return true :: getType=" + contentPermissionSet.getType());
                }
                return true;
            }
            if (contentPermissionSet.getType().equalsIgnoreCase("edit")) {
                if (log.isDebugEnabled()) {
                    log.debug(" return ???? :: getType=" + contentPermissionSet.getType());
                    log.debug(" return ???? :: ContentPermission.VIEW_PERMISSION=View");
                }
                if (permissionType.equals("View")) {
                    return true;
                }
                for (ContentPermission contentPermission : this.toolsHelper.getContentPermissionsCopy(contentPermissionSet)) {
                    if (!contentPermission.isGroupPermission() || !contentPermission.getType().equals(permissionType) || !contentPermission.getGroupName().equals(groupName)) continue;
                    return true;
                }
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug(" return ???? :: getType=" + contentPermissionSet.getType());
            }
            for (ContentPermission contentPermission : this.toolsHelper.getContentPermissionsCopy(contentPermissionSet)) {
                if (!contentPermission.isGroupPermission() || !contentPermission.getType().equals(permissionType) || !contentPermission.getGroupName().equals(groupName)) continue;
                return true;
            }
        }
        if (!permissionFound && !permissions.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug(" check permission after for - inherite :: permissions=" + permissions.toString());
            }
            return true;
        }
        return false;
    }

    private boolean userIsAddedToContentPermission(ContentEntityObject contentObject, String permissionType, String userName) {
        ConfluenceUser confluenceUser = this.userAccessor.getUserByName(userName);
        return this.userIsAddedToContentPermission(contentObject, permissionType, confluenceUser);
    }

    private boolean userIsAddedToContentPermission(ContentEntityObject contentObject, String permissionType, ConfluenceUser user) {
        List permissions = this.contentPermissionManager.getContentPermissionSets(contentObject, permissionType);
        if (permissions == null || permissions.isEmpty()) {
            return false;
        }
        for (ContentPermissionSet contentPermissionSet : permissions) {
            if (contentPermissionSet.getOwningContent().getId() != contentObject.getId()) continue;
            for (ContentPermission contentPermission : this.toolsHelper.getContentPermissionsCopy(contentPermissionSet)) {
                if (!contentPermission.getType().equals(permissionType) || !contentPermission.isUserPermission() || !contentPermission.getUserSubject().getKey().equals((Object)user.getKey())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean groupIsAddedToContentPermission(ContentEntityObject contentObject, String permissionType, String groupName) {
        List permissions = this.contentPermissionManager.getContentPermissionSets(contentObject, permissionType);
        if (permissions == null || permissions.isEmpty()) {
            return false;
        }
        for (ContentPermissionSet contentPermissionSet : permissions) {
            if (contentPermissionSet.getOwningContent().getId() != contentObject.getId()) continue;
            for (ContentPermission contentPermission : this.toolsHelper.getContentPermissionsCopy(contentPermissionSet)) {
                if (!contentPermission.getType().equals(permissionType) || !contentPermission.isGroupPermission() || !contentPermission.getGroupName().equals(groupName)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean userHasInheritedContentPermissionPersonalOrGroup(User user, String permissionType, ContentEntityObject contentObject) {
        return this.contentPermissionManager.hasContentLevelPermission(user, permissionType, contentObject);
    }

    private boolean isValidPermissionType(String permissionType) {
        return permissionType.equalsIgnoreCase("view") || permissionType.equalsIgnoreCase("edit");
    }

    private boolean isValidGlobalPermissionType(String permissionType) {
        String tempPermissionType = permissionType.toUpperCase();
        return this.globalPermissions.contains(tempPermissionType);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/space/permissionTypes")
    public Response getSpacePermissions() {
        return Response.ok((Object)SpacePermission.GENERIC_SPACE_PERMISSIONS).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/space/{spaceKey}/allUsersWithAnyPermission")
    public Response getUsersWithPermForSpace(@PathParam(value="spaceKey") String spaceKey, @QueryParam(value="startAt") int startAt, @QueryParam(value="maxResults") int maxResults) throws EntityException {
        Space space;
        HashMap<String, Serializable> response = new HashMap<String, Serializable>();
        HashSet<String> usersList = new HashSet<String>();
        int iterator = 0;
        if (maxResults == 0) {
            maxResults = 100;
        }
        if ((space = this.toolsHelper.getSpaceFromSpaceDao(spaceKey)) == null) {
            return this.toolsHelper.spaceNotExist(spaceKey);
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (!this.toolsHelper.isConfluenceAdministrator() && !this.toolsHelper.isCurrentUserIsSpaceAdministrator(space)) {
            return this.toolsHelper.permissionViolation();
        }
        Map users = this.toolsHelper.getSpacePermissionManager().getUsersForPermissionType("VIEWSPACE", space);
        for (String userName : users.keySet()) {
            if (log.isDebugEnabled()) {
                log.debug("getUser : " + userName);
            }
            if (startAt <= iterator && iterator < startAt + maxResults) {
                usersList.add(userName);
            }
            ++iterator;
        }
        response.put("users", usersList);
        response.put("total", Integer.valueOf(users.size()));
        response.put("startAt", Integer.valueOf(startAt));
        response.put("maxResults", Integer.valueOf(maxResults));
        return Response.ok(response).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/space/{spaceKey}/allGroupsWithAnyPermission")
    public Response getGroupsWithPermForSpace(@PathParam(value="spaceKey") String spaceKey, @QueryParam(value="startAt") int startAt, @QueryParam(value="maxResults") int maxResults) throws EntityException {
        Space space;
        HashMap<String, Serializable> response = new HashMap<String, Serializable>();
        ArrayList<String> groupsList = new ArrayList<String>();
        int iterator = 0;
        if (maxResults == 0) {
            maxResults = 100;
        }
        if ((space = this.toolsHelper.getSpaceFromSpaceDao(spaceKey)) == null) {
            return this.toolsHelper.spaceNotExist(spaceKey);
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (!this.toolsHelper.isConfluenceAdministrator() && !this.toolsHelper.isCurrentUserIsSpaceAdministrator(space)) {
            return this.toolsHelper.permissionViolation();
        }
        Collection groups = this.toolsHelper.getSpacePermissionManager().getGroupsWithPermissions(space);
        for (Group group : groups) {
            if (startAt <= iterator && iterator < startAt + maxResults) {
                groupsList.add(group.getName());
            }
            ++iterator;
        }
        response.put("groups", groupsList);
        response.put("total", Integer.valueOf(groups.size()));
        response.put("startAt", Integer.valueOf(startAt));
        response.put("maxResults", Integer.valueOf(maxResults));
        return Response.ok(response).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/user/{userName}/getAllSpacesWithPermissions")
    public Response getAllSpacesPermissionForUser(@PathParam(value="userName") String userName, @QueryParam(value="startAt") int startAt, @QueryParam(value="maxResults") int maxResults, @QueryParam(value="spacesAsArray") boolean spacesAsArray, @QueryParam(value="spaceKey") String spaceKey) throws EntityException {
        userName = this.toolsHelper.decodeUrlParam(userName);
        HashMap<String, Serializable> response = new HashMap<String, Serializable>();
        HashMap spaces = new HashMap();
        ArrayList spacesArray = new ArrayList();
        int iterator = 0;
        if (maxResults == 0) {
            maxResults = 100;
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        Collection spacePermissions = SpacePermission.GENERIC_SPACE_PERMISSIONS;
        int total = 0;
        List<Space> spaceList = this.toolsHelper.getAllSpacesFormSpaceDao();
        if (spaceKey != null && !spaceKey.equals("")) {
            spaceList = new ArrayList<Space>();
            spaceList.add(this.toolsHelper.getSpaceFromSpaceDao(spaceKey));
        }
        for (Space space : spaceList) {
            HashMap<String, Object> spaceMap = new HashMap<String, Object>();
            Map users = this.toolsHelper.getSpacePermissionManager().getUsersForPermissionType("VIEWSPACE", space);
            if (users.get(userName) == null) continue;
            ArrayList<String> permissionList = new ArrayList<String>();
            ++total;
            if (startAt <= iterator && iterator < startAt + maxResults) {
                for (String spacePermission : spacePermissions) {
                    if (this.toolsHelper.getSpacePermissionManager().getUsersForPermissionType(spacePermission, space).get(userName) == null) continue;
                    permissionList.add(spacePermission);
                }
                spaceMap.put("permissions", permissionList);
                spaceMap.put("key", space.getKey());
                spaceMap.put("name", space.getName());
                if (spacesAsArray) {
                    spacesArray.add(spaceMap);
                } else {
                    spaces.put(space.getKey(), spaceMap);
                }
            }
            ++iterator;
        }
        response.put("startAt", Integer.valueOf(startAt));
        response.put("maxResults", Integer.valueOf(maxResults));
        if (spacesAsArray) {
            response.put("spaces", spacesArray);
        } else {
            response.put("spaces", spaces);
        }
        response.put("total", Integer.valueOf(total));
        return Response.ok(response).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/group/{groupName}/getAllSpacesWithPermissions")
    public Response getAllSpacesPermissionForGroup(@PathParam(value="groupName") String groupName, @QueryParam(value="startAt") int startAt, @QueryParam(value="maxResults") int maxResults, @QueryParam(value="spacesAsArray") boolean spacesAsArray, @QueryParam(value="spaceKey") String spaceKey) throws EntityException, UnsupportedEncodingException {
        groupName = this.toolsHelper.decodeUrlParam(groupName);
        HashMap<String, Serializable> response = new HashMap<String, Serializable>();
        HashMap spaces = new HashMap();
        ArrayList spacesArray = new ArrayList();
        int iterator = 0;
        if (maxResults == 0) {
            maxResults = 100;
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        if (this.groupManager.getGroup(groupName) == null) {
            return this.toolsHelper.groupNotExit(groupName);
        }
        List spacePermissions = this.toolsHelper.getSpacePermissionManager().getAllPermissionsForGroup(groupName);
        for (SpacePermission spacePermission : spacePermissions) {
            HashMap<String, Object> space = new HashMap<String, Object>();
            if (spacePermission.getSpace() == null) continue;
            String spaceKeyFromSpace = spacePermission.getSpace().getKey();
            String spaceName = spacePermission.getSpace().getName();
            List<String> permissionList = new ArrayList<String>();
            if (spaces.get(spaceKeyFromSpace) != null) {
                Map temp = (Map)spaces.get(spaceKeyFromSpace);
                permissionList = (List)temp.get("permissions");
            }
            permissionList.add(spacePermission.getType());
            space.put("permissions", permissionList);
            space.put("key", spaceKeyFromSpace);
            space.put("name", spaceName);
            if (!this.toolsHelper.skipParamSpaceValidation(spaceKey, spaceKeyFromSpace)) continue;
            spaces.put(spaceKeyFromSpace, space);
        }
        HashMap spaceToResponse = new HashMap();
        for (Map.Entry entry : spaces.entrySet()) {
            if (startAt <= iterator && iterator < startAt + maxResults) {
                spaceToResponse.put((String)entry.getKey(), entry.getValue());
            }
            ++iterator;
        }
        if (spacesAsArray) {
            for (Map.Entry entry : spaceToResponse.entrySet()) {
                spacesArray.add(entry.getValue());
            }
        }
        response.put("startAt", Integer.valueOf(startAt));
        response.put("maxResults", Integer.valueOf(maxResults));
        if (spacesAsArray) {
            response.put("spaces", spacesArray);
        } else {
            response.put("spaces", spaceToResponse);
        }
        response.put("total", Integer.valueOf(spaces.size()));
        return Response.ok(response).build();
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/space/{spaceKey}/user/{userName}/manageSpacePermissions")
    public Response manageUserSpacePermissions(String jsonString, @PathParam(value="userName") String userName, @PathParam(value="spaceKey") String spaceKey) throws EntityException {
        userName = this.toolsHelper.decodeUrlParam(userName);
        HashMap response = new HashMap();
        Space space = this.toolsHelper.getSpaceFromSpaceDao(spaceKey);
        if (space == null) {
            return this.toolsHelper.spaceNotExist(spaceKey);
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!(this.toolsHelper.isConfluenceAdministrator() || this.toolsHelper.isCurrentUserIsSpaceAdministrator(space) && !this.toolsHelper.isDisabledForSpaceAdministrator("manageSpacePermissionsForUser"))) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.toolsHelper.isUserExistByName(userName)) {
            return this.toolsHelper.userNotFound(userName);
        }
        JSONObject jsonObject = new JSONObject(jsonString);
        ArrayList<String> addPermissions = this.toolsHelper.getJSONarray(jsonObject, "addPermissions");
        ArrayList<String> removePermissions = this.toolsHelper.getJSONarray(jsonObject, "removePermissions");
        ArrayList<String> addedPermissions = new ArrayList<String>();
        User user = this.toolsHelper.getUserByName(userName);
        for (String permission : addPermissions) {
            if (!SpacePermission.PERMISSION_TYPES.contains(permission) || this.toolsHelper.getSpacePermissionManager().getUsersForPermissionType(permission, space).get(userName) != null) continue;
            SpacePermission newSpacePermission = SpacePermission.createUserSpacePermission((String)permission, (Space)space, (ConfluenceUser)((ConfluenceUser)user));
            this.toolsHelper.getSpacePermissionManager().savePermission(newSpacePermission);
            addedPermissions.add(permission);
        }
        ArrayList spacePermissionsToRemove = new ArrayList(space.getPermissions());
        ArrayList<String> removedPermissions = new ArrayList<String>();
        for (SpacePermission permission : spacePermissionsToRemove) {
            if (!permission.isUserPermission() || !permission.getUserSubject().getName().equalsIgnoreCase(userName) || !removePermissions.contains(permission.getType())) continue;
            this.toolsHelper.getSpacePermissionManager().removePermission(permission);
            removedPermissions.add(permission.getType());
        }
        response.put("addedPermissions", addedPermissions);
        response.put("removedPermissions", removedPermissions);
        return Response.ok(response).build();
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/space/{spaceKey}/user/{userName}/addSpacePermissions")
    public Response addUserPermissionToSpace(String jsonString, @PathParam(value="userName") String userName, @PathParam(value="spaceKey") String spaceKey) throws EntityException {
        userName = this.toolsHelper.decodeUrlParam(userName);
        HashMap<String, Serializable> response = new HashMap<String, Serializable>();
        Space space = this.toolsHelper.getSpaceFromSpaceDao(spaceKey);
        if (space == null) {
            return this.toolsHelper.spaceNotExist(spaceKey);
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!(this.toolsHelper.isConfluenceAdministrator() || this.toolsHelper.isCurrentUserIsSpaceAdministrator(space) && !this.toolsHelper.isDisabledForSpaceAdministrator("spaceAddPermissionForUser"))) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.toolsHelper.isUserExistByName(userName)) {
            return this.toolsHelper.userNotFound(userName);
        }
        JSONObject jsonObject = new JSONObject(jsonString);
        ArrayList<String> permissionsList = this.toolsHelper.getJSONarray(jsonObject, "permissions");
        ArrayList<String> added = new ArrayList<String>();
        ArrayList<String> skipped = new ArrayList<String>();
        User user = this.toolsHelper.getUserByName(userName);
        for (String permission : permissionsList) {
            if (!SpacePermission.PERMISSION_TYPES.contains(permission)) continue;
            if (this.toolsHelper.getSpacePermissionManager().getUsersForPermissionType(permission, space).get(userName) != null) {
                skipped.add(permission);
                continue;
            }
            SpacePermission newSpacePermission = SpacePermission.createUserSpacePermission((String)permission, (Space)space, (ConfluenceUser)((ConfluenceUser)user));
            this.toolsHelper.getSpacePermissionManager().savePermission(newSpacePermission);
            added.add(permission);
        }
        response.put("added", added);
        response.put("skipped", skipped);
        response.put("total", Integer.valueOf(added.size()));
        return Response.ok(response).build();
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/space/{spaceKey}/anonymous/manageSpacePermissions")
    public Response manageAnonymousSpacePermissions(String jsonString, @PathParam(value="spaceKey") String spaceKey) throws EntityException {
        HashMap response = new HashMap();
        Space space = this.toolsHelper.getSpaceFromSpaceDao(spaceKey);
        if (space == null) {
            return this.toolsHelper.spaceNotExist(spaceKey);
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!(this.toolsHelper.isConfluenceAdministrator() || this.toolsHelper.isCurrentUserIsSpaceAdministrator(space) && !this.toolsHelper.isDisabledForSpaceAdministrator("manageSpacePermissionsForUser"))) {
            return this.toolsHelper.permissionViolation();
        }
        JSONObject jsonObject = new JSONObject(jsonString);
        ArrayList<String> addPermissions = this.toolsHelper.getJSONarray(jsonObject, "addPermissions");
        ArrayList<String> removePermissions = this.toolsHelper.getJSONarray(jsonObject, "removePermissions");
        ArrayList<String> addedPermissions = new ArrayList<String>();
        ArrayList<String> currentAnonymousPermissions = new ArrayList<String>();
        for (SpacePermission spacePermission : space.getPermissions()) {
            if (!spacePermission.isAnonymousPermission()) continue;
            currentAnonymousPermissions.add(spacePermission.getType());
        }
        for (String permission : addPermissions) {
            if (!SpacePermission.PERMISSION_TYPES.contains(permission) || currentAnonymousPermissions.contains(permission) || permission.equalsIgnoreCase("SETPAGEPERMISSIONS") || permission.equalsIgnoreCase("SETSPACEPERMISSIONS")) continue;
            SpacePermission newSpacePermission = SpacePermission.createAnonymousSpacePermission((String)permission, (Space)space);
            this.toolsHelper.getSpacePermissionManager().savePermission(newSpacePermission);
            addedPermissions.add(permission);
            currentAnonymousPermissions.add(permission);
        }
        ArrayList spacePermissionsToRemove = new ArrayList(space.getPermissions());
        ArrayList<String> removedPermissions = new ArrayList<String>();
        for (SpacePermission permission : spacePermissionsToRemove) {
            if (!permission.isAnonymousPermission() || !removePermissions.contains(permission.getType())) continue;
            this.toolsHelper.getSpacePermissionManager().removePermission(permission);
            removedPermissions.add(permission.getType());
        }
        response.put("addedPermissions", addedPermissions);
        response.put("removedPermissions", removedPermissions);
        return Response.ok(response).build();
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/space/{spaceKey}/anonymous/addSpacePermissions")
    public Response addAnonymousPermissionToSpace(String jsonString, @PathParam(value="spaceKey") String spaceKey) throws EntityException {
        HashMap<String, Serializable> response = new HashMap<String, Serializable>();
        Space space = this.toolsHelper.getSpaceFromSpaceDao(spaceKey);
        if (space == null) {
            return this.toolsHelper.spaceNotExist(spaceKey);
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!(this.toolsHelper.isConfluenceAdministrator() || this.toolsHelper.isCurrentUserIsSpaceAdministrator(space) && !this.toolsHelper.isDisabledForSpaceAdministrator("spaceAddPermissionForUser"))) {
            return this.toolsHelper.permissionViolation();
        }
        JSONObject jsonObject = new JSONObject(jsonString);
        ArrayList<String> permissionsList = this.toolsHelper.getJSONarray(jsonObject, "permissions");
        ArrayList<String> added = new ArrayList<String>();
        ArrayList<String> skipped = new ArrayList<String>();
        ArrayList<String> currentAnonymousPermissions = new ArrayList<String>();
        for (SpacePermission spacePermission : space.getPermissions()) {
            if (!spacePermission.isAnonymousPermission()) continue;
            currentAnonymousPermissions.add(spacePermission.getType());
        }
        for (String permission : permissionsList) {
            if (!SpacePermission.PERMISSION_TYPES.contains(permission)) continue;
            if (currentAnonymousPermissions.contains(permission) || permission.equalsIgnoreCase("SETPAGEPERMISSIONS") || permission.equalsIgnoreCase("SETSPACEPERMISSIONS")) {
                skipped.add(permission);
                continue;
            }
            SpacePermission newSpacePermission = SpacePermission.createAnonymousSpacePermission((String)permission, (Space)space);
            this.toolsHelper.getSpacePermissionManager().savePermission(newSpacePermission);
            added.add(permission);
        }
        response.put("added", added);
        response.put("skipped", skipped);
        response.put("total", Integer.valueOf(added.size()));
        return Response.ok(response).build();
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/space/{spaceKey}/group/{groupName}/manageSpacePermissions")
    public Response manageGroupSpacePermissions(String jsonString, @PathParam(value="groupName") String groupName, @PathParam(value="spaceKey") String spaceKey) throws EntityException {
        groupName = this.toolsHelper.decodeUrlParam(groupName);
        HashMap response = new HashMap();
        Space space = this.toolsHelper.getSpaceFromSpaceDao(spaceKey);
        if (space == null) {
            return this.toolsHelper.spaceNotExist(spaceKey);
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!(this.toolsHelper.isConfluenceAdministrator() || this.toolsHelper.isCurrentUserIsSpaceAdministrator(space) && !this.toolsHelper.isDisabledForSpaceAdministrator("manageSpacePermissionsForGroup"))) {
            return this.toolsHelper.permissionViolation();
        }
        if (this.groupManager.getGroup(groupName) == null) {
            return this.toolsHelper.groupNotExit(groupName);
        }
        JSONObject jsonObject = new JSONObject(jsonString);
        ArrayList<String> addPermissions = this.toolsHelper.getJSONarray(jsonObject, "addPermissions");
        ArrayList<String> removePermissions = this.toolsHelper.getJSONarray(jsonObject, "removePermissions");
        ArrayList<String> addedPermissions = new ArrayList<String>();
        ArrayList<String> removedPermissions = new ArrayList<String>();
        for (String permission : addPermissions) {
            if (!SpacePermission.PERMISSION_TYPES.contains(permission) || this.toolsHelper.getSpacePermissionManager().groupHasPermission(permission, space, groupName)) continue;
            SpacePermission newSpacePermission = SpacePermission.createGroupSpacePermission((String)permission, (Space)space, (String)groupName);
            this.toolsHelper.getSpacePermissionManager().savePermission(newSpacePermission);
            addedPermissions.add(permission);
        }
        ArrayList spacePermissionsToRemove = new ArrayList(space.getPermissions());
        for (SpacePermission permission : spacePermissionsToRemove) {
            if (!permission.isGroupPermission() || !permission.getGroup().equalsIgnoreCase(groupName) || !removePermissions.contains(permission.getType())) continue;
            this.toolsHelper.getSpacePermissionManager().removePermission(permission);
            removedPermissions.add(permission.getType());
        }
        response.put("addedPermissions", addedPermissions);
        response.put("removedPermissions", removedPermissions);
        return Response.ok(response).build();
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/space/{spaceKey}/group/{groupName}/addSpacePermissions")
    public Response addGroupsPermissionToSpace(String jsonString, @PathParam(value="groupName") String groupName, @PathParam(value="spaceKey") String spaceKey) throws EntityException {
        groupName = this.toolsHelper.decodeUrlParam(groupName);
        HashMap<String, Serializable> response = new HashMap<String, Serializable>();
        Space space = this.toolsHelper.getSpaceFromSpaceDao(spaceKey);
        if (space == null) {
            return this.toolsHelper.spaceNotExist(spaceKey);
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!(this.toolsHelper.isConfluenceAdministrator() || this.toolsHelper.isCurrentUserIsSpaceAdministrator(space) && !this.toolsHelper.isDisabledForSpaceAdministrator("spaceAddPermissionForGroup"))) {
            return this.toolsHelper.permissionViolation();
        }
        if (this.groupManager.getGroup(groupName) == null) {
            return this.toolsHelper.groupNotExit(groupName);
        }
        JSONObject jsonObject = new JSONObject(jsonString);
        ArrayList<String> permissionsList = this.toolsHelper.getJSONarray(jsonObject, "permissions");
        ArrayList<String> added = new ArrayList<String>();
        ArrayList<String> skipped = new ArrayList<String>();
        for (String permission : permissionsList) {
            if (!SpacePermission.PERMISSION_TYPES.contains(permission)) continue;
            if (this.toolsHelper.getSpacePermissionManager().groupHasPermission(permission, space, groupName)) {
                skipped.add(permission);
                continue;
            }
            SpacePermission newSpacePermission = SpacePermission.createGroupSpacePermission((String)permission, (Space)space, (String)groupName);
            this.toolsHelper.getSpacePermissionManager().savePermission(newSpacePermission);
            added.add(permission);
        }
        response.put("added", added);
        response.put("skipped", skipped);
        response.put("total", Integer.valueOf(added.size()));
        return Response.ok(response).build();
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/space/{spaceKey}/user/{userName}/removeSpacePermissions")
    public Response removeUserWithPermForSpace(String jsonString, @PathParam(value="userName") String userName, @PathParam(value="spaceKey") String spaceKey) throws EntityException {
        userName = this.toolsHelper.decodeUrlParam(userName);
        HashMap<String, Serializable> response = new HashMap<String, Serializable>();
        Space space = this.toolsHelper.getSpaceFromSpaceDao(spaceKey);
        if (space == null) {
            return this.toolsHelper.spaceNotExist(spaceKey);
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!(this.toolsHelper.isConfluenceAdministrator() || this.toolsHelper.isCurrentUserIsSpaceAdministrator(space) && !this.toolsHelper.isDisabledForSpaceAdministrator("spaceRemovePermissionForUser"))) {
            return this.toolsHelper.permissionViolation();
        }
        JSONObject jsonObject = new JSONObject(jsonString);
        ArrayList<String> permissionsList = this.toolsHelper.getJSONarray(jsonObject, "permissions");
        ArrayList spacePermissionsToRemove = new ArrayList(space.getPermissions());
        ArrayList<String> removedPermissions = new ArrayList<String>();
        for (SpacePermission permission : spacePermissionsToRemove) {
            if (!permission.isUserPermission() || !permission.getUserSubject().getName().equalsIgnoreCase(userName) || !permissionsList.contains(permission.getType())) continue;
            removedPermissions.add(permission.getType());
            this.toolsHelper.getSpacePermissionManager().removePermission(permission);
        }
        response.put("removed", removedPermissions);
        response.put("total", Integer.valueOf(removedPermissions.size()));
        return Response.ok(response).build();
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/space/{spaceKey}/anonymous/removeSpacePermissions")
    public Response removeAnonymousWithPermForSpace(String jsonString, @PathParam(value="spaceKey") String spaceKey) throws EntityException {
        HashMap<String, Serializable> response = new HashMap<String, Serializable>();
        Space space = this.toolsHelper.getSpaceFromSpaceDao(spaceKey);
        if (space == null) {
            return this.toolsHelper.spaceNotExist(spaceKey);
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!(this.toolsHelper.isConfluenceAdministrator() || this.toolsHelper.isCurrentUserIsSpaceAdministrator(space) && !this.toolsHelper.isDisabledForSpaceAdministrator("spaceRemovePermissionForUser"))) {
            return this.toolsHelper.permissionViolation();
        }
        JSONObject jsonObject = new JSONObject(jsonString);
        ArrayList<String> permissionsList = this.toolsHelper.getJSONarray(jsonObject, "permissions");
        ArrayList spacePermissionsToRemove = new ArrayList(space.getPermissions());
        ArrayList<String> removedPermissions = new ArrayList<String>();
        for (SpacePermission permission : spacePermissionsToRemove) {
            if (!permission.isAnonymousPermission() || !permissionsList.contains(permission.getType())) continue;
            removedPermissions.add(permission.getType());
            this.toolsHelper.getSpacePermissionManager().removePermission(permission);
        }
        response.put("removed", removedPermissions);
        response.put("total", Integer.valueOf(removedPermissions.size()));
        return Response.ok(response).build();
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/space/{spaceKey}/group/{groupName}/removeSpacePermissions")
    public Response removeGroupsWithPermForSpace(String jsonString, @PathParam(value="groupName") String groupName, @PathParam(value="spaceKey") String spaceKey) throws EntityException {
        groupName = this.toolsHelper.decodeUrlParam(groupName);
        HashMap<String, Serializable> response = new HashMap<String, Serializable>();
        Space space = this.toolsHelper.getSpaceFromSpaceDao(spaceKey);
        if (space == null) {
            return this.toolsHelper.spaceNotExist(spaceKey);
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!(this.toolsHelper.isConfluenceAdministrator() || this.toolsHelper.isCurrentUserIsSpaceAdministrator(space) && !this.toolsHelper.isDisabledForSpaceAdministrator("spaceRemovePermissionForGroup"))) {
            return this.toolsHelper.permissionViolation();
        }
        if (this.groupManager.getGroup(groupName) == null) {
            return this.toolsHelper.groupNotExit(groupName);
        }
        JSONObject jsonObject = new JSONObject(jsonString);
        ArrayList<String> permissionsList = this.toolsHelper.getJSONarray(jsonObject, "permissions");
        ArrayList spacePermissionsToRemove = new ArrayList(space.getPermissions());
        ArrayList<String> removedPermissions = new ArrayList<String>();
        for (SpacePermission permission : spacePermissionsToRemove) {
            if (!permission.isGroupPermission() || !permission.getGroup().equalsIgnoreCase(groupName) || !permissionsList.contains(permission.getType())) continue;
            removedPermissions.add(permission.getType());
            this.toolsHelper.getSpacePermissionManager().removePermission(permission);
        }
        response.put("removed", removedPermissions);
        response.put("total", Integer.valueOf(removedPermissions.size()));
        return Response.ok(response).build();
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/space/{spaceKey}/anonymous/removeAllSpacePermissions")
    public Response removeAnonymousWithPermForSpace(@PathParam(value="spaceKey") String spaceKey) throws EntityException {
        HashMap<String, Serializable> response = new HashMap<String, Serializable>();
        Space space = this.toolsHelper.getSpaceFromSpaceDao(spaceKey);
        if (space == null) {
            return this.toolsHelper.spaceNotExist(spaceKey);
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!(this.toolsHelper.isConfluenceAdministrator() || this.toolsHelper.isCurrentUserIsSpaceAdministrator(space) && !this.toolsHelper.isDisabledForSpaceAdministrator("spaceRemoveAllPermissionForUser"))) {
            return this.toolsHelper.permissionViolation();
        }
        ArrayList spacePermissionsToRemove = new ArrayList(space.getPermissions());
        ArrayList<String> removedPermissions = new ArrayList<String>();
        for (SpacePermission permission : spacePermissionsToRemove) {
            if (!permission.isAnonymousPermission()) continue;
            removedPermissions.add(permission.getType());
            this.toolsHelper.getSpacePermissionManager().removePermission(permission);
        }
        response.put("removed", removedPermissions);
        response.put("total", Integer.valueOf(removedPermissions.size()));
        return Response.ok(response).build();
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/space/{spaceKey}/user/{userName}/removeAllSpacePermissions")
    public Response removeUserWithPermForSpace(@PathParam(value="userName") String userName, @PathParam(value="spaceKey") String spaceKey) throws EntityException {
        userName = this.toolsHelper.decodeUrlParam(userName);
        HashMap<String, Serializable> response = new HashMap<String, Serializable>();
        Space space = this.toolsHelper.getSpaceFromSpaceDao(spaceKey);
        if (space == null) {
            return this.toolsHelper.spaceNotExist(spaceKey);
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!(this.toolsHelper.isConfluenceAdministrator() || this.toolsHelper.isCurrentUserIsSpaceAdministrator(space) && !this.toolsHelper.isDisabledForSpaceAdministrator("spaceRemoveAllPermissionForUser"))) {
            return this.toolsHelper.permissionViolation();
        }
        ArrayList spacePermissionsToRemove = new ArrayList(space.getPermissions());
        ArrayList<String> removedPermissions = new ArrayList<String>();
        for (SpacePermission permission : spacePermissionsToRemove) {
            if (!permission.isUserPermission() || !permission.getUserSubject().getName().equalsIgnoreCase(userName)) continue;
            removedPermissions.add(permission.getType());
            this.toolsHelper.getSpacePermissionManager().removePermission(permission);
        }
        response.put("removed", removedPermissions);
        response.put("total", Integer.valueOf(removedPermissions.size()));
        return Response.ok(response).build();
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/space/{spaceKey}/group/{groupName}/removeAllSpacePermissions")
    public Response removeGroupsWithPermForSpace(@PathParam(value="groupName") String groupName, @PathParam(value="spaceKey") String spaceKey) throws EntityException {
        groupName = this.toolsHelper.decodeUrlParam(groupName);
        HashMap<String, Serializable> response = new HashMap<String, Serializable>();
        Space space = this.toolsHelper.getSpaceFromSpaceDao(spaceKey);
        if (space == null) {
            return this.toolsHelper.spaceNotExist(spaceKey);
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!(this.toolsHelper.isConfluenceAdministrator() || this.toolsHelper.isCurrentUserIsSpaceAdministrator(space) && !this.toolsHelper.isDisabledForSpaceAdministrator("spaceRemoveAllPermissionForGroup"))) {
            return this.toolsHelper.permissionViolation();
        }
        if (this.groupManager.getGroup(groupName) == null) {
            return this.toolsHelper.groupNotExit(groupName);
        }
        ArrayList spacePermissionsToRemove = new ArrayList(space.getPermissions());
        ArrayList<String> removedPermissions = new ArrayList<String>();
        for (SpacePermission permission : spacePermissionsToRemove) {
            if (!permission.isGroupPermission() || !permission.getGroup().equalsIgnoreCase(groupName)) continue;
            removedPermissions.add(permission.getType());
            this.toolsHelper.getSpacePermissionManager().removePermission(permission);
        }
        response.put("removed", removedPermissions);
        response.put("total", Integer.valueOf(removedPermissions.size()));
        return Response.ok(response).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/space/{spaceKey}/getSpacePermissionActors/{spacePermissionType}")
    public Response getSpacesWithPermissions(@PathParam(value="spaceKey") String spaceKey, @PathParam(value="spacePermissionType") String spacePermissionType) throws EntityException {
        HashMap<String, Object> response = new HashMap<String, Object>();
        Space space = this.toolsHelper.getSpaceFromSpaceDao(spaceKey);
        if (space == null) {
            return this.toolsHelper.spaceNotExist(spaceKey);
        }
        if (spacePermissionType == null || spacePermissionType.equals("") || !SpacePermission.GENERIC_SPACE_PERMISSIONS.contains(spacePermissionType) && !spacePermissionType.equalsIgnoreCase("all")) {
            response.put("message", "permission type '" + spacePermissionType + "' does not exist");
            return Response.serverError().entity(response).build();
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (!this.toolsHelper.isConfluenceAdministrator() && !this.toolsHelper.isCurrentUserIsSpaceAdministrator(space)) {
            return this.toolsHelper.permissionViolation();
        }
        HashMap permissionMatrix = new HashMap();
        for (SpacePermission spacePermission : space.getPermissions()) {
            Map permissionTypeMatrix;
            if (!spacePermissionType.equalsIgnoreCase("all") && !spacePermission.getType().equalsIgnoreCase(spacePermissionType)) continue;
            if (permissionMatrix.get(spacePermission.getType()) == null) {
                permissionTypeMatrix = new HashMap<String, Boolean>();
                permissionTypeMatrix.put("anonymousAccess", false);
            } else {
                permissionTypeMatrix = (Map)permissionMatrix.get(spacePermission.getType());
            }
            if (spacePermission.isAnonymousPermission()) {
                permissionTypeMatrix.put("anonymousAccess", true);
            } else if (spacePermission.isGroupPermission()) {
                List<String> permissionTypeGroup = permissionTypeMatrix.get("groups") == null ? new ArrayList() : (List)permissionTypeMatrix.get("groups");
                permissionTypeGroup.add(spacePermission.getGroup());
                permissionTypeMatrix.put("groups", permissionTypeGroup);
            } else {
                List<String> permissionTypeUser;
                List list = permissionTypeUser = permissionTypeMatrix.get("users") == null ? new ArrayList() : (List)permissionTypeMatrix.get("users");
                if (spacePermission.getUserSubject() != null) {
                    permissionTypeUser.add(spacePermission.getUserSubject().getName());
                }
                permissionTypeMatrix.put("users", permissionTypeUser);
            }
            permissionMatrix.put(spacePermission.getType(), permissionTypeMatrix);
        }
        response.put("key", space.getKey());
        response.put("name", space.getName());
        response.put("permissions", permissionMatrix);
        return Response.ok(response).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/space/{spaceKey}/getContentWithPermissionModificationDate")
    public Response getContentWithPermissionModificationDate(@PathParam(value="spaceKey") String spaceKey, @QueryParam(value="lastPermissionModificationDateFrom") String lastPermissionModificationDateFrom, @QueryParam(value="lastPermissionModificationDateTo") String lastPermissionModificationDateTo, @QueryParam(value="dateFormat") String dateFormatApi, @QueryParam(value="startAt") int startAt, @QueryParam(value="maxResults") int maxResults) throws ParseException {
        HashMap<String, Long> contentMap;
        Date creationDate;
        Date lastPermissionModificationDate;
        long lastPermissionModificationLong;
        ArrayList allPermissionsList;
        HashMap<String, Serializable> response = new HashMap<String, Serializable>();
        Space space = this.toolsHelper.getSpaceFromSpaceDao(spaceKey);
        if (space == null) {
            return this.toolsHelper.spaceNotExist(spaceKey);
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (!this.toolsHelper.isConfluenceAdministrator() && !this.toolsHelper.isCurrentUserIsSpaceAdministrator(space)) {
            return this.toolsHelper.permissionViolation();
        }
        int iterator = 0;
        int total = 0;
        if (maxResults == 0) {
            maxResults = 100;
        }
        Date lastPermissionModificationFrom = new Date(0, 0, 1);
        Date lastPermissionModificationTo = new Date();
        String dateFormat = "";
        String fullDateFormat = "";
        if (dateFormatApi == null || dateFormatApi.equals("")) {
            dateFormat = "yyyy-MM-dd";
            fullDateFormat = dateFormat + " HH:mm:ss";
        } else {
            dateFormat = dateFormatApi;
            fullDateFormat = dateFormatApi + " HH:mm:ss";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        SimpleDateFormat sdfFull = new SimpleDateFormat(fullDateFormat);
        if (lastPermissionModificationDateFrom != null && !lastPermissionModificationDateFrom.equals("")) {
            lastPermissionModificationFrom = sdf.parse(lastPermissionModificationDateFrom);
        }
        if (lastPermissionModificationDateTo != null && !lastPermissionModificationDateTo.equals("")) {
            lastPermissionModificationTo = sdf.parse(lastPermissionModificationDateTo);
        }
        ArrayList<HashMap<String, Long>> contentList = new ArrayList<HashMap<String, Long>>();
        List pages = this.pageManager.getPages(space, true);
        List blogPosts = this.pageManager.getBlogPosts(space, true);
        if (log.isDebugEnabled()) {
            log.debug("getContentWithPermissionModificationDate pages = " + pages.size());
            log.debug("getContentWithPermissionModificationDate blogPosts = " + blogPosts.size());
            log.debug("getContentWithPermissionModificationDate lastPermissionModificationFrom = " + lastPermissionModificationFrom);
            log.debug("getContentWithPermissionModificationDate lastPermissionModificationTo   = " + lastPermissionModificationTo);
        }
        for (Page page : pages) {
            allPermissionsList = new ArrayList();
            allPermissionsList.addAll(this.contentPermissionManager.getContentPermissionSets((ContentEntityObject)page, "View"));
            allPermissionsList.addAll(this.contentPermissionManager.getContentPermissionSets((ContentEntityObject)page, "Edit"));
            lastPermissionModificationLong = -1L;
            lastPermissionModificationDate = null;
            for (ContentPermissionSet contentPermissionSet : allPermissionsList) {
                creationDate = contentPermissionSet.getCreationDate();
                if (creationDate.getTime() <= lastPermissionModificationLong) continue;
                lastPermissionModificationLong = creationDate.getTime();
                lastPermissionModificationDate = creationDate;
            }
            if (lastPermissionModificationDate != null && log.isDebugEnabled()) {
                log.debug("getContentWithPermissionModificationDate lastPermissionModificationDate   = " + lastPermissionModificationDate);
                log.debug("getContentWithPermissionModificationDate test 1   = " + (lastPermissionModificationDate.compareTo(lastPermissionModificationFrom) >= 0));
                log.debug("getContentWithPermissionModificationDate test 2   = " + (lastPermissionModificationDate.compareTo(lastPermissionModificationTo) <= 0));
            }
            if (lastPermissionModificationDate == null || lastPermissionModificationDate.compareTo(lastPermissionModificationFrom) < 0 || lastPermissionModificationDate.compareTo(lastPermissionModificationTo) > 0) continue;
            if (startAt <= iterator && iterator < startAt + maxResults) {
                contentMap = new HashMap();
                contentMap.put("id", page.getId());
                contentMap.put("name", (Long)((Object)page.getNameForComparison()));
                contentMap.put("type", (Long)((Object)page.getType()));
                contentMap.put("status", (Long)((Object)page.getContentStatus()));
                if (lastPermissionModificationDate != null) {
                    contentMap.put("lastPermissionModificationDate", (Long)((Object)lastPermissionModificationDate));
                    contentMap.put("lastPermissionModificationDateString", (Long)((Object)sdfFull.format(lastPermissionModificationDate)));
                } else {
                    contentMap.put("lastPermissionModificationDate", (Long)((Object)""));
                    contentMap.put("lastPermissionModificationDateString", (Long)((Object)""));
                }
                contentList.add(contentMap);
            }
            ++iterator;
            ++total;
        }
        for (BlogPost blogPost : blogPosts) {
            allPermissionsList = new ArrayList();
            allPermissionsList.addAll(this.contentPermissionManager.getContentPermissionSets((ContentEntityObject)blogPost, "View"));
            allPermissionsList.addAll(this.contentPermissionManager.getContentPermissionSets((ContentEntityObject)blogPost, "Edit"));
            lastPermissionModificationLong = -1L;
            lastPermissionModificationDate = null;
            for (ContentPermissionSet contentPermissionSet : allPermissionsList) {
                creationDate = contentPermissionSet.getCreationDate();
                if (creationDate.getTime() <= lastPermissionModificationLong) continue;
                lastPermissionModificationLong = creationDate.getTime();
                lastPermissionModificationDate = creationDate;
            }
            if (lastPermissionModificationDate != null && log.isDebugEnabled()) {
                log.debug("getContentWithPermissionModificationDate lastPermissionModificationDate   = " + lastPermissionModificationDate);
                log.debug("getContentWithPermissionModificationDate test 1   = " + (lastPermissionModificationDate.compareTo(lastPermissionModificationFrom) >= 0));
                log.debug("getContentWithPermissionModificationDate test 2   = " + (lastPermissionModificationDate.compareTo(lastPermissionModificationTo) <= 0));
            }
            if (lastPermissionModificationDate == null || lastPermissionModificationDate.compareTo(lastPermissionModificationFrom) < 0 || lastPermissionModificationDate.compareTo(lastPermissionModificationTo) > 0) continue;
            if (startAt <= iterator && iterator < startAt + maxResults) {
                contentMap = new HashMap<String, Long>();
                contentMap.put("id", blogPost.getId());
                contentMap.put("name", (Long)((Object)blogPost.getNameForComparison()));
                contentMap.put("type", (Long)((Object)blogPost.getType()));
                contentMap.put("status", (Long)((Object)blogPost.getContentStatus()));
                if (lastPermissionModificationDate != null) {
                    contentMap.put("lastPermissionModificationDate", (Long)((Object)lastPermissionModificationDate));
                    contentMap.put("lastPermissionModificationDateString", (Long)((Object)sdfFull.format(lastPermissionModificationDate)));
                } else {
                    contentMap.put("lastPermissionModificationDate", (Long)((Object)""));
                    contentMap.put("lastPermissionModificationDateString", (Long)((Object)""));
                }
                contentList.add(contentMap);
            }
            ++iterator;
            ++total;
        }
        response.put("startAt", Integer.valueOf(startAt));
        response.put("maxResults", Integer.valueOf(maxResults));
        response.put("total", Integer.valueOf(total));
        response.put("content", contentList);
        return Response.ok(response).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/space/getSpacesWithAnonymousPermissions")
    public Response getSpacesWithAnonymousPermissions(@QueryParam(value="startAt") int startAt, @QueryParam(value="maxResults") int maxResults, @QueryParam(value="creationDateFrom") String creationDateFrom, @QueryParam(value="creationDateTo") String creationDateTo, @QueryParam(value="dateFormat") String dateFormatApi, @QueryParam(value="spaceKey") String spaceKey) throws ParseException {
        HashMap<String, Serializable> response = new HashMap<String, Serializable>();
        HashMap<String, Map<String, List<String>>> spaces = new HashMap<String, Map<String, List<String>>>();
        Date from = new Date();
        Date to = new Date();
        boolean checkDateFrom = false;
        boolean checkDateTo = false;
        String dateFormat = "";
        String fullDateFormat = "";
        if (dateFormatApi == null || dateFormatApi.equals("")) {
            dateFormat = "yyyy-MM-dd";
            fullDateFormat = dateFormat + " HH:mm:ss";
        } else {
            dateFormat = dateFormatApi;
            fullDateFormat = dateFormatApi + " HH:mm:ss";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        SimpleDateFormat sdfFull = new SimpleDateFormat(fullDateFormat);
        if (creationDateFrom != null && !creationDateFrom.equals("")) {
            checkDateFrom = true;
            from = sdf.parse(creationDateFrom);
        }
        if (creationDateTo != null && !creationDateTo.equals("")) {
            checkDateTo = true;
            to = sdf.parse(creationDateTo);
        }
        int iterator = 0;
        if (maxResults == 0) {
            maxResults = 100;
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        List<Space> spaceList = this.toolsHelper.getAllSpacesFormSpaceDao();
        if (spaceKey != null && !spaceKey.equals("")) {
            spaceList = new ArrayList<Space>();
            spaceList.add(this.toolsHelper.getSpaceFromSpaceDao(spaceKey));
        }
        for (Space space : spaceList) {
            if (!(!checkDateFrom && !checkDateTo || !checkDateFrom && checkDateTo && space.getCreationDate().compareTo(to) <= 0 || checkDateFrom && !checkDateTo && space.getCreationDate().compareTo(from) >= 0) && (!checkDateFrom || space.getCreationDate().compareTo(from) < 0 || !checkDateTo || space.getCreationDate().compareTo(to) > 0)) continue;
            for (SpacePermission spacePermission : space.getPermissions()) {
                List<String> permissionsList;
                if (!spacePermission.isAnonymousPermission()) continue;
                String spaceKeyFromSpace = space.getKey();
                String permissionType = spacePermission.getType();
                Map<String, List<String>> spaceDetails = spaces.get(spaceKeyFromSpace) == null ? new HashMap() : (Map)spaces.get(spaceKeyFromSpace);
                List list = permissionsList = spaceDetails.get("permissions") == null ? new ArrayList() : (List)spaceDetails.get("permissions");
                if (!permissionsList.contains(permissionType)) {
                    permissionsList.add(permissionType);
                    spaceDetails.put("permissions", permissionsList);
                }
                spaceDetails.put("creationDate", (List<String>)((Object)space.getCreationDate()));
                spaceDetails.put("creationDateString", (List<String>)((Object)sdfFull.format(space.getCreationDate())));
                spaceDetails.put("lastModificationDate", (List<String>)((Object)space.getLastModificationDate()));
                spaceDetails.put("lastModificationDateString", (List<String>)((Object)sdfFull.format(space.getLastModificationDate())));
                spaceDetails.put("creatorName", (List<String>)((Object)(space.getCreator() != null ? space.getCreator().getName() : "not exist")));
                spaceDetails.put("key", (List<String>)((Object)space.getKey()));
                spaceDetails.put("name", (List<String>)((Object)space.getName()));
                spaces.put(spaceKeyFromSpace, spaceDetails);
            }
        }
        HashMap spaceToResponse = new HashMap();
        for (Map.Entry entry : spaces.entrySet()) {
            if (startAt <= iterator && iterator < startAt + maxResults) {
                spaceToResponse.put((String)entry.getKey(), entry.getValue());
            }
            ++iterator;
        }
        response.put("startAt", Integer.valueOf(startAt));
        response.put("maxResults", Integer.valueOf(maxResults));
        response.put("spaces", spaceToResponse);
        response.put("total", Integer.valueOf(spaces.size()));
        return Response.ok(response).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/user/{userName}/getPermissionsForSpace/space/{spaceKey}")
    public Response getPermissionsForSpaceUser(@PathParam(value="spaceKey") String spaceKey, @PathParam(value="userName") String userName) {
        userName = this.toolsHelper.decodeUrlParam(userName);
        HashMap<String, Object> response = new HashMap<String, Object>();
        Space space = this.toolsHelper.getSpaceFromSpaceDao(spaceKey);
        if (space == null) {
            return this.toolsHelper.spaceNotExist(spaceKey);
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (!this.toolsHelper.isConfluenceAdministrator() && !this.toolsHelper.isCurrentUserIsSpaceAdministrator(space)) {
            return this.toolsHelper.permissionViolation();
        }
        ArrayList<String> permissionList = new ArrayList<String>();
        Map users = this.toolsHelper.getSpacePermissionManager().getUsersForPermissionType("VIEWSPACE", space);
        if (users.get(userName) != null) {
            for (String spacePermission : SpacePermission.GENERIC_SPACE_PERMISSIONS) {
                if (this.toolsHelper.getSpacePermissionManager().getUsersForPermissionType(spacePermission, space).get(userName) == null) continue;
                permissionList.add(spacePermission);
            }
        }
        response.put("permissions", permissionList);
        response.put("key", space.getKey());
        response.put("name", space.getName());
        return Response.ok(response).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/anonymous/getPermissionsForSpace/space/{spaceKey}")
    public Response getPermissionsForAnonymous(@PathParam(value="spaceKey") String spaceKey) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        Space space = this.toolsHelper.getSpaceFromSpaceDao(spaceKey);
        if (space == null) {
            return this.toolsHelper.spaceNotExist(spaceKey);
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (!this.toolsHelper.isConfluenceAdministrator() && !this.toolsHelper.isCurrentUserIsSpaceAdministrator(space)) {
            return this.toolsHelper.permissionViolation();
        }
        ArrayList<String> permissionList = new ArrayList<String>();
        for (SpacePermission permission : space.getPermissions()) {
            if (!permission.isAnonymousPermission()) continue;
            permissionList.add(permission.getType());
        }
        response.put("permissions", permissionList);
        response.put("key", space.getKey());
        response.put("name", space.getName());
        return Response.ok(response).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/group/{groupName}/getPermissionsForSpace/space/{spaceKey}")
    public Response getPermissionsForSpaceGroup(@PathParam(value="spaceKey") String spaceKey, @PathParam(value="groupName") String groupName) throws EntityException {
        groupName = this.toolsHelper.decodeUrlParam(groupName);
        HashMap<String, Object> response = new HashMap<String, Object>();
        Space space = this.toolsHelper.getSpaceFromSpaceDao(spaceKey);
        if (space == null) {
            return this.toolsHelper.spaceNotExist(spaceKey);
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (!this.toolsHelper.isConfluenceAdministrator() && !this.toolsHelper.isCurrentUserIsSpaceAdministrator(space)) {
            return this.toolsHelper.permissionViolation();
        }
        if (this.groupManager.getGroup(groupName) == null) {
            return this.toolsHelper.groupNotExit(groupName);
        }
        ArrayList<String> permissionList = new ArrayList<String>();
        if (this.toolsHelper.getSpacePermissionManager().getGroupsWithPermissions(space).contains(this.groupManager.getGroup(groupName))) {
            for (String spacePermission : SpacePermission.GENERIC_SPACE_PERMISSIONS) {
                Map groupsForPermissionType = this.toolsHelper.getSpacePermissionManager().getGroupsForPermissionType(spacePermission, space);
                if (groupsForPermissionType.get(groupName) == null) continue;
                permissionList.add(spacePermission);
            }
        }
        response.put("permissions", permissionList);
        response.put("key", space.getKey());
        response.put("name", space.getName());
        return Response.ok(response).build();
    }

    private Set<String> getSpaceAdministrators(Space space, boolean showBasicDetails) {
        HashSet<String> spaceAdministrators = new HashSet<String>();
        Map adminUsers = this.toolsHelper.getSpacePermissionManager().getUsersForPermissionType("SETSPACEPERMISSIONS", space);
        for (Map.Entry entry : adminUsers.entrySet()) {
            spaceAdministrators.add((String)entry.getKey());
        }
        Map adminGroups = this.toolsHelper.getSpacePermissionManager().getGroupsForPermissionType("SETSPACEPERMISSIONS", space);
        for (Map.Entry entry : adminGroups.entrySet()) {
            Group group = this.userAccessor.getGroup((String)entry.getKey());
            if (group == null) continue;
            spaceAdministrators.addAll(this.userAccessor.getMemberNamesAsList(group));
        }
        return spaceAdministrators;
    }

    private Map<String, Object> addLastPermissionModificationDate(Map<String, Object> currentMap, String dateFormatApi, ContentEntityObject contentObject, String permissionType) {
        if (permissionType == null || !permissionType.equalsIgnoreCase("edit") && !permissionType.equalsIgnoreCase("view")) {
            permissionType = "all";
        }
        ArrayList allPermissionsList = new ArrayList();
        if (permissionType.equalsIgnoreCase("all") || permissionType.equalsIgnoreCase("view")) {
            allPermissionsList.addAll(this.contentPermissionManager.getContentPermissionSets(contentObject, "View"));
        }
        if (permissionType.equalsIgnoreCase("all") || permissionType.equalsIgnoreCase("edit")) {
            allPermissionsList.addAll(this.contentPermissionManager.getContentPermissionSets(contentObject, "Edit"));
        }
        long lastPermissionModificationLong = -1L;
        Date lastPermissionModificationDate = null;
        for (ContentPermissionSet contentPermissionSet : allPermissionsList) {
            Date creationDate = contentPermissionSet.getCreationDate();
            if (creationDate.getTime() <= lastPermissionModificationLong) continue;
            lastPermissionModificationLong = creationDate.getTime();
            lastPermissionModificationDate = creationDate;
        }
        String fullDateFormat = "";
        fullDateFormat = dateFormatApi == null || dateFormatApi.equals("") ? "yyyy-MM-dd HH:mm:ss" : dateFormatApi + " HH:mm:ss";
        SimpleDateFormat sdfFull = new SimpleDateFormat(fullDateFormat);
        if (lastPermissionModificationDate != null) {
            currentMap.put("lastPermissionModificationDate", lastPermissionModificationDate);
            currentMap.put("lastPermissionModificationDateString", sdfFull.format(lastPermissionModificationDate));
        } else {
            currentMap.put("lastPermissionModificationDate", "");
            currentMap.put("lastPermissionModificationDateString", "");
        }
        return currentMap;
    }
}

