/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender.favoriteMacro;

import com.itlab.confluence.plugins.restextender.helper.ToolsHelper;
import java.util.ArrayList;
import java.util.HashMap;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/favorite-macro")
public class FavoriteMacroApi {
    private static final Logger log = LoggerFactory.getLogger(FavoriteMacroApi.class);
    private final ToolsHelper toolsHelper;

    @Inject
    public FavoriteMacroApi(ToolsHelper toolsHelper) {
        this.toolsHelper = toolsHelper;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/get")
    public Response getFavoriteMacro() {
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        HashMap response = new HashMap();
        String userFavoriteMacro = this.toolsHelper.getFavoriteMacroForCurrentUser();
        ArrayList macroList = new ArrayList();
        if (userFavoriteMacro == null || userFavoriteMacro.isEmpty()) {
            response.put("macro", macroList);
        } else {
            log.warn("BBBBBBBBBB userFavoriteMacro=" + userFavoriteMacro);
            JSONObject jsonObject = new JSONObject(userFavoriteMacro);
            log.warn("CCCCCCCCC jsonObject=" + jsonObject);
            if (jsonObject.has("macro")) {
                JSONArray macros = jsonObject.getJSONArray("macro");
                for (int i = 0; i < macros.length(); ++i) {
                    HashMap<String, Object> macroMap = new HashMap<String, Object>();
                    JSONObject macrosJSONObject = macros.getJSONObject(i);
                    macroMap.put("name", macrosJSONObject.getString("name"));
                    macroMap.put("visible", macrosJSONObject.has("visible") && macrosJSONObject.getBoolean("visible"));
                    macroList.add(macroMap);
                }
            }
            log.warn("DDDDDDDD jsonObject=" + macroList);
            response.put("macro", macroList);
        }
        return Response.ok(response).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/reset")
    public Response resetFavoriteMacro(String requestJson, @Context HttpServletRequest request) {
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        this.toolsHelper.setFavoriteMacroForCurrentUser(null);
        return Response.ok().build();
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/set")
    public Response setFavoriteMacro(String requestJson, @Context HttpServletRequest request) {
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        JSONObject jsonObject = new JSONObject(requestJson);
        JSONObject jsonObjectToSave = new JSONObject();
        jsonObjectToSave.put("macro", (Object)jsonObject.getJSONArray("macro"));
        this.toolsHelper.setFavoriteMacroForCurrentUser(jsonObjectToSave.toString());
        return Response.ok().build();
    }
}

