/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender.content;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.confluence.core.DefaultSaveContext;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceType;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.user.User;
import com.itlab.confluence.plugins.restextender.helper.ToolsHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/content")
public class ContentRestApi {
    private static final Logger log = LoggerFactory.getLogger(ContentRestApi.class);
    private final PageManager pageManager;
    private final PermissionManager permissionManager;
    private final AttachmentManager attachmentManager;
    private final ContentPermissionManager contentPermissionManager;
    private ToolsHelper toolsHelper;

    @Inject
    public ContentRestApi(@ConfluenceImport PageManager pageManager, @ConfluenceImport PermissionManager permissionManager, @ConfluenceImport AttachmentManager attachmentManager, @ConfluenceImport ContentPermissionManager contentPermissionManager, ToolsHelper toolsHelper) {
        this.pageManager = pageManager;
        this.toolsHelper = toolsHelper;
        this.permissionManager = permissionManager;
        this.contentPermissionManager = contentPermissionManager;
        this.attachmentManager = attachmentManager;
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/{contentId}/prepend")
    public Response prepend(String jsonString, @PathParam(value="contentId") long contentId, @QueryParam(value="spaceKey") String spaceKey) {
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (this.toolsHelper.getPageFormPageDao(contentId) == null) {
            return this.toolsHelper.contentIdNotExist(contentId);
        }
        if (!(this.toolsHelper.isConfluenceAdministrator() || this.toolsHelper.isCurrentUserIsSpaceAdministrator(this.toolsHelper.getPageFormPageDao(contentId).getSpace()) || this.toolsHelper.isDisabledForSpaceAdministrator("contentPrepend"))) {
            return this.toolsHelper.permissionViolation();
        }
        JSONObject jsonObject = new JSONObject(jsonString);
        if (!jsonObject.has("text")) {
            return this.toolsHelper.fieldRequired("text");
        }
        String text = jsonObject.getString("text");
        if (!this.toolsHelper.skipParamSpaceValidation(spaceKey, this.toolsHelper.getPageFormPageDao(contentId))) {
            return this.toolsHelper.permissionViolation();
        }
        TransactionTemplate transactionTemplate = (TransactionTemplate)ComponentLocator.getComponent(TransactionTemplate.class);
        transactionTemplate.execute(() -> {
            Page page = this.toolsHelper.getPageFormPageDao(contentId);
            String newBody = text + page.getEntity().getBodyAsString();
            this.pageManager.saveNewVersion((ContentEntityObject)page, pageToModify -> pageToModify.getEntity().setBodyAsString(newBody));
            return null;
        });
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("status", "done");
        return Response.ok(response).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/{contentId}/append")
    public Response append(String jsonString, @PathParam(value="contentId") long contentId, @QueryParam(value="spaceKey") String spaceKey) {
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (this.toolsHelper.getPageFormPageDao(contentId) == null) {
            return this.toolsHelper.contentIdNotExist(contentId);
        }
        if (!(this.toolsHelper.isConfluenceAdministrator() || this.toolsHelper.isCurrentUserIsSpaceAdministrator(this.toolsHelper.getPageFormPageDao(contentId).getSpace()) || this.toolsHelper.isDisabledForSpaceAdministrator("contentAppend"))) {
            return this.toolsHelper.permissionViolation();
        }
        JSONObject jsonObject = new JSONObject(jsonString);
        if (!jsonObject.has("text")) {
            return this.toolsHelper.fieldRequired("text");
        }
        String text = jsonObject.getString("text");
        if (!this.toolsHelper.skipParamSpaceValidation(spaceKey, this.toolsHelper.getPageFormPageDao(contentId))) {
            return this.toolsHelper.permissionViolation();
        }
        TransactionTemplate transactionTemplate = (TransactionTemplate)ComponentLocator.getComponent(TransactionTemplate.class);
        transactionTemplate.execute(() -> {
            Page page = this.toolsHelper.getPageFormPageDao(contentId);
            String newBody = page.getEntity().getBodyAsString() + text;
            this.pageManager.saveNewVersion((ContentEntityObject)page, pageToModify -> pageToModify.getEntity().setBodyAsString(newBody));
            return null;
        });
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("status", "done");
        return Response.ok(response).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/{contentId}/replaceAll")
    public Response replaceAll(String jsonString, @PathParam(value="contentId") long contentId, @QueryParam(value="spaceKey") String spaceKey) {
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (this.toolsHelper.getPageFormPageDao(contentId) == null) {
            return this.toolsHelper.contentIdNotExist(contentId);
        }
        if (!(this.toolsHelper.isConfluenceAdministrator() || this.toolsHelper.isCurrentUserIsSpaceAdministrator(this.toolsHelper.getPageFormPageDao(contentId).getSpace()) || this.toolsHelper.isDisabledForSpaceAdministrator("contentReplaceAll"))) {
            return this.toolsHelper.permissionViolation();
        }
        JSONObject jsonObject = new JSONObject(jsonString);
        AtomicInteger numberOfReplacements = new AtomicInteger();
        if (!jsonObject.has("find")) {
            return this.toolsHelper.fieldRequired("find");
        }
        if (!jsonObject.has("replace")) {
            return this.toolsHelper.fieldRequired("replace");
        }
        boolean ignoreCase = jsonObject.has("ignoreCase") ? jsonObject.getBoolean("ignoreCase") : false;
        String find = jsonObject.getString("find");
        String replace = jsonObject.getString("replace");
        if (!this.toolsHelper.skipParamSpaceValidation(spaceKey, this.toolsHelper.getPageFormPageDao(contentId))) {
            return this.toolsHelper.permissionViolation();
        }
        TransactionTemplate transactionTemplate = (TransactionTemplate)ComponentLocator.getComponent(TransactionTemplate.class);
        transactionTemplate.execute(() -> {
            String newBody;
            Page page = this.toolsHelper.getPageFormPageDao(contentId);
            String body = page.getEntity().getBodyAsString();
            if (ignoreCase) {
                newBody = StringUtils.replaceIgnoreCase((String)body, (String)find, (String)replace);
                numberOfReplacements.set(StringUtils.countMatches((CharSequence)body.toLowerCase(), (CharSequence)find.toLowerCase()));
            } else {
                newBody = body.replace(find, replace);
                numberOfReplacements.set(StringUtils.countMatches((CharSequence)body, (CharSequence)find));
            }
            this.pageManager.saveNewVersion((ContentEntityObject)page, pageToModify -> pageToModify.getEntity().setBodyAsString(newBody));
            return null;
        });
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("status", "done");
        response.put("numberOfReplacements", numberOfReplacements);
        response.put("ignoreCase", ignoreCase);
        return Response.ok(response).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/attachment/{attachmentId}/versions")
    public Response getAttachmentVersions(@PathParam(value="attachmentId") long attachmentId, @QueryParam(value="startAt") int startAt, @QueryParam(value="maxResults") int maxResults, @QueryParam(value="spaceKey") String spaceKey) {
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        Attachment attachment = this.attachmentManager.getAttachment(attachmentId);
        if (attachment == null) {
            return this.toolsHelper.attachmentIdNotExist(attachmentId);
        }
        if (!this.toolsHelper.currentUserIsInConfluenceAdministratorGroup() && !this.contentPermissionManager.hasContentLevelPermission(this.toolsHelper.getCurrentUser(), "View", attachment.getContainer())) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.toolsHelper.skipParamSpaceValidation(spaceKey, attachment.getSpace().getKey())) {
            return this.toolsHelper.permissionViolation();
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        List attachmentVersions = this.attachmentManager.getAllVersions(attachment);
        ArrayList attachmentVersionsList = new ArrayList();
        response.put("fileExtension", attachment.getFileExtension());
        response.put("name", attachment.getFileName());
        response.put("id", attachment.getId());
        int iterator = 0;
        if (maxResults == 0) {
            maxResults = 10;
        }
        for (Attachment attachmentVersion : attachmentVersions) {
            if (startAt <= iterator && iterator < startAt + maxResults) {
                HashMap<String, Object> attachmentMap = new HashMap<String, Object>();
                attachmentMap.put("fileName", attachment.getFileName());
                attachmentMap.put("version", attachmentVersion.getVersion());
                attachmentMap.put("comment", attachmentVersion.getVersionComment() == null ? "" : attachmentVersion.getVersionComment());
                attachmentMap.put("fileSize", attachmentVersion.getFileSize());
                attachmentMap.put("creatorName", attachmentVersion.getCreator() != null ? attachmentVersion.getCreator().getName() : "unknown user");
                attachmentMap.put("creationDate", attachmentVersion.getCreationDate());
                attachmentMap.put("fileSizeNice", attachmentVersion.getNiceFileSize());
                attachmentVersionsList.add(attachmentMap);
            }
            ++iterator;
        }
        response.put("total", attachmentVersions.size());
        response.put("startAt", startAt);
        response.put("maxResults", maxResults);
        response.put("versions", attachmentVersionsList);
        return Response.ok(response).build();
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/attachment/{attachmentId}/delete")
    public Response deleteAttachmentAllVersion(@PathParam(value="attachmentId") long attachmentId, @QueryParam(value="muteNotification") boolean muteNotification, @QueryParam(value="spaceKey") String spaceKey) {
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        Attachment attachment = this.attachmentManager.getAttachment(attachmentId);
        if (attachment == null) {
            return this.toolsHelper.attachmentIdNotExist(attachmentId);
        }
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (!(this.toolsHelper.currentUserIsInConfluenceAdministratorGroup() || this.contentPermissionManager.hasContentLevelPermission(this.toolsHelper.getCurrentUser(), "Edit", attachment.getContainer()) && this.toolsHelper.getSpacePermissionManager().hasPermission("REMOVEATTACHMENT", attachment.getSpace(), (User)user))) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.toolsHelper.skipParamSpaceValidation(spaceKey, attachment.getSpace().getKey())) {
            return this.toolsHelper.permissionViolation();
        }
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("message", "Attachment '" + attachment.getFileName() + "' deleted.");
        if (this.toolsHelper.isConfluenceAdministrator() && muteNotification) {
            this.attachmentManager.removeAttachmentWithoutNotifications(attachment);
        } else {
            this.attachmentManager.removeAttachmentFromServer(attachment);
        }
        response.put("status", "done");
        return Response.ok(response).build();
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/attachment/{attachmentId}/delete/{versionId}")
    public Response deleteAttachmentVersion(@PathParam(value="attachmentId") long attachmentId, @PathParam(value="versionId") long versionId, @QueryParam(value="spaceKey") String spaceKey) {
        HashMap<String, String> response;
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        Attachment attachment = this.attachmentManager.getAttachment(attachmentId);
        if (attachment == null) {
            return this.toolsHelper.attachmentIdNotExist(attachmentId);
        }
        if (!(this.toolsHelper.currentUserIsInConfluenceAdministratorGroup() || this.contentPermissionManager.hasContentLevelPermission(this.toolsHelper.getCurrentUser(), "View", attachment.getContainer()) && this.toolsHelper.isCurrentUserIsSpaceAdministrator(attachment.getSpace()) && !this.toolsHelper.isDisabledForSpaceAdministrator("attachmentDeleteVersionId"))) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.toolsHelper.skipParamSpaceValidation(spaceKey, attachment.getSpace().getKey())) {
            return this.toolsHelper.permissionViolation();
        }
        Attachment attachmentToDelete = null;
        List attachmentVersions = this.attachmentManager.getAllVersions(attachment);
        for (Attachment findAttachmentToDelete : attachmentVersions) {
            if ((long)findAttachmentToDelete.getVersion() != versionId) continue;
            attachmentToDelete = findAttachmentToDelete;
            break;
        }
        if (attachmentToDelete == null) {
            response = new HashMap<String, String>();
            response.put("message", "version '" + versionId + "' of the '" + attachment.getFileName() + "' attachment does not exist");
            return Response.serverError().entity(response).build();
        }
        response = new HashMap();
        response.put("message", "version '" + versionId + "' of the '" + attachment.getFileName() + "' attachment has been removed");
        this.attachmentManager.removeAttachmentVersionFromServer(attachmentToDelete);
        response.put("status", "done");
        return Response.ok(response).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/{a:movePage|reorderPage}")
    public Response moveReorderPage(String jsonString, @QueryParam(value="spaceKey") String spaceKey) {
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        HashMap<String, String> response = new HashMap<String, String>();
        ArrayList<String> errors = new ArrayList<String>();
        JSONObject jsonObject = new JSONObject(jsonString);
        if (!jsonObject.has("sourcePageId")) {
            return this.toolsHelper.fieldRequired("sourcePageId");
        }
        if (!jsonObject.has("targetPageId")) {
            return this.toolsHelper.fieldRequired("targetPageId");
        }
        if (!jsonObject.has("position")) {
            return this.toolsHelper.fieldRequired("position");
        }
        Page sourcePage = this.toolsHelper.getPageFormPageDao(jsonObject.getLong("sourcePageId"));
        Page targetPage = this.toolsHelper.getPageFormPageDao(jsonObject.getLong("targetPageId"));
        String movePoint = jsonObject.getString("position").toLowerCase();
        if (sourcePage == null) {
            response.put("message", this.toolsHelper.getTranslation("movepage.source.notfound"));
            return Response.serverError().entity(response).build();
        }
        if (targetPage == null) {
            response.put("message", this.toolsHelper.getTranslation("movepage.target.notfound"));
            return Response.serverError().entity(response).build();
        }
        if (!(movePoint.equals("append") || movePoint.equals("above") || movePoint.equals("below"))) {
            response.put("message", this.toolsHelper.getTranslation("movepage.point.invalid", Collections.singletonList(movePoint)));
            return Response.serverError().entity(response).build();
        }
        if (sourcePage.equals((Object)targetPage)) {
            response.put("message", "The source page cannot be the same as the target page.");
            return Response.serverError().entity(response).build();
        }
        if (sourcePage.getSpace() != targetPage.getSpace()) {
            ConfluenceUser user;
            Space targetSpace = targetPage.getSpace();
            List<String> existPageTitles = this.listOfPermittedPageTitlesAlreadyExist(sourcePage, targetSpace);
            if (!existPageTitles.isEmpty()) {
                String targetSpaceName = targetSpace.getName();
                for (String title : existPageTitles) {
                    errors.add(this.toolsHelper.getTranslation("page.already.exists.inspace", Arrays.asList(title, targetSpaceName)));
                }
            }
            if ((sourcePage.hasPermissions("View") || sourcePage.hasPermissions("Edit")) && !this.permissionManager.hasPermission((User)(user = this.toolsHelper.getCurrentUser()), Permission.SET_PERMISSIONS, (Object)targetPage)) {
                errors.add(this.toolsHelper.getTranslation("save.restrictions.not.permitted"));
            }
        }
        if ("append".equals(movePoint)) {
            if (targetPage.getAncestors().contains(sourcePage)) {
                errors.add(this.toolsHelper.getTranslation("movepage.target.invalid"));
            }
        } else if (targetPage.getParent() != null && targetPage.getParent().getAncestors().contains(sourcePage)) {
            errors.add(this.toolsHelper.getTranslation("movepage.target.invalid"));
        }
        if (!errors.isEmpty()) {
            response.put("message", String.join((CharSequence)"; ", errors));
            return Response.serverError().entity(response).build();
        }
        if (!this.toolsHelper.skipParamSpaceValidation(spaceKey, sourcePage)) {
            return this.toolsHelper.permissionViolation();
        }
        if ("below".equals(movePoint)) {
            this.pageManager.movePageAfter(sourcePage, targetPage);
        } else if ("above".equals(movePoint)) {
            this.pageManager.movePageBefore(sourcePage, targetPage);
        } else if (!(targetPage.hasChildren() && targetPage.getChildren().contains(sourcePage) || !"append".equals(movePoint))) {
            this.pageManager.movePageAsChild(sourcePage, targetPage);
        }
        response.put("message", "Page '" + sourcePage.getTitle() + " (Id: " + sourcePage.getIdAsString() + ")' moved.");
        response.put("status", "done");
        return Response.ok(response).build();
    }

    private List<String> listOfPermittedPageTitlesAlreadyExist(Page sourcePage, Space targetSpace) {
        ArrayList<String> existTitles = new ArrayList<String>();
        if (this.toolsHelper.getPageFormPageDao(targetSpace.getKey(), sourcePage.getTitle()) != null) {
            existTitles.add(sourcePage.getTitle());
        }
        List descendantTitles = this.pageManager.getDescendantTitles(sourcePage);
        for (String title : descendantTitles) {
            Page page = this.toolsHelper.getPageFormPageDao(targetSpace.getKey(), title);
            ConfluenceUser user = this.toolsHelper.getCurrentUser();
            if (page == null || !this.permissionManager.hasPermission((User)user, Permission.EDIT, (Object)page)) continue;
            existTitles.add(title);
        }
        return existTitles;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/countContent/{userName}")
    public Response countContentCreator(@PathParam(value="userName") String userName) {
        userName = this.toolsHelper.decodeUrlParam(userName);
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        ConfluenceUser confluenceUser = this.toolsHelper.getConfluenceUserByName(userName);
        if (confluenceUser == null) {
            return this.toolsHelper.userNotFound(userName);
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("contentCount", this.toolsHelper.getPageAuthoredPagesCountByUserFormPageDao(userName));
        response.put("message", "success");
        return Response.ok(response).build();
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/changeCreator/space/{spaceKey}/user/{userNameOrKey}")
    public Response changeSpaceCreatorBySpaceKey(String jsonString, @PathParam(value="userNameOrKey") String userNameOrKey, @PathParam(value="spaceKey") String spaceKey) {
        userNameOrKey = this.toolsHelper.decodeUrlParam(userNameOrKey);
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        if (this.toolsHelper.getConfluenceUserByName(userNameOrKey) == null && this.toolsHelper.getConfluenceUserByKey(userNameOrKey) == null) {
            return this.toolsHelper.userNotFound(userNameOrKey);
        }
        JSONObject jsonObject = new JSONObject(jsonString);
        HashMap<String, Object> response = new HashMap<String, Object>();
        String newCreatorName = "";
        if (jsonObject.isNull("newCreatorName") || jsonObject.getString("newCreatorName").equals("")) {
            return this.toolsHelper.fieldRequired("newCreatorName");
        }
        newCreatorName = jsonObject.getString("newCreatorName");
        Space space = this.toolsHelper.getSpaceFromSpaceDao(spaceKey);
        if (space == null) {
            return this.toolsHelper.spaceNotExist(spaceKey);
        }
        if (space.getSpaceType().equals((Object)SpaceType.PERSONAL)) {
            return this.toolsHelper.spaceIsNotGlobal(spaceKey);
        }
        ConfluenceUser confluenceUser = this.toolsHelper.getConfluenceUserByName(newCreatorName);
        if (confluenceUser == null) {
            return this.toolsHelper.userNotFound(newCreatorName);
        }
        if (log.isDebugEnabled()) {
            log.debug("spaceKey : " + spaceKey);
            log.debug("userNameOrKey : " + userNameOrKey);
            log.debug("newCreatorName : " + newCreatorName);
        }
        ArrayList<Long> contentsChanged = new ArrayList<Long>();
        ArrayList contentsSkipped = new ArrayList();
        int contentCount = 0;
        List<ContentEntityObject> contentEntityObjects = this.toolsHelper.getPageContentAuthoredByUser(userNameOrKey);
        for (ContentEntityObject contentEntityObject : contentEntityObjects) {
            String contentType;
            if (log.isDebugEnabled()) {
                log.debug("getType " + contentEntityObject.getType());
                log.debug("getId " + contentEntityObject.getId());
            }
            if (!(contentType = contentEntityObject.getType()).equalsIgnoreCase("blogpost") && !contentType.equalsIgnoreCase("page") || !contentEntityObject.toPageContext().getSpaceKey().equalsIgnoreCase(spaceKey)) continue;
            contentEntityObject.setCreator(confluenceUser);
            this.pageManager.saveContentEntity(contentEntityObject, null);
            contentsChanged.add(contentEntityObject.getId());
            ++contentCount;
        }
        response.put("contentsSkipped", contentsSkipped);
        response.put("contentsChanged", contentsChanged);
        response.put("total", contentCount);
        response.put("message", "success");
        return Response.ok(response).build();
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/changeCreator/contentId")
    public Response changeSpaceCreatorByContentId(String jsonString, @QueryParam(value="spaceKey") String spaceKey) {
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        JSONObject jsonObject = new JSONObject(jsonString);
        HashMap<String, Object> response = new HashMap<String, Object>();
        String newCreatorName = "";
        if (jsonObject.isNull("contentIds") || !jsonObject.isNull("contentIds") && jsonObject.getJSONArray("contentIds").length() < 1) {
            return this.toolsHelper.fieldRequired("contentIds");
        }
        ArrayList<Long> contentIds = this.toolsHelper.getLongJSONarray(jsonObject, "contentIds");
        if (jsonObject.isNull("newCreatorName") || jsonObject.getString("newCreatorName").equals("")) {
            return this.toolsHelper.fieldRequired("newCreatorName");
        }
        newCreatorName = jsonObject.getString("newCreatorName");
        User user = this.toolsHelper.getUserByName(newCreatorName);
        if (user == null) {
            return this.toolsHelper.userNotFound(newCreatorName);
        }
        if (log.isDebugEnabled()) {
            log.debug("contentIds : " + contentIds);
            log.debug("creatorName : " + newCreatorName);
        }
        ArrayList<Long> contentsChanged = new ArrayList<Long>();
        ArrayList<Long> contentsSkipped = new ArrayList<Long>();
        int contentCount = 0;
        for (Long contentId : contentIds) {
            Page page = this.toolsHelper.getPageFormPageDao(contentId);
            BlogPost blogPost = this.toolsHelper.getBlogPostFormPageDao(contentId);
            if (page != null && this.toolsHelper.skipParamSpaceValidation(spaceKey, page) || blogPost != null && this.toolsHelper.skipParamSpaceValidation(spaceKey, blogPost)) {
                if (page != null) {
                    page.setCreator((ConfluenceUser)user);
                    this.pageManager.saveContentEntity((ContentEntityObject)page, DefaultSaveContext.SUPPRESS_NOTIFICATIONS);
                    contentsChanged.add(page.getId());
                } else {
                    blogPost.setCreator((ConfluenceUser)user);
                    this.pageManager.saveContentEntity((ContentEntityObject)blogPost, DefaultSaveContext.SUPPRESS_NOTIFICATIONS);
                    contentsChanged.add(blogPost.getId());
                }
                ++contentCount;
                continue;
            }
            contentsSkipped.add(contentId);
        }
        response.put("contentsSkipped", contentsSkipped);
        response.put("contentsChanged", contentsChanged);
        response.put("total", contentCount);
        response.put("message", "success");
        return Response.ok(response).build();
    }
}

