/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender.user;

import com.atlassian.confluence.security.websudo.WebSudoManager;
import com.atlassian.sal.api.component.ComponentLocator;
import com.itlab.confluence.plugins.restextender.helper.ToolsHelper;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/userSessions")
public class UserSession {
    private static final Logger log = LoggerFactory.getLogger(UserSession.class);
    private final ToolsHelper toolsHelper;

    @Inject
    public UserSession(ToolsHelper toolsHelper) {
        this.toolsHelper = toolsHelper;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/wsActivate")
    public Response wsActivate(@Context HttpServletRequest request, @Context HttpServletResponse response) {
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        WebSudoManager websudoManager = (WebSudoManager)ComponentLocator.getComponent(WebSudoManager.class);
        if (websudoManager.isEnabled()) {
            websudoManager.startSession(request, response);
        }
        return Response.ok().build();
    }
}

