/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender.space;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.model.search.SearchContext;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.plugins.ia.SidebarLinkCategory;
import com.atlassian.confluence.plugins.ia.rest.SidebarLinkBean;
import com.atlassian.confluence.plugins.ia.service.SidebarLinkService;
import com.atlassian.confluence.rpc.NotPermittedException;
import com.atlassian.confluence.search.ConfluenceIndexer;
import com.atlassian.confluence.search.IndexManager;
import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.SpaceStatus;
import com.atlassian.confluence.spaces.SpaceType;
import com.atlassian.confluence.spaces.persistence.dao.SpaceDao;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.PersonalInformationManager;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.EntityException;
import com.atlassian.user.User;
import com.itlab.confluence.plugins.restextender.helper.ToolsHelper;
import java.io.Serializable;
import java.net.URLDecoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.log4j.Logger;

@Path(value="/space")
public class SpaceRestApi {
    private static final Logger log = Logger.getLogger(SpaceRestApi.class);
    private static final String CHANGE_SPACE_KEY = "com.itlab.confluence.plugins.restextender.space.changeSpaceKey";
    private static final String REPLACE_ALL_TASK = "com.itlab.confluence.plugins.restextender.space.replaceAll";
    private final SpaceManager spaceManager;
    private final SpaceDao spaceDao;
    private final PageManager pageManager;
    private final SidebarLinkService sidebarLinkService;
    private final ConfluenceIndexer confluenceIndexer;
    private final PersonalInformationManager personalInformationManager;
    private final BandanaManager bandanaManager;
    private final AttachmentManager attachmentManager;
    private final CQLSearchService cqlSearchService;
    private ToolsHelper toolsHelper;

    @Inject
    public SpaceRestApi(@ConfluenceImport PageManager pageManager, @ConfluenceImport SpaceManager spaceManager, @ConfluenceImport SidebarLinkService sidebarLinkService, @ConfluenceImport PersonalInformationManager personalInformationManager, @ConfluenceImport AttachmentManager attachmentManager, @ConfluenceImport CQLSearchService cqlSearchService, ToolsHelper toolsHelper) {
        this.spaceManager = spaceManager;
        this.pageManager = pageManager;
        this.confluenceIndexer = (ConfluenceIndexer)ComponentLocator.getComponent(ConfluenceIndexer.class);
        this.toolsHelper = toolsHelper;
        this.spaceDao = (SpaceDao)ComponentLocator.getComponent(SpaceDao.class);
        this.sidebarLinkService = sidebarLinkService;
        this.personalInformationManager = personalInformationManager;
        this.attachmentManager = attachmentManager;
        this.cqlSearchService = cqlSearchService;
        this.bandanaManager = (BandanaManager)ComponentLocator.getComponent(BandanaManager.class);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/content/replaceAll/taskStatus")
    public Response replaceAllTaskStatus() {
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        HashMap<String, String> response = new HashMap<String, String>();
        Object replaceAllTask = this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), REPLACE_ALL_TASK);
        if (replaceAllTask != null && !replaceAllTask.toString().equals("")) {
            response.put("message", replaceAllTask.toString());
            response.put("status", "in progress");
            return Response.ok(response).build();
        }
        response.put("message", "no 'replaceAll' job for the space is running");
        response.put("status", "done");
        return Response.ok(response).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/content/replaceAll/reset")
    public Response replaceAllReset() {
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), REPLACE_ALL_TASK, (Object)"");
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("status", "done");
        return Response.ok(response).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/{spaceKey}/content/replaceAll")
    public Response replaceAll(String jsonString, @PathParam(value="spaceKey") String spaceKey) throws EntityException {
        Space space = this.toolsHelper.getSpaceFromSpaceDao(spaceKey);
        if (space == null) {
            return this.toolsHelper.spaceNotExist(spaceKey);
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!(this.toolsHelper.isConfluenceAdministrator() || this.toolsHelper.isCurrentUserIsSpaceAdministrator(space) && !this.toolsHelper.isDisabledForSpaceAdministrator("replaceAll"))) {
            return this.toolsHelper.permissionViolation();
        }
        JSONObject jsonObject = new JSONObject(jsonString);
        if (!jsonObject.has("find")) {
            return this.toolsHelper.fieldRequired("find");
        }
        if (!jsonObject.has("replace")) {
            return this.toolsHelper.fieldRequired("replace");
        }
        boolean ignoreCase = jsonObject.has("ignoreCase") ? jsonObject.getBoolean("ignoreCase") : false;
        String find = jsonObject.getString("find");
        String replace = jsonObject.getString("replace");
        String searchQuery = "space=\"" + spaceKey.replace("\"", "%5C%22") + "\" AND type=page AND text ~ \"" + find.replace("\"", "%5C%22") + "\"";
        HashMap<String, String> response = new HashMap<String, String>();
        Object replaceAllTask = this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), REPLACE_ALL_TASK);
        if (replaceAllTask != null && !replaceAllTask.toString().equals("")) {
            response.put("message", replaceAllTask.toString());
            response.put("status", "waiting");
            return Response.ok(response).build();
        }
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), REPLACE_ALL_TASK, (Object)("API 'replaceAll' for space '" + spaceKey + "' is in progress, wait for it to finish [In progress ...]"));
        UpdateSpaceContentThread updateConfigSchemeIdThread = new UpdateSpaceContentThread(this.cqlSearchService, this.bandanaManager, this.toolsHelper.getCurrentUser(), spaceKey, searchQuery, find, replace, ignoreCase);
        updateConfigSchemeIdThread.start();
        response.put("message", "task `replaceAll' for space '" + spaceKey + "' has been started in the background");
        response.put("status", "done");
        return Response.ok(response).build();
    }

    private PageResponse<Content> getContentCqlQuery(String searchQuery, ConfluenceUser currentUser) {
        int pageMaxSize = 50;
        AuthenticatedUserThreadLocal.set((ConfluenceUser)currentUser);
        return this.cqlSearchService.searchContent(searchQuery, SearchContext.builder().build(), (PageRequest)new SimplePageRequest(0, pageMaxSize), new Expansion[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PUT
    @Produces(value={"application/json"})
    @Path(value="/{spaceKey}/shortcut")
    public Response createShortcut(@PathParam(value="spaceKey") String spaceKey, String jsonString, @Context HttpServletRequest request) throws EntityException, NotPermittedException {
        String stackTrace;
        String message;
        SidebarLinkBean sidebarLinkBean;
        String resourceId;
        String type;
        HashMap<String, Object> response;
        block32: {
            JSONObject jsonObject;
            Space space = this.toolsHelper.getSpaceFromSpaceDao(spaceKey);
            if (space == null) {
                return this.toolsHelper.spaceNotExist(spaceKey);
            }
            if (!this.toolsHelper.isLicenseIsValid()) {
                return this.toolsHelper.licenseIsInvalid();
            }
            if (this.toolsHelper.isReadOnly()) {
                return this.toolsHelper.readOnlyMode();
            }
            if (!(this.toolsHelper.isConfluenceAdministrator() || this.toolsHelper.isCurrentUserIsSpaceAdministrator(space) && !this.toolsHelper.isDisabledForSpaceAdministrator("addShortcut"))) {
                return this.toolsHelper.permissionViolation();
            }
            response = new HashMap<String, Object>();
            if (log.isDebugEnabled()) {
                log.debug((Object)("jsonString: " + jsonString));
            }
            if (!(jsonObject = new JSONObject(jsonString)).has("type")) {
                return this.toolsHelper.fieldRequired("type");
            }
            type = jsonObject.getString("type");
            if (!(type.equalsIgnoreCase("pinned_space") || type.equalsIgnoreCase("pinned_attachment") || type.equalsIgnoreCase("pinned_profile") || type.startsWith("pinned_page") || type.equalsIgnoreCase("external_link"))) {
                response.put("message", "'type' is not valid (list of valid type's: \"pinned_attachment\", \"pinned_profile\", \"pinned_page\", \"pinned_space\", \"external_link\")");
                return Response.serverError().entity(response).build();
            }
            String title = "";
            if (jsonObject.has("title")) {
                title = jsonObject.getString("title");
            }
            resourceId = "";
            String url = "";
            if (type.equalsIgnoreCase("pinned_space") || type.equalsIgnoreCase("pinned_attachment") || type.equalsIgnoreCase("pinned_profile") || type.startsWith("pinned_page")) {
                if (type.equalsIgnoreCase("pinned_profile")) {
                    String userName = "";
                    if (!jsonObject.has("resourceId") && !jsonObject.has("userName")) {
                        response.put("message", "field 'resourceId' or 'userName' is required");
                        return Response.serverError().entity(response).build();
                    }
                    if (jsonObject.has("userName")) {
                        userName = jsonObject.getString("userName");
                        User confluenceUser = this.toolsHelper.getUserByName(userName);
                        if (confluenceUser == null) return this.toolsHelper.userNotFound(userName);
                        resourceId = this.personalInformationManager.getOrCreatePersonalInformation(confluenceUser).getIdAsString();
                    } else {
                        resourceId = jsonObject.getString("resourceId") == null ? jsonObject.getLong("resourceId") + "" : jsonObject.getString("resourceId");
                    }
                } else {
                    if (!jsonObject.has("resourceId")) {
                        return this.toolsHelper.fieldRequired("resourceId");
                    }
                    resourceId = jsonObject.getString("resourceId") == null ? jsonObject.getLong("resourceId") + "" : jsonObject.getString("resourceId");
                }
            } else {
                if (!jsonObject.has("url")) {
                    return this.toolsHelper.fieldRequired("url");
                }
                url = jsonObject.getString("url");
                List<String> urls = Arrays.asList("http://", "https://", "mailto:", "skype:", "callto:", "facetime:", "git:", "irc:", "irc6:", "news:", "nntp:", "feed:", "cvs:", "svn:", "mvn:", "ssh:", "itms:", "notes:", "smb:", "hipchat:");
                boolean safeUrl = false;
                for (String prefixUrl : urls) {
                    if (!url.startsWith(prefixUrl)) continue;
                    safeUrl = true;
                }
                if (!safeUrl) {
                    response.put("message", "url is not valid (list of valid URI's: \"http://\", \"https://\", \"mailto:\", \"skype:\", \"callto:\", \"facetime:\", \"git:\", \"irc:\", \"irc6:\", \"news:\", \"nntp:\", \"feed:\", \"cvs:\", \"svn:\", \"mvn:\", \"ssh:\", \"itms:\", \"notes:\", \"smb:\", \"hipchat:\")");
                    return Response.serverError().entity(response).build();
                }
            }
            sidebarLinkBean = null;
            message = "";
            stackTrace = "";
            try {
                if (type.equalsIgnoreCase("pinned_space") || type.equalsIgnoreCase("pinned_attachment") || type.equalsIgnoreCase("pinned_profile") || type.startsWith("pinned_page")) {
                    String finalResourceType = "";
                    if (type.equalsIgnoreCase("pinned_attachment")) {
                        finalResourceType = "attachment";
                        if (this.attachmentManager.getAttachment(Long.parseLong(resourceId)) == null) {
                            response.put("message", "attachment with id '" + resourceId + "' does not exist");
                            return Response.serverError().entity(response).build();
                        }
                        sidebarLinkBean = this.sidebarLinkService.create(spaceKey, finalResourceType, Long.valueOf(Long.parseLong(resourceId)), title.equals("") ? "" : title, null);
                        break block32;
                    }
                    if (type.equalsIgnoreCase("pinned_profile")) {
                        finalResourceType = "userinfo";
                        try {
                            sidebarLinkBean = this.sidebarLinkService.create(spaceKey, finalResourceType, Long.valueOf(Long.parseLong(resourceId)), title.equals("") ? "" : title, null);
                            break block32;
                        }
                        catch (Exception ex) {
                            response.put("message", "user with profile id '" + resourceId + "' does not exist");
                            return Response.serverError().entity(response).build();
                        }
                    }
                    if (type.equalsIgnoreCase("pinned_space")) {
                        finalResourceType = "space";
                        Space resourceSpace = this.toolsHelper.getSpaceFromSpaceDao(Long.parseLong(resourceId));
                        if (resourceSpace == null) {
                            return this.toolsHelper.spaceNotExist(spaceKey);
                        }
                        sidebarLinkBean = this.sidebarLinkService.create(spaceKey, finalResourceType, Long.valueOf(Long.parseLong(resourceId)), title.equals("") ? "" : title, null);
                    } else {
                        finalResourceType = "page";
                        Page page = this.toolsHelper.getPageFormPageDao(Long.parseLong(resourceId));
                        BlogPost blogPost = this.toolsHelper.getBlogPostFormPageDao(Long.parseLong(resourceId));
                        if (page == null && blogPost == null) {
                            response.put("message", "page or blog post with id '" + resourceId + "' does not exist");
                            return Response.serverError().entity(response).build();
                        }
                        sidebarLinkBean = type.equalsIgnoreCase("pinned_page") ? this.sidebarLinkService.create(spaceKey, finalResourceType, Long.valueOf(Long.parseLong(resourceId)), title.equals("") ? "" : title, null) : this.sidebarLinkService.create(spaceKey, finalResourceType, Long.valueOf(Long.parseLong(resourceId)), title.equals("") ? "" : title, null, type.replace("pinned_page", "").trim());
                    }
                    break block32;
                }
                sidebarLinkBean = this.sidebarLinkService.create(spaceKey, null, title.equals("") ? url : title, url);
            }
            catch (Exception ex) {
                message = ex.getMessage();
                stackTrace = ExceptionUtils.getStackTrace((Throwable)ex);
            }
        }
        if (sidebarLinkBean == null) {
            response.put("message", message);
            response.put("stackTrace", stackTrace);
            return Response.serverError().entity(response).build();
        }
        response.put("message", "shortcut created");
        response.put("title", sidebarLinkBean.getTitle());
        response.put("type", type);
        response.put("id", sidebarLinkBean.getId());
        response.put("url", sidebarLinkBean.getUrl());
        response.put("resourceId", resourceId);
        return Response.ok(response).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{spaceKey}/shortcuts")
    public Response getShortcuts(@PathParam(value="spaceKey") String spaceKey, @Context HttpServletRequest request) throws EntityException {
        Space space = this.toolsHelper.getSpaceFromSpaceDao(spaceKey);
        if (space == null) {
            return this.toolsHelper.spaceNotExist(spaceKey);
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (!this.toolsHelper.isConfluenceAdministrator() && !this.toolsHelper.isCurrentUserIsSpaceAdministrator(space)) {
            return this.toolsHelper.permissionViolation();
        }
        HashMap response = new HashMap();
        ArrayList spaceShortcuts = new ArrayList();
        List sidebarLinkBeanList = this.sidebarLinkService.getLinksForSpace(SidebarLinkCategory.QUICK, spaceKey, false);
        Collections.reverse(sidebarLinkBeanList);
        int position = 1;
        for (SidebarLinkBean linkBean : sidebarLinkBeanList) {
            String linkUrl = linkBean.getUrl();
            String type = linkBean.getStyleClass();
            HashMap<String, Object> sidebarLinkMap = new HashMap<String, Object>();
            sidebarLinkMap.put("title", linkBean.getTitle());
            sidebarLinkMap.put("position", position++);
            sidebarLinkMap.put("type", type);
            sidebarLinkMap.put("id", linkBean.getId());
            sidebarLinkMap.put("url", linkBean.getUrl());
            String pageId = "";
            if (type.equalsIgnoreCase("external_link")) {
                pageId = "";
            } else if (type.equalsIgnoreCase("pinned_attachment")) {
                pageId = linkUrl.substring(linkUrl.indexOf("pageId=") + 7);
                if (pageId.contains("&")) {
                    pageId = pageId.substring(0, pageId.indexOf("&"));
                }
                String attachmentId = linkUrl.substring(linkUrl.indexOf("preview=") + 8).replace("%2F" + pageId + "%2F", "");
                pageId = attachmentId.split("%2F")[0];
            } else if (type.equalsIgnoreCase("pinned_profile")) {
                String userName = linkUrl.split("~")[1];
                User confluenceUser = this.toolsHelper.getUserByName(userName);
                if (confluenceUser != null) {
                    pageId = this.personalInformationManager.getOrCreatePersonalInformation(confluenceUser).getIdAsString();
                }
            } else if (type.equalsIgnoreCase("pinned_space")) {
                String[] urlPatterns = linkUrl.split("/");
                String spaceKeyFromPattern = urlPatterns[urlPatterns.length - 1];
                Space spaceFromPattern = this.toolsHelper.getSpaceFromSpaceDao(spaceKeyFromPattern);
                if (spaceFromPattern != null) {
                    pageId = spaceFromPattern.getId() + "";
                }
            } else if (linkUrl.contains("pageId=")) {
                pageId = linkUrl.substring(linkUrl.indexOf("pageId=") + 7);
            } else {
                String[] linkUrlSplit = linkUrl.split("/");
                String pageName = "";
                try {
                    pageName = URLDecoder.decode(linkUrlSplit[linkUrlSplit.length - 1], "UTF-8");
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("pageName  :" + pageName));
                    }
                }
                catch (Exception spaceFromPattern) {
                    // empty catch block
                }
                Page page = this.toolsHelper.getPageFormPageDao(linkUrlSplit[linkUrlSplit.length - 2], pageName);
                BlogPost blogPost = this.toolsHelper.getBlogPostFormPageDao(linkUrlSplit[linkUrlSplit.length - 2], pageName);
                if (page != null) {
                    pageId = page.getIdAsString();
                }
                if (blogPost != null) {
                    pageId = blogPost.getIdAsString();
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("pageId  : " + pageId));
                    log.debug((Object)("page    : " + (page != null)));
                    log.debug((Object)("blogPost: " + (blogPost != null)));
                }
            }
            sidebarLinkMap.put("resourceId", pageId);
            spaceShortcuts.add(sidebarLinkMap);
        }
        response.put("spaceShortcuts", spaceShortcuts);
        return Response.ok(response).build();
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/changeSpaceCreator/user/{userNameOrKey}")
    public Response changeSpaceCreator(String jsonString, @PathParam(value="userNameOrKey") String userNameOrKey, @QueryParam(value="spaceKey") String spaceKey) {
        userNameOrKey = this.toolsHelper.decodeUrlParam(userNameOrKey);
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        JSONObject jsonObject = new JSONObject(jsonString);
        HashMap<String, Object> response = new HashMap<String, Object>();
        String newCreatorName = "";
        if (jsonObject.isNull("newCreatorName") || jsonObject.getString("newCreatorName").equals("")) {
            return this.toolsHelper.fieldRequired("newCreatorName");
        }
        newCreatorName = jsonObject.getString("newCreatorName");
        ConfluenceUser confluenceUser = this.toolsHelper.getConfluenceUserByName(newCreatorName);
        if (confluenceUser == null) {
            return this.toolsHelper.userNotFound(newCreatorName);
        }
        ConfluenceUser oldConfluenceUser = this.toolsHelper.getConfluenceUserByName(userNameOrKey);
        if (oldConfluenceUser == null) {
            oldConfluenceUser = this.toolsHelper.getConfluenceUserByKey(userNameOrKey);
        }
        if (oldConfluenceUser == null) {
            return this.toolsHelper.userNotFound(userNameOrKey);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("userNameOrKey : " + userNameOrKey));
            log.debug((Object)("newCreatorName : " + newCreatorName));
            log.debug((Object)("spaceKey : " + spaceKey));
        }
        ArrayList<String> spacesChanged = new ArrayList<String>();
        ArrayList<String> spacesSkipped = new ArrayList<String>();
        int spaceCount = 0;
        for (Space space : this.spaceDao.getSpacesCreatedByUser(oldConfluenceUser.getName())) {
            if (space != null && space.getSpaceType() != SpaceType.PERSONAL && this.toolsHelper.skipParamSpaceValidation(spaceKey, space)) {
                space.setCreator(confluenceUser);
                this.spaceManager.saveSpace(space);
                spacesChanged.add(space.getKey());
                ++spaceCount;
                continue;
            }
            spacesSkipped.add(space.getKey());
        }
        response.put("spacesSipped", spacesSkipped);
        response.put("spacesChanged", spacesChanged);
        response.put("total", spaceCount);
        response.put("message", "success");
        return Response.ok(response).build();
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/changeSpaceCreator/space/{spaceKey}")
    public Response changeSpaceCreatorBySpaceKey(String jsonString, @PathParam(value="spaceKey") String spaceKey) {
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        JSONObject jsonObject = new JSONObject(jsonString);
        HashMap<String, String> response = new HashMap<String, String>();
        String newCreatorName = "";
        Space space = this.toolsHelper.getSpaceFromSpaceDao(spaceKey);
        if (space == null) {
            return this.toolsHelper.spaceNotExist(spaceKey);
        }
        if (!(this.toolsHelper.isConfluenceAdministrator() || this.toolsHelper.isCurrentUserIsSpaceAdministrator(space) || this.toolsHelper.isDisabledForSpaceAdministrator("changeSpaceCreatorSpaceKey"))) {
            return this.toolsHelper.permissionViolation();
        }
        if (space.getSpaceType().equals((Object)SpaceType.PERSONAL)) {
            return this.toolsHelper.spaceIsNotGlobal(spaceKey);
        }
        if (jsonObject.isNull("newCreatorName") || jsonObject.getString("newCreatorName").equals("")) {
            return this.toolsHelper.fieldRequired("newCreatorName");
        }
        newCreatorName = jsonObject.getString("newCreatorName");
        ConfluenceUser confluenceUser = this.toolsHelper.getConfluenceUserByName(newCreatorName);
        if (confluenceUser == null) {
            return this.toolsHelper.userNotFound(newCreatorName);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("spaceKey : " + spaceKey));
            log.debug((Object)("newCreatorName : " + newCreatorName));
        }
        space.setCreator(confluenceUser);
        this.spaceManager.saveSpace(space);
        response.put("message", "success");
        return Response.ok(response).build();
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/changeSpaceStatus")
    public Response editSpace(String jsonString, @QueryParam(value="spaceKey") String spaceKey) {
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        JSONObject jsonObject = new JSONObject(jsonString);
        String spaceKeyFormJson = "";
        String status = "";
        if (!jsonObject.has("spaceKey") || jsonObject.isNull("spaceKey")) {
            return this.toolsHelper.fieldRequired("spaceKey");
        }
        spaceKeyFormJson = jsonObject.getString("spaceKey");
        if (jsonObject.has("status") && !jsonObject.isNull("status")) {
            status = jsonObject.getString("status");
            if (!status.equalsIgnoreCase("archived") && !status.equalsIgnoreCase("current")) {
                return this.toolsHelper.fieldRequired("status");
            }
        } else {
            return this.toolsHelper.fieldRequired("status");
        }
        Space space = this.toolsHelper.getSpaceFromSpaceDao(spaceKeyFormJson);
        if (space == null) {
            return this.toolsHelper.spaceNotExist(spaceKeyFormJson);
        }
        if (!(this.toolsHelper.isConfluenceAdministrator() || this.toolsHelper.isCurrentUserIsSpaceAdministrator(space) || this.toolsHelper.isDisabledForSpaceAdministrator("changeSpaceStatus"))) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.toolsHelper.skipParamSpaceValidation(spaceKey, space)) {
            return this.toolsHelper.permissionViolation();
        }
        space.setSpaceStatus(status.equalsIgnoreCase("archived") ? SpaceStatus.ARCHIVED : SpaceStatus.CURRENT);
        this.spaceManager.saveSpace(space);
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("message", "space status set to '" + status.toLowerCase() + "'");
        return Response.ok(response).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/changeSpaceKey/task/reset")
    public Response changeSpaceKeyTaskReset() {
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), CHANGE_SPACE_KEY, (Object)"");
        return Response.ok().build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/changeSpaceKey/task")
    public Response checkChangeSpaceKeyTask() {
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        HashMap<String, String> response = new HashMap<String, String>();
        Object asyncTask = this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), CHANGE_SPACE_KEY);
        if (asyncTask == null || asyncTask.toString().isEmpty()) {
            response.put("status", "done");
            response.put("message", "");
            return Response.ok(response).build();
        }
        response.put("status", "in progress");
        response.put("message", asyncTask.toString());
        return Response.ok(response).build();
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/changeSpaceKey")
    public Response changeSpaceKey(String jsonString, @QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="asynchronous") boolean asynchronous) {
        Space spaceOld;
        boolean reindexSpace;
        String newSpaceKey;
        String currentSpaceKey;
        HashMap<String, String> response;
        block24: {
            JSONObject jsonObject;
            block23: {
                if (!this.toolsHelper.isLicenseIsValid()) {
                    return this.toolsHelper.licenseIsInvalid();
                }
                if (this.toolsHelper.isReadOnly()) {
                    return this.toolsHelper.readOnlyMode();
                }
                if (!this.toolsHelper.isConfluenceAdministrator()) {
                    return this.toolsHelper.permissionViolation();
                }
                response = new HashMap<String, String>();
                jsonObject = new JSONObject(jsonString);
                currentSpaceKey = "";
                newSpaceKey = "";
                reindexSpace = false;
                try {
                    currentSpaceKey = jsonObject.getString("currentSpaceKey");
                }
                catch (Exception ex) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"currentSpaceKey is empty");
                    }
                    return this.toolsHelper.fieldRequired("currentSpaceKey");
                }
                if (currentSpaceKey == null || currentSpaceKey.equals("")) {
                    return this.toolsHelper.fieldRequired("newSpaceKey");
                }
                try {
                    newSpaceKey = jsonObject.getString("newSpaceKey");
                }
                catch (Exception ex) {
                    if (!log.isDebugEnabled()) break block23;
                    log.debug((Object)"newSpaceKey is empty");
                }
            }
            if (newSpaceKey == null || newSpaceKey.equals("")) {
                return this.toolsHelper.fieldRequired("newSpaceKey");
            }
            try {
                reindexSpace = jsonObject.getBoolean("reindexSpace");
            }
            catch (Exception ex) {
                if (!log.isDebugEnabled()) break block24;
                log.debug((Object)"reindexSpace is set - serror");
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("currentSpaceKey : " + currentSpaceKey));
            log.debug((Object)("newSpaceKey : " + newSpaceKey));
            log.debug((Object)("reindexSpace : " + reindexSpace));
        }
        if ((spaceOld = this.toolsHelper.getSpaceFromSpaceDao(currentSpaceKey)) == null) {
            return this.toolsHelper.spaceNotExist(currentSpaceKey);
        }
        if (spaceOld.getSpaceType().equals((Object)SpaceType.PERSONAL)) {
            return this.toolsHelper.spaceIsNotGlobal(currentSpaceKey);
        }
        if (!this.toolsHelper.skipParamSpaceValidation(spaceKey, spaceOld)) {
            return this.toolsHelper.permissionViolation();
        }
        Space spaceNew = this.toolsHelper.getSpaceFromSpaceDao(newSpaceKey);
        if (spaceNew != null) {
            return this.toolsHelper.spaceExists(newSpaceKey);
        }
        if (!Space.isValidGlobalSpaceKey((String)newSpaceKey)) {
            return this.toolsHelper.invalidSpaceKey(newSpaceKey);
        }
        IndexManager indexManager = (IndexManager)ContainerManager.getComponent((String)"indexManager", IndexManager.class);
        if (indexManager.isReIndexing()) {
            response.put("message", "Confluence is re-indexing");
            return Response.serverError().entity(response).build();
        }
        spaceOld.setKey(newSpaceKey);
        this.spaceManager.saveSpace(spaceOld);
        if (reindexSpace) {
            List pages = this.pageManager.getPages(this.toolsHelper.getSpaceFromSpaceDao(newSpaceKey), true);
            if (asynchronous) {
                this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), CHANGE_SPACE_KEY, (Object)("Reindexing space with key '" + newSpaceKey + "' is in progress, wait for it to finish [In progress ...]"));
                ChangeSpaceKeyThread changeSpaceKeyThread = new ChangeSpaceKeyThread(pages, this.bandanaManager, this.confluenceIndexer, this.toolsHelper.getCurrentUser(), newSpaceKey);
                changeSpaceKeyThread.start();
            } else {
                for (Page page : pages) {
                    TransactionTemplate transactionTemplate = (TransactionTemplate)ComponentLocator.getComponent(TransactionTemplate.class);
                    transactionTemplate.execute(() -> {
                        page.getAncestors().clear();
                        if (page.getParent() != null) {
                            page.getAncestors().addAll(page.getParent().getAncestors());
                            page.getAncestors().add(page.getParent());
                        }
                        this.confluenceIndexer.reIndex((Searchable)page);
                        return null;
                    });
                }
            }
        }
        response.put("message", "space key '" + currentSpaceKey + "' changed to '" + newSpaceKey + "'");
        return Response.ok(response).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/getAllSpaces")
    public Response getAllSpaces(@QueryParam(value="startAt") int startAt, @QueryParam(value="maxResults") int maxResults, @QueryParam(value="creationDateFrom") String creationDateFrom, @QueryParam(value="creationDateTo") String creationDateTo, @QueryParam(value="lastPermissionModificationDateFrom") String lastPermissionModificationDateFrom, @QueryParam(value="lastPermissionModificationDateTo") String lastPermissionModificationDateTo, @QueryParam(value="dateFormat") String dateFormatApi, @QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="spacesAsArray") boolean spacesAsArray) throws ParseException {
        HashMap<String, Serializable> response = new HashMap<String, Serializable>();
        HashMap<String, Map<String, String>> spaces = new HashMap<String, Map<String, String>>();
        ArrayList<Map<String, String>> spacesArray = new ArrayList<Map<String, String>>();
        Date from = new Date();
        Date to = new Date();
        Date lastPermissionModificationFrom = new Date();
        Date lastPermissionModificationTo = new Date();
        boolean checkDateFrom = false;
        boolean checkDateTo = false;
        boolean checkLastPermissionModificationDateFrom = false;
        boolean checkLastPermissionModificationDateTo = false;
        String dateFormat = "";
        String fullDateFormat = "";
        if (dateFormatApi == null || dateFormatApi.equals("")) {
            dateFormat = "yyyy-MM-dd";
            fullDateFormat = dateFormat + " HH:mm:ss";
        } else {
            dateFormat = dateFormatApi;
            fullDateFormat = dateFormatApi + " HH:mm:ss";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        SimpleDateFormat sdfFull = new SimpleDateFormat(fullDateFormat);
        if (creationDateFrom != null && !creationDateFrom.equals("")) {
            checkDateFrom = true;
            from = sdf.parse(creationDateFrom);
        }
        if (creationDateTo != null && !creationDateTo.equals("")) {
            checkDateTo = true;
            to = sdf.parse(creationDateTo);
        }
        if (lastPermissionModificationDateFrom != null && !lastPermissionModificationDateFrom.equals("")) {
            checkLastPermissionModificationDateFrom = true;
            lastPermissionModificationFrom = sdf.parse(lastPermissionModificationDateFrom);
        }
        if (lastPermissionModificationDateTo != null && !lastPermissionModificationDateTo.equals("")) {
            checkLastPermissionModificationDateTo = true;
            lastPermissionModificationTo = sdf.parse(lastPermissionModificationDateTo);
        }
        int iterator = 0;
        int total = 0;
        if (maxResults == 0) {
            maxResults = 100;
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        List<Space> spaceList = this.toolsHelper.getAllSpacesFormSpaceDao();
        if (spaceKey != null && !spaceKey.equals("")) {
            spaceList = new ArrayList<Space>();
            spaceList.add(this.toolsHelper.getSpaceFromSpaceDao(spaceKey));
        }
        for (Space space : spaceList) {
            long lastPermissionModificationLong = -1L;
            Date lastPermissionModificationDate = null;
            if (checkLastPermissionModificationDateFrom || checkLastPermissionModificationDateTo) {
                for (SpacePermission spacePermission : space.getPermissions()) {
                    Date creationDate = spacePermission.getCreationDate();
                    if (creationDate.getTime() <= lastPermissionModificationLong) continue;
                    lastPermissionModificationLong = creationDate.getTime();
                    lastPermissionModificationDate = creationDate;
                }
                if (lastPermissionModificationDate == null) {
                    checkLastPermissionModificationDateFrom = false;
                    checkLastPermissionModificationDateTo = false;
                }
            }
            if (!this.spaceValidCondition(space, checkDateFrom, checkDateTo, checkLastPermissionModificationDateFrom, checkLastPermissionModificationDateTo, to, from, lastPermissionModificationDate, lastPermissionModificationTo, lastPermissionModificationFrom)) continue;
            if (startAt <= iterator && iterator < startAt + maxResults) {
                String spaceKeyFromSpace = space.getKey();
                Map<String, String> spaceDetails = spaces.get(spaceKeyFromSpace) == null ? new HashMap() : (Map)spaces.get(spaceKeyFromSpace);
                spaceDetails.put("creationDate", (String)((Object)space.getCreationDate()));
                spaceDetails.put("creationDateString", sdfFull.format(space.getCreationDate()));
                spaceDetails.put("lastModificationDate", (String)((Object)space.getLastModificationDate()));
                spaceDetails.put("lastModificationDateString", sdfFull.format(space.getLastModificationDate()));
                Page contentEntityObject = this.toolsHelper.getLastModifiedFormPageDao(space);
                if (contentEntityObject != null) {
                    spaceDetails.put("lastContentModificationDate", (String)((Object)contentEntityObject.getLastModificationDate()));
                    spaceDetails.put("lastContentModificationId", contentEntityObject.getIdAsString());
                    spaceDetails.put("lastContentModificationDateString", sdfFull.format(contentEntityObject.getLastModificationDate()));
                } else {
                    spaceDetails.put("lastContentModificationDate", "");
                    spaceDetails.put("lastContentModificationId", "");
                    spaceDetails.put("lastContentModificationDateString", "");
                }
                if (!checkLastPermissionModificationDateFrom && !checkLastPermissionModificationDateTo) {
                    lastPermissionModificationLong = -1L;
                    lastPermissionModificationDate = null;
                    for (SpacePermission spacePermission : space.getPermissions()) {
                        Date creationDate = spacePermission.getCreationDate();
                        if (creationDate.getTime() <= lastPermissionModificationLong) continue;
                        lastPermissionModificationLong = creationDate.getTime();
                        lastPermissionModificationDate = creationDate;
                    }
                }
                if (lastPermissionModificationDate != null) {
                    spaceDetails.put("lastPermissionModificationDate", (String)((Object)lastPermissionModificationDate));
                    spaceDetails.put("lastPermissionModificationDateString", sdfFull.format(lastPermissionModificationDate));
                } else {
                    spaceDetails.put("lastPermissionModificationDate", "");
                    spaceDetails.put("lastPermissionModificationDateString", "");
                }
                spaceDetails.put("creatorName", space.getCreator() != null ? space.getCreator().getName() : "not exist");
                spaceDetails.put("key", space.getKey());
                spaceDetails.put("id", (String)((Object)Long.valueOf(space.getId())));
                spaceDetails.put("name", space.getName());
                spaceDetails.put("status", space.isArchived() ? "archived" : "current");
                if (spacesAsArray) {
                    spacesArray.add(spaceDetails);
                } else {
                    spaces.put(spaceKeyFromSpace, spaceDetails);
                }
            }
            ++iterator;
            ++total;
        }
        response.put("startAt", Integer.valueOf(startAt));
        response.put("maxResults", Integer.valueOf(maxResults));
        if (spacesAsArray) {
            response.put("spaces", spacesArray);
        } else {
            response.put("spaces", spaces);
        }
        response.put("total", Integer.valueOf(total));
        return Response.ok(response).build();
    }

    private boolean spaceValidCondition(Space space, boolean checkDateFrom, boolean checkDateTo, boolean checkLastPermissionModificationDateFrom, boolean checkLastPermissionModificationDateTo, Date to, Date from, Date lastPermissionModificationDate, Date lastPermissionModificationTo, Date lastPermissionModificationFrom) {
        return !checkDateFrom && !checkDateTo && !checkLastPermissionModificationDateFrom && !checkLastPermissionModificationDateTo || (checkDateFrom || checkDateTo) && (!checkDateFrom && checkDateTo && space.getCreationDate().compareTo(to) <= 0 || checkDateFrom && !checkDateTo && space.getCreationDate().compareTo(from) >= 0 || checkDateFrom && space.getCreationDate().compareTo(from) >= 0 && checkDateTo && space.getCreationDate().compareTo(to) <= 0) || (checkLastPermissionModificationDateFrom || checkDateTo) && (!checkLastPermissionModificationDateFrom && checkLastPermissionModificationDateTo && lastPermissionModificationDate.compareTo(lastPermissionModificationTo) <= 0 || checkLastPermissionModificationDateFrom && !checkLastPermissionModificationDateTo && lastPermissionModificationDate.compareTo(lastPermissionModificationFrom) >= 0 || checkLastPermissionModificationDateFrom && lastPermissionModificationDate.compareTo(lastPermissionModificationFrom) >= 0 && checkLastPermissionModificationDateTo && lastPermissionModificationDate.compareTo(lastPermissionModificationTo) <= 0);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/getSpace/{spaceKey}")
    public Response getSpace(@PathParam(value="spaceKey") String spaceKey, @QueryParam(value="dateFormat") String dateFormatApi) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        Space space = this.toolsHelper.getSpaceFromSpaceDao(spaceKey);
        if (space == null) {
            return this.toolsHelper.spaceNotExist(spaceKey);
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (!this.toolsHelper.isConfluenceAdministrator() && !this.toolsHelper.isCurrentUserIsSpaceAdministrator(space)) {
            return this.toolsHelper.permissionViolation();
        }
        String fullDateFormat = "";
        fullDateFormat = dateFormatApi == null || dateFormatApi.equals("") ? "yyyy-MM-dd HH:mm:ss" : dateFormatApi + " HH:mm:ss";
        SimpleDateFormat sdfFull = new SimpleDateFormat(fullDateFormat);
        response.put("creationDate", space.getCreationDate());
        response.put("creationDateString", sdfFull.format(space.getCreationDate()));
        response.put("lastModificationDate", space.getLastModificationDate());
        response.put("lastModificationDateString", sdfFull.format(space.getLastModificationDate()));
        Page contentEntityObject = this.toolsHelper.getLastModifiedFormPageDao(space);
        if (contentEntityObject != null) {
            response.put("lastContentModificationDate", contentEntityObject.getLastModificationDate());
            response.put("lastContentModificationId", contentEntityObject.getIdAsString());
            response.put("lastContentModificationDateString", sdfFull.format(contentEntityObject.getLastModificationDate()));
        } else {
            response.put("lastContentModificationDate", "");
            response.put("lastContentModificationId", "");
            response.put("lastContentModificationDateString", "");
        }
        long lastPermissionModificationLong = -1L;
        Date lastPermissionModificationDate = null;
        for (SpacePermission spacePermission : space.getPermissions()) {
            Date creationDate = spacePermission.getCreationDate();
            if (creationDate.getTime() <= lastPermissionModificationLong) continue;
            lastPermissionModificationLong = creationDate.getTime();
            lastPermissionModificationDate = creationDate;
        }
        if (lastPermissionModificationDate != null) {
            response.put("lastPermissionModificationDate", lastPermissionModificationDate);
            response.put("lastPermissionModificationDateString", sdfFull.format(lastPermissionModificationDate));
        } else {
            response.put("lastPermissionModificationDate", "");
            response.put("lastPermissionModificationDateString", "");
        }
        response.put("creatorName", space.getCreator() != null ? space.getCreator().getName() : "not exist");
        response.put("key", space.getKey());
        response.put("id", space.getId());
        response.put("name", space.getName());
        response.put("status", space.isArchived() ? "archived" : "current");
        return Response.ok(response).build();
    }

    public class ChangeSpaceKeyThread
    extends Thread {
        private List<Page> pages;
        private final String newSpaceKey;
        private final ConfluenceUser currentUser;
        private final BandanaManager bandanaManager;
        private final ConfluenceIndexer confluenceIndexer;

        public ChangeSpaceKeyThread(List<Page> pages, BandanaManager bandanaManager, ConfluenceIndexer confluenceIndexer, ConfluenceUser currentUser, String newSpaceKey) {
            this.pages = pages;
            this.currentUser = currentUser;
            this.bandanaManager = bandanaManager;
            this.newSpaceKey = newSpaceKey;
            this.confluenceIndexer = confluenceIndexer;
        }

        @Override
        public void run() {
            if (log.isDebugEnabled()) {
                log.debug((Object)("pages: " + this.pages));
                log.debug((Object)("newSpaceKey: " + this.newSpaceKey));
                log.debug((Object)("pages.size(): " + this.pages.size()));
            }
            int total = this.pages.size();
            AtomicInteger countIndex = new AtomicInteger();
            for (Page page : this.pages) {
                TransactionTemplate transactionTemplate = (TransactionTemplate)ComponentLocator.getComponent(TransactionTemplate.class);
                transactionTemplate.execute(() -> {
                    countIndex.set(countIndex.get() + 1);
                    page.getAncestors().clear();
                    if (page.getParent() != null) {
                        page.getAncestors().addAll(page.getParent().getAncestors());
                        page.getAncestors().add(page.getParent());
                    }
                    log.warn((Object)("[EXTENDER][CSKT][changeSpaceKey] Reindexing space with key '" + this.newSpaceKey + "' is in progress, wait for it to finish [" + countIndex.get() + " of " + total + "]"));
                    this.confluenceIndexer.reIndex((Searchable)page);
                    this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), SpaceRestApi.CHANGE_SPACE_KEY, (Object)("Reindexing space with key '" + this.newSpaceKey + "' is in progress, wait for it to finish [" + countIndex.get() + " of " + total + "]"));
                    return null;
                });
            }
            this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), SpaceRestApi.CHANGE_SPACE_KEY, (Object)"");
        }
    }

    public class UpdateSpaceContentThread
    extends Thread {
        private String searchQuery;
        private String find;
        private String replace;
        private boolean ignoreCase;
        private final CQLSearchService cqlSearchService;
        private final ConfluenceUser currentUser;
        private final BandanaManager bandanaManager;
        private final String spaceKey;

        public UpdateSpaceContentThread(CQLSearchService cqlSearchService, BandanaManager bandanaManager, ConfluenceUser currentUser, String spaceKey, String searchQuery, String find, String replace, boolean ignoreCase) {
            this.searchQuery = searchQuery;
            this.find = find;
            this.replace = replace;
            this.ignoreCase = ignoreCase;
            this.cqlSearchService = cqlSearchService;
            this.currentUser = currentUser;
            this.bandanaManager = bandanaManager;
            this.spaceKey = spaceKey;
        }

        @Override
        public void run() {
            int loop = 1;
            PageResponse pageResponse = SpaceRestApi.this.getContentCqlQuery(this.searchQuery, this.currentUser);
            int total = this.cqlSearchService.countContent(this.searchQuery, SearchContext.builder().build());
            boolean whileBoolean = false;
            if (pageResponse.size() > 0) {
                whileBoolean = true;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("searchQuery: " + this.searchQuery));
                log.debug((Object)("total: " + total));
                log.debug((Object)("pageResponse.size(): " + pageResponse.size()));
            }
            ArrayList processedPages = new ArrayList();
            while (whileBoolean) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("[SPACE][replaceAll] :: START :: " + loop));
                    log.debug((Object)("[SPACE][replaceAll] :: START :: searchQuery: " + this.searchQuery));
                    log.debug((Object)("[SPACE][replaceAll] :: START :: total: " + total));
                    log.debug((Object)("[SPACE][replaceAll] :: START :: pageResponse.size(): " + pageResponse.size()));
                }
                PageResponse finalPageResponse = pageResponse;
                TransactionTemplate transactionTemplate = (TransactionTemplate)ComponentLocator.getComponent(TransactionTemplate.class);
                transactionTemplate.execute(() -> {
                    for (Content content : finalPageResponse.getResults()) {
                        String newBody;
                        long contentId = content.getId().asLong();
                        Page page = SpaceRestApi.this.toolsHelper.getPageFormPageDao(contentId);
                        String body = page.getEntity().getBodyAsString();
                        boolean saveNewContent = false;
                        if (this.ignoreCase && body.toLowerCase().contains(this.find.toLowerCase())) {
                            saveNewContent = true;
                            newBody = StringUtils.replaceIgnoreCase((String)body, (String)this.find, (String)this.replace);
                        } else if (body.contains(this.find)) {
                            saveNewContent = true;
                            newBody = body.replace(this.find, this.replace);
                        } else {
                            saveNewContent = false;
                            newBody = body;
                        }
                        if (saveNewContent) {
                            SpaceRestApi.this.pageManager.saveNewVersion((ContentEntityObject)page, pageToModify -> pageToModify.getEntity().setBodyAsString(newBody));
                        }
                        processedPages.add(page.getId());
                        log.warn((Object)("[EXTENDER][USCT][replaceAll] contentId: " + contentId + " :: processing ..."));
                        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), SpaceRestApi.REPLACE_ALL_TASK, (Object)("API 'replaceAll' for space '" + this.spaceKey + "' is in progress, wait for it to finish [" + processedPages.size() + " of " + total + "]"));
                    }
                    return null;
                });
                if (log.isDebugEnabled()) {
                    log.debug((Object)("[SPACE][replaceAll] :: END :: " + loop));
                }
                if (pageResponse.hasMore()) {
                    this.searchQuery = this.searchQuery + (processedPages.size() > 0 ? " AND id not in (" + StringUtils.join(processedPages, (String)",") + ")" : "");
                    pageResponse = SpaceRestApi.this.getContentCqlQuery(this.searchQuery, this.currentUser);
                } else {
                    whileBoolean = false;
                }
                ++loop;
            }
            this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), SpaceRestApi.REPLACE_ALL_TASK, (Object)"");
        }
    }
}

