/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender.resources;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.core.filters.ServletContextThreadLocal;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.webresource.api.data.WebResourceDataProvider;
import com.itlab.confluence.plugins.restextender.helper.ToolsHelper;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataProvider
implements WebResourceDataProvider {
    private static final Logger log = LoggerFactory.getLogger(DataProvider.class);
    private static final String BUTTONS_GROUP = "com.itlab.confluence.plugins.restextender.notifyWatchers.groups";
    private final ToolsHelper toolsHelper;
    private final BandanaManager bandanaManager;
    private final UserAccessor userAccessor;

    @Inject
    public DataProvider(@ConfluenceImport UserAccessor userAccessor, ToolsHelper toolsHelper) {
        this.toolsHelper = toolsHelper;
        this.bandanaManager = (BandanaManager)ComponentLocator.getComponent(BandanaManager.class);
        this.userAccessor = userAccessor;
    }

    public Jsonable get() {
        return writer -> {
            block2: {
                try {
                    this.getBodyContentJsonObject().write(writer);
                }
                catch (Exception ex) {
                    if (!log.isDebugEnabled()) break block2;
                    log.debug("Exception: " + ExceptionUtils.getStackTrace((Throwable)ex));
                }
            }
        };
    }

    private JSONObject getBodyContentJsonObject() throws JSONException {
        JSONObject pluginData = new JSONObject();
        pluginData.put("baseUrl", (Object)this.toolsHelper.getBaseUrl());
        pluginData.put("isConfluenceAdministrator", this.toolsHelper.isConfluenceAdministrator());
        pluginData.put("isLicenseIsValid", this.toolsHelper.isLicenseIsValid());
        pluginData.put("isPluginRemoved", this.toolsHelper.isSensitiveCustomer());
        pluginData.put("isSourceEditorVisible", this.toolsHelper.isSourceEditorVisibleForUser());
        pluginData.put("notifyWatchers", this.notifyWatchers());
        pluginData.put("changeContextBack", this.changeContextBack());
        return pluginData;
    }

    private boolean notifyWatchers() {
        Object groups = this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), BUTTONS_GROUP);
        ConfluenceUser confluenceUser = this.toolsHelper.getAuthenticatedUser();
        if (confluenceUser == null || confluenceUser.getName() == null) {
            return false;
        }
        List userGroups = this.userAccessor.getGroupNamesForUserName(confluenceUser.getName());
        boolean isInGroup = false;
        if (groups != null) {
            if (groups.toString().contains("@@@")) {
                String[] groupsTable = groups.toString().split("@@@");
                for (int i = 0; i < groupsTable.length; ++i) {
                    if (!userGroups.contains(groupsTable[i])) continue;
                    isInGroup = true;
                    break;
                }
            } else if (!groups.toString().equals("") && userGroups.contains(groups.toString())) {
                isInGroup = true;
            }
        }
        return this.toolsHelper.isLicenseIsValid() && isInGroup;
    }

    private boolean changeContextBack() {
        HttpServletRequest req = ServletContextThreadLocal.getRequest();
        if (req == null || req.getSession() == null) {
            return false;
        }
        Object param = req.getSession().getAttribute("extender_default_user");
        return this.toolsHelper.isLicenseIsValid() && param != null && !param.equals("") && this.toolsHelper.isUserExistByName(param.toString());
    }
}

