/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender.privileges;

import com.itlab.confluence.plugins.restextender.helper.ToolsHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/configuration")
public class ExtenderRestApi {
    private static final Logger log = LoggerFactory.getLogger(ExtenderRestApi.class);
    private ToolsHelper toolsHelper;

    @Inject
    public ExtenderRestApi(ToolsHelper toolsHelper) {
        this.toolsHelper = toolsHelper;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/set/api/{apiType}/{disabled}")
    public Response setApi(@PathParam(value="apiType") String apiType, @PathParam(value="disabled") boolean disabled, @Context HttpServletRequest request) throws JSONException {
        HashMap<String, String> response = new HashMap<String, String>();
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        this.toolsHelper.setApiConfiguration(apiType, disabled);
        response.put("status", "done");
        return Response.ok(response).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/get")
    public Response getConfiguration() throws JSONException {
        HashMap<String, ArrayList<Map<String, Object>>> response = new HashMap<String, ArrayList<Map<String, Object>>>();
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        ArrayList apiDisabled = this.toolsHelper.getDisabledApiConfiguration();
        response.put("api", apiDisabled);
        ArrayList<Map<String, Object>> configuration = this.toolsHelper.getConfiguration();
        if (!configuration.isEmpty()) {
            response.put("configuration", configuration);
        }
        return Response.ok(response).build();
    }
}

