/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender.condition;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.webresource.api.QueryParams;
import com.atlassian.webresource.api.url.UrlBuilder;
import com.atlassian.webresource.spi.condition.UrlReadingCondition;
import com.itlab.confluence.plugins.restextender.helper.ToolsHelper;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotifyWatchersCondition
implements UrlReadingCondition {
    private static final Logger log = LoggerFactory.getLogger(NotifyWatchersCondition.class);
    private final ToolsHelper toolsHelper;
    private final BandanaManager bandanaManager;
    private final UserAccessor userAccessor;
    private static final String BUTTONS_GROUP = "com.itlab.confluence.plugins.restextender.notifyWatchers.groups";

    @Inject
    public NotifyWatchersCondition(@ConfluenceImport UserAccessor userAccessor, ToolsHelper toolsHelper) {
        this.toolsHelper = toolsHelper;
        this.bandanaManager = (BandanaManager)ComponentLocator.getComponent(BandanaManager.class);
        this.userAccessor = userAccessor;
    }

    public void init(Map<String, String> map) throws PluginParseException {
    }

    public void addToUrl(UrlBuilder urlBuilder) {
    }

    public boolean shouldDisplay(QueryParams queryParams) {
        Object groups = this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), BUTTONS_GROUP);
        ConfluenceUser confluenceUser = this.toolsHelper.getAuthenticatedUser();
        if (confluenceUser == null || confluenceUser.getName() == null) {
            return false;
        }
        List userGroups = this.userAccessor.getGroupNamesForUserName(confluenceUser.getName());
        boolean isInGroup = false;
        if (groups != null) {
            if (groups.toString().contains("@@@")) {
                String[] groupsTable = groups.toString().split("@@@");
                for (int i = 0; i < groupsTable.length; ++i) {
                    if (!userGroups.contains(groupsTable[i])) continue;
                    isInGroup = true;
                    break;
                }
            } else if (!groups.toString().equals("") && userGroups.contains(groups.toString())) {
                isInGroup = true;
            }
        }
        return this.toolsHelper.isLicenseIsValid() && isInGroup;
    }
}

