/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender.contactForm;

import com.atlassian.confluence.mail.ConfluenceMailServerManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.TrashManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.mail.Email;
import com.atlassian.mail.MailException;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.sal.api.component.ComponentLocator;
import com.itlab.confluence.plugins.restextender.helper.ToolsHelper;
import java.util.HashMap;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/contactForm")
public class ContactFormApi {
    private static final Logger log = LoggerFactory.getLogger(ContactFormApi.class);
    private final ToolsHelper toolsHelper;
    private final TrashManager trashManager;
    private final PageManager pageManager;
    private final UserAccessor userAccessor;

    @Inject
    public ContactFormApi(@ConfluenceImport TrashManager trashManager, @ConfluenceImport PageManager pageManager, @ConfluenceImport UserAccessor userAccessor, ToolsHelper toolsHelper) {
        this.toolsHelper = toolsHelper;
        this.trashManager = trashManager;
        this.pageManager = pageManager;
        this.userAccessor = userAccessor;
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="sendMessage")
    public Response sendMessage(String jsonString, @Context HttpServletRequest request) {
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        HashMap<String, String> response = new HashMap<String, String>();
        JSONObject jsonObject = new JSONObject(jsonString);
        String message = jsonObject.getString("message").replace("@@quot@@", "\"").replace("@@br@@", "<br>");
        String spaceKeys = jsonObject.getString("spaceKeys");
        String title = jsonObject.getString("title");
        boolean skipConfluenceAdmins = jsonObject.getBoolean("skipConfluenceAdmins");
        boolean useBCC = jsonObject.getBoolean("useBCC");
        log.warn("message " + message);
        log.warn("spaceKeys " + spaceKeys);
        log.warn("title " + title);
        log.warn("skipConfluenceAdmins " + skipConfluenceAdmins);
        log.warn("useBCC " + useBCC);
        ConfluenceMailServerManager confluenceMailServerManager = (ConfluenceMailServerManager)ComponentLocator.getComponent(ConfluenceMailServerManager.class);
        SMTPMailServer smtpMailServer = confluenceMailServerManager.getDefaultSMTPMailServer();
        if (smtpMailServer != null) {
            String to = "";
            String bcc = "";
            if (useBCC) {
                bcc = this.toolsHelper.getCurrentUser().getEmail();
            } else {
                to = this.toolsHelper.getCurrentUser().getEmail();
            }
            Email mail = new Email(to, "", bcc);
            mail.setBody(message);
            mail.setSubject(title);
            mail.setMimeType("text/html");
            String mailMessage = "The email has been sent";
            ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(SMTPMailServer.class.getClassLoader());
            try {
                smtpMailServer.send(mail);
                response.put("status", "success");
            }
            catch (MailException ex) {
                response.put("status", "error");
                mailMessage = "Error while sending email - " + ex.getMessage();
            }
            Thread.currentThread().setContextClassLoader(threadClassLoader);
            response.put("message", mailMessage);
        } else {
            response.put("status", "warning");
            response.put("message", "Mail has not been sent, the mail server does not exist");
        }
        return Response.ok(response).build();
    }
}

