/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender.helper.rest;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.search.query.entity.UserQuery;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestriction;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestrictionImpl;
import com.atlassian.crowd.search.query.entity.restriction.MatchMode;
import com.atlassian.crowd.search.query.entity.restriction.TermRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.atlassian.user.search.page.Pager;
import com.google.common.collect.ImmutableList;
import com.itlab.confluence.plugins.restextender.helper.ToolsHelper;
import io.atlassian.fugue.Option;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;

@Path(value="/idHelper")
public class IdHelperApi {
    private static final Logger log = Logger.getLogger(IdHelperApi.class);
    private final ToolsHelper toolsHelper;
    private final UserAccessor userAccessor;
    private final CrowdService crowdService;

    @Inject
    public IdHelperApi(@ConfluenceImport UserAccessor userAccessor, ToolsHelper toolsHelper) {
        this.userAccessor = userAccessor;
        this.toolsHelper = toolsHelper;
        this.crowdService = (CrowdService)ComponentLocator.getComponent(CrowdService.class);
    }

    private String getNotNullValue(Object value) {
        if (value == null) {
            return "";
        }
        return this.getNotNullValue(value + "");
    }

    private String getNotNullValue(String value) {
        if (value == null || value.equalsIgnoreCase("null")) {
            return "";
        }
        return value;
    }

    private boolean passContainsCondition(Long elementId, String elementName, String elementDescription, String searchString) {
        return this.passContainsCondition(Long.toString(elementId), elementName, elementDescription, searchString);
    }

    private boolean passContainsCondition(String elementId, String elementName, String elementDescription, String searchString) {
        elementId = this.toolsHelper.unescapeHtml(elementId);
        elementName = this.toolsHelper.unescapeHtml(elementName);
        elementDescription = this.toolsHelper.unescapeHtml(elementDescription);
        return this.containsIgnoreCase(elementId, searchString = this.toolsHelper.unescapeHtml(searchString)) || this.containsIgnoreCase(elementName, searchString) || this.containsIgnoreCase(elementDescription, searchString);
    }

    private boolean containsIgnoreCase(String src, String what) {
        int length = what.length();
        if (length == 0) {
            return true;
        }
        char firstLo = Character.toLowerCase(what.charAt(0));
        char firstUp = Character.toUpperCase(what.charAt(0));
        for (int i = src.length() - length; i >= 0; --i) {
            char ch = src.charAt(i);
            if (ch != firstLo && ch != firstUp || !src.regionMatches(true, i, what, 0, length)) continue;
            return true;
        }
        return false;
    }

    private Map transformResponse(Map firstElementValue) {
        return this.transformResponse("results", firstElementValue);
    }

    private Map transformResponse(final String firstElementName, final Map firstElementValue) {
        return new HashMap<String, Object>(){
            {
                this.put(firstElementName, firstElementValue);
            }
        };
    }

    private Response findAndReturn(String configType, String search, List values) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("findAndReturn - START " + configType));
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        HashSet<String> addedObjects = new HashSet<String>();
        if (search.equals("")) {
            for (Object object : values) {
                String groupName;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("findAndReturn - object " + object));
                }
                List<?> value = ToolsHelper.convertObjectToList(object);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("findAndReturn - value " + value));
                }
                if (configType.equalsIgnoreCase("spaces")) {
                    response.put(value.get(1).toString().trim(), value.get(0));
                    continue;
                }
                if (!configType.equalsIgnoreCase("groups") || addedObjects.contains(groupName = this.getNotNullValue(value.get(1)))) continue;
                addedObjects.add(groupName);
                response.put(groupName, groupName);
            }
        } else {
            for (Object object : values) {
                String groupName;
                List<?> value = ToolsHelper.convertObjectToList(object);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("findAndReturn - value " + value));
                }
                if (configType.equalsIgnoreCase("spaces")) {
                    String spaceDescription = this.getNotNullValue(value.get(3)).toString().replaceAll("^clob[0-9]+:", "");
                    if (!this.passContainsCondition(this.getNotNullValue(value.get(0)) + " " + this.getNotNullValue(value.get(2)), this.getNotNullValue(value.get(1)), spaceDescription, search)) continue;
                    response.put(value.get(1).toString().trim(), this.getNotNullValue(value.get(0)) + " | " + this.getNotNullValue(value.get(2)));
                    continue;
                }
                if (!configType.equalsIgnoreCase("groups") || !this.passContainsCondition(groupName = this.getNotNullValue(value.get(1)), "", "", search) || addedObjects.contains(groupName)) continue;
                addedObjects.add(groupName);
                response.put(groupName, groupName);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("findAndReturn - DONE " + configType));
        }
        return Response.ok((Object)this.transformResponse(response)).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/users/all")
    public Response getUsers(@DefaultValue(value="") @QueryParam(value="search") String search, @Context HttpServletRequest request) {
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        HashMap<String, Serializable> response = new HashMap<String, Serializable>();
        ArrayList users = new ArrayList();
        int maxResults = 50;
        int iterator = 0;
        int startAt = 0;
        SearchRestriction searchRestriction = (SearchRestriction)this.makeUserSearchRestrictionsForAllUsers(search).getOrNull();
        UserQuery query = new UserQuery(String.class, searchRestriction, 0, -1);
        Iterable userNames = this.crowdService.search((Query)query);
        List userNamesList = userNames instanceof List ? (List)userNames : ImmutableList.copyOf((Iterable)userNames);
        for (String userName : userNamesList) {
            ConfluenceUser applicationUser = this.userAccessor.getUserByName(userName);
            if (startAt <= iterator && iterator < startAt + maxResults) {
                HashMap<String, String> userMap = new HashMap<String, String>();
                userMap.put("username", applicationUser.getName());
                userMap.put("userKey", applicationUser.getKey().getStringValue());
                userMap.put("title", applicationUser.getFullName());
                userMap.put("avatarUrl", this.userAccessor.getUserProfilePicture((User)applicationUser).getUriReference());
                users.add(userMap);
            }
            if (++iterator <= startAt + maxResults) continue;
            break;
        }
        response.put("result", users);
        response.put("total", Integer.valueOf(userNamesList.size()));
        response.put("maxResults", Integer.valueOf(maxResults));
        return Response.ok(response).build();
    }

    private Option<SearchRestriction> makeUserSearchRestrictionsForAllUsers(String searchFilter) {
        ArrayList<BooleanRestrictionImpl> searchRestrictionList = new ArrayList<BooleanRestrictionImpl>();
        searchRestrictionList.add(new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.OR, (Collection)ImmutableList.of((Object)new TermRestriction(UserTermKeys.ACTIVE, MatchMode.EXACTLY_MATCHES, (Object)true), (Object)new TermRestriction(UserTermKeys.ACTIVE, MatchMode.EXACTLY_MATCHES, (Object)false))));
        searchRestrictionList.add(new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.OR, (Collection)ImmutableList.of((Object)new TermRestriction(UserTermKeys.USERNAME, MatchMode.CONTAINS, (Object)searchFilter), (Object)new TermRestriction(UserTermKeys.DISPLAY_NAME, MatchMode.CONTAINS, (Object)searchFilter), (Object)new TermRestriction(UserTermKeys.EMAIL, MatchMode.CONTAINS, (Object)searchFilter))));
        return Option.option((Object)new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.AND, searchRestrictionList));
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/space/all")
    public Response getSpaces(@DefaultValue(value="") @QueryParam(value="search") String search, @Context HttpServletRequest request) {
        List matchingResults;
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"spaces :: use native query");
        }
        if ((matchingResults = this.toolsHelper.getDataBaseResults("SELECT sp.SPACEID, sp.SPACENAME, sp.SPACEKEY, bc.BODY FROM SPACES sp LEFT JOIN BODYCONTENT bc ON sp.SPACEDESCID = bc.CONTENTID", "space")) == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"spaces :: use internal JAVA API");
            }
            List<Space> spaces = this.toolsHelper.getAllSpacesFormSpaceDao();
            HashMap<String, String> response = new HashMap<String, String>();
            if (search.equals("")) {
                for (Space space : spaces) {
                    response.put(space.getName().trim(), this.getNotNullValue(space.getId()) + " | " + this.getNotNullValue(space.getKey()));
                }
            } else {
                for (Space space : spaces) {
                    String description;
                    String string = description = space.getDescription() != null && space.getDescription().getLatestVersion() != null ? this.toolsHelper.getSpaceDescription(space.getDescription()) : "";
                    if (!this.passContainsCondition(this.getNotNullValue(space.getId()) + " " + this.getNotNullValue(space.getKey()), this.getNotNullValue(space.getName()), this.getNotNullValue(description), search)) continue;
                    response.put(space.getName().trim(), this.getNotNullValue(space.getId()) + " | " + this.getNotNullValue(space.getKey()));
                }
            }
            return Response.ok((Object)this.transformResponse(response)).build();
        }
        return this.findAndReturn("spaces", search, matchingResults);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/group/all")
    public Response getGroups(@DefaultValue(value="") @QueryParam(value="search") String search, @Context HttpServletRequest request) {
        List matchingResults;
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"groups :: use native query");
        }
        if ((matchingResults = this.toolsHelper.getDataBaseResults("SELECT * FROM cwd_group", "group")) == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"groups :: use internal JAVA API");
            }
            Pager groups = this.userAccessor.getGroups();
            HashMap<String, String> response = new HashMap<String, String>();
            if (search.equals("")) {
                for (Group group : groups) {
                    response.put(group.getName().trim(), this.getNotNullValue(group.getName()));
                }
            } else {
                for (Group group : groups) {
                    if (!this.passContainsCondition(this.getNotNullValue(group.getName()), "", "", search)) continue;
                    response.put(group.getName().trim(), this.getNotNullValue(group.getName()));
                }
            }
            return Response.ok((Object)this.transformResponse(response)).build();
        }
        return this.findAndReturn("groups", search, matchingResults);
    }
}

