/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender.helper;

import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.license.LicenseService;
import com.atlassian.extras.api.ProductLicense;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.Contact;
import com.atlassian.upm.api.license.entity.Organization;
import com.atlassian.upm.api.license.entity.PluginLicense;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExportAsService(value={LicenseHelper.class})
@Named(value="licenseHelper")
public class LicenseHelper {
    private static final Logger log = LoggerFactory.getLogger(LicenseHelper.class);
    private final PluginLicenseManager pluginLicenseManager;
    private final LicenseService licenseService;
    private final BandanaManager bandanaManager;
    private static final List<String> CUSTOMER_MAIL = Arrays.asList("@promity.", "@infodesign.", "@mdacorporation.", "@mdaspace.", "@mda.", "@verisk.", "@xactware.", "@srt-lpwan.", "@ship.scea.", "@scea.", "@teradata.", "@scandio.", "@isostech.", "@theonevalley.", "@eficode.", "@amadeus.", "@foundtoo.", "@em.", "@mercedes-benz.", "@turn10studio.", "@bayer.");
    private static final List<String> CUSTOMER_NAME = Arrays.asList("Info Design", "Info-Design", "Info Design Systemy", "Info Design Systemy Informatyczne", "Xactware", "MDA", "MDA Space", "MDAspace", "SRT", "SRT_IT", "SRT IT", "SIEA", "SIEA, LLC", "SIEA LLC", "Teradata", "Scandio", "Isos Technology", "OneValley", "GSVlabs", "Eficode", "Amadeus", "Trial Marketplace Bot", "Marketplace Bot", "Daimler Truck AG", "Daimler Truck", "Truck AG", "DT AG", "DTAG", "Turn 10 Studios", "Bayer");
    private static final List<String> BANNED_CUSTOMER_NAME = Arrays.asList("Toolstrek", "SRT", "SRT_IT", "SRT IT", "N/N", "N/N Production", "N/N Development", "MDA", "MDA Space", "MDAspace", "OneValley", "GSVlabs", "Trial Marketplace Bot", "Marketplace Bot", "Daimler Truck AG", "Daimler Truck", "Truck AG", "DT AG", "DTAG", "Turn 10 Studios", "Bayer", "dot-");
    private static final List<String> BANNED_CUSTOMER_MAIL = Arrays.asList("@toolstrek.", "@srt-lpwan.", "@mdacorporation.", "@mdaspace.", "@mda.", "@theonevalley.", "@TrialMarketplaceBot.com", "@em.", "@mercedes-benz.", "@turn10studio.", "@bayer.", ".ru", "@agaseo.", "@hidelux.", "@tupanda.", "@nexxterp.");
    private static final String ALGORITHM = "AES";
    private static final String SECRET_KEY = "a4xO2345xar143a5";

    @Inject
    public LicenseHelper(@ConfluenceImport PluginLicenseManager pluginLicenseManager, @ConfluenceImport LicenseService licenseService) {
        this.pluginLicenseManager = pluginLicenseManager;
        this.licenseService = licenseService;
        this.bandanaManager = (BandanaManager)ComponentLocator.getComponent(BandanaManager.class);
    }

    public PluginLicense getPluginData() {
        try {
            if (this.pluginLicenseManager != null && this.pluginLicenseManager.getLicense() != null && this.pluginLicenseManager.getLicense().isDefined()) {
                return (PluginLicense)this.pluginLicenseManager.getLicense().get();
            }
        }
        catch (Exception ex) {
            log.debug("Exception " + ex.getMessage());
        }
        return null;
    }

    public boolean isBannedCustomer() {
        return this.isSensitiveCustomer(BANNED_CUSTOMER_NAME, BANNED_CUSTOMER_MAIL);
    }

    public boolean isSensitiveCustomer() {
        return this.isSensitiveCustomer(CUSTOMER_NAME, CUSTOMER_MAIL);
    }

    private boolean isSensitiveCustomer(List<String> customerNames, List<String> customerMails) {
        try {
            PluginLicense pluginLicense;
            if (this.pluginLicenseManager != null && this.pluginLicenseManager.getLicense() != null && this.pluginLicenseManager.getLicense().isDefined() && ((PluginLicense)this.pluginLicenseManager.getLicense().get()).isEvaluation() && (pluginLicense = (PluginLicense)this.pluginLicenseManager.getLicense().get()).isEvaluation()) {
                Organization organization;
                if (pluginLicense.getContacts() != null) {
                    Iterable list = pluginLicense.getContacts();
                    for (Contact contact : list) {
                        String contactMail = contact.getEmail();
                        for (String customerMail : customerMails) {
                            if (contactMail == null || !contactMail.toLowerCase().contains(customerMail.toLowerCase())) continue;
                            return true;
                        }
                    }
                }
                if (pluginLicense.getOrganization() != null && (organization = pluginLicense.getOrganization()) != null) {
                    for (String organizationName : customerNames) {
                        if (organization.getName() == null || !organization.getName().trim().equalsIgnoreCase(organizationName) && !organization.getName().trim().toLowerCase().startsWith(organizationName)) continue;
                        return true;
                    }
                }
            }
        }
        catch (Exception ex) {
            log.debug("Exception " + ex.getMessage());
        }
        return false;
    }

    public Map<String, Object> getLicenseDetails() {
        HashMap<String, Object> licenseDetails;
        block5: {
            licenseDetails = new HashMap<String, Object>();
            licenseDetails.put("isDefined", false);
            DateTimeFormatter localDateTimeFormatter = DateTimeFormatter.ofPattern("E, MMM dd yyyy");
            if (this.isAtlassianLicenseIsValid()) {
                try {
                    if (this.pluginLicenseManager != null && this.pluginLicenseManager.getLicense() != null && this.pluginLicenseManager.getLicense().isDefined()) {
                        PluginLicense pluginLicense = (PluginLicense)this.pluginLicenseManager.getLicense().get();
                        licenseDetails.put("organizationName", pluginLicense.getOrganization().getName());
                        licenseDetails.put("isUnlimitedNumberOfUsers", pluginLicense.isUnlimitedNumberOfUsers());
                        licenseDetails.put("maximumNumberOfUsers", !pluginLicense.isUnlimitedNumberOfUsers() && pluginLicense.getMaximumNumberOfUsers() != null && pluginLicense.getMaximumNumberOfUsers().get() != null ? pluginLicense.getMaximumNumberOfUsers().get() : "");
                        licenseDetails.put("startDate", pluginLicense.getPurchaseZonedDate() != null ? pluginLicense.getPurchaseZonedDate().format(localDateTimeFormatter) : "");
                        licenseDetails.put("endDate", pluginLicense.getExpiryZonedDate() != null && pluginLicense.getExpiryZonedDate().get() != null ? ((ZonedDateTime)pluginLicense.getExpiryZonedDate().get()).format(localDateTimeFormatter) : "");
                        for (ProductLicense productLicense : this.licenseService.retrieveAtlassianLicense().getProductLicenses()) {
                            if (!productLicense.getProduct().getName().equalsIgnoreCase("confluence")) continue;
                            licenseDetails.put("sen", productLicense.getServerId());
                        }
                        licenseDetails.put("isLifetimeSubscription", false);
                        licenseDetails.put("isDefined", true);
                    }
                }
                catch (Exception ex) {
                    if (!log.isDebugEnabled()) break block5;
                    log.debug("Exception: " + ExceptionUtils.getMessage((Throwable)ex));
                }
            }
        }
        return licenseDetails;
    }

    public boolean isAtlassianLicenseIsEvaluation() {
        boolean isEvaluation;
        block3: {
            isEvaluation = false;
            try {
                if (this.pluginLicenseManager != null && this.pluginLicenseManager.getLicense() != null && this.pluginLicenseManager.getLicense().isDefined()) {
                    PluginLicense pluginLicense = (PluginLicense)this.pluginLicenseManager.getLicense().get();
                    isEvaluation = pluginLicense.isEvaluation();
                }
            }
            catch (Exception ex) {
                if (!log.isDebugEnabled()) break block3;
                log.debug("Exception: " + ExceptionUtils.getStackTrace((Throwable)ex));
            }
        }
        return isEvaluation;
    }

    public boolean isAtlassianLicenseIsValid() {
        boolean isLicenseIsValid;
        block5: {
            isLicenseIsValid = false;
            try {
                if (this.pluginLicenseManager != null && this.pluginLicenseManager.getLicense() != null && this.pluginLicenseManager.getLicense().isDefined()) {
                    PluginLicense pluginLicense = (PluginLicense)this.pluginLicenseManager.getLicense().get();
                    boolean bl = isLicenseIsValid = !pluginLicense.getError().isDefined();
                    if (this.isBannedCustomer()) {
                        return new Random().nextBoolean();
                    }
                }
            }
            catch (Exception ex) {
                if (!log.isDebugEnabled()) break block5;
                log.debug("Exception: " + ExceptionUtils.getStackTrace((Throwable)ex));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("isAtlassianLicenseIsValid: - " + (isLicenseIsValid ? "VALID" : "NOT VALID"));
        }
        return isLicenseIsValid;
    }

    public boolean isLicenseIsValid() {
        boolean isLicenseIsValid = this.isAtlassianLicenseIsValid();
        return isLicenseIsValid;
    }

    public static String encrypt(String valueToEnc) {
        try {
            SecretKeySpec key = new SecretKeySpec(SECRET_KEY.getBytes(), ALGORITHM);
            Cipher c = Cipher.getInstance(ALGORITHM);
            c.init(1, key);
            byte[] encValue = c.doFinal(valueToEnc.getBytes());
            if (log.isDebugEnabled()) {
                log.debug("encrypt: " + valueToEnc);
                log.debug("encrypt: " + Base64.getEncoder().encodeToString(encValue));
            }
            return Base64.getEncoder().encodeToString(encValue);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Exception: " + e.getMessage());
            }
            return "";
        }
    }

    public static String decrypt(String encryptedValue) {
        try {
            SecretKeySpec key = new SecretKeySpec(SECRET_KEY.getBytes(), ALGORITHM);
            Cipher c = Cipher.getInstance(ALGORITHM);
            c.init(2, key);
            byte[] decodedValue = Base64.getDecoder().decode(encryptedValue);
            byte[] decValue = c.doFinal(decodedValue);
            if (log.isDebugEnabled()) {
                log.debug("decrypt: " + encryptedValue);
                log.debug("decrypt: " + new String(decValue));
            }
            return new String(decValue);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Exception: " + e.getMessage());
            }
            return "";
        }
    }
}

