/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender.tokens.rest;

import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.confluence.api.model.audit.AffectedObject;
import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.json.jsonorg.JSONException;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.sal.api.user.UserProfile;
import com.itlab.confluence.plugins.restextender.helper.ToolsHelper;
import com.itlab.confluence.plugins.restextender.tokens.model.Token;
import com.itlab.confluence.plugins.restextender.tokens.model.TokenContainer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.log4j.Logger;

@Path(value="/tokenTools")
public class TokenUtils {
    private static final Logger log = Logger.getLogger(TokenUtils.class);
    private final ToolsHelper toolsHelper;

    @Inject
    public TokenUtils(ToolsHelper toolsHelper) {
        this.toolsHelper = toolsHelper;
    }

    @ReadOnlyAccessAllowed
    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/delete")
    public Response clear(String jsonString, @Context HttpServletRequest request) throws JSONException {
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        JSONObject jsonObject = new JSONObject(jsonString);
        String stringToken = jsonObject.has("token") ? jsonObject.getString("token") : "";
        String id = jsonObject.has("id") ? jsonObject.getString("id") : "";
        TokenContainer tokenContainer = this.toolsHelper.getSavedTokens();
        ArrayList<Token> newTokens = new ArrayList<Token>();
        for (Token token : tokenContainer.getTokens()) {
            if (!token.getToken().equals(stringToken)) {
                if (!ToolsHelper.encrypt(token.getToken()).equals(id)) {
                    newTokens.add(token);
                    continue;
                }
            }
            this.addAuditRecord(token, "deleted", request, "Token", "");
        }
        tokenContainer.setTokens(newTokens);
        this.toolsHelper.saveTokens(tokenContainer);
        return Response.ok().build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/config/{option}")
    public Response setConfig(@PathParam(value="option") String option) {
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        if (option.equalsIgnoreCase("limit") || option.equalsIgnoreCase("nolimit")) {
            this.toolsHelper.savedTokensConfig(option.toLowerCase());
        }
        if (option.equalsIgnoreCase("basic") || option.equalsIgnoreCase("bearer") || option.equalsIgnoreCase("all")) {
            this.toolsHelper.setTokensAccessType(option.toLowerCase());
        }
        return Response.ok().build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/get")
    public Response getTokens(@Context HttpServletRequest request) {
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        TokenContainer tokenContainer = this.toolsHelper.getSavedTokens();
        boolean tokenConfigurationSecureMode = this.toolsHelper.getTokenConfigurationSecureMode();
        ArrayList<Token> tokens = tokenContainer.getTokens();
        ArrayList arrayTokens = new ArrayList();
        for (Token token : tokens) {
            ConfluenceUser confluenceUser;
            HashMap<String, Object> tokenMap = new HashMap<String, Object>();
            tokenMap.put("dateCreated", token.getDateCreated() == null ? "" : token.getDateCreated());
            tokenMap.put("label", token.getLabel() == null ? "" : token.getLabel());
            tokenMap.put("limitTo", token.getLimitTo() == null ? "" : token.getLimitTo());
            if (!tokenConfigurationSecureMode) {
                tokenMap.put("token", token.getToken() == null ? "" : token.getToken());
            }
            tokenMap.put("id", token.getToken() == null ? "" : ToolsHelper.encrypt(token.getToken()));
            tokenMap.put("user", token.getUser());
            tokenMap.put("userKey", token.getUserKey());
            tokenMap.put("userDisplayName", token.getUserKey());
            if (token.getUserKey() != null && !token.getUserKey().equals("") && !token.getUserKey().equals("not found") && (confluenceUser = this.toolsHelper.getConfluenceUserByKey(token.getUserKey())) != null) {
                tokenMap.put("user", confluenceUser.getName());
                tokenMap.put("userDisplayName", confluenceUser.getFullName());
            }
            tokenMap.put("validUntil", token.getValidUntil() == null ? "" : token.getValidUntil());
            if (tokenContainer.getCollectUsageDetails()) {
                tokenMap.put("ip", token.getIp() == null ? "" : token.getIp());
                tokenMap.put("lastUsed", token.getLastUsed() == null ? "" : token.getLastUsed());
                tokenMap.put("counter", token.getCounter());
            }
            arrayTokens.add(tokenMap);
        }
        if (tokenContainer.getTokens().isEmpty()) {
            response.put("status", "empty");
        } else {
            response.put("status", "ok");
            response.put("tokens", arrayTokens);
        }
        response.put("collectUsageDetails", tokenContainer.getCollectUsageDetails());
        response.put("addAuditRecord", tokenContainer.getAddAuditRecord());
        response.put("tokenAccessType", this.toolsHelper.getTokensAccessType());
        response.put("config", this.toolsHelper.getTokensConfig());
        return Response.ok(response).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/edit")
    public Response editToken(String jsonString, @Context HttpServletRequest request) throws JSONException {
        String id;
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        if (this.toolsHelper.getTokenConfigurationSecureMode()) {
            return this.toolsHelper.permissionViolation();
        }
        JSONObject jsonObject = new JSONObject(jsonString);
        String stringToken = jsonObject.has("token") ? jsonObject.getString("token") : "";
        String string = id = jsonObject.has("id") ? jsonObject.getString("id") : "";
        if (this.toolsHelper.getTokenConfigurationSecureMode()) {
            if (!jsonObject.has("id") || jsonObject.getString("id").equals("")) {
                return this.toolsHelper.fieldRequired("id");
            }
        } else if (!jsonObject.has("token") || jsonObject.getString("token").equals("")) {
            return this.toolsHelper.fieldRequired("token");
        }
        if (!jsonObject.has("label") || jsonObject.getString("label").equals("")) {
            return this.toolsHelper.fieldRequired("label");
        }
        TokenContainer tokenContainer = this.toolsHelper.getSavedTokens();
        ArrayList<Token> newTokens = new ArrayList<Token>();
        for (Token token : tokenContainer.getTokens()) {
            block16: {
                block15: {
                    if (token.getToken().equals(stringToken)) break block15;
                    if (!ToolsHelper.encrypt(token.getToken()).equals(id)) break block16;
                }
                boolean setLimitTo = false;
                String limitTo = "";
                if (jsonObject.has("limitTo")) {
                    limitTo = jsonObject.getString("limitTo");
                    if (!limitTo.equals("") && (limitTo.contains("\\n") || limitTo.contains("\\\\n"))) {
                        limitTo = limitTo.replaceAll("\\\\n", "<br>").replaceAll("\\n", "<br>");
                    }
                    setLimitTo = true;
                }
                String newData = "Name: " + jsonObject.getString("label") + ", Limit to: " + limitTo.replace("<br>", " - ");
                this.addAuditRecord(token, "changed", request, "Changes", newData);
                if (setLimitTo) {
                    token.setLimitTo(limitTo);
                }
                token.setLabel(jsonObject.getString("label"));
            }
            newTokens.add(token);
        }
        tokenContainer.setTokens(newTokens);
        this.toolsHelper.saveTokens(tokenContainer);
        return Response.ok().build();
    }

    @ReadOnlyAccessAllowed
    @POST
    @Produces(value={"application/json"})
    @Path(value="/set")
    public Response setTokens(String jsonString, @Context HttpServletRequest request) throws JSONException {
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        JSONObject jsonObject = new JSONObject(jsonString);
        if (jsonObject.has("collectUsageDetails")) {
            TokenContainer tokenContainer = this.toolsHelper.getSavedTokens();
            tokenContainer.setCollectUsageDetails(jsonObject.getBoolean("collectUsageDetails"));
            this.toolsHelper.saveTokens(tokenContainer);
            return Response.ok().build();
        }
        if (jsonObject.has("addAuditRecord")) {
            TokenContainer tokenContainer = this.toolsHelper.getSavedTokens();
            tokenContainer.setAddAuditRecord(jsonObject.getBoolean("addAuditRecord"));
            this.toolsHelper.saveTokens(tokenContainer);
            return Response.ok().build();
        }
        String label = "";
        String userName = "";
        String stringToken = "";
        String daysUntilExpiry = "";
        String limitTo = "";
        if (jsonObject.isNull("label") || jsonObject.getString("label").equals("")) {
            return this.toolsHelper.fieldRequired("label");
        }
        label = jsonObject.getString("label");
        if (!jsonObject.isNull("userName")) {
            userName = jsonObject.getString("userName");
        }
        if (!jsonObject.isNull("limitTo")) {
            limitTo = jsonObject.getString("limitTo");
        }
        if (!jsonObject.isNull("daysUntilExpiry")) {
            daysUntilExpiry = jsonObject.get("daysUntilExpiry") + "";
        }
        if (!jsonObject.isNull("token")) {
            stringToken = jsonObject.getString("token");
        }
        if (stringToken.equals("")) {
            stringToken = this.generateToken();
        }
        if (!limitTo.equals("") && (limitTo.contains("\\n") || limitTo.contains("\\\\n"))) {
            limitTo = limitTo.replaceAll("\\\\n", "<br>").replaceAll("\\n", "<br>");
        }
        String userKey = "";
        if (userName.equals("")) {
            userKey = "";
        } else {
            ConfluenceUser confluenceUser = this.toolsHelper.getConfluenceUserByName(userName);
            if (confluenceUser == null) {
                HashMap<String, String> response = new HashMap<String, String>();
                response.put("message", "User '" + userName + "' does not exist");
                return Response.serverError().entity(response).build();
            }
            userKey = confluenceUser.getKey().getStringValue();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("userKey " + userKey));
            log.debug((Object)("userName " + userName));
            log.debug((Object)("token " + stringToken));
            log.debug((Object)("daysUntilExpiry " + daysUntilExpiry));
            log.debug((Object)("limitTo " + limitTo));
        }
        TokenContainer tokenContainer = this.toolsHelper.getSavedTokens();
        ArrayList<Token> tokens = tokenContainer.getTokens();
        Date date = null;
        if (this.toolsHelper.isNumeric(daysUntilExpiry)) {
            Calendar now = Calendar.getInstance();
            now.add(5, Integer.parseInt(daysUntilExpiry));
            date = now.getTime();
        }
        Token token = new Token(label, userName, userKey, stringToken, date, limitTo);
        tokens.add(token);
        tokenContainer.setTokens(tokens);
        this.toolsHelper.saveTokens(tokenContainer);
        this.addAuditRecord(token, "added", request, "Token", "");
        return Response.ok().build();
    }

    private void addAuditRecord(Token token, String action, HttpServletRequest request, String changeValueName, String changeValueData) {
        String tokenDetails = "Name: " + token.getLabel();
        tokenDetails = tokenDetails + (!this.toolsHelper.getTokenConfigurationSecureMode() ? ", Token: " + token.getToken() : "");
        tokenDetails = tokenDetails + ", User: " + this.getUserDisplayName(token);
        tokenDetails = tokenDetails + (!token.getLimitTo().isEmpty() ? ", Limit to: " + token.getLimitTo().replace("<br>", " - ") : "");
        tokenDetails = tokenDetails + ", Valid until: " + (token.getValidUntil() != null ? token.getValidUntil() : "Indefinitely");
        ArrayList<Map<String, String>> changedValueList = new ArrayList<Map<String, String>>();
        HashMap<String, String> changedValue = new HashMap<String, String>();
        changedValue.put("name", changeValueName);
        changedValue.put("oldValue", !action.equalsIgnoreCase("added") && !action.equalsIgnoreCase("changed") ? tokenDetails : "");
        changedValue.put("newValue", action.equalsIgnoreCase("added") ? tokenDetails : changeValueData);
        changedValueList.add(changedValue);
        AffectedObject targetAffected = AffectedObject.builder().name(token.getLabel()).objectType("REST API Token").build();
        UserProfile currentUserProfile = this.toolsHelper.getCurrentUserProfile();
        String objectType = this.toolsHelper.getUntransformedRawText("audit.logging.affected.object.user");
        AffectedObject targetAffectedUser = AffectedObject.builder().name(currentUserProfile.getUsername()).objectType(objectType).build();
        HashSet<AffectedObject> associatedObjects = new HashSet<AffectedObject>();
        associatedObjects.add(targetAffectedUser);
        associatedObjects.add(targetAffected);
        this.toolsHelper.addAuditRecord("Token \"" + token.getLabel() + "\" was " + action, this.toolsHelper.getUntransformedRawText("audit.logging.category.auth"), targetAffectedUser, changedValueList, action.equalsIgnoreCase("changed") ? new AuditAttribute("Token", tokenDetails) : null);
    }

    private String generateToken() {
        int length = 54;
        boolean useLetters = true;
        boolean useNumbers = true;
        return RandomStringUtils.random((int)length, (boolean)useLetters, (boolean)useNumbers);
    }

    private String getUserDisplayName(Token token) {
        ConfluenceUser confluenceUser;
        String userToken = token.getUserKey();
        if (token.getUserKey() != null && !token.getUserKey().equals("") && !token.getUserKey().equals("not found") && (confluenceUser = this.toolsHelper.getConfluenceUserByKey(token.getUserKey())) != null) {
            userToken = confluenceUser.getFullName() + " [" + confluenceUser.getName() + "]" + (!this.toolsHelper.userIsDeactivated(confluenceUser.getName()) ? "" : " (Inactive)");
        }
        return userToken.isEmpty() ? "any user" : userToken;
    }
}

