/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender.space;

import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.SpaceLabelManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.extras.common.org.springframework.util.StringUtils;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.itlab.confluence.plugins.restextender.helper.ToolsHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;

@Path(value="/category")
public class CategoryRestApi {
    private static final Logger log = Logger.getLogger(CategoryRestApi.class);
    private final LabelManager labelManager;
    private final SpaceLabelManager spaceLabelManager;
    private final GroupManager groupManager;
    private ToolsHelper toolsHelper;

    @Inject
    public CategoryRestApi(@ConfluenceImport LabelManager labelManager, @ConfluenceImport SpaceLabelManager spaceLabelManager, @ConfluenceImport GroupManager groupManager, ToolsHelper toolsHelper) {
        this.labelManager = labelManager;
        this.spaceLabelManager = spaceLabelManager;
        this.groupManager = groupManager;
        this.toolsHelper = toolsHelper;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/getAllCategories")
    public Response getAllCategories() {
        HashMap response = new HashMap();
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        List teamLabels = this.labelManager.getTeamLabels();
        ArrayList teamLabelsMap = new ArrayList();
        for (Label label : teamLabels) {
            HashMap<String, Object> teamLabel = new HashMap<String, Object>();
            teamLabel.put("name", label.getName());
            teamLabel.put("id", label.getId());
            teamLabel.put("niceName", StringUtils.capitalize((String)label.getName()));
            teamLabelsMap.add(teamLabel);
        }
        response.put("categories", teamLabelsMap);
        return Response.ok(response).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/getSpaceCategories/{spaceKey}")
    public Response getSpaceCategories(@PathParam(value="spaceKey") String spaceKey) throws EntityException {
        HashMap<String, Object> response = new HashMap<String, Object>();
        Space space = this.toolsHelper.getSpaceFromSpaceDao(spaceKey);
        if (space == null) {
            return this.toolsHelper.spaceNotExist(spaceKey);
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (!this.toolsHelper.isConfluenceAdministrator() && !this.isCurrentUserIsSpaceAdministrator(space)) {
            return this.toolsHelper.permissionViolation();
        }
        List teamLabelsInSpace = this.labelManager.getTeamLabelsForSpace(space.getKey());
        ArrayList teamLabelsInSpaceMap = new ArrayList();
        for (Label label : teamLabelsInSpace) {
            HashMap<String, Object> teamLabel = new HashMap<String, Object>();
            teamLabel.put("name", label.getName());
            teamLabel.put("id", label.getId());
            teamLabel.put("niceName", StringUtils.capitalize((String)label.getName()));
            teamLabelsInSpaceMap.add(teamLabel);
        }
        response.put("categories", teamLabelsInSpaceMap);
        response.put("key", space.getKey());
        response.put("name", space.getName());
        return Response.ok(response).build();
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/renameCategory/category/{categoryName}/renameTo/{newCategoryName}")
    public Response renameCategory(@PathParam(value="categoryName") String categoryName, @PathParam(value="newCategoryName") String newCategoryName) throws EntityException {
        categoryName = this.toolsHelper.decodeUrlParam(categoryName);
        newCategoryName = this.toolsHelper.decodeUrlParam(newCategoryName);
        HashMap<String, String> response = new HashMap<String, String>();
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        List labels = this.labelManager.getTeamLabels();
        Label label = null;
        for (Label labelTeam : labels) {
            if (!labelTeam.getName().equalsIgnoreCase(categoryName)) continue;
            label = labelTeam;
        }
        if (label == null) {
            response.put("status", "category '" + categoryName + "' does not exist");
            return Response.serverError().entity(response).build();
        }
        List spacesWithLabel = this.labelManager.getSpacesWithLabel(label);
        for (Space space : spacesWithLabel) {
            this.spaceLabelManager.addLabel(space, newCategoryName);
        }
        this.labelManager.deleteLabel(label);
        response.put("status", "category '" + categoryName + "' renamed to '" + newCategoryName + ")'");
        return Response.ok(response).build();
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/addSpaceCategory/space/{spaceKey}/category/{categoryName}")
    public Response addCategoryToSpace(@PathParam(value="spaceKey") String spaceKey, @PathParam(value="categoryName") String categoryName) throws EntityException {
        categoryName = this.toolsHelper.decodeUrlParam(categoryName);
        HashMap<String, String> response = new HashMap<String, String>();
        Space space = this.toolsHelper.getSpaceFromSpaceDao(spaceKey);
        if (space == null) {
            return this.toolsHelper.spaceNotExist(spaceKey);
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!(this.toolsHelper.isConfluenceAdministrator() || this.isCurrentUserIsSpaceAdministrator(space) && !this.toolsHelper.isDisabledForSpaceAdministrator("spaceAddCategory"))) {
            return this.toolsHelper.permissionViolation();
        }
        this.spaceLabelManager.addLabel(space, categoryName);
        response.put("status", "category '" + categoryName + "' added to '" + space.getName() + " (" + space.getKey() + ")' space");
        return Response.ok(response).build();
    }

    private boolean isCurrentUserIsSpaceAdministrator(Space space) throws EntityException {
        UserProfile userProfile = this.toolsHelper.getCurrentUserProfile();
        User user = this.toolsHelper.getUserByName(userProfile.getUsername());
        Map groups = this.toolsHelper.getSpacePermissionManager().getGroupsForPermissionType("SETSPACEPERMISSIONS", space);
        Map users = this.toolsHelper.getSpacePermissionManager().getUsersForPermissionType("SETSPACEPERMISSIONS", space);
        if (log.isDebugEnabled()) {
            log.debug((Object)("groups: " + groups));
            log.debug((Object)("users: " + users));
        }
        if (users.get(userProfile.getUsername()) != null) {
            return true;
        }
        for (Map.Entry entry : groups.entrySet()) {
            Group group = this.groupManager.getGroup((String)entry.getKey());
            if (!this.groupManager.hasMembership(group, user)) continue;
            return true;
        }
        return false;
    }
}

