/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender.webModuleDescriptor;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.plugin.descriptor.web.ConfluenceWebInterfaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.web.descriptors.WebItemModuleDescriptor;
import com.atlassian.plugin.web.descriptors.WebSectionModuleDescriptor;
import com.atlassian.sal.api.component.ComponentLocator;
import com.itlab.confluence.plugins.restextender.helper.ToolsHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;

@Path(value="/webModuleDescriptors")
public class WebModuleDescriptorRestApi
extends ConfluenceActionSupport {
    private static final Logger log = Logger.getLogger(WebModuleDescriptorRestApi.class);
    private final ConfluenceWebInterfaceManager webInterfaceManager = (ConfluenceWebInterfaceManager)ComponentLocator.getComponent(ConfluenceWebInterfaceManager.class);
    private ToolsHelper toolsHelper;

    @Inject
    public WebModuleDescriptorRestApi(ToolsHelper toolsHelper) {
        this.toolsHelper = toolsHelper;
    }

    public Map<String, Object> getContext() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("action", (Object)this);
        ConfluenceUser confluenceUser = this.toolsHelper.getAuthenticatedUser();
        context.put("remoteuser", confluenceUser);
        context.put("user", confluenceUser);
        return context;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/all")
    public Response getAll(@DefaultValue(value="") @QueryParam(value="search") String search, @Context HttpServletRequest request) {
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        Map<String, Object> context = this.getContext();
        HashMap<String, Object> response = new HashMap<String, Object>();
        ArrayList sections = new ArrayList();
        String systemAdminSection = "system.admin";
        List webSectionModuleDescriptors = this.webInterfaceManager.getDisplayableSections(systemAdminSection, context);
        for (WebSectionModuleDescriptor webSectionModuleDescriptor : webSectionModuleDescriptors) {
            HashMap<String, Object> section = new HashMap<String, Object>();
            String name = "";
            String translatedName = webSectionModuleDescriptor.getWebLabel().getDisplayableLabel(request, context);
            String completeKey = webSectionModuleDescriptor.getCompleteKey();
            name = webSectionModuleDescriptor.getWebLabel().getKey() == null ? webSectionModuleDescriptor.getWebLabel().getNoKeyValue() : this.toolsHelper.getTranslation(webSectionModuleDescriptor.getWebLabel().getKey());
            section.put("name", translatedName);
            section.put("originalName", name);
            section.put("weight", webSectionModuleDescriptor.getWeight());
            section.put("key", webSectionModuleDescriptor.getKey());
            section.put("completeKey", completeKey);
            String sectionKey = systemAdminSection + "/" + webSectionModuleDescriptor.getKey();
            ArrayList items = new ArrayList();
            for (WebItemModuleDescriptor webItemModuleDescriptor : this.webInterfaceManager.getDisplayableItems(sectionKey, context)) {
                String descriptionTranslation;
                HashMap<String, Object> item = new HashMap<String, Object>();
                String itemName = this.toolsHelper.getTranslation(webItemModuleDescriptor.getWebLabel().getKey());
                String itemTranslatedName = webItemModuleDescriptor.getWebLabel().getDisplayableLabel(request, context);
                String link = webItemModuleDescriptor.getLink() != null ? webItemModuleDescriptor.getLink().getRenderedUrl(context) : "";
                String key = webItemModuleDescriptor.getKey();
                String description = webItemModuleDescriptor.getDescription() != null ? webItemModuleDescriptor.getDescription() : "";
                String string = descriptionTranslation = webItemModuleDescriptor.getDescriptionKey() != null ? this.toolsHelper.getTranslation(webItemModuleDescriptor.getDescriptionKey()) : "";
                if (!search.equals("") && !this.passContainsCondition(itemName + itemTranslatedName, "", description + descriptionTranslation, search)) continue;
                item.put("name", itemTranslatedName);
                item.put("originalName", itemName);
                item.put("link", link);
                item.put("weight", webItemModuleDescriptor.getWeight());
                item.put("key", key);
                item.put("description", description.equals(descriptionTranslation) ? description : descriptionTranslation);
                item.put("originalDescription", descriptionTranslation);
                item.put("completeKey", webItemModuleDescriptor.getCompleteKey());
                items.add(item);
            }
            if ((search.equals("") || items.isEmpty()) && !search.equals("")) continue;
            section.put("items", items);
            sections.add(section);
        }
        response.put("configurationName", this.toolsHelper.getTranslation("administration.global.menu.label"));
        response.put("sections", sections);
        return Response.ok(response).build();
    }

    private boolean passContainsCondition(String elementId, String elementName, String elementDescription, String searchString) {
        elementId = this.toolsHelper.unescapeHtml(elementId);
        elementName = this.toolsHelper.unescapeHtml(elementName);
        elementDescription = this.toolsHelper.unescapeHtml(elementDescription);
        return this.containsIgnoreCase(elementId, searchString = this.toolsHelper.unescapeHtml(searchString)) || this.containsIgnoreCase(elementName, searchString) || this.containsIgnoreCase(elementDescription, searchString);
    }

    private boolean containsIgnoreCase(String src, String what) {
        int length = what.length();
        if (length == 0) {
            return true;
        }
        char firstLo = Character.toLowerCase(what.charAt(0));
        char firstUp = Character.toUpperCase(what.charAt(0));
        for (int i = src.length() - length; i >= 0; --i) {
            char ch = src.charAt(i);
            if (ch != firstLo && ch != firstUp || !src.regionMatches(true, i, what, 0, length)) continue;
            return true;
        }
        return false;
    }
}

