/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender.helper;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.api.model.audit.AffectedObject;
import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.persistence.ContentEntityObjectDao;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.license.LicenseService;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.persistence.dao.BlogPostDao;
import com.atlassian.confluence.pages.persistence.dao.PageDao;
import com.atlassian.confluence.persistence.EntityManagerProvider;
import com.atlassian.confluence.security.ContentPermission;
import com.atlassian.confluence.security.ContentPermissionSet;
import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.security.administrators.PermissionsAdministrator;
import com.atlassian.confluence.security.administrators.PermissionsAdministratorBuilder;
import com.atlassian.confluence.security.login.LoginInfo;
import com.atlassian.confluence.security.login.LoginManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.setup.settings.Settings;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceDescription;
import com.atlassian.confluence.spaces.persistence.dao.SpaceDao;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.UserDetailsManager;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.confluence.util.i18n.CachingI18NBeanFactory;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.model.user.TimestampedUser;
import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.atlassian.xwork.XsrfTokenGenerator;
import com.itlab.confluence.plugins.restextender.helper.LicenseHelper;
import com.itlab.confluence.plugins.restextender.tokens.model.Token;
import com.itlab.confluence.plugins.restextender.tokens.model.TokenContainer;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.inject.Inject;
import javax.inject.Named;
import javax.persistence.Query;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExportAsService(value={ToolsHelper.class})
@Named(value="toolsHelper")
public class ToolsHelper {
    private static final Logger log = LoggerFactory.getLogger(ToolsHelper.class);
    private final UserAccessor userAccessor;
    private final UserManager userManager;
    private final SpacePermissionManager spacePermissionManager;
    private final BandanaManager bandanaManager;
    private final LoginManager loginManager;
    private final CrowdService crowdService;
    private final UserDetailsManager userDetailsManager;
    private final AccessModeService accessModeService;
    private final EntityManagerProvider entityManagerProvider;
    private final SpaceDao spaceDao;
    private final PageDao pageDao;
    private final BlogPostDao blogPostDao;
    private final LicenseService licenseService;
    private final LocaleManager localeManager;
    private final BootstrapManager bootstrapManager;
    private final SettingsManager settingsManager;
    private LicenseHelper licenseHelper;
    private static final String TOKENS = "com.itlab.confluence.plugins.restextender.tokens";
    private static final String TOKEN_LIMIT = "com.itlab.confluence.plugins.restextender.tokens.limit";
    private static final String TOKEN_ACCESS_TYPE = "com.itlab.confluence.plugins.restextender.tokens.accessType";
    private static final String RESTAPI = "com.itlab.confluence.plugins.restextender.configuration.";
    private static final ArrayList APILIST = new ArrayList<String>(Arrays.asList("templateDelete", "spaceAddCategory", "spaceAddPermissionForGroup", "spaceRemoveAllPermissionForGroup", "spaceRemovePermissionForGroup", "spaceAddPermissionForUser", "spaceRemoveAllPermissionForUser", "spaceRemovePermissionForUser", "attachmentDeleteVersionId", "exportSpace", "replaceAll", "addShortcut", "trashPurgeAll", "trashPurgeContent", "trashRestoreContent", "manageSpacePermissionsForUser", "manageSpacePermissionsForGroup", "contentPrepend", "contentAppend", "contentReplaceAll", "changeSpaceStatus", "changeSpaceCreatorSpaceKey", "addContentPermissionUserByName", "removeContentPermissionUserByName", "addContentPermissionGroupByName", "removeContentPermissionGroupByName"));
    private static final ArrayList CONFIGLIST = new ArrayList<String>(Arrays.asList("global.search"));
    private static final String ALGORITHM = "AES";
    private static final String SECRET_KEY = "a4xO2345xar143a5";
    private static final String SOURCE_EDITOR_GROUPS = "com.itlab.confluence.plugins.restextender.sourceEditor.groups";
    private static final String SOURCE_EDITOR_ALLOW_ALL = "com.itlab.confluence.plugins.restextender.sourceEditor.all";
    private static final String NOTIFY_WATCHERS_PRIMARY_BUTTON = "com.itlab.confluence.plugins.restextender.notifyWatchers.button.primary";
    private static final String NOTIFY_WATCHERS_GROUPS = "com.itlab.confluence.plugins.restextender.notifyWatchers.groups";

    @Inject
    public ToolsHelper(LicenseHelper licenseHelper, @ConfluenceImport UserManager userManager, @ConfluenceImport UserAccessor userAccessor, @ConfluenceImport SpacePermissionManager spacePermissionManager, @ConfluenceImport LoginManager loginManager, @ConfluenceImport CrowdService crowdService, @ConfluenceImport UserDetailsManager userDetailsManager, @ConfluenceImport AccessModeService accessModeService, @ConfluenceImport LicenseService licenseService, @ConfluenceImport BootstrapManager bootstrapManager, @ConfluenceImport LocaleManager localeManager, @ConfluenceImport SettingsManager settingsManager) {
        this.licenseHelper = licenseHelper;
        this.localeManager = localeManager;
        this.userManager = userManager;
        this.userAccessor = userAccessor;
        this.spacePermissionManager = spacePermissionManager;
        this.loginManager = loginManager;
        this.crowdService = crowdService;
        this.licenseService = licenseService;
        this.userDetailsManager = userDetailsManager;
        this.bandanaManager = (BandanaManager)ComponentLocator.getComponent(BandanaManager.class);
        this.accessModeService = accessModeService;
        this.spaceDao = (SpaceDao)ComponentLocator.getComponent(SpaceDao.class);
        this.blogPostDao = (BlogPostDao)ComponentLocator.getComponent(BlogPostDao.class);
        this.pageDao = (PageDao)ComponentLocator.getComponent(PageDao.class);
        this.entityManagerProvider = (EntityManagerProvider)ComponentLocator.getComponent(EntityManagerProvider.class);
        this.bootstrapManager = bootstrapManager;
        this.settingsManager = settingsManager;
    }

    public List getDataBaseResults(String queryString, String queryType) {
        if (log.isDebugEnabled()) {
            log.debug("getDataBaseResults [" + queryType + "] queryString: " + queryString);
        }
        HashMap transactionTemplateResults = new HashMap();
        TransactionTemplate tt = (TransactionTemplate)ComponentLocator.getComponent(TransactionTemplate.class);
        try {
            tt.execute(() -> {
                Query query = this.entityManagerProvider.getEntityManager().createNativeQuery(queryString);
                List results = query.getResultList();
                transactionTemplateResults.put("results", results);
                return null;
            });
        }
        catch (Exception ex) {
            if (log.isDebugEnabled()) {
                log.debug("getDataBaseResults [" + queryType + "] Exception: " + ex.getMessage());
            }
            return null;
        }
        List matchingResults = new ArrayList();
        if (transactionTemplateResults.get("results") != null) {
            matchingResults = (List)transactionTemplateResults.get("results");
        }
        if (log.isDebugEnabled()) {
            log.debug("getDataBaseResults [" + queryType + "] matchingResults: " + matchingResults.size());
        }
        return matchingResults;
    }

    public static List<?> convertObjectToList(Object obj) {
        List<Object> list = new ArrayList();
        if (obj.getClass().isArray()) {
            list = Arrays.asList((Object[])obj);
        } else if (obj instanceof Collection) {
            list = new ArrayList((Collection)obj);
        }
        return list;
    }

    public String getSpaceDescription(SpaceDescription spaceDescription) {
        String bodyAsString = "";
        try {
            if (this.confluenceVersionIsGreaterThanOrEqualTo(7, 0)) {
                ContentEntityObject versioned = spaceDescription.getLatestVersion();
                Method getBodyAsString = versioned.getClass().getMethod("getBodyAsString", new Class[0]);
                bodyAsString = getBodyAsString.invoke((Object)versioned, new Object[0]) + "";
            } else {
                bodyAsString = spaceDescription.getBodyAsString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bodyAsString;
    }

    public long getTrashData(ContentEntityObject trashObject) {
        long millisecond;
        block3: {
            millisecond = -1L;
            try {
                Method toEpochMilli;
                Object millis;
                Method get;
                Object instant;
                Method getTrashDate;
                Object optional;
                if (this.confluenceVersionIsGreaterThanOrEqualTo(7, 14) && (optional = (getTrashDate = trashObject.getClass().getMethod("getTrashDate", new Class[0])).invoke((Object)trashObject, new Object[0])) != null && (instant = (get = optional.getClass().getMethod("get", new Class[0])).invoke(optional, new Object[0])) != null && (millis = (toEpochMilli = instant.getClass().getMethod("toEpochMilli", new Class[0])).invoke(instant, new Object[0])) instanceof Long) {
                    millisecond = (Long)millis;
                }
            }
            catch (Exception ex) {
                if (!log.isDebugEnabled()) break block3;
                log.debug(ExceptionUtils.getStackTrace((Throwable)ex));
            }
        }
        return millisecond;
    }

    public boolean confluenceVersionIsGreaterThanOrEqualTo(int numberOne, int numberTwo) {
        String versionNumber = GeneralUtil.getVersionNumber();
        String[] versionNumbers = versionNumber.split("\\.");
        return Integer.parseInt(versionNumbers[0]) > numberOne || Integer.parseInt(versionNumbers[0]) == numberOne && Integer.parseInt(versionNumbers[1]) >= numberTwo;
    }

    public boolean isReadOnly() {
        return this.accessModeService.isReadOnlyAccessModeEnabled();
    }

    public Response readOnlyMode() {
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("message", "READ_ONLY mode is enabled");
        return Response.serverError().entity(response).build();
    }

    public boolean isLicenseIsValid() {
        return this.licenseHelper.isLicenseIsValid();
    }

    public boolean isNumeric(String str) {
        try {
            double d = Double.parseDouble(str);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public boolean isSystemAdministrator(UserProfile userProfile) {
        if (log.isDebugEnabled()) {
            log.debug("userProfile: " + userProfile.getUsername());
        }
        if (userProfile != null && this.userManager.isSystemAdmin(userProfile.getUserKey())) {
            if (log.isDebugEnabled()) {
                log.debug("userProfile: " + userProfile.getUsername() + " - true");
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug("userProfile: " + userProfile.getUsername() + " - false");
        }
        return false;
    }

    public boolean isSystemAdministrator(String userName) {
        return this.isSystemAdministrator(this.userManager.getUserProfile(userName));
    }

    public boolean isSystemAdministrator() {
        UserProfile user = this.userManager.getRemoteUser();
        return user != null && this.userManager.isSystemAdmin(user.getUserKey());
    }

    public boolean isConfluenceAdministrator(String userName) {
        return this.isConfluenceAdministrator(this.userManager.getUserProfile(userName));
    }

    public boolean isConfluenceAdministrator() {
        UserProfile userProfile = this.userManager.getRemoteUser();
        return this.isConfluenceAdministrator(userProfile);
    }

    public boolean isConfluenceAdministrator(UserProfile userProfile) {
        if (log.isDebugEnabled()) {
            log.debug("userProfile: " + userProfile.getUsername());
        }
        if (userProfile != null && (this.isSystemAdministrator(userProfile) || this.userManager.isAdmin(userProfile.getUserKey()))) {
            if (log.isDebugEnabled()) {
                log.debug("userProfile: " + userProfile.getUsername() + " - true");
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug("userProfile: " + userProfile.getUsername() + " - false");
        }
        return false;
    }

    public boolean objectHasGlobalPermission(String permissionObject, String objectName, String permissionType) {
        PermissionsAdministratorBuilder permissionsAdministratorBuilder = (PermissionsAdministratorBuilder)ComponentLocator.getComponent(PermissionsAdministratorBuilder.class);
        PermissionsAdministrator permissionsAdministrator = permissionsAdministratorBuilder.buildGlobalPermissionAdministrator();
        for (SpacePermission permission : permissionsAdministrator.getPermissions()) {
            if (permissionObject.equals("group") && permission.isGroupPermission() && permission.getType().equalsIgnoreCase(permissionType) && objectName.equals(permission.getGroup())) {
                return true;
            }
            if (!permissionObject.equals("user") || !permission.isUserPermission() || !permission.getType().equalsIgnoreCase(permissionType) || permission.getUserSubject() == null || !permission.getUserSubject().getName().equals(objectName)) continue;
            return true;
        }
        return false;
    }

    public boolean isUserExistByKey(HttpServletRequest request) {
        UserKey userKey = this.userManager.getRemoteUserKey(request);
        UserProfile userProfile = this.userManager.getUserProfile(userKey);
        return this.userProfileExist(userProfile);
    }

    public void saveTokens(TokenContainer tokenContainer) {
        String content = this.getJaxbContentString(tokenContainer);
        if (content != null) {
            this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), TOKENS, (Object)ToolsHelper.encrypt(content));
        }
    }

    public boolean isSensitiveCustomer() {
        return this.licenseHelper.isSensitiveCustomer() && this.licenseHelper.isAtlassianLicenseIsEvaluation();
    }

    public boolean isBannedCustomer() {
        return this.licenseHelper.isBannedCustomer() && this.licenseHelper.isAtlassianLicenseIsEvaluation();
    }

    public boolean isDisabledForSpaceAdministrator(String type) {
        Object objIsDisabled = this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), RESTAPI + type);
        if (objIsDisabled == null) {
            return false;
        }
        return (Boolean)objIsDisabled;
    }

    public void setApiConfiguration(String apiType, boolean disabled) {
        if (APILIST.contains(apiType) || CONFIGLIST.contains(apiType)) {
            this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), RESTAPI + apiType, (Object)disabled);
        }
    }

    public String getTokensAccessType() {
        Object optionObject = this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), TOKEN_ACCESS_TYPE);
        if (optionObject == null) {
            return "basic";
        }
        if (optionObject.toString().equalsIgnoreCase("basic")) {
            return "basic";
        }
        if (optionObject.toString().equalsIgnoreCase("bearer")) {
            return "bearer";
        }
        return "all";
    }

    public void setTokensAccessType(String accessType) {
        if (accessType == null || accessType.equalsIgnoreCase("basic")) {
            this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), TOKEN_ACCESS_TYPE, (Object)accessType);
        } else if (accessType.equalsIgnoreCase("bearer") || accessType.equalsIgnoreCase("all")) {
            this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), TOKEN_ACCESS_TYPE, (Object)accessType);
        }
    }

    public String getTokensConfig() {
        Object optionObject = this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), TOKEN_LIMIT);
        if (optionObject == null) {
            return "nolimit";
        }
        if (optionObject.toString().equalsIgnoreCase("limit")) {
            return "limit";
        }
        return "nolimit";
    }

    public void savedTokensConfig(String option) {
        if (option != null && option.equalsIgnoreCase("limit")) {
            if (log.isDebugEnabled()) {
                log.debug("save limit OPTION: " + option);
            }
            this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), TOKEN_LIMIT, (Object)"limit");
        } else {
            if (log.isDebugEnabled()) {
                log.debug("save nolimit OPTION: " + option);
            }
            this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), TOKEN_LIMIT, (Object)"nolimit");
        }
    }

    private String getTokensContainer() {
        String containerString = (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), TOKENS);
        if (containerString == null) {
            return "";
        }
        return ToolsHelper.decrypt(containerString);
    }

    public TokenContainer getSavedTokens() {
        try {
            Token token2;
            String content = this.getTokensContainer();
            if (content == null || content.equals("")) {
                return new TokenContainer();
            }
            TokenContainer tokenContainer = (TokenContainer)this.getUnmarshallerObject("TokenContainer").unmarshal((Reader)new StringReader(content));
            boolean migrate = false;
            ArrayList<Token> tokens = tokenContainer.getTokens();
            for (int i = tokens.size() - 1; i >= 0 && (token2 = tokens.get(i)).getUserKey() == null; --i) {
                migrate = true;
                log.warn("[TOKEN-MIGRATE-TO-KEY] --- START --- ");
                if (token2.getUser().equals("")) {
                    log.warn("[TOKEN-MIGRATE-TO-KEY]   - user: " + token2.getUser() + " set empty key");
                    token2.setUserKey("");
                    continue;
                }
                if (token2.getUser().equals("")) continue;
                ConfluenceUser confluenceUser = this.getConfluenceUserByName(token2.getUser());
                if (confluenceUser == null) {
                    log.warn("[TOKEN-MIGRATE-TO-KEY]   - user: " + token2.getUser() + " not found");
                    token2.setUserKey("not found");
                    continue;
                }
                log.warn("[TOKEN-MIGRATE-TO-KEY]   - user: " + token2.getUser() + " set key: " + confluenceUser.getKey());
                token2.setUserKey(confluenceUser.getKey().getStringValue());
            }
            if (migrate) {
                log.warn("[TOKEN-MIGRATE-TO-KEY] save migrated tokens into tokenContainer");
                for (Token token2 : tokenContainer.getTokens()) {
                    log.warn("[TOKEN-MIGRATE-TO-KEY] saved token for token.getUser(): " + token2.getUser() + " :: token.getUserKey(): " + token2.getUserKey());
                }
                this.saveTokens(tokenContainer);
                log.warn("[TOKEN-MIGRATE-TO-KEY] --- DONE --- ");
            }
            return tokenContainer;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("JAXBException " + e);
            }
            return new TokenContainer();
        }
    }

    private String getJaxbContentString(Object object) {
        String content;
        block4: {
            content = null;
            try {
                JAXBContext jaxbContext = null;
                if (object instanceof TokenContainer) {
                    jaxbContext = JAXBContext.newInstance((Class[])new Class[]{TokenContainer.class});
                }
                Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
                jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                StringWriter stringWriter = new StringWriter();
                jaxbMarshaller.marshal(object, (Writer)stringWriter);
                content = stringWriter.toString();
                if (log.isDebugEnabled()) {
                    log.debug("content " + content);
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block4;
                log.debug("JAXBException " + e);
            }
        }
        return content;
    }

    public boolean isUserExistByName(String userName) {
        UserProfile userProfile = this.userManager.getUserProfile(userName);
        return this.userProfileExist(userProfile);
    }

    public User getUserByName(String userName) {
        return this.userAccessor.getUserByName(userName);
    }

    public ConfluenceUser getAuthenticatedUser() {
        return AuthenticatedUserThreadLocal.get();
    }

    public ConfluenceUser getCurrentUser() {
        return AuthenticatedUserThreadLocal.get();
    }

    public ConfluenceUser getConfluenceUserByName(String userName) {
        return this.userAccessor.getUserByName(userName);
    }

    public boolean currentUserIsInConfluenceAdministratorGroup() {
        return this.userAccessor.getGroupNames((User)this.getCurrentUser()).contains("confluence-administrators");
    }

    public ConfluenceUser getConfluenceUserByKey(String userKeyString) {
        UserKey userKey = new UserKey(userKeyString);
        return this.userAccessor.getExistingUserByKey(userKey);
    }

    public UserProfile getUserProfileByName(String userName) {
        return this.userManager.getUserProfile(userName);
    }

    public UserProfile getCurrentUserProfile() {
        return this.userManager.getRemoteUser();
    }

    public UserProfile getUserProfile(String userKeyString) {
        UserKey userKey = new UserKey(userKeyString);
        return this.userManager.getUserProfile(userKey);
    }

    public Response permissionViolation() {
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("message", "permission violation");
        return Response.serverError().entity(response).build();
    }

    public Response licenseIsInvalid() {
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("message", "license is not valid");
        return Response.serverError().entity(response).build();
    }

    public Response userNotFound(String userName) {
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("message", "user '" + userName + "' not found");
        return Response.serverError().entity(response).build();
    }

    private boolean userProfileExist(UserProfile userProfile) {
        return userProfile != null;
    }

    public Response fieldRequired(String fieldName) {
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("message", "field '" + fieldName + "' is required");
        return Response.serverError().entity(response).build();
    }

    public Response taskIdNotExist(String taskId) {
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("message", "task id '" + taskId + "' not found");
        return Response.serverError().entity(response).build();
    }

    public Response spaceNotExist(String spaceKey) {
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("message", "space with a key '" + spaceKey + "' does not exist");
        return Response.serverError().entity(response).build();
    }

    public Response attachmentIdNotExist(Long contentId) {
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("message", "attachment with id '" + contentId + "' does not exist");
        return Response.serverError().entity(response).build();
    }

    public Response contentIdNotExist(Long contentId) {
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("message", "content with id '" + contentId + "' does not exist");
        return Response.serverError().entity(response).build();
    }

    public Response contentNameNotExist(String contentName) {
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("message", "content with a name '" + contentName + "' does not exist");
        return Response.serverError().entity(response).build();
    }

    public Response spaceIsNotGlobal(String spaceKey) {
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("message", "space with a key '" + spaceKey + "' is a personal space");
        return Response.serverError().entity(response).build();
    }

    public Response spaceExists(String spaceKey) {
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("message", "space with a key '" + spaceKey + "' already exists");
        return Response.serverError().entity(response).build();
    }

    public Response invalidSpaceKey(String spaceKey) {
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("message", "space keys may only consist of ASCII letters or numbers (A-Z, a-z, 0-9)");
        return Response.serverError().entity(response).build();
    }

    public String unescapeHtml(String text) {
        if (text == null) {
            return "";
        }
        return StringEscapeUtils.unescapeHtml4((String)text);
    }

    public Response customMessageError(String message, boolean addStatusCanceled) {
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("message", message);
        if (addStatusCanceled) {
            response.put("status", "canceled");
        }
        return Response.serverError().entity(response).build();
    }

    public Response customMessageError(String message) {
        return this.customMessageError(message, false);
    }

    public Response groupNotExit(String groupName) {
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("message", "group '" + groupName + "' not found");
        return Response.serverError().entity(response).build();
    }

    public Response permissionTypeNotExist(String permissionType) {
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("message", "permission type '" + permissionType + "' not found");
        return Response.serverError().entity(response).build();
    }

    public ArrayList<String> getJSONarray(JSONObject jsonObject, String object) {
        log.debug("getJSONarray - jsonObject:'" + jsonObject.toString() + "' object:'" + object + "'");
        ArrayList<String> arrayStringJSON = new ArrayList<String>();
        if (jsonObject.has(object)) {
            Object objectToTest = jsonObject.get(object);
            if (objectToTest instanceof JSONArray) {
                JSONArray jsonArray = jsonObject.getJSONArray(object);
                for (int i = 0; i < jsonArray.length(); ++i) {
                    arrayStringJSON.add(jsonArray.getString(i));
                }
            } else {
                arrayStringJSON.add(objectToTest.toString());
            }
        }
        return arrayStringJSON;
    }

    public ArrayList<Long> getLongJSONarray(JSONObject jsonObject, String object) {
        log.debug("getLongJSONarray - jsonObject:'" + jsonObject.toString() + "' object:'" + object + "'");
        ArrayList<Long> arrayList = new ArrayList<Long>();
        JSONArray jsonArray = jsonObject.getJSONArray(object);
        if (jsonArray != null) {
            int len = jsonArray.length();
            for (int i = 0; i < len; ++i) {
                arrayList.add(Long.parseLong(jsonArray.get(i).toString()));
            }
        }
        return arrayList;
    }

    public boolean isCurrentUserHasSpaceViewPermission(Space space) {
        Map groups = this.getSpacePermissionManager().getGroupsForPermissionType("VIEWSPACE", space);
        Map users = this.getSpacePermissionManager().getUsersForPermissionType("VIEWSPACE", space);
        return this.checkGroupsAndUsers(groups, users);
    }

    public boolean isCurrentUserHasSpaceCreatePagePermission(Space space) {
        Map groups = this.getSpacePermissionManager().getGroupsForPermissionType("EDITSPACE", space);
        Map users = this.getSpacePermissionManager().getUsersForPermissionType("EDITSPACE", space);
        return this.checkGroupsAndUsers(groups, users);
    }

    public boolean istUserIsSpaceAdministrator(Space space, UserProfile userProfile) {
        if (space == null) {
            return false;
        }
        if (userProfile == null) {
            return false;
        }
        Map groups = this.getSpacePermissionManager().getGroupsForPermissionType("SETSPACEPERMISSIONS", space);
        Map users = this.getSpacePermissionManager().getUsersForPermissionType("SETSPACEPERMISSIONS", space);
        return this.checkGroupsAndUsers(groups, users, userProfile);
    }

    public boolean istUserIsSpaceAdministrator(Space space, String userName) {
        UserProfile userProfile = this.userManager.getUserProfile(userName);
        return this.istUserIsSpaceAdministrator(space, userProfile);
    }

    public boolean isCurrentUserIsSpaceAdministrator(Space space) {
        UserProfile curretUserProfile = this.userManager.getRemoteUser();
        return this.istUserIsSpaceAdministrator(space, curretUserProfile);
    }

    private boolean checkGroupsAndUsers(Map<String, Long> groups, Map<String, Long> users, UserProfile userProfile) {
        User user = this.getUserByName(userProfile.getUsername());
        if (log.isDebugEnabled()) {
            log.debug("groups: " + groups);
            log.debug("users: " + users);
        }
        if (users.get(userProfile.getUsername()) != null) {
            return true;
        }
        for (Map.Entry<String, Long> entry : groups.entrySet()) {
            Group group = this.userAccessor.getGroup(entry.getKey());
            if (!this.userAccessor.hasMembership(group, user)) continue;
            return true;
        }
        return false;
    }

    private boolean checkGroupsAndUsers(Map<String, Long> groups, Map<String, Long> users) {
        UserProfile userProfile = this.getCurrentUserProfile();
        return this.checkGroupsAndUsers(groups, users, userProfile);
    }

    private Unmarshaller getUnmarshallerObject(String className) {
        try {
            JAXBContext jaxbContext = null;
            if (className.contains("TokenContainer")) {
                jaxbContext = JAXBContext.newInstance((Class[])new Class[]{TokenContainer.class});
            }
            return jaxbContext.createUnmarshaller();
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("JAXBException " + e);
            }
            return null;
        }
    }

    public Map<String, Object> addUserGroupDetails(Map<String, Object> mapIn, User confluenceUser, String dateFormatApi) {
        for (String group : this.userDetailsManager.getProfileGroups()) {
            ArrayList userGroups = new ArrayList();
            HashMap<String, String> details = new HashMap<String, String>();
            Iterator iterator = this.userDetailsManager.getProfileKeys(group).iterator();
            while (iterator.hasNext()) {
                String key;
                String property = this.userDetailsManager.getStringProperty(confluenceUser, key = (String)iterator.next());
                details.put(key, property == null ? "" : property);
            }
            userGroups.add(details);
            mapIn.put(group, userGroups);
        }
        String fullDateFormat = "";
        fullDateFormat = dateFormatApi == null || dateFormatApi.equals("") ? "yyyy-MM-dd HH:mm:ss" : dateFormatApi + " HH:mm:ss";
        SimpleDateFormat sdfFull = new SimpleDateFormat(fullDateFormat);
        TimestampedUser timestampedUser = null;
        LoginInfo loginInfo = this.loginManager.getLoginInfo(confluenceUser.getName());
        try {
            timestampedUser = (TimestampedUser)this.crowdService.getUser(confluenceUser.getName());
        }
        catch (Exception ex) {
            log.debug("cant get CachedCrowdUser : " + confluenceUser.getName());
        }
        mapIn.put("createdDate", timestampedUser == null ? null : timestampedUser.getCreatedDate());
        mapIn.put("updatedDate", timestampedUser == null ? null : timestampedUser.getUpdatedDate());
        mapIn.put("lastSuccessfulLoginDate", loginInfo.getLastSuccessfulLoginDate());
        mapIn.put("lastFailedLoginDate", loginInfo.getLastFailedLoginDate());
        mapIn.put("createdDateString", timestampedUser == null ? null : sdfFull.format(timestampedUser.getCreatedDate()));
        mapIn.put("updatedDateString", timestampedUser == null ? null : sdfFull.format(timestampedUser.getUpdatedDate()));
        mapIn.put("lastSuccessfulLoginDateString", loginInfo.getLastSuccessfulLoginDate() == null ? null : sdfFull.format(loginInfo.getLastSuccessfulLoginDate()));
        mapIn.put("lastFailedLoginDateString", loginInfo.getLastFailedLoginDate() == null ? null : sdfFull.format(loginInfo.getLastFailedLoginDate()));
        if (this.userAccessor.getUserNamesWithConfluenceAccess().contains(confluenceUser.getName())) {
            mapIn.put("hasAccessToUseConfluence", true);
        } else {
            mapIn.put("hasAccessToUseConfluence", false);
        }
        return mapIn;
    }

    public void resetCaptcha(User user) {
        this.loginManager.resetFailedLoginCount(user);
    }

    public Map<String, Object> addUserGroupDetails(Map<String, Object> mapIn, String userName, String dateFormatApi) {
        return this.addUserGroupDetails(mapIn, this.getUserByName(userName), dateFormatApi);
    }

    public ArrayList<Map<String, Object>> getConfiguration() {
        ArrayList<Map<String, Object>> configList = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < CONFIGLIST.size(); ++i) {
            Object apiConfiguration = this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), RESTAPI + CONFIGLIST.get(i));
            if (apiConfiguration == null) continue;
            HashMap<String, Object> value = new HashMap<String, Object>();
            value.put(RESTAPI + CONFIGLIST.get(i), apiConfiguration);
            configList.add(value);
        }
        return configList;
    }

    public ArrayList getDisabledApiConfiguration() {
        ArrayList apiDisabled = new ArrayList();
        for (int i = 0; i < APILIST.size(); ++i) {
            boolean isDisabled;
            Object apiConfiguration = this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), RESTAPI + APILIST.get(i));
            if (apiConfiguration == null || !(isDisabled = ((Boolean)apiConfiguration).booleanValue())) continue;
            apiDisabled.add(APILIST.get(i));
        }
        return apiDisabled;
    }

    public Page getLastModifiedFormPageDao(Space space) {
        return this.getLastModifiedFormPageDao(space, 1);
    }

    public Page getLastModifiedFormPageDao(Space space, int maxResults) {
        List spaceContentEntityObject = this.pageDao.getRecentlyUpdatedPages(maxResults, space.getKey());
        if (!spaceContentEntityObject.isEmpty()) {
            return (Page)spaceContentEntityObject.get(0);
        }
        return null;
    }

    public BlogPost getBlogPostFormPageDao(String spaceKey, String blogPostName) {
        return this.blogPostDao.getBlogPostByTitle(spaceKey, blogPostName);
    }

    public BlogPost getBlogPostFormPageDao(Space space, String blogPostName) {
        return this.getBlogPostFormPageDao(space.getKey(), blogPostName);
    }

    public BlogPost getBlogPostFormPageDao(Long pageId) {
        return this.blogPostDao.getById(pageId.longValue());
    }

    public Space getSpaceFromSpaceDao(String spaceKey) {
        return this.spaceDao.getSpace(spaceKey);
    }

    public Space getSpaceFromSpaceDao(Long spaceId) {
        return this.spaceDao.getById(spaceId.longValue());
    }

    public List<Space> getAllSpacesFormSpaceDao() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1900, 0, 1);
        return this.spaceDao.getSpacesCreatedAfter(calendar.getTime());
    }

    public Page getPageFormPageDao(String spaceKey, String pageName) {
        return this.getPageFormPageDao(this.getSpaceFromSpaceDao(spaceKey), pageName);
    }

    public Page getPageFormPageDao(Space space, String pageName) {
        return this.pageDao.getPage(space, pageName);
    }

    public Page getPageFormPageDao(Long pageId) {
        if (log.isDebugEnabled()) {
            log.debug("pageId: " + pageId);
        }
        return this.pageDao.getPageById(pageId.longValue());
    }

    public int getPageAuthoredPagesCountByUserFormPageDao(String userName) {
        if (log.isDebugEnabled()) {
            log.debug("userName: " + userName);
        }
        return this.pageDao.getAuthoredPagesCountByUser(userName);
    }

    public List<ContentEntityObject> getPageContentAuthoredByUser(String userName) {
        if (log.isDebugEnabled()) {
            log.debug("userName: " + userName);
        }
        ContentEntityObjectDao contentEntityObjectDao = (ContentEntityObjectDao)ComponentLocator.getComponent(ContentEntityObjectDao.class);
        return contentEntityObjectDao.getContentAuthoredByUser(userName);
    }

    public SpacePermissionManager getSpacePermissionManager() {
        return this.spacePermissionManager;
    }

    public boolean isLicensedForDataCenter() {
        return this.licenseService.isLicensedForDataCenter();
    }

    public String getJsonBodyForAuditRecord(HttpServletRequest httpRequest) {
        String queryString = httpRequest.getQueryString() != null && !httpRequest.getQueryString().equals("") ? "?" + httpRequest.getQueryString() : "";
        String content = "";
        String description = "";
        try {
            content = IOUtils.toString((InputStream)httpRequest.getInputStream(), (String)this.getStandardCharsets());
            if (content == null) {
                content = "";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!queryString.equals("")) {
            description = description + queryString;
        }
        if (!content.equals("")) {
            if (!description.equals("")) {
                description = description + "; ";
            }
            description = description + content;
        }
        String jsonBody = description;
        return jsonBody;
    }

    public String getStandardCharsets() {
        return GeneralUtil.getCharacterEncoding();
    }

    public String decodeUrlParam(String param) {
        return HtmlUtil.urlDecode((String)param);
    }

    private I18NBean getI18Bean() {
        Locale locale = this.localeManager.getLocale((User)this.getAuthenticatedUser());
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ((CachingI18NBeanFactory)ComponentLocator.getComponent(CachingI18NBeanFactory.class)).getI18NBean(locale);
    }

    public String getUntransformedRawText(String key) {
        return this.getI18Bean().getUntransformedRawText(key);
    }

    public String getTranslation(String key) {
        return this.getI18Bean().getText(key);
    }

    public String getTranslation(String key, List<String> args) {
        return this.getI18Bean().getText(key, args);
    }

    public void addAuditRecord(com.atlassian.confluence.api.model.people.User author, String description, String category, String summary, boolean isSysAdmin, AffectedObject targetAffectedUser, Set<AffectedObject> associatedObjects, List<Map<String, String>> changedValues) {
        this.addAuditRecord(author, description, category, summary, isSysAdmin, targetAffectedUser, associatedObjects, changedValues, true);
    }

    private void addAuditRecord(com.atlassian.confluence.api.model.people.User author, String description, String category, String summary, boolean isSysAdmin, AffectedObject targetAffectedUser, Set<AffectedObject> associatedObjects, List<Map<String, String>> changedValues, boolean trySecondTime) {
    }

    public com.atlassian.confluence.api.model.people.User getPeopleUser(UserProfile userProfile) {
        return new com.atlassian.confluence.api.model.people.User(null, userProfile.getUsername(), userProfile.getFullName(), userProfile.getUserKey());
    }

    public SettingsManager getSettingsManager() {
        return this.settingsManager;
    }

    public Settings getGlobalSettings() {
        return this.getSettingsManager().getGlobalSettings();
    }

    public boolean isExternalUserManagement() {
        return this.getGlobalSettings().isExternalUserManagement();
    }

    public String getBaseUrl() {
        return this.getGlobalSettings().getBaseUrl();
    }

    public String getDefaultUsersGroup() {
        return this.getGlobalSettings().getDefaultUsersGroup();
    }

    public String getSharedHomeDirectory() {
        try {
            return this.bootstrapManager.getSharedHome().toString();
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("getSharedHomeDirectory: " + e.getMessage());
            }
            return "";
        }
    }

    public String getBootstrapKey(String bootstrapKey) {
        try {
            return this.bootstrapManager.getFilePathProperty(bootstrapKey).toString();
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("getBootstrapKey: " + e.getMessage());
            }
            return "";
        }
    }

    public String getLocalHomeDirectory() {
        try {
            return this.bootstrapManager.getLocalHome().toString();
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("getLocalHomeDirectory: " + e.getMessage());
            }
            return "";
        }
    }

    public Iterable<? extends ContentPermission> getContentPermissionsCopy(ContentPermissionSet contentPermissionSet) {
        return contentPermissionSet.getContentPermissionsCopy();
    }

    public String getXrfsToken(boolean generate, HttpServletRequest request) {
        XsrfTokenGenerator xsrfTokenGenerator = (XsrfTokenGenerator)ComponentLocator.getComponent(XsrfTokenGenerator.class);
        if (generate) {
            return xsrfTokenGenerator.generateToken(request);
        }
        if (request != null) {
            return xsrfTokenGenerator.generateToken(request);
        }
        return "";
    }

    public boolean skipParamSpaceValidation(String spaceKey, BlogPost blogPost) {
        if (blogPost == null) {
            return true;
        }
        return this.skipParamSpaceValidation(spaceKey, blogPost.getSpace());
    }

    public boolean skipParamSpaceValidation(String spaceKey, Page page) {
        if (page == null) {
            return true;
        }
        return this.skipParamSpaceValidation(spaceKey, page.getSpace());
    }

    public boolean skipParamSpaceValidation(String spaceKey, Space space) {
        if (space == null) {
            return true;
        }
        return this.skipParamSpaceValidation(spaceKey, space.getKey());
    }

    public boolean skipParamSpaceValidation(String spaceKeyOne, String spaceKeyTwo) {
        if (log.isDebugEnabled()) {
            log.debug("skipParamSpaceValidation : spaceKeyOne=" + spaceKeyOne);
            log.debug("skipParamSpaceValidation : spaceKeyTwo=" + spaceKeyTwo);
        }
        return spaceKeyOne == null || spaceKeyOne.equals("") || spaceKeyOne.equals(spaceKeyTwo);
    }

    public boolean getTokenConfigurationSecureMode() {
        String tokenSecureMode = this.getBootstrapKey("extender.token.secure.mode");
        return tokenSecureMode != null && tokenSecureMode.equals("true");
    }

    public static String encrypt(String valueToEnc) {
        try {
            SecretKeySpec key = new SecretKeySpec(SECRET_KEY.getBytes(), ALGORITHM);
            Cipher c = Cipher.getInstance(ALGORITHM);
            c.init(1, key);
            byte[] encValue = c.doFinal(valueToEnc.getBytes());
            if (log.isDebugEnabled()) {
                log.debug("encrypt: " + valueToEnc);
                log.debug("encrypt: " + Base64.getEncoder().encodeToString(encValue));
            }
            return Base64.getEncoder().encodeToString(encValue);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Exception: " + e.getMessage());
            }
            return "";
        }
    }

    public static String decrypt(String encryptedValue) {
        try {
            SecretKeySpec key = new SecretKeySpec(SECRET_KEY.getBytes(), ALGORITHM);
            Cipher c = Cipher.getInstance(ALGORITHM);
            c.init(2, key);
            byte[] decodedValue = Base64.getDecoder().decode(encryptedValue);
            byte[] decValue = c.doFinal(decodedValue);
            if (log.isDebugEnabled()) {
                log.debug("decrypt: " + encryptedValue);
                log.debug("decrypt: " + new String(decValue));
            }
            return new String(decValue);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Exception: " + e.getMessage());
            }
            return "";
        }
    }

    public String getSourceEditorGroups() {
        return SOURCE_EDITOR_GROUPS;
    }

    public String getSourceEditorAllowAll() {
        return SOURCE_EDITOR_ALLOW_ALL;
    }

    public String getNotifyWatchersPrimaryButton() {
        return NOTIFY_WATCHERS_PRIMARY_BUTTON;
    }

    public String getNotifyWatchersGroups() {
        return NOTIFY_WATCHERS_GROUPS;
    }

    public boolean isSourceEditorVisibleForUser() {
        Object allowAll = this.getBandanaObjectByType(this.getSourceEditorAllowAll());
        if (allowAll != null && allowAll.toString() != null && allowAll.toString().equalsIgnoreCase("allowAll")) {
            return true;
        }
        Object groups = this.getBandanaObjectByType(this.getSourceEditorGroups());
        List userGroups = this.userAccessor.getGroupNamesForUserName(this.getAuthenticatedUser().getName());
        boolean isInGroup = false;
        if (groups != null) {
            if (groups.toString().contains("@@@")) {
                String[] groupsTable = groups.toString().split("@@@");
                for (int i = 0; i < groupsTable.length; ++i) {
                    if (!userGroups.contains(groupsTable[i])) continue;
                    isInGroup = true;
                    break;
                }
            } else if (!groups.toString().equals("") && userGroups.contains(groups.toString())) {
                isInGroup = true;
            }
        }
        return isInGroup;
    }

    public void setBandanaObjectByType(String bandanaType, Object value) {
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), bandanaType, value);
    }

    public Object getBandanaObjectByType(String bandanaType) {
        return this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), bandanaType);
    }
}

