/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender.sourceEditor;

import com.itlab.confluence.plugins.restextender.helper.ToolsHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/sourceEditor")
public class SourceEditorUtils {
    private static final Logger log = LoggerFactory.getLogger(SourceEditorUtils.class);
    private final ToolsHelper toolsHelper;

    public SourceEditorUtils(ToolsHelper toolsHelper) {
        this.toolsHelper = toolsHelper;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/getGroups")
    public Response getGroups() {
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        HashMap response = new HashMap();
        ArrayList<String> groupsArray = new ArrayList<String>();
        Object groups = this.toolsHelper.getBandanaObjectByType(this.toolsHelper.getSourceEditorGroups());
        if (groups != null) {
            if (groups.toString().contains("@@@")) {
                String[] groupsTable = groups.toString().split("@@@");
                groupsArray.addAll(Arrays.asList(groupsTable));
            } else if (!groups.toString().isEmpty()) {
                groupsArray.add(groups.toString());
            }
        }
        response.put("groups", groupsArray);
        return Response.ok(response).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/allowAll")
    public Response allowAll() {
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        this.toolsHelper.setBandanaObjectByType(this.toolsHelper.getSourceEditorAllowAll(), "allowAll");
        return Response.ok().build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/disallowAll")
    public Response disallowAll() {
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        this.toolsHelper.setBandanaObjectByType(this.toolsHelper.getSourceEditorAllowAll(), "disallowAll");
        return Response.ok().build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/removeGroup/{groupName}")
    public Response removeGroup(@PathParam(value="groupName") String groupName) {
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        StringBuilder newGroups = new StringBuilder();
        Object groups = this.toolsHelper.getBandanaObjectByType(this.toolsHelper.getSourceEditorGroups());
        if (groups != null) {
            if (groups.toString().contains("@@@")) {
                String[] groupsTable;
                for (String groupTableName : groupsTable = groups.toString().split("@@@")) {
                    if (groupTableName.equalsIgnoreCase(groupName)) continue;
                    if (newGroups.length() > 0) {
                        newGroups.append("@@@");
                    }
                    newGroups.append(groupTableName);
                }
            } else if (!groups.toString().isEmpty()) {
                newGroups = new StringBuilder(groups.toString().replace(groupName, ""));
            }
            this.toolsHelper.setBandanaObjectByType(this.toolsHelper.getSourceEditorGroups(), newGroups.toString());
        }
        return Response.ok().build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/configuration")
    public Response getConfig() {
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("limitSourceCode", "");
        Object allowAll = this.toolsHelper.getBandanaObjectByType(this.toolsHelper.getSourceEditorAllowAll());
        if (allowAll != null && allowAll.toString() != null && allowAll.toString().equalsIgnoreCase("allowAll")) {
            response.put("limitSourceCode", "allowAll");
        }
        return Response.ok(response).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/addGroup/{groupName}")
    public Response setGroups(@PathParam(value="groupName") String groupName) {
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        Object groups = this.toolsHelper.getBandanaObjectByType(this.toolsHelper.getSourceEditorGroups());
        if (groups != null && !groups.toString().isEmpty()) {
            this.toolsHelper.setBandanaObjectByType(this.toolsHelper.getSourceEditorGroups(), groups.toString() + "@@@" + groupName);
        } else {
            this.toolsHelper.setBandanaObjectByType(this.toolsHelper.getSourceEditorGroups(), groupName);
        }
        return Response.ok().build();
    }
}

